/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.FromBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.EnvVisitor;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.compile.NameGenerator;
import net.hydromatic.morel.compile.TypeMap;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Resolver {
    public static final ImmutableMap<Op, BuiltIn> OP_BUILT_IN_MAP = Init.INSTANCE.opBuiltInMap;
    public static final ImmutableMap<BuiltIn, Op> BUILT_IN_OP_MAP = Init.INSTANCE.builtInOpMap;
    final TypeMap typeMap;
    private final NameGenerator nameGenerator;
    private final Environment env;
    private final @Nullable Session session;
    private final Map<Pair<Core.NamedPat, Type>, Core.NamedPat> variantIdMap;

    private Resolver(TypeMap typeMap, NameGenerator nameGenerator, Map<Pair<Core.NamedPat, Type>, Core.NamedPat> variantIdMap, Environment env, @Nullable Session session) {
        this.typeMap = typeMap;
        this.nameGenerator = nameGenerator;
        this.variantIdMap = variantIdMap;
        this.env = env;
        this.session = session;
    }

    public static Resolver of(TypeMap typeMap, Environment env, @Nullable Session session) {
        return new Resolver(typeMap, new NameGenerator(), new HashMap<Pair<Core.NamedPat, Type>, Core.NamedPat>(), env, session);
    }

    public Resolver withEnv(Environment env) {
        return env == this.env ? this : new Resolver(this.typeMap, this.nameGenerator, this.variantIdMap, env, this.session);
    }

    public final Resolver withEnv(Iterable<Binding> bindings) {
        return this.withEnv(Environments.bind(this.env, bindings));
    }

    public Core.Decl toCore(Ast.Decl node) {
        switch (node.op) {
            case VAL_DECL: {
                return this.toCore((Ast.ValDecl)node);
            }
            case DATATYPE_DECL: {
                return this.toCore((Ast.DatatypeDecl)node);
            }
        }
        throw new AssertionError((Object)("unknown decl [" + (Object)((Object)node.op) + ", " + node + "]"));
    }

    public Core.ValDecl toCore(Ast.ValDecl valDecl) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ResolvedValDecl resolvedValDecl = this.resolveValDecl(valDecl, bindings);
        Core.NonRecValDecl nonRecValDecl = CoreBuilder.core.nonRecValDecl(((PatExp)resolvedValDecl.patExps.get((int)0)).pos, resolvedValDecl.pat, resolvedValDecl.exp);
        return resolvedValDecl.rec ? CoreBuilder.core.recValDecl((Iterable<? extends Core.NonRecValDecl>)ImmutableList.of((Object)nonRecValDecl)) : nonRecValDecl;
    }

    public Core.DatatypeDecl toCore(Ast.DatatypeDecl datatypeDecl) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ResolvedDatatypeDecl resolvedDatatypeDecl = this.resolveDatatypeDecl(datatypeDecl, bindings);
        return resolvedDatatypeDecl.toDecl();
    }

    private ResolvedDecl resolve(Ast.Decl decl, List<Binding> bindings) {
        if (decl instanceof Ast.DatatypeDecl) {
            return this.resolveDatatypeDecl((Ast.DatatypeDecl)decl, bindings);
        }
        return this.resolveValDecl((Ast.ValDecl)decl, bindings);
    }

    private ResolvedDatatypeDecl resolveDatatypeDecl(Ast.DatatypeDecl decl, List<Binding> bindings) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Ast.DatatypeBind bind : decl.binds) {
            DataType dataType = this.toCore(bind);
            dataTypes.add(dataType);
            dataType.typeConstructors.keySet().forEach(name -> bindings.add(this.typeMap.typeSystem.bindTyCon(dataType, (String)name)));
        }
        return new ResolvedDatatypeDecl((ImmutableList<DataType>)ImmutableList.copyOf(dataTypes));
    }

    private ResolvedValDecl resolveValDecl(Ast.ValDecl valDecl, List<Binding> bindings) {
        Core.Exp exp2;
        Core.Pat pat0;
        boolean rec;
        boolean composite = valDecl.valBinds.size() > 1;
        LinkedHashMap<Ast.Pat, Ast.Exp> matches = new LinkedHashMap<Ast.Pat, Ast.Exp>();
        valDecl.valBinds.forEach(valBind -> Resolver.flatten(matches, composite, valBind.pat, valBind.exp));
        ArrayList<PatExp> patExps = new ArrayList<PatExp>();
        if (valDecl.rec) {
            ArrayList pats = new ArrayList();
            matches.forEach((pat, exp) -> pats.add(this.toCore((Ast.Pat)pat)));
            pats.forEach(p -> Compiles.acceptBinding(this.typeMap.typeSystem, p, bindings));
            Resolver r = this.withEnv(bindings);
            Iterator patIter = pats.iterator();
            matches.forEach((pat, exp) -> patExps.add(new PatExp((Core.Pat)patIter.next(), r.toCore((Ast.Exp)exp), pat.pos.plus(exp.pos))));
        } else {
            matches.forEach((pat, exp) -> patExps.add(new PatExp(this.toCore((Ast.Pat)pat), this.toCore((Ast.Exp)exp), pat.pos.plus(exp.pos))));
            patExps.forEach(x -> Compiles.acceptBinding(this.typeMap.typeSystem, x.pat, bindings));
        }
        boolean bl = rec = valDecl.rec && this.references(patExps);
        if (composite) {
            List<Core.Pat> pats = Static.transform(patExps, x -> x.pat);
            List<Core.Exp> exps = Static.transform(patExps, x -> x.exp);
            pat0 = CoreBuilder.core.tuplePat(this.typeMap.typeSystem, pats);
            exp2 = CoreBuilder.core.tuple((RecordLikeType)pat0.type, exps);
        } else {
            PatExp patExp = (PatExp)patExps.get(0);
            pat0 = patExp.pat;
            exp2 = patExp.exp;
        }
        Core.NamedPat pat2 = pat0 instanceof Core.NamedPat ? (Core.NamedPat)pat0 : CoreBuilder.core.asPat(exp2.type, "it", this.nameGenerator, pat0);
        return new ResolvedValDecl(rec, (ImmutableList<PatExp>)ImmutableList.copyOf(patExps), pat2, exp2);
    }

    private boolean references(List<PatExp> patExps) {
        HashSet<Core.NamedPat> refSet = new HashSet<Core.NamedPat>();
        ReferenceFinder finder = new ReferenceFinder(this.typeMap.typeSystem, Environments.empty(), refSet, new ArrayDeque<EnvVisitor.FromContext>());
        patExps.forEach(x -> x.exp.accept(finder));
        final HashSet defSet = new HashSet();
        Visitor v = new Visitor(){

            @Override
            protected void visit(Core.IdPat idPat) {
                defSet.add(idPat);
            }
        };
        patExps.forEach(x -> x.pat.accept(v));
        return Util.intersects(refSet, defSet);
    }

    private DataType toCore(Ast.DatatypeBind bind) {
        Type type = this.typeMap.typeSystem.lookup(bind.name.name);
        return type instanceof ForallType ? (DataType)((ForallType)type).type : (DataType)type;
    }

    private Core.Exp toCore(Ast.Exp exp) {
        switch (exp.op) {
            case BOOL_LITERAL: {
                return CoreBuilder.core.boolLiteral((Boolean)((Ast.Literal)exp).value);
            }
            case CHAR_LITERAL: {
                return CoreBuilder.core.charLiteral(((Character)((Ast.Literal)exp).value).charValue());
            }
            case INT_LITERAL: {
                return CoreBuilder.core.intLiteral((BigDecimal)((Ast.Literal)exp).value);
            }
            case REAL_LITERAL: {
                return ((Ast.Literal)exp).value instanceof BigDecimal ? CoreBuilder.core.realLiteral((BigDecimal)((Ast.Literal)exp).value) : CoreBuilder.core.realLiteral((Float)((Ast.Literal)exp).value);
            }
            case STRING_LITERAL: {
                return CoreBuilder.core.stringLiteral((String)((Object)((Ast.Literal)exp).value));
            }
            case UNIT_LITERAL: {
                return CoreBuilder.core.unitLiteral();
            }
            case ANNOTATED_EXP: {
                return this.toCore(((Ast.AnnotatedExp)exp).exp);
            }
            case ID: {
                return this.toCore((Ast.Id)exp);
            }
            case ANDALSO: 
            case ORELSE: {
                return this.toCore((Ast.InfixCall)exp);
            }
            case APPLY: {
                return this.toCore((Ast.Apply)exp);
            }
            case FN: {
                return this.toCore((Ast.Fn)exp);
            }
            case IF: {
                return this.toCore((Ast.If)exp);
            }
            case CASE: {
                return this.toCore((Ast.Case)exp);
            }
            case LET: {
                return this.toCore((Ast.Let)exp);
            }
            case FROM: {
                return this.toCore((Ast.From)exp);
            }
            case TUPLE: {
                return this.toCore((Ast.Tuple)exp);
            }
            case RECORD: {
                return this.toCore((Ast.Record)exp);
            }
            case RECORD_SELECTOR: {
                return this.toCore((Ast.RecordSelector)exp);
            }
            case LIST: {
                return this.toCore((Ast.ListExp)exp);
            }
            case FROM_EQ: {
                return this.toCoreFromEq(((Ast.PrefixCall)exp).a);
            }
        }
        throw new AssertionError((Object)("unknown exp " + (Object)((Object)exp.op)));
    }

    private Core.Id toCore(Ast.Id id) {
        Binding binding = this.env.getOpt(id.name);
        Preconditions.checkNotNull((Object)binding, (String)"not found", (Object)id);
        Core.NamedPat idPat = this.getIdPat(id, binding);
        return CoreBuilder.core.id(idPat);
    }

    private Core.IdPat toCorePat(Ast.Id id) {
        Type type = this.typeMap.getType(id);
        return CoreBuilder.core.idPat(type, id.name, this.nameGenerator);
    }

    private Core.NamedPat getIdPat(Ast.Id id, Binding binding) {
        Type type = this.typeMap.getType(id);
        if (type == binding.id.type) {
            return binding.id;
        }
        return this.variantIdMap.computeIfAbsent(Pair.of(binding.id, type), k -> ((Core.NamedPat)k.left).withType((Type)k.right));
    }

    private Core.Tuple toCore(Ast.Tuple tuple) {
        return CoreBuilder.core.tuple((RecordLikeType)this.typeMap.getType(tuple), (Iterable<? extends Core.Exp>)Static.transformEager(tuple.args, this::toCore));
    }

    private Core.Tuple toCore(Ast.Record record) {
        return CoreBuilder.core.tuple((RecordLikeType)this.typeMap.getType(record), (Iterable<? extends Core.Exp>)Static.transformEager(record.args(), this::toCore));
    }

    private Core.Exp toCore(Ast.ListExp list) {
        ListType type = (ListType)this.typeMap.getType(list);
        return CoreBuilder.core.apply(list.pos, type, CoreBuilder.core.functionLiteral(this.typeMap.typeSystem, BuiltIn.Z_LIST), CoreBuilder.core.tuple(this.typeMap.typeSystem, null, (Iterable<? extends Core.Exp>)Static.transformEager(list.args, this::toCore)));
    }

    private Core.Exp toCoreFromEq(Ast.Exp exp) {
        Type type = this.typeMap.getType(exp);
        ListType listType = this.typeMap.typeSystem.listType(type);
        return CoreBuilder.core.apply(exp.pos, listType, CoreBuilder.core.functionLiteral(this.typeMap.typeSystem, BuiltIn.Z_LIST), CoreBuilder.core.tuple(this.typeMap.typeSystem, this.toCore(exp)));
    }

    private Core.Apply toCore(Ast.Apply apply) {
        Core.Exp coreFn;
        Core.Exp coreArg = this.toCore(apply.arg);
        Type type = this.typeMap.getType(apply);
        if (apply.fn.op == Op.RECORD_SELECTOR) {
            Object o;
            Ast.RecordSelector recordSelector = (Ast.RecordSelector)apply.fn;
            RecordLikeType recordType = (RecordLikeType)coreArg.type;
            if (coreArg.type.isProgressive() && (o = Resolver.valueOf(this.env, coreArg)) instanceof TypedValue) {
                TypedValue typedValue = (TypedValue)o;
                TypedValue typedValue2 = typedValue.discoverField(this.typeMap.typeSystem, recordSelector.name);
                recordType = (RecordLikeType)typedValue2.typeKey().toType(this.typeMap.typeSystem);
            }
            coreFn = CoreBuilder.core.recordSelector(this.typeMap.typeSystem, recordType, recordSelector.name);
            if (type.op() == Op.TY_VAR && coreFn.type.op() == Op.FUNCTION_TYPE || type.isProgressive() || type instanceof ListType && ((ListType)type).elementType.isProgressive()) {
                type = ((FnType)coreFn.type).resultType;
            }
        } else {
            coreFn = this.toCore(apply.fn);
        }
        return CoreBuilder.core.apply(apply.pos, type, coreFn, coreArg);
    }

    static Object valueOf(Environment env, Core.Exp exp) {
        if (exp instanceof Core.Literal) {
            return ((Core.Literal)exp).value;
        }
        if (exp.op == Op.ID) {
            Core.Id id = (Core.Id)exp;
            Binding binding = env.getOpt(id.idPat);
            if (binding != null) {
                return binding.value;
            }
        }
        if (exp.op == Op.APPLY) {
            Core.Apply apply = (Core.Apply)exp;
            if (apply.fn.op == Op.RECORD_SELECTOR) {
                Core.RecordSelector recordSelector = (Core.RecordSelector)apply.fn;
                Object o = Resolver.valueOf(env, apply.arg);
                if (o instanceof TypedValue) {
                    return ((TypedValue)o).fieldValueAs(recordSelector.slot, Object.class);
                }
                if (o instanceof List) {
                    List list = (List)o;
                    return list.get(recordSelector.slot);
                }
            }
        }
        return null;
    }

    private Core.RecordSelector toCore(Ast.RecordSelector recordSelector) {
        FnType fnType = (FnType)this.typeMap.getType(recordSelector);
        return CoreBuilder.core.recordSelector(this.typeMap.typeSystem, (RecordLikeType)fnType.paramType, recordSelector.name);
    }

    private Core.Apply toCore(Ast.InfixCall call) {
        Core.Exp core0 = this.toCore(call.a0);
        Core.Exp core1 = this.toCore(call.a1);
        BuiltIn builtIn = this.toBuiltIn(call.op);
        return CoreBuilder.core.apply(call.pos, this.typeMap.getType(call), CoreBuilder.core.functionLiteral(this.typeMap.typeSystem, builtIn), CoreBuilder.core.tuple(this.typeMap.typeSystem, core0, core1));
    }

    private BuiltIn toBuiltIn(Op op) {
        return (BuiltIn)((Object)OP_BUILT_IN_MAP.get((Object)op));
    }

    private Core.Fn toCore(Ast.Fn fn) {
        FnType type = (FnType)this.typeMap.getType(fn);
        ImmutableList<Core.Match> matchList = Static.transformEager(fn.matchList, this::toCore);
        return CoreBuilder.core.fn(fn.pos, type, (List<Core.Match>)matchList, this.nameGenerator);
    }

    private Core.Case toCore(Ast.If if_) {
        return CoreBuilder.core.ifThenElse(this.toCore(if_.condition), this.toCore(if_.ifTrue), this.toCore(if_.ifFalse));
    }

    private Core.Case toCore(Ast.Case case_) {
        return CoreBuilder.core.caseOf(case_.pos, this.typeMap.getType(case_), this.toCore(case_.exp), (Iterable<? extends Core.Match>)Static.transformEager(case_.matchList, this::toCore));
    }

    private Core.Exp toCore(Ast.Let let) {
        return this.flattenLet(let.decls, let.exp);
    }

    private Core.Exp flattenLet(List<Ast.Decl> decls, Ast.Exp exp) {
        if (decls.isEmpty()) {
            return this.toCore(exp);
        }
        Ast.Decl decl = decls.get(0);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ResolvedDecl resolvedDecl = this.resolve(decl, bindings);
        Core.Exp e2 = this.withEnv(bindings).flattenLet(Static.skip(decls), exp);
        return resolvedDecl.toExp(e2);
    }

    static void flatten(Map<Ast.Pat, Ast.Exp> matches, boolean flatten, Ast.Pat pat, Ast.Exp exp) {
        if (flatten && pat.op == Op.TUPLE_PAT && exp.op == Op.TUPLE) {
            Pair.forEach(((Ast.TuplePat)pat).args, ((Ast.Tuple)exp).args, (p, e) -> Resolver.flatten(matches, true, p, e));
        } else {
            matches.put(pat, exp);
        }
    }

    private Core.Pat toCore(Ast.Pat pat) {
        Type type = this.typeMap.getType(pat);
        return this.toCore(pat, type, type);
    }

    private Core.Pat toCore(Ast.Pat pat, Type targetType) {
        Type type = this.typeMap.getType(pat);
        return this.toCore(pat, type, targetType);
    }

    private Core.Pat toCore(Ast.Pat pat, Type type, Type targetType) {
        switch (pat.op) {
            case BOOL_LITERAL_PAT: 
            case CHAR_LITERAL_PAT: 
            case INT_LITERAL_PAT: 
            case REAL_LITERAL_PAT: 
            case STRING_LITERAL_PAT: {
                return CoreBuilder.core.literalPat(pat.op, type, ((Ast.LiteralPat)pat).value);
            }
            case WILDCARD_PAT: {
                return CoreBuilder.core.wildcardPat(type);
            }
            case ID_PAT: {
                Ast.IdPat idPat = (Ast.IdPat)pat;
                if (type.op() == Op.DATA_TYPE && ((DataType)type).typeConstructors.containsKey(idPat.name)) {
                    return CoreBuilder.core.con0Pat((DataType)type, idPat.name);
                }
                return CoreBuilder.core.idPat(type, idPat.name, this.nameGenerator);
            }
            case AS_PAT: {
                Ast.AsPat asPat = (Ast.AsPat)pat;
                return CoreBuilder.core.asPat(type, asPat.id.name, this.nameGenerator, this.toCore(asPat.pat));
            }
            case ANNOTATED_PAT: {
                Ast.AnnotatedPat annotatedPat = (Ast.AnnotatedPat)pat;
                return this.toCore(annotatedPat.pat);
            }
            case CON_PAT: {
                Ast.ConPat conPat = (Ast.ConPat)pat;
                return CoreBuilder.core.conPat(type, conPat.tyCon.name, this.toCore(conPat.pat));
            }
            case CON0_PAT: {
                Ast.Con0Pat con0Pat = (Ast.Con0Pat)pat;
                return CoreBuilder.core.con0Pat((DataType)type, con0Pat.tyCon.name);
            }
            case CONS_PAT: {
                Ast.InfixPat infixPat = (Ast.InfixPat)pat;
                Type type0 = this.typeMap.getType(infixPat.p0);
                Type type1 = this.typeMap.getType(infixPat.p1);
                TupleType tupleType = this.typeMap.typeSystem.tupleType(type0, type1);
                return CoreBuilder.core.consPat(type, BuiltIn.OP_CONS.mlName, CoreBuilder.core.tuplePat((RecordLikeType)tupleType, this.toCore(infixPat.p0), this.toCore(infixPat.p1)));
            }
            case LIST_PAT: {
                Ast.ListPat listPat = (Ast.ListPat)pat;
                return CoreBuilder.core.listPat(type, (Iterable<? extends Core.Pat>)Static.transformEager(listPat.args, this::toCore));
            }
            case RECORD_PAT: {
                RecordType recordType = (RecordType)targetType;
                Ast.RecordPat recordPat = (Ast.RecordPat)pat;
                ImmutableList.Builder args = ImmutableList.builder();
                recordType.argNameTypes.forEach((label, argType) -> {
                    Ast.Pat argPat = (Ast.Pat)recordPat.args.get(label);
                    Core.Pat corePat = argPat != null ? this.toCore(argPat) : CoreBuilder.core.wildcardPat((Type)argType);
                    args.add((Object)corePat);
                });
                return CoreBuilder.core.recordPat(recordType, (List<? extends Core.Pat>)args.build());
            }
            case TUPLE_PAT: {
                Ast.TuplePat tuplePat = (Ast.TuplePat)pat;
                ImmutableList<Core.Pat> argList = Static.transformEager(tuplePat.args, this::toCore);
                return CoreBuilder.core.tuplePat((RecordLikeType)type, (Iterable<? extends Core.Pat>)argList);
            }
        }
        throw new AssertionError((Object)("unknown pat " + (Object)((Object)pat.op)));
    }

    private Core.Match toCore(Ast.Match match) {
        Core.Pat pat = this.toCore(match.pat);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.acceptBinding(this.typeMap.typeSystem, pat, bindings);
        Core.Exp exp = this.withEnv(bindings).toCore(match.exp);
        return CoreBuilder.core.match(match.pos, pat, exp);
    }

    Core.Exp toCore(Ast.From from) {
        Type type = this.typeMap.getType(from);
        Core.Exp coreFrom = new FromResolver().run(from);
        Preconditions.checkArgument((boolean)Resolver.subsumes(type, coreFrom.type()), (String)"Conversion to core did not preserve type: expected [%s] actual [%s] from [%s]", (Object)type, (Object)coreFrom.type, (Object)coreFrom);
        return coreFrom;
    }

    private static boolean subsumes(Type actualType, Type expectedType) {
        switch (actualType.op()) {
            case LIST: {
                if (expectedType.op() != Op.LIST) {
                    return false;
                }
                return Resolver.subsumes(((ListType)actualType).elementType, ((ListType)expectedType).elementType);
            }
            case RECORD_TYPE: {
                Map.Entry<String, Type> expected;
                Map.Entry<String, Type> actual;
                if (expectedType.op() != Op.RECORD_TYPE) {
                    return false;
                }
                if (actualType.isProgressive()) {
                    return true;
                }
                SortedMap<String, Type> actualMap = ((RecordType)actualType).argNameTypes();
                SortedMap<String, Type> expectedMap = ((RecordType)expectedType).argNameTypes();
                Iterator<Map.Entry<String, Type>> actualIterator = actualMap.entrySet().iterator();
                Iterator<Map.Entry<String, Type>> expectedIterator = expectedMap.entrySet().iterator();
                do {
                    if (actualIterator.hasNext()) {
                        if (!expectedIterator.hasNext()) {
                            return false;
                        }
                    } else if (!expectedIterator.hasNext()) {
                        return true;
                    }
                    actual = actualIterator.next();
                    expected = expectedIterator.next();
                    if (actual.getKey().equals(expected.getKey())) continue;
                    return false;
                } while (Resolver.subsumes(actual.getValue(), expected.getValue()));
                return false;
            }
        }
        return actualType.equals(expectedType);
    }

    private Core.Aggregate toCore(Ast.Aggregate aggregate, Collection<? extends Core.IdPat> groupKeys) {
        Resolver resolver = this.withEnv(Static.transform(groupKeys, Binding::of));
        return CoreBuilder.core.aggregate(this.typeMap.getType(aggregate), resolver.toCore(aggregate.aggregate), aggregate.argument == null ? null : this.toCore(aggregate.argument));
    }

    private Core.OrderItem toCore(Ast.OrderItem orderItem) {
        return CoreBuilder.core.orderItem(this.toCore(orderItem.exp), orderItem.direction);
    }

    class ResolvedValDecl
    extends ResolvedDecl {
        final boolean rec;
        final boolean composite;
        final ImmutableList<PatExp> patExps;
        final Core.NamedPat pat;
        final Core.Exp exp;

        ResolvedValDecl(boolean rec, ImmutableList<PatExp> patExps, Core.NamedPat pat, Core.Exp exp) {
            this.rec = rec;
            this.composite = patExps.size() > 1;
            this.patExps = patExps;
            this.pat = pat;
            this.exp = exp;
        }

        @Override
        Core.Let toExp(Core.Exp resultExp) {
            if (this.rec) {
                ArrayList valDecls = new ArrayList();
                this.patExps.forEach(x -> valDecls.add(CoreBuilder.core.nonRecValDecl(x.pos, (Core.IdPat)x.pat, x.exp)));
                return CoreBuilder.core.let(CoreBuilder.core.recValDecl(valDecls), resultExp);
            }
            if (!this.composite && ((PatExp)this.patExps.get((int)0)).pat instanceof Core.IdPat) {
                PatExp x2 = (PatExp)this.patExps.get(0);
                Core.NonRecValDecl valDecl = CoreBuilder.core.nonRecValDecl(x2.pos, (Core.IdPat)x2.pat, x2.exp);
                return CoreBuilder.core.let(valDecl, resultExp);
            }
            String name = Resolver.this.nameGenerator.get();
            Core.IdPat idPat = CoreBuilder.core.idPat(this.pat.type, name, Resolver.this.nameGenerator);
            Core.Id id = CoreBuilder.core.id(idPat);
            Pos pos = ((PatExp)this.patExps.get((int)0)).pos;
            return CoreBuilder.core.let(CoreBuilder.core.nonRecValDecl(pos, idPat, this.exp), CoreBuilder.core.caseOf(pos, resultExp.type, id, (Iterable<? extends Core.Match>)ImmutableList.of((Object)CoreBuilder.core.match(pos, this.pat, resultExp))));
        }
    }

    static class PatExp {
        final Core.Pat pat;
        final Core.Exp exp;
        final Pos pos;

        PatExp(Core.Pat pat, Core.Exp exp, Pos pos) {
            this.pat = pat;
            this.exp = exp;
            this.pos = pos;
        }

        public String toString() {
            return "[pat: " + this.pat + ", exp: " + this.exp + ", pos: " + this.pos + "]";
        }
    }

    static class ResolvedDatatypeDecl
    extends ResolvedDecl {
        private final ImmutableList<DataType> dataTypes;

        ResolvedDatatypeDecl(ImmutableList<DataType> dataTypes) {
            this.dataTypes = dataTypes;
        }

        @Override
        Core.Exp toExp(Core.Exp resultExp) {
            return this.toExp((List<DataType>)this.dataTypes, resultExp);
        }

        private Core.Exp toExp(List<DataType> dataTypes, Core.Exp resultExp) {
            if (dataTypes.isEmpty()) {
                return resultExp;
            }
            return CoreBuilder.core.local(dataTypes.get(0), this.toExp(Static.skip(dataTypes), resultExp));
        }

        public Core.DatatypeDecl toDecl() {
            return CoreBuilder.core.datatypeDecl((Iterable<DataType>)this.dataTypes);
        }
    }

    static class ReferenceFinder
    extends EnvVisitor {
        final Set<Core.NamedPat> set;

        protected ReferenceFinder(TypeSystem typeSystem, Environment env, Set<Core.NamedPat> set, Deque<EnvVisitor.FromContext> fromStack) {
            super(typeSystem, env, fromStack);
            this.set = set;
        }

        @Override
        protected ReferenceFinder push(Environment env) {
            return new ReferenceFinder(this.typeSystem, env, this.set, this.fromStack);
        }

        @Override
        protected void visit(Core.Id id) {
            if (this.env.getOpt(id.idPat) == null) {
                this.set.add(id.idPat);
            }
            super.visit(id);
        }
    }

    public static abstract class ResolvedDecl {
        abstract Core.Exp toExp(Core.Exp var1);
    }

    private class FromResolver
    extends Visitor {
        final FromBuilder fromBuilder;

        private FromResolver() {
            this.fromBuilder = CoreBuilder.core.fromBuilder(Resolver.this.typeMap.typeSystem, Resolver.this.env);
        }

        Core.Exp run(Ast.From from) {
            if (from.isInto()) {
                Core.Exp coreFrom = this.run(Util.skipLast(from.steps));
                Ast.Into into = (Ast.Into)Util.last(from.steps);
                Core.Exp exp = Resolver.this.toCore(into.exp);
                return CoreBuilder.core.apply(exp.pos, Resolver.this.typeMap.getType(from), exp, coreFrom);
            }
            Core.Exp coreFrom = this.run((List<Ast.FromStep>)from.steps);
            if (from.isCompute()) {
                return CoreBuilder.core.only(Resolver.this.typeMap.typeSystem, from.pos, coreFrom);
            }
            return coreFrom;
        }

        private Core.Exp run(List<Ast.FromStep> steps) {
            steps.forEach(x$0 -> this.accept(x$0));
            return this.fromBuilder.buildSimplify();
        }

        @Override
        protected void visit(Ast.From from) {
        }

        @Override
        protected void visit(Ast.Scan scan) {
            Core.Exp coreExp;
            Core.Pat corePat;
            Resolver r = Resolver.this.withEnv(this.fromBuilder.bindings());
            if (scan.exp == null) {
                corePat = r.toCore(scan.pat);
                coreExp = CoreBuilder.core.extent(Resolver.this.typeMap.typeSystem, corePat.type, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
            } else {
                coreExp = r.toCore(scan.exp);
                ListType listType = (ListType)coreExp.type;
                corePat = r.toCore(scan.pat, listType.elementType);
            }
            ArrayList<Binding> bindings2 = new ArrayList<Binding>(this.fromBuilder.bindings());
            Compiles.acceptBinding(Resolver.this.typeMap.typeSystem, corePat, bindings2);
            Core.Literal coreCondition = scan.condition == null ? CoreBuilder.core.boolLiteral(true) : r.withEnv(bindings2).toCore(scan.condition);
            this.fromBuilder.scan(corePat, coreExp, coreCondition);
        }

        @Override
        protected void visit(Ast.Where where) {
            Resolver r = Resolver.this.withEnv(this.fromBuilder.bindings());
            this.fromBuilder.where(r.toCore(where.exp));
        }

        @Override
        protected void visit(Ast.Skip skip) {
            Resolver r = Resolver.this.withEnv(Resolver.this.env);
            this.fromBuilder.skip(r.toCore(skip.exp));
        }

        @Override
        protected void visit(Ast.Take take) {
            Resolver r = Resolver.this.withEnv(Resolver.this.env);
            this.fromBuilder.take(r.toCore(take.exp));
        }

        @Override
        protected void visit(Ast.Yield yield) {
            Resolver r = Resolver.this.withEnv(this.fromBuilder.bindings());
            this.fromBuilder.yield_(r.toCore(yield.exp));
        }

        @Override
        protected void visit(Ast.Order order) {
            Resolver r = Resolver.this.withEnv(this.fromBuilder.bindings());
            this.fromBuilder.order((Iterable<Core.OrderItem>)Static.transformEager(order.orderItems, x$0 -> r.toCore(x$0)));
        }

        @Override
        protected void visit(Ast.Through through) {
            Core.From from = this.fromBuilder.build();
            this.fromBuilder.clear();
            Core.Exp exp = Resolver.this.toCore(through.exp);
            Core.Pat pat = Resolver.this.toCore(through.pat);
            ListType type = Resolver.this.typeMap.typeSystem.listType(pat.type);
            this.fromBuilder.scan(pat, CoreBuilder.core.apply(through.pos, type, exp, from));
        }

        @Override
        protected void visit(Ast.Compute compute) {
            this.visit((Ast.Group)compute);
        }

        @Override
        protected void visit(Ast.Group group) {
            Resolver r = Resolver.this.withEnv(this.fromBuilder.bindings());
            ImmutableSortedMap.Builder groupExpsB = ImmutableSortedMap.naturalOrder();
            ImmutableSortedMap.Builder aggregates = ImmutableSortedMap.naturalOrder();
            Pair.forEach(group.groupExps, (id, exp) -> groupExpsB.put((Object)Resolver.this.toCorePat(id), (Object)r.toCore(exp)));
            ImmutableSortedMap groupExps = groupExpsB.build();
            group.aggregates.forEach(arg_0 -> this.lambda$visit$3(aggregates, r, (SortedMap)groupExps, arg_0));
            this.fromBuilder.group((SortedMap<Core.IdPat, Core.Exp>)groupExps, (SortedMap<Core.IdPat, Core.Aggregate>)aggregates.build());
        }

        @Override
        protected void visit(Ast.Distinct distinct) {
            this.fromBuilder.distinct();
        }

        private /* synthetic */ void lambda$visit$3(ImmutableSortedMap.Builder aggregates, Resolver r, SortedMap groupExps, Ast.Aggregate aggregate) {
            aggregates.put((Object)Resolver.this.toCorePat(aggregate.id), (Object)r.toCore(aggregate, groupExps.keySet()));
        }
    }

    private static enum Init {
        INSTANCE;

        final ImmutableMap<Op, BuiltIn> opBuiltInMap;
        final ImmutableMap<BuiltIn, Op> builtInOpMap;

        private Init() {
            Object[] values = new Object[]{BuiltIn.LIST_OP_AT, Op.AT, BuiltIn.OP_CONS, Op.CONS, BuiltIn.OP_EQ, Op.EQ, BuiltIn.OP_EXCEPT, Op.EXCEPT, BuiltIn.OP_GE, Op.GE, BuiltIn.OP_GT, Op.GT, BuiltIn.OP_INTERSECT, Op.INTERSECT, BuiltIn.OP_LE, Op.LE, BuiltIn.OP_LT, Op.LT, BuiltIn.OP_NE, Op.NE, BuiltIn.OP_UNION, Op.UNION, BuiltIn.Z_ANDALSO, Op.ANDALSO, BuiltIn.Z_ORELSE, Op.ORELSE, BuiltIn.Z_PLUS_INT, Op.PLUS, BuiltIn.Z_PLUS_REAL, Op.PLUS};
            ImmutableMap.Builder b2o = ImmutableMap.builder();
            HashMap<Op, BuiltIn> o2b = new HashMap<Op, BuiltIn>();
            for (int i = 0; i < values.length / 2; ++i) {
                BuiltIn builtIn = (BuiltIn)((Object)values[i * 2]);
                Op op = (Op)((Object)values[i * 2 + 1]);
                b2o.put((Object)builtIn, (Object)op);
                o2b.put(op, builtIn);
            }
            this.builtInOpMap = b2o.build();
            this.opBuiltInMap = ImmutableMap.copyOf(o2b);
        }
    }
}

