/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.compile.TypeResolver;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Unifier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeMap {
    public final TypeSystem typeSystem;
    private final Map<AstNode, Unifier.Term> nodeTypeTerms;
    final Unifier.Substitution substitution;
    private final Map<String, TypeVar> typeVars = new HashMap<String, TypeVar>();

    TypeMap(TypeSystem typeSystem, Map<AstNode, Unifier.Term> nodeTypeTerms, Unifier.Substitution substitution) {
        this.typeSystem = Objects.requireNonNull(typeSystem);
        this.nodeTypeTerms = ImmutableMap.copyOf(nodeTypeTerms);
        this.substitution = Objects.requireNonNull(substitution.resolve());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("terms:\n");
        ArrayList<Map.Entry<AstNode, Unifier.Term>> nodeTerms = new ArrayList<Map.Entry<AstNode, Unifier.Term>>(this.nodeTypeTerms.entrySet());
        nodeTerms.sort(Comparator.comparing(o -> ((Unifier.Term)o.getValue()).toString()));
        nodeTerms.forEach(pair -> b.append(pair.getValue()).append(": ").append(pair.getKey()).append('\n'));
        b.append("substitution:\n");
        this.substitution.accept(b);
        return b.toString();
    }

    Type termToType(Unifier.Term term) {
        return term.accept(new TermToTypeConverter(this));
    }

    public Type getType(AstNode node) {
        Unifier.Term term = Objects.requireNonNull(this.nodeTypeTerms.get(node));
        return this.termToType(term);
    }

    public @Nullable Type getTypeOpt(AstNode node) {
        Unifier.Term term = this.nodeTypeTerms.get(node);
        return term == null ? null : this.termToType(term);
    }

    public boolean typeIsVariable(AstNode node) {
        Unifier.Term term = this.nodeTypeTerms.get(node);
        if (term instanceof Unifier.Variable) {
            Type type = this.termToType(term);
            return type instanceof TypeVar || type.isProgressive();
        }
        return false;
    }

    public boolean hasType(AstNode node) {
        return this.nodeTypeTerms.containsKey(node);
    }

    @Nullable SortedSet<String> typeFieldNames(AstNode node) {
        Type type;
        Unifier.Sequence sequence;
        List<String> fieldList;
        Unifier.Term term = this.nodeTypeTerms.get(node);
        if (term instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList(sequence = (Unifier.Sequence)term)) != null) {
            return ImmutableSortedSet.copyOf(RecordType.ORDERING, fieldList);
        }
        if (term instanceof Unifier.Variable && (type = this.termToType(term)) instanceof RecordLikeType) {
            return (SortedSet)((RecordLikeType)type).argNameTypes().keySet();
        }
        return null;
    }

    private static class TermToTypeConverter
    implements Unifier.TermVisitor<Type> {
        private final TypeMap typeMap;

        TermToTypeConverter(TypeMap typeMap) {
            this.typeMap = typeMap;
        }

        @Override
        public Type visit(Unifier.Sequence sequence) {
            List<String> argNames;
            switch (sequence.operator) {
                case "fn": {
                    assert (sequence.terms.size() == 2);
                    Type paramType = sequence.terms.get(0).accept(this);
                    Type resultType = sequence.terms.get(1).accept(this);
                    return this.typeMap.typeSystem.fnType(paramType, resultType);
                }
                case "tuple": {
                    assert (sequence.terms.size() != 1);
                    ImmutableList<Type> argTypes = Static.transformEager(sequence.terms, term -> term.accept(this));
                    return this.typeMap.typeSystem.tupleType((List<? extends Type>)argTypes);
                }
                case "list": {
                    assert (sequence.terms.size() == 1);
                    Type elementType = sequence.terms.get(0).accept(this);
                    return this.typeMap.typeSystem.listType(elementType);
                }
            }
            Type type = this.typeMap.typeSystem.lookupOpt(sequence.operator);
            if (type != null) {
                if (sequence.terms.isEmpty()) {
                    return type;
                }
                List<Type> types = Static.transform(sequence.terms, t -> t.accept(this));
                return this.typeMap.typeSystem.apply(type, types);
            }
            if (sequence.operator.startsWith("record") && (argNames = TypeResolver.fieldList(sequence)) != null) {
                PairList<String, Type> argNameTypes = PairList.of();
                AtomicBoolean progressive = new AtomicBoolean(false);
                Pair.forEach(argNames, sequence.terms, (name, term) -> {
                    if (name.equals("z$dummy")) {
                        progressive.set(true);
                    } else {
                        argNameTypes.add((String)name, term.accept(this));
                    }
                });
                return progressive.get() ? this.typeMap.typeSystem.progressiveRecordType(argNameTypes) : this.typeMap.typeSystem.recordType(argNameTypes);
            }
            throw new AssertionError((Object)("unknown type constructor " + sequence.operator));
        }

        @Override
        public Type visit(Unifier.Variable variable) {
            Unifier.Term term = this.typeMap.substitution.resultMap.get(variable);
            if (term == null) {
                return this.typeMap.typeVars.computeIfAbsent(variable.toString(), varName -> new TypeVar(this.typeMap.typeVars.size()));
            }
            return term.accept(this);
        }
    }
}

