/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Prop
extends Enum<Prop> {
    public static final /* enum */ Prop DIRECTORY = new Prop("directory", File.class, new File(""));
    public static final /* enum */ Prop SCRIPT_DIRECTORY = new Prop("scriptDirectory", File.class, new File(""));
    public static final /* enum */ Prop HYBRID = new Prop("hybrid", Boolean.class, false);
    public static final /* enum */ Prop INLINE_PASS_COUNT = new Prop("inlinePassCount", Integer.class, 5);
    public static final /* enum */ Prop MATCH_COVERAGE_ENABLED = new Prop("matchCoverageEnabled", Boolean.class, true);
    public static final /* enum */ Prop OPTIONAL_INT = new Prop("optionalInt", Integer.class, null);
    public static final /* enum */ Prop PRINT_DEPTH = new Prop("printDepth", Integer.class, 5);
    public static final /* enum */ Prop PRINT_LENGTH = new Prop("printLength", Integer.class, 12);
    public static final /* enum */ Prop RELATIONALIZE = new Prop("relationalize", Boolean.class, false);
    public static final /* enum */ Prop STRING_DEPTH = new Prop("stringDepth", Integer.class, 70);
    public static final /* enum */ Prop LINE_WIDTH = new Prop("lineWidth", Integer.class, 79);
    public final String camelName;
    private final Class<?> type;
    private final Object defaultValue;
    public static final ImmutableMap<String, Prop> BY_NAME;
    private static final /* synthetic */ Prop[] $VALUES;

    public static Prop[] values() {
        return (Prop[])$VALUES.clone();
    }

    public static Prop valueOf(String name) {
        return Enum.valueOf(Prop.class, name);
    }

    private Prop(String camelName, Class<?> type, Object defaultValue) {
        this.camelName = camelName;
        this.type = type;
        this.defaultValue = defaultValue;
        assert (CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelName).equals(this.name()));
        if (type == Boolean.class) {
            assert (defaultValue == null || defaultValue.getClass() == type);
        } else if (type == Integer.class) {
            assert (defaultValue == null || defaultValue.getClass() == type);
        } else if (type == String.class) {
            assert (defaultValue == null || defaultValue.getClass() == type);
        } else if (type == File.class) {
            assert (defaultValue == null || defaultValue.getClass() == type);
        } else {
            throw new AssertionError((Object)("not a valid property type: " + type));
        }
    }

    public static Prop lookup(String propName) {
        Prop prop = (Prop)((Object)BY_NAME.get((Object)propName));
        if (prop == null) {
            throw new RuntimeException("property " + propName + " not found");
        }
        return prop;
    }

    public Object get(Map<Prop, Object> map) {
        Object o = map.get((Object)this);
        return o != null ? o : this.defaultValue;
    }

    public boolean booleanValue(Map<Prop, Object> map) {
        assert (this.type == Boolean.class);
        Object o = map.get((Object)this);
        return (Boolean)this.typeValue(o);
    }

    public int intValue(Map<Prop, Object> map) {
        assert (this.type == Integer.class);
        Object o = map.get((Object)this);
        return (Integer)this.typeValue(o);
    }

    public String stringValue(Map<Prop, Object> map) {
        assert (this.type == String.class);
        Object o = map.get((Object)this);
        return (String)this.typeValue(o);
    }

    public File fileValue(Map<Prop, Object> map) {
        assert (this.type == File.class);
        Object o = map.get((Object)this);
        return (File)this.typeValue(o);
    }

    private <T> T typeValue(Object o) {
        if (o == null) {
            if (this.defaultValue == null) {
                throw new RuntimeException("no value for property " + this.camelName + " and no default value");
            }
            return (T)this.defaultValue;
        }
        return (T)o;
    }

    public void set(Map<Prop, Object> map, Object value) {
        if (value != null && !this.type.isInstance(value)) {
            throw new RuntimeException("value for property must have type " + this.type);
        }
        map.put(this, value);
    }

    public Object remove(Map<Prop, Object> map) {
        return map.remove((Object)this);
    }

    private static /* synthetic */ Prop[] $values() {
        return new Prop[]{DIRECTORY, SCRIPT_DIRECTORY, HYBRID, INLINE_PASS_COUNT, MATCH_COVERAGE_ENABLED, OPTIONAL_INT, PRINT_DEPTH, PRINT_LENGTH, RELATIONALIZE, STRING_DEPTH, LINE_WIDTH};
    }

    static {
        $VALUES = Prop.$values();
        LinkedHashMap<String, Prop> map = new LinkedHashMap<String, Prop>();
        for (Prop value : Prop.values()) {
            map.put(value.name(), value);
            map.put(value.camelName, value);
        }
        BY_NAME = ImmutableMap.copyOf(map);
    }
}

