/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.parse;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.parse.MorelParser;
import net.hydromatic.morel.parse.MorelParserImplConstants;
import net.hydromatic.morel.parse.MorelParserImplTokenManager;
import net.hydromatic.morel.parse.ParseException;
import net.hydromatic.morel.parse.Parsers;
import net.hydromatic.morel.parse.SimpleCharStream;
import net.hydromatic.morel.parse.Span;
import net.hydromatic.morel.parse.Token;
import net.hydromatic.morel.util.Folder;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorelParserImpl
implements MorelParser,
MorelParserImplConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"net.hydromatic.morel.parse");
    private int lineOffset;
    private String file = "";
    public MorelParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[86];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    @Override
    public Pos pos() {
        return new Pos(this.file, this.token.beginLine - this.lineOffset, this.token.beginColumn, this.token.endLine - this.lineOffset, this.token.endColumn + 1);
    }

    @Override
    public void zero(String file) {
        this.file = file;
        if (this.jj_input_stream.bufpos >= 0) {
            this.lineOffset = this.jj_input_stream.bufline[this.jj_input_stream.bufpos];
        }
    }

    void debug_message1() throws ParseException {
        LOGGER.info("{} , {}", (Object)this.getToken((int)0).image, (Object)this.getToken((int)1).image);
    }

    public final Ast.Literal literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                Ast.Literal e = this.numericLiteral();
                return e;
            }
            case 47: {
                Ast.Literal e = this.stringLiteral();
                return e;
            }
            case 48: {
                Ast.Literal e = this.charLiteral();
                return e;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Literal literalEof() throws ParseException {
        Ast.Literal n = this.literal();
        this.jj_consume_token(0);
        return n;
    }

    public final Ast.Literal numericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 42: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BigDecimal d = this.token.image.startsWith("~") ? new BigDecimal(this.token.image.substring(1)).negate() : new BigDecimal(this.token.image);
                return AstBuilder.ast.intLiteral(this.pos(), d);
            }
            case 43: {
                BigDecimal d;
                this.jj_consume_token(43);
                if (this.token.image.startsWith("~")) {
                    d = new BigDecimal(this.token.image.substring(1)).negate();
                    if (d.compareTo(BigDecimal.ZERO) == 0) {
                        return AstBuilder.ast.realLiteral(this.pos(), Float.valueOf(-0.0f));
                    }
                } else {
                    d = new BigDecimal(this.token.image);
                }
                return AstBuilder.ast.realLiteral(this.pos(), d);
            }
            case 44: {
                BigDecimal d;
                this.jj_consume_token(44);
                int e = Math.max(this.token.image.indexOf("e"), this.token.image.indexOf("E"));
                if (this.token.image.startsWith("~")) {
                    d = new BigDecimal(this.token.image.substring(1, e)).negate();
                    if (d.compareTo(BigDecimal.ZERO) == 0) {
                        return AstBuilder.ast.realLiteral(this.pos(), Float.valueOf(-0.0f));
                    }
                } else {
                    d = new BigDecimal(this.token.image.substring(0, e));
                }
                int exponent = this.token.image.startsWith("~", e + 1) ? -Integer.parseInt(this.token.image.substring(e + 2)) : Integer.parseInt(this.token.image.substring(e + 1));
                return AstBuilder.ast.realLiteral(this.pos(), d.scaleByPowerOfTen(exponent));
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Literal stringLiteral() throws ParseException {
        this.jj_consume_token(47);
        return AstBuilder.ast.stringLiteral(this.pos(), Parsers.unquoteString(this.token.image));
    }

    public final Ast.Literal charLiteral() throws ParseException {
        this.jj_consume_token(48);
        return AstBuilder.ast.charLiteral(this.pos(), Parsers.unquoteCharLiteral(this.token.image));
    }

    public final Ast.Id identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                return AstBuilder.ast.id(this.pos(), this.token.image);
            }
            case 91: {
                this.jj_consume_token(91);
                return AstBuilder.ast.id(this.pos(), Parsers.unquoteIdentifier(this.token.image));
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.RecordSelector recordSelector() throws ParseException {
        this.jj_consume_token(93);
        assert (this.token.image.startsWith("#"));
        return AstBuilder.ast.recordSelector(this.pos(), this.token.image.substring(1));
    }

    public final Ast.TyVar tyVar() throws ParseException {
        this.jj_consume_token(92);
        assert (this.token.image.startsWith("'"));
        return AstBuilder.ast.tyVar(this.pos(), this.token.image);
    }

    public final List<Ast.TyVar> tyVarOptionalList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 92: {
                Ast.TyVar tyVar = this.tyVar();
                return ImmutableList.of((Object)tyVar);
            }
            case 49: {
                this.jj_consume_token(49);
                ArrayList<Ast.TyVar> tyVars = new ArrayList<Ast.TyVar>();
                Ast.TyVar tyVar = this.tyVar();
                tyVars.add(tyVar);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(58);
                    tyVar = this.tyVar();
                    tyVars.add(tyVar);
                }
                return tyVars;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        return ImmutableList.of();
    }

    public final Ast.RecordType recordType() throws ParseException {
        this.jj_consume_token(51);
        Span span = Span.of(this.pos());
        LinkedHashMap<String, Ast.Type> map = new LinkedHashMap<String, Ast.Type>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: 
            case 91: {
                this.fieldType(map);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(58);
                    this.fieldType(map);
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(52);
        return AstBuilder.ast.recordType(span.end(this), map);
    }

    public final void fieldType(Map<String, Ast.Type> map) throws ParseException {
        Ast.Id id = this.identifier();
        this.jj_consume_token(64);
        Ast.Type type = this.type();
        map.put(id.name, type);
    }

    public final Ast.Exp ifThenElse() throws ParseException {
        this.jj_consume_token(14);
        Span span = Span.of(this.pos());
        Ast.Exp condition = this.expression();
        this.jj_consume_token(24);
        Ast.Exp ifTrue = this.expression();
        this.jj_consume_token(9);
        Ast.Exp ifFalse = this.expression();
        return AstBuilder.ast.ifThenElse(span.end(this), condition, ifTrue, ifFalse);
    }

    public final Ast.Exp let() throws ParseException {
        ArrayList<Ast.Decl> declList = new ArrayList<Ast.Decl>();
        this.jj_consume_token(17);
        Span span = Span.of(this.pos());
        block6: while (true) {
            Ast.Decl decl = this.decl();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 55: {
                    this.jj_consume_token(55);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
            declList.add(decl);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 13: 
                case 26: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(15);
        Ast.Exp e = this.expression();
        this.jj_consume_token(11);
        return AstBuilder.ast.let(span.end(this), declList, e);
    }

    public final Ast.Exp caseOf() throws ParseException {
        this.jj_consume_token(5);
        Span span = Span.of(this.pos());
        Ast.Exp exp = this.expression();
        this.jj_consume_token(21);
        List<Ast.Match> matchList = this.matchList();
        return AstBuilder.ast.caseOf(span.end(this), exp, matchList);
    }

    public final Ast.Exp from() throws ParseException {
        ArrayList<Ast.FromStep> steps = new ArrayList<Ast.FromStep>();
        this.jj_consume_token(30);
        Span span = Span.of(this.pos());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 90: 
            case 91: {
                this.fromFirstScan(steps);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(58);
                    this.fromScan(steps);
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 29: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block10;
                }
            }
            this.fromStep(steps);
        }
        return AstBuilder.ast.from(span.end(this), steps);
    }

    public final void fromFirstScan(List<Ast.FromStep> steps) throws ParseException {
        Pair<Ast.Pat, Ast.Exp> patExp = this.fromSource();
        Span span = patExp.right != null ? Span.of((AstNode)patExp.left, (AstNode)patExp.right) : Span.of((AstNode)patExp.left);
        steps.add(AstBuilder.ast.scan(span.pos(), (Ast.Pat)patExp.left, (Ast.Exp)patExp.right, null));
    }

    public final void fromScan(List<Ast.FromStep> steps) throws ParseException {
        Ast.Exp condition;
        Span span;
        Pair<Ast.Pat, Ast.Exp> patExp = this.fromSource();
        Span span2 = span = patExp.right != null ? Span.of((AstNode)patExp.left, (AstNode)patExp.right) : Span.of((AstNode)patExp.left);
        if (this.jj_2_1(2)) {
            this.jj_consume_token(34);
            condition = this.expression();
        } else {
            condition = null;
        }
        steps.add(AstBuilder.ast.scan(span.end(this), (Ast.Pat)patExp.left, (Ast.Exp)patExp.right, condition));
    }

    public final void fromStep(List<Ast.FromStep> steps) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                this.fromScan(steps);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(58);
                    this.fromScan(steps);
                }
            }
            case 39: {
                this.jj_consume_token(39);
                Span span = Span.of(this.pos());
                Ast.Exp filterExp = this.expression();
                steps.add(AstBuilder.ast.where(span.end(this), filterExp));
                break;
            }
            case 31: {
                ImmutableList aggregates;
                PairList<Ast.Id, Ast.Exp> groupExps;
                this.jj_consume_token(31);
                Span span = Span.of(this.pos());
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 73: 
                    case 90: 
                    case 91: 
                    case 93: {
                        groupExps = this.namedExpressionCommaList();
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        groupExps = ImmutablePairList.of();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        aggregates = this.aggregateCommaList();
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        aggregates = ImmutableList.of();
                    }
                }
                steps.add(AstBuilder.ast.group(span.end(this), groupExps, (List<Ast.Aggregate>)aggregates));
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                Span span = Span.of(this.pos());
                List<Ast.Aggregate> aggregates = this.aggregateCommaList();
                steps.add(AstBuilder.ast.compute(span.end(this), aggregates));
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                steps.add(AstBuilder.ast.distinct(this.pos()));
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                Span span = Span.of(this.pos());
                Ast.Exp intoExp = this.expression();
                steps.add(AstBuilder.ast.into(span.end(this), intoExp));
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                Span span = Span.of(this.pos());
                List<Ast.OrderItem> orderItems = this.orderItemCommaList();
                steps.add(AstBuilder.ast.order(span.end(this), orderItems));
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                Span span = Span.of(this.pos());
                Ast.Exp skipExp = this.expression();
                steps.add(AstBuilder.ast.skip(span.end(this), skipExp));
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                Span span = Span.of(this.pos());
                Ast.Exp takeExp = this.expression();
                steps.add(AstBuilder.ast.take(span.end(this), takeExp));
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                Span span = Span.of(this.pos());
                Ast.Pat pat = this.pat();
                this.jj_consume_token(15);
                Ast.Exp throughExp = this.expression();
                steps.add(AstBuilder.ast.through(span.end(this), pat, throughExp));
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                Span span = Span.of(this.pos());
                Ast.Exp yieldExp = this.expression();
                steps.add(AstBuilder.ast.yield(span.end(this), yieldExp));
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Pair<Ast.Pat, Ast.Exp> fromSource() throws ParseException {
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Ast.Id id = this.identifier();
            return Pair.of(AstBuilder.ast.idPat(id.pos, id.name), null);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 90: 
            case 91: {
                Ast.Pat pat = this.pat();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        Ast.Exp exp = this.expression();
                        return Pair.of(pat, exp);
                    }
                    case 61: {
                        this.jj_consume_token(61);
                        Ast.Exp exp = this.expression();
                        return Pair.of(pat, AstBuilder.ast.fromEq(exp));
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<Ast.Aggregate> aggregateCommaList() throws ParseException {
        ArrayList<Ast.Aggregate> list = new ArrayList<Ast.Aggregate>();
        Ast.Aggregate e = this.aggregate();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            e = this.aggregate();
            list.add(e);
        }
        return list;
    }

    public final Ast.Aggregate aggregate() throws ParseException {
        Ast.Exp argument;
        PairList<Ast.Id, Ast.Exp> aggregateIds = PairList.of();
        this.namedExpression(aggregateIds);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                argument = this.expression();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                argument = null;
            }
        }
        Ast.Id id = (Ast.Id)((Map.Entry)aggregateIds.get(0)).getKey();
        Ast.Exp aggregate = (Ast.Exp)((Map.Entry)aggregateIds.get(0)).getValue();
        return AstBuilder.ast.aggregate(id.pos.plus(this.pos()), aggregate, argument, id);
    }

    public final List<Ast.OrderItem> orderItemCommaList() throws ParseException {
        ArrayList<Ast.OrderItem> list = new ArrayList<Ast.OrderItem>();
        Ast.OrderItem i = this.orderItem();
        list.add(i);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            i = this.orderItem();
            list.add(i);
        }
        return list;
    }

    public final Ast.OrderItem orderItem() throws ParseException {
        Ast.Exp exp = this.expression();
        Span span = Span.of(this.pos());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                return AstBuilder.ast.orderItem(span.end(this), exp, Ast.Direction.DESC);
            }
        }
        this.jj_la1[22] = this.jj_gen;
        return AstBuilder.ast.orderItem(span.end(this), exp, Ast.Direction.ASC);
    }

    public final Ast.Exp fn() throws ParseException {
        this.jj_consume_token(12);
        Span span = Span.of(this.pos());
        List<Ast.Match> matchList = this.matchList();
        return AstBuilder.ast.fn(span.end(this), matchList);
    }

    public final List<Ast.Match> matchList() throws ParseException {
        ArrayList<Ast.Match> matchList = new ArrayList<Ast.Match>();
        Ast.Match match = this.match();
        matchList.add(match);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            match = this.match();
            matchList.add(match);
        }
        return matchList;
    }

    public final Ast.Match match() throws ParseException {
        Ast.Pat pat = this.pat();
        this.jj_consume_token(59);
        Ast.Exp e = this.expression();
        return AstBuilder.ast.match(pat.pos.plus(e.pos), pat, e);
    }

    public final Ast.Exp expression9() throws ParseException {
        Ast.Exp e = this.atom();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(57);
            Ast.Id id = this.identifier();
            Ast.RecordSelector s = AstBuilder.ast.recordSelector(this.pos(), id.name);
            e = AstBuilder.ast.apply(s, e);
        }
        return e;
    }

    public final Ast.Exp expression8() throws ParseException {
        Ast.Exp e = this.expression9();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 12: 
                case 14: 
                case 17: 
                case 30: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 90: 
                case 91: 
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            Ast.Exp e2 = this.expression9();
            e = AstBuilder.ast.apply(e, e2);
        }
        return e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Ast.Exp expression7() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                Ast.Exp e = this.expression7();
                return AstBuilder.ast.negate(this.pos(), e);
            }
            case 5: 
            case 12: 
            case 14: 
            case 17: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 90: 
            case 91: 
            case 93: {
                Ast.Exp e = this.expression8();
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 7: 
                        case 16: 
                        case 18: 
                        case 71: 
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            return e;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 71: {
                            this.jj_consume_token(71);
                            Ast.Exp e2 = this.expression8();
                            e = AstBuilder.ast.times(e, e2);
                            continue block14;
                        }
                        case 72: {
                            this.jj_consume_token(72);
                            Ast.Exp e2 = this.expression8();
                            e = AstBuilder.ast.divide(e, e2);
                            continue block14;
                        }
                        case 7: {
                            this.jj_consume_token(7);
                            Ast.Exp e2 = this.expression8();
                            e = AstBuilder.ast.div(e, e2);
                            continue block14;
                        }
                        case 16: {
                            this.jj_consume_token(16);
                            Ast.Exp e2 = this.expression8();
                            e = AstBuilder.ast.intersect(e, e2);
                            continue block14;
                        }
                        case 18: {
                            this.jj_consume_token(18);
                            Ast.Exp e2 = this.expression8();
                            e = AstBuilder.ast.mod(e, e2);
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Exp expression6() throws ParseException {
        Ast.Exp e;
        block11: {
            e = this.expression7();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 10: 
                    case 25: 
                    case 68: 
                    case 69: 
                    case 70: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 68: {
                        this.jj_consume_token(68);
                        Ast.Exp e2 = this.expression7();
                        e = AstBuilder.ast.plus(e, e2);
                        continue block10;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        Ast.Exp e2 = this.expression7();
                        e = AstBuilder.ast.minus(e, e2);
                        continue block10;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        Ast.Exp e2 = this.expression7();
                        e = AstBuilder.ast.caret(e, e2);
                        continue block10;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        Ast.Exp e2 = this.expression7();
                        e = AstBuilder.ast.except(e, e2);
                        continue block10;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        Ast.Exp e2 = this.expression7();
                        e = AstBuilder.ast.union(e, e2);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[30] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    public final Ast.Exp expression5() throws ParseException {
        ArrayList<Folder<Ast.Exp>> list;
        block8: {
            list = new ArrayList<Folder<Ast.Exp>>();
            Ast.Exp e = this.expression6();
            Folder.start(list, e);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 74: 
                    case 75: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        this.jj_consume_token(75);
                        e = this.expression6();
                        Folder.at(list, e);
                        continue block7;
                    }
                    case 74: {
                        this.jj_consume_token(74);
                        e = this.expression6();
                        Folder.cons(list, e);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[32] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return (Ast.Exp)Folder.combineAll(list);
    }

    public final Ast.Exp expression4() throws ParseException {
        Ast.Exp e;
        block14: {
            e = this.expression5();
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 19: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.equal(e, e2);
                        continue block13;
                    }
                    case 67: {
                        this.jj_consume_token(67);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.notEqual(e, e2);
                        continue block13;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.lessThan(e, e2);
                        continue block13;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.greaterThan(e, e2);
                        continue block13;
                    }
                    case 65: {
                        this.jj_consume_token(65);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.lessThanOrEqual(e, e2);
                        continue block13;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.greaterThanOrEqual(e, e2);
                        continue block13;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.elem(e, e2);
                        continue block13;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        Ast.Exp e2 = this.expression5();
                        e = AstBuilder.ast.notElem(e, e2);
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[34] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    public final Ast.Exp expression3() throws ParseException {
        Ast.Exp e = this.expression4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(20);
            Ast.Exp e2 = this.expression4();
            e = AstBuilder.ast.o(e, e2);
        }
        return e;
    }

    public final Ast.Exp expression2() throws ParseException {
        Ast.Exp e = this.expression3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
            Ast.Exp e2 = this.expression3();
            e = AstBuilder.ast.andAlso(e, e2);
        }
        return e;
    }

    public final Ast.Exp expression1() throws ParseException {
        Ast.Exp e = this.expression2();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            Ast.Exp e2 = this.expression2();
            e = AstBuilder.ast.orElse(e, e2);
        }
        return e;
    }

    public final Ast.Exp expression() throws ParseException {
        Ast.Exp e = this.expression1();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            Ast.Type t = this.type();
            e = AstBuilder.ast.annotatedExp(e.pos.plus(t.pos), e, t);
        }
        return e;
    }

    public final PairList<Ast.Id, Ast.Exp> namedExpressionCommaList() throws ParseException {
        PairList<Ast.Id, Ast.Exp> list = PairList.of();
        this.namedExpression(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            this.namedExpression(list);
        }
        return list;
    }

    public final void namedExpression(PairList<Ast.Id, Ast.Exp> list) throws ParseException {
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            Ast.Id id = this.identifier();
            this.jj_consume_token(61);
            Ast.Exp exp = this.expression();
            list.add(id, exp);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 12: 
                case 14: 
                case 17: 
                case 30: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 73: 
                case 90: 
                case 91: 
                case 93: {
                    Ast.Exp exp = this.expression();
                    String name = AstBuilder.ast.implicitLabel(exp);
                    list.add(AstBuilder.ast.id(exp.pos, name), exp);
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Ast.Exp atom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: 
            case 91: {
                Ast.Id e = this.identifier();
                return e;
            }
            case 93: {
                Ast.RecordSelector e = this.recordSelector();
                return e;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                Ast.Literal e = this.literal();
                return e;
            }
            case 17: {
                Ast.Exp e = this.let();
                return e;
            }
            case 12: {
                Ast.Exp e = this.fn();
                return e;
            }
            case 14: {
                Ast.Exp e = this.ifThenElse();
                return e;
            }
            case 5: {
                Ast.Exp e = this.caseOf();
                return e;
            }
            case 30: {
                Ast.Exp e = this.from();
                return e;
            }
            case 49: {
                this.jj_consume_token(49);
                Span span = Span.of(this.pos());
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        return AstBuilder.ast.unitLiteral(span.end(this));
                    }
                    case 5: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 73: 
                    case 90: 
                    case 91: 
                    case 93: {
                        Ast.Exp e = this.expression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 50: {
                                this.jj_consume_token(50);
                                return e;
                            }
                            case 58: {
                                ArrayList<Ast.Exp> list = new ArrayList<Ast.Exp>();
                                list.add(e);
                                block36: while (true) {
                                    this.jj_consume_token(58);
                                    Ast.Exp e2 = this.expression();
                                    list.add(e2);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 58: {
                                            continue block36;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[41] = this.jj_gen;
                                this.jj_consume_token(50);
                                return AstBuilder.ast.tuple(span.end(this), list);
                            }
                        }
                        this.jj_la1[42] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 53: {
                this.jj_consume_token(53);
                Span span = Span.of(this.pos());
                ArrayList<Ast.Exp> list = new ArrayList<Ast.Exp>();
                block24 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 73: 
                    case 90: 
                    case 91: 
                    case 93: {
                        Ast.Exp e2 = this.expression();
                        list.add(e2);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[44] = this.jj_gen;
                                    break block24;
                                }
                            }
                            this.jj_consume_token(58);
                            e2 = this.expression();
                            list.add(e2);
                        }
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                    }
                }
                this.jj_consume_token(54);
                return AstBuilder.ast.list(span.end(this), list);
            }
            case 51: {
                this.jj_consume_token(51);
                Span span = Span.of(this.pos());
                PairList<String, Ast.Exp> nameExps = PairList.of();
                block30 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 73: 
                    case 90: 
                    case 91: 
                    case 93: {
                        this.recordExp(nameExps);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[46] = this.jj_gen;
                                    break block30;
                                }
                            }
                            this.jj_consume_token(58);
                            this.recordExp(nameExps);
                        }
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(52);
                return AstBuilder.ast.record(span.end(this), nameExps);
            }
        }
        this.jj_la1[48] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void recordExp(PairList<String, Ast.Exp> nameExps) throws ParseException {
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.jj_consume_token(41);
            String id = this.token.image;
            this.jj_consume_token(61);
            Ast.Exp exp = this.expression();
            nameExps.add(id, exp);
        } else if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(90);
            String id = this.token.image;
            this.jj_consume_token(61);
            Ast.Exp exp = this.expression();
            nameExps.add(id, exp);
        } else if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(91);
            String id = Parsers.unquoteIdentifier(this.token.image);
            this.jj_consume_token(61);
            Ast.Exp exp = this.expression();
            nameExps.add(id, exp);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 12: 
                case 14: 
                case 17: 
                case 30: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 73: 
                case 90: 
                case 91: 
                case 93: {
                    Ast.Exp exp = this.expression();
                    String label = AstBuilder.ast.implicitLabel(exp);
                    nameExps.add(label, exp);
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void addValDecl(List decls) throws ParseException {
        Ast.ValDecl decl = this.valDecl();
        decls.add(decl);
    }

    public final Ast.ValDecl valDecl() throws ParseException {
        boolean rec = false;
        ArrayList<Ast.ValBind> valBinds = new ArrayList<Ast.ValBind>();
        this.jj_consume_token(26);
        Span span = Span.of(this.pos());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                rec = true;
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        this.valBind(valBinds);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(2);
            this.valBind(valBinds);
        }
        return AstBuilder.ast.valDecl(span.end(this), rec, valBinds);
    }

    public final void valBind(List<Ast.ValBind> valBinds) throws ParseException {
        Ast.Pat pat = this.pat();
        this.jj_consume_token(61);
        Ast.Exp e = this.expression();
        valBinds.add(AstBuilder.ast.valBind(pat.pos.plus(e.pos), pat, e));
    }

    public final Ast.Decl decl() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                Ast.DatatypeDecl n = this.datatypeDecl();
                return n;
            }
            case 26: {
                Ast.ValDecl n = this.valDecl();
                return n;
            }
            case 13: {
                Ast.FunDecl n = this.funDecl();
                return n;
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Decl declEof() throws ParseException {
        Ast.Decl d = this.decl();
        this.jj_consume_token(0);
        return d;
    }

    public final Ast.DatatypeDecl datatypeDecl() throws ParseException {
        ArrayList<Ast.DatatypeBind> binds = new ArrayList<Ast.DatatypeBind>();
        this.jj_consume_token(6);
        Span span = Span.of(this.pos());
        this.datatypeBind(binds);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            this.datatypeBind(binds);
        }
        return AstBuilder.ast.datatypeDecl(span.end(this), binds);
    }

    public final void datatypeBind(List<Ast.DatatypeBind> datatypeBinds) throws ParseException {
        ArrayList<Ast.TyVar> tyVars = new ArrayList<Ast.TyVar>();
        ArrayList<Ast.TyCon> tyCons = new ArrayList<Ast.TyCon>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: 
            case 92: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 92: {
                        Ast.TyVar tyVar = this.tyVar();
                        tyVars.add(tyVar);
                        break block0;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        Ast.TyVar tyVar = this.tyVar();
                        tyVars.add(tyVar);
                        block13: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[54] = this.jj_gen;
                                    break block13;
                                }
                            }
                            this.jj_consume_token(58);
                            tyVar = this.tyVar();
                            tyVars.add(tyVar);
                        }
                        this.jj_consume_token(50);
                        break block0;
                    }
                }
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        Ast.Id id = this.identifier();
        this.jj_consume_token(61);
        Ast.TyCon tyCon = this.typeConstructor();
        tyCons.add(tyCon);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(56);
            tyCon = this.typeConstructor();
            tyCons.add(tyCon);
        }
        ImmutableList nodes = ImmutableList.builder().addAll(tyVars).add((Object)id).addAll(tyCons).build();
        datatypeBinds.add(AstBuilder.ast.datatypeBind(Pos.sum((List<? extends AstNode>)nodes), id, tyVars, tyCons));
    }

    public final Ast.TyCon typeConstructor() throws ParseException {
        Ast.Type type;
        Ast.Id tag = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                type = this.type();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
                type = null;
            }
        }
        Pos pos = type == null ? tag.pos : tag.pos.plus(type.pos);
        return AstBuilder.ast.typeConstructor(pos, tag, type);
    }

    public final Ast.FunDecl funDecl() throws ParseException {
        ArrayList<Ast.FunBind> funBindList = new ArrayList<Ast.FunBind>();
        this.jj_consume_token(13);
        Span span = Span.of(this.pos());
        this.funBind(funBindList);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            this.funBind(funBindList);
        }
        return AstBuilder.ast.funDecl(span.end(this), funBindList);
    }

    public final void funBind(List<Ast.FunBind> list) throws ParseException {
        ArrayList<Ast.FunMatch> matchList = new ArrayList<Ast.FunMatch>();
        this.funMatch(matchList);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            this.funMatch(matchList);
        }
        list.add(AstBuilder.ast.funBind(Pos.sum(matchList), matchList));
    }

    public final void funMatch(List<Ast.FunMatch> list) throws ParseException {
        ArrayList<Ast.Pat> patList = new ArrayList<Ast.Pat>();
        Ast.Type returnType = null;
        Ast.Id id = this.identifier();
        block6: while (true) {
            Ast.Pat pat = this.atomPat();
            patList.add(pat);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 90: 
                case 91: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[61] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                returnType = this.type();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        this.jj_consume_token(61);
        Ast.Exp expression = this.expression();
        list.add(AstBuilder.ast.funMatch(id.pos.plus(expression.pos), id.name, patList, returnType, expression));
    }

    public final Ast.Pat pat() throws ParseException {
        Ast.Pat pat = this.pat5();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            Ast.Type type = this.type();
            pat = AstBuilder.ast.annotatedPat(pat.pos.plus(type.pos), pat, type);
        }
        return pat;
    }

    public final Ast.Pat pat5() throws ParseException {
        ArrayList<Ast.Pat> list = new ArrayList<Ast.Pat>();
        Ast.Pat pat = this.pat4();
        list.add(pat);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 74: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(74);
            pat = this.pat4();
            list.add(pat);
        }
        pat = (Ast.Pat)list.get(list.size() - 1);
        for (int i = list.size() - 2; i >= 0; --i) {
            pat = AstBuilder.ast.consPat((Ast.Pat)list.get(i), pat);
        }
        return pat;
    }

    public final Ast.Pat pat4() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: 
            case 91: {
                Ast.Id id = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        Ast.Pat pat = this.pat();
                        return AstBuilder.ast.asPat(id.pos.plus(pat.pos), (Ast.IdPat)AstBuilder.ast.idPat(id.pos, id.name), pat);
                    }
                    case 1: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 90: 
                    case 91: {
                        Ast.Pat pat = this.pat();
                        return AstBuilder.ast.conPat(id.pos.plus(pat.pos), id, pat);
                    }
                }
                this.jj_la1[65] = this.jj_gen;
                return AstBuilder.ast.idPat(id.pos, id.name);
            }
            case 1: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                Ast.Pat pat = this.atomPat();
                return pat;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Pat atomPat() throws ParseException {
        ArrayList<Ast.Pat> list = new ArrayList<Ast.Pat>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: 
            case 91: {
                Ast.Id id = this.identifier();
                return AstBuilder.ast.idPat(id.pos, id.name);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                Ast.Literal literal = this.literal();
                return AstBuilder.ast.literalPat(literal.pos, literal.op.toPat(), literal.value);
            }
            case 1: {
                this.jj_consume_token(1);
                return AstBuilder.ast.wildcardPat(this.pos());
            }
            case 49: {
                this.jj_consume_token(49);
                Span span = Span.of(this.pos());
                block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 90: 
                    case 91: {
                        Ast.Pat p = this.pat();
                        list.add(p);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[67] = this.jj_gen;
                                    break block8;
                                }
                            }
                            this.jj_consume_token(58);
                            p = this.pat();
                            list.add(p);
                        }
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                    }
                }
                this.jj_consume_token(50);
                if (list.size() == 1) {
                    return (Ast.Pat)list.get(0);
                }
                return AstBuilder.ast.tuplePat(span.end(this), list);
            }
            case 53: {
                this.jj_consume_token(53);
                Span span = Span.of(this.pos());
                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 90: 
                    case 91: {
                        Ast.Pat p = this.pat();
                        list.add(p);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[69] = this.jj_gen;
                                    break block14;
                                }
                            }
                            this.jj_consume_token(58);
                            p = this.pat();
                            list.add(p);
                        }
                    }
                    default: {
                        this.jj_la1[70] = this.jj_gen;
                    }
                }
                this.jj_consume_token(54);
                return AstBuilder.ast.listPat(span.end(this), list);
            }
            case 51: {
                this.jj_consume_token(51);
                Span span = Span.of(this.pos());
                LinkedHashMap<String, Ast.Pat> map = new LinkedHashMap<String, Ast.Pat>();
                boolean ellipsis = false;
                block20 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: 
                    case 76: 
                    case 90: 
                    case 91: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 76: {
                                this.jj_consume_token(76);
                                ellipsis = true;
                                break block20;
                            }
                            case 41: 
                            case 90: 
                            case 91: {
                                this.recordPat(map);
                                while (this.jj_2_7(2)) {
                                    this.jj_consume_token(58);
                                    this.recordPat(map);
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 58: {
                                        this.jj_consume_token(58);
                                        this.jj_consume_token(76);
                                        ellipsis = true;
                                        break block20;
                                    }
                                }
                                this.jj_la1[71] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_la1[72] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                this.jj_consume_token(52);
                return AstBuilder.ast.recordPat(span.end(this), ellipsis, map);
            }
        }
        this.jj_la1[74] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void recordPat(Map<String, Ast.Pat> map) throws ParseException {
        String id;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                id = this.token.image;
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                id = this.token.image;
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                id = Parsers.unquoteIdentifier(this.token.image);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: {
                this.jj_consume_token(61);
                Ast.Pat pat = this.pat();
                map.put(id, pat);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                map.put(id, AstBuilder.ast.idPat(this.pos(), id));
            }
        }
    }

    public final Ast.Type atomicType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 92: {
                Ast.TyVar type = this.tyVar();
                return type;
            }
            case 90: {
                Ast.Type type = this.namedType();
                return type;
            }
            case 51: {
                Ast.RecordType type = this.recordType();
                return type;
            }
            case 49: {
                this.jj_consume_token(49);
                Span span = Span.of(this.pos());
                Ast.Type type = this.type();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        return type;
                    }
                    case 58: {
                        ArrayList<Ast.Type> list = new ArrayList<Ast.Type>();
                        list.add(type);
                        block13: while (true) {
                            this.jj_consume_token(58);
                            Ast.Type type2 = this.type();
                            list.add(type2);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 58: {
                                    continue block13;
                                }
                            }
                            break;
                        }
                        this.jj_la1[77] = this.jj_gen;
                        this.jj_consume_token(50);
                        return AstBuilder.ast.compositeType(span.end(this), list);
                    }
                }
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[79] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Type type7() throws ParseException {
        Ast.Type t = this.atomicType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(90);
            Object types = t instanceof Ast.CompositeType ? ((Ast.CompositeType)t).types : ImmutableList.of((Object)t);
            t = AstBuilder.ast.namedType(t.pos.plus(this.pos()), (Iterable<? extends Ast.Type>)types, this.token.image);
        }
        return t;
    }

    public final Ast.Type type6() throws ParseException {
        ArrayList<Ast.Type> types = new ArrayList<Ast.Type>();
        Ast.Type t = this.type7();
        types.add(t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 71: {
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(71);
            t = this.type7();
            types.add(t);
        }
        return types.size() == 1 ? t : AstBuilder.ast.tupleType(Pos.sum(types), types);
    }

    public final Ast.Type type() throws ParseException {
        ArrayList<Ast.Type> types = new ArrayList<Ast.Type>();
        Ast.Type t = this.type6();
        types.add(t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(60);
            t = this.type6();
            types.add(t);
        }
        return types.size() == 1 ? t : AstBuilder.ast.foldFunctionType(types);
    }

    public final Ast.Type namedType() throws ParseException {
        this.jj_consume_token(90);
        return AstBuilder.ast.namedType(this.pos(), (Iterable<? extends Ast.Type>)ImmutableList.of(), this.token.image);
    }

    public final AstNode statement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 12: 
            case 14: 
            case 17: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 73: 
            case 90: 
            case 91: 
            case 93: {
                Ast.Exp n = this.expression();
                return n;
            }
            case 6: 
            case 13: 
            case 26: {
                Ast.Decl n = this.decl();
                return n;
            }
        }
        this.jj_la1[83] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode statementSemicolon() throws ParseException {
        AstNode n = this.statement();
        this.jj_consume_token(55);
        return n;
    }

    public final AstNode statementSemicolonOrEof() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                return null;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 26: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 73: 
            case 90: 
            case 91: 
            case 93: {
                AstNode n = this.statement();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 55: {
                        this.jj_consume_token(55);
                        break;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break;
                    }
                    default: {
                        this.jj_la1[84] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return n;
            }
        }
        this.jj_la1[85] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode statementEof() throws ParseException {
        AstNode n = this.statement();
        this.jj_consume_token(0);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3R_charLiteral_183_3_83() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_expression_811_3_40();
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(90)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(33)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(39)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(31)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(27)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(36)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(37)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(40)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(0)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_stringLiteral_173_3_82() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_fn_550_3_72() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_expression7_638_3_53() {
        return this.jj_3R_expression8_620_3_54();
    }

    private boolean jj_3R_expression7_636_3_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_expression7_636_3_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_expression7_638_3_53()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_expression7_636_3_52() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_atom_917_3_67() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_expression4_720_3_48() {
        return this.jj_3R_expression5_703_3_49();
    }

    private boolean jj_3R_recordPat_1287_5_45() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3R_recordPat_1286_5_44() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_recordPat_1285_5_43() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_expression_811_3_40() {
        return this.jj_3R_expression1_796_3_42();
    }

    private boolean jj_3R_numericLiteral_145_3_86() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_expression8_620_3_54() {
        return this.jj_3R_expression9_603_3_55();
    }

    private boolean jj_3R_recordPat_1285_3_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_recordPat_1285_5_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_recordPat_1286_5_44()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_recordPat_1287_5_45()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_from_332_3_75() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_atom_902_3_66() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_expression5_703_3_49() {
        return this.jj_3R_expression6_670_3_50();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_3R_recordPat_1285_3_41();
    }

    private boolean jj_3R_numericLiteral_131_3_85() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_expression1_796_3_42() {
        return this.jj_3R_expression2_780_3_46();
    }

    private boolean jj_3R_caseOf_318_3_74() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_expression9_603_3_55() {
        return this.jj_3R_atom_862_3_56();
    }

    private boolean jj_3R_numericLiteral_122_3_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(42)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_numericLiteral_122_3_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numericLiteral_122_3_84()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_numericLiteral_131_3_85()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_numericLiteral_145_3_86()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_atom_878_3_65() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_atom_876_3_64() {
        return this.jj_3R_from_332_3_75();
    }

    private boolean jj_3R_recordSelector_210_3_69() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_expression2_780_3_46() {
        return this.jj_3R_expression3_764_3_47();
    }

    private boolean jj_3R_atom_874_3_63() {
        return this.jj_3R_caseOf_318_3_74();
    }

    private boolean jj_3R_let_303_3_71() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_atom_872_3_62() {
        return this.jj_3R_ifThenElse_287_3_73();
    }

    private boolean jj_3R_atom_870_3_61() {
        return this.jj_3R_fn_550_3_72();
    }

    private boolean jj_3R_atom_868_3_60() {
        return this.jj_3R_let_303_3_71();
    }

    private boolean jj_3R_atom_866_3_59() {
        return this.jj_3R_literal_100_3_70();
    }

    private boolean jj_3R_literal_104_3_80() {
        return this.jj_3R_charLiteral_183_3_83();
    }

    private boolean jj_3R_atom_864_3_58() {
        return this.jj_3R_recordSelector_210_3_69();
    }

    private boolean jj_3R_literal_102_3_79() {
        return this.jj_3R_stringLiteral_173_3_82();
    }

    private boolean jj_3R_atom_862_3_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_atom_862_3_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_atom_864_3_58()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_atom_866_3_59()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_atom_868_3_60()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_atom_870_3_61()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_atom_872_3_62()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_atom_874_3_63()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_atom_876_3_64()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_atom_878_3_65()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_atom_902_3_66()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_atom_917_3_67()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_atom_862_3_57() {
        return this.jj_3R_identifier_193_3_68();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_identifier_196_3_77() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3R_literal_100_3_78() {
        return this.jj_3R_numericLiteral_122_3_81();
    }

    private boolean jj_3R_literal_100_3_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_literal_100_3_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_literal_102_3_79()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_literal_104_3_80()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_expression6_670_3_50() {
        return this.jj_3R_expression7_636_3_51();
    }

    private boolean jj_3R_expression3_764_3_47() {
        return this.jj_3R_expression4_720_3_48();
    }

    private boolean jj_3R_identifier_193_3_76() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_identifier_193_3_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_identifier_193_3_76()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_identifier_196_3_77()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_ifThenElse_287_3_73() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(90)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                return true;
            }
        }
        return this.jj_scan_token(61);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(61);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4002040, 0, 2, -1476395008, 0, 1073893408, 0x8000000, -1476395008, 32768, 2, 0, 0x200000, 0, 0x10000000, 0, 0, 1073893408, 327808, 327808, 1073893408, 0x2000400, 0x2000400, 0, 0, 524544, 524544, 0x100000, 8, 0x400000, 0, 0, 1073893408, 0, 0, 1073893408, 0, 1073893408, 0, 1073893408, 1073893408, 1073893408, 0x800000, 4, 0x4002040, 4, 0, 0, 0, 0, 0x200000, 4, 0, 2, 0, 0, 0, 18, 2, 0, 2, 0, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1141010528, 1, 1141010529};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{105984, 1536, 7680, 0, 0x4000000, 131072, 0x4000000, 0, 0x800000, 0, 0x4000000, 2858496, 507, 0x4000000, 2858496, 0, 507, 0x20000000, 2858496, 0x4000000, 0, 0x4000000, 0, 0x1000000, 0x2000000, 2858496, 0, 0, 2858496, 0, 0, 0, 0, -536870912, -536870912, 0, 0, 0, 0, 0x4000000, 2858496, 0x4000000, 0x4040000, 3120640, 0x4000000, 2858496, 0x4000000, 2858496, 2858496, 2858496, 0, 0, 0, 0, 0x4000000, 131072, 131072, 0x1000000, 0, 0, 0x1000000, 2858496, 0, 0, 0, 2858496, 2858496, 0x4000000, 2858496, 0x4000000, 2858496, 0x4000000, 512, 512, 2858496, 512, 0x20000000, 0x4000000, 0x4040000, 655360, 0, 0, 0x10000000, 2858496, 0x800000, 2858496};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0xC000000, 0, 0x10000000, 0, 0xC000000, 0, 0, 0, 0xC000000, 0, 0, 0x2C000200, 0, 0, 0, 0xC000000, 0, 0, 0, 0, 0, 0, 0x2C000000, 384, 384, 0x2C000200, 112, 112, 3072, 3072, 14, 14, 0, 0, 0, 1, 0, 0x2C000200, 0, 0, 0x2C000200, 0, 0x2C000200, 0, 0x2C000200, 0x2C000000, 0x2C000200, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0, 0, 0, 0, 0xC000000, 1, 1, 1024, 0xC000000, 0xC000000, 0, 0xC000000, 0, 0xC000000, 0, 0xC001000, 0xC001000, 0xC000000, 0xC000000, 0, 0, 0, 0x14000000, 0x4000000, 128, 0, 0x2C000200, 0, 0x2C000200};
    }

    public MorelParserImpl(InputStream stream) {
        this(stream, null);
    }

    public MorelParserImpl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MorelParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MorelParserImpl(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MorelParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new MorelParserImplTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MorelParserImpl(MorelParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MorelParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 86; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[96];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 86; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 96; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        MorelParserImpl.jj_la1_init_0();
        MorelParserImpl.jj_la1_init_1();
        MorelParserImpl.jj_la1_init_2();
        jj_ls = new LookaheadSuccess();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

