/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.parse;

public final class Parsers {
    private Parsers() {
    }

    public static String unquoteIdentifier(String s) {
        assert (s.charAt(0) == '`');
        assert (s.charAt(s.length() - 1) == '`');
        return s.substring(1, s.length() - 1).replace("``", "`");
    }

    public static String unquoteString(String s) {
        assert (s.charAt(0) == '\"');
        assert (s.charAt(s.length() - 1) == '\"');
        return s.substring(1, s.length() - 1).replace("\\\\", "\\").replace("\\\"", "\"");
    }

    public static char unquoteCharLiteral(String s) {
        assert (s.charAt(0) == '#');
        assert (s.charAt(1) == '\"');
        assert (s.charAt(s.length() - 1) == '\"');
        String image = s.substring(2, s.length() - 1).replace("\\\\", "\\").replace("\\\"", "\"");
        if (image.length() != 1) {
            throw new RuntimeException("Error: character constant not length 1");
        }
        return image.charAt(0);
    }

    public static StringBuilder appendId(StringBuilder buf, String id) {
        if (id.contains("`")) {
            return buf.append("`").append(id.replaceAll("`", "``")).append("`");
        }
        if (id.contains(" ")) {
            return buf.append("`").append(id).append("`");
        }
        return buf.append(id);
    }
}

