/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.DummyType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Unit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RangeExtent {
    public final Map<String, ImmutableRangeSet> rangeSetMap;
    public final Type type;
    public final @Nullable Iterable iterable;

    public RangeExtent(TypeSystem typeSystem, Type type, Map<String, ImmutableRangeSet> rangeSetMap) {
        this.rangeSetMap = ImmutableMap.copyOf((Map)Maps.transformValues(rangeSetMap, r -> ImmutableRangeSet.copyOf((RangeSet)r)));
        this.type = type;
        this.iterable = this.toList(type, typeSystem);
    }

    public String toString() {
        if (this.isUnbounded()) {
            return this.type.toString();
        }
        return this.type + " " + this.rangeSetMap;
    }

    public boolean isUnbounded() {
        return this.rangeSetMap.isEmpty();
    }

    private <E extends Comparable<E>> Iterable<E> toList(Type type, TypeSystem typeSystem) {
        ArrayList list = new ArrayList();
        if (this.populate(typeSystem, type, "/", this.rangeSetMap, list::add)) {
            return list;
        }
        return null;
    }

    private <E extends Comparable<E>> boolean populate(TypeSystem typeSystem, Type type, String path, Map<String, ImmutableRangeSet> rangeSetMap, Consumer<E> consumer) {
        RangeSet rangeSet = (RangeSet)rangeSetMap.get(path);
        Consumer<Object> filteredConsumer = rangeSet != null ? e -> {
            if (rangeSet.contains(e)) {
                consumer.accept(e);
            }
        } : consumer;
        switch (type.op()) {
            case ID: {
                switch ((PrimitiveType)type) {
                    case BOOL: {
                        filteredConsumer.accept(Boolean.FALSE);
                        filteredConsumer.accept(Boolean.TRUE);
                        return true;
                    }
                    case UNIT: {
                        filteredConsumer.accept(Unit.INSTANCE);
                        return true;
                    }
                    case CHAR: {
                        for (int i = 0; i < 256; ++i) {
                            filteredConsumer.accept(Character.valueOf((char)i));
                        }
                        return true;
                    }
                    case INT: {
                        if (rangeSet == null) break;
                        for (Range range : rangeSet.asRanges()) {
                            if (!range.hasLowerBound() || !range.hasUpperBound()) {
                                return false;
                            }
                            int lower = ((BigDecimal)range.lowerEndpoint()).intValue() + (range.lowerBoundType() == BoundType.OPEN ? 1 : 0);
                            int upper = ((BigDecimal)range.upperEndpoint()).intValue() - (range.upperBoundType() == BoundType.OPEN ? 1 : 0);
                            for (int i = lower; i <= upper; ++i) {
                                consumer.accept(i);
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
            case DUMMY_TYPE: {
                assert (type == DummyType.INSTANCE);
                filteredConsumer.accept(Unit.INSTANCE);
                return true;
            }
            case DATA_TYPE: {
                DataType dataType = (DataType)type;
                for (Map.Entry<String, Type> entry : dataType.typeConstructors(typeSystem).entrySet()) {
                    Consumer<Comparable> consumer2;
                    String name = entry.getKey();
                    Type type2 = entry.getValue();
                    Consumer<Comparable> consumer3 = consumer2 = type2.op() == Op.DUMMY_TYPE ? v -> filteredConsumer.accept((Comparable)((Object)FlatLists.of((Object)name))) : v -> filteredConsumer.accept((Comparable)((Object)FlatLists.of((Object)name, (Object)v)));
                    if (this.populate(typeSystem, type2, path + name + "/", rangeSetMap, consumer2)) continue;
                    return false;
                }
                return true;
            }
            case RECORD_TYPE: 
            case TUPLE_TYPE: {
                RecordLikeType recordType = (RecordLikeType)type;
                ArrayList listList = new ArrayList();
                for (Map.Entry<String, Type> entry : recordType.argNameTypes().entrySet()) {
                    String name = entry.getKey();
                    Type type2 = entry.getValue();
                    ArrayList list2 = new ArrayList();
                    Consumer<Comparable> consumer2 = list2::add;
                    if (!this.populate(typeSystem, type2, path + name + '/', rangeSetMap, consumer2)) {
                        return false;
                    }
                    listList.add(list2);
                }
                Lists.cartesianProduct(listList).forEach(list -> filteredConsumer.accept(FlatLists.ofComparable((List)list)));
                return true;
            }
        }
        return false;
    }
}

