/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;

public class TypeVar
implements Type {
    private static final char[] ALPHAS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final LoadingCache<Integer, String> NAME_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(TypeVar::name));
    public final int ordinal;
    private final String name;

    public TypeVar(int ordinal) {
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0);
        this.ordinal = ordinal;
        try {
            this.name = Objects.requireNonNull((String)NAME_CACHE.get((Object)ordinal));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public int hashCode() {
        return this.ordinal + 6563;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TypeVar && this.ordinal == ((TypeVar)obj).ordinal;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    static String name(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder s = new StringBuilder();
        do {
            int mod = i % 26;
            s.append(ALPHAS[mod]);
        } while ((i /= 26) != 0);
        return s.append("'").reverse().toString();
    }

    @Override
    public Type.Key key() {
        return Keys.ordinal(this.ordinal);
    }

    @Override
    public Op op() {
        return Op.TY_VAR;
    }

    @Override
    public Type copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        return (Type)transform.apply(this);
    }

    @Override
    public Type substitute(TypeSystem typeSystem, List<? extends Type> types) {
        return types.get(this.ordinal);
    }
}

