/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.MapEntry;
import net.hydromatic.morel.util.PairList;
import org.apache.calcite.linq4j.function.Functions;
import org.checkerframework.checker.nullness.qual.Nullable;

class PairLists {
    static final ImmutablePairList<Object, Object> EMPTY = new EmptyImmutablePairList<Object, Object>();

    private PairLists() {
    }

    static <T, U> ImmutablePairList<T, U> immutableBackedBy(List<Object> list) {
        switch (list.size()) {
            case 0: {
                return ImmutablePairList.of();
            }
            case 2: {
                return new SingletonImmutablePairList<Object, Object>(list.get(0), list.get(1));
            }
        }
        return new ArrayImmutablePairList(list.toArray());
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... elements) {
        for (int i = 0; i < elements.length; ++i) {
            PairLists.checkElementNotNull(i, elements[i]);
        }
        return elements;
    }

    static void checkElementNotNull(int i, Object element) {
        if (element == null) {
            throw new NullPointerException((i % 2 == 0 ? "key" : "value") + " at index " + i / 2);
        }
    }

    static class SingletonImmutablePairList<T, U>
    extends AbstractPairList<T, U>
    implements ImmutablePairList<T, U> {
        private final T t;
        private final U u;

        SingletonImmutablePairList(T t, U u) {
            this.t = t;
            this.u = u;
            PairLists.checkElementNotNull(0, t);
            PairLists.checkElementNotNull(1, u);
        }

        @Override
        List<Object> backingList() {
            return ImmutableList.of(this.t, this.u);
        }

        @Override
        public Map.Entry<T, U> get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index out of range: " + index);
            }
            return new MapEntry<T, U>(this.t, this.u);
        }

        @Override
        public T left(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index out of range: " + index);
            }
            return this.t;
        }

        @Override
        public U right(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index out of range: " + index);
            }
            return this.u;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public List<T> leftList() {
            return ImmutableList.of(this.t);
        }

        @Override
        public List<U> rightList() {
            return ImmutableList.of(this.u);
        }

        @Override
        public void forEach(BiConsumer<T, U> consumer) {
            consumer.accept(this.t, this.u);
        }

        @Override
        public void forEachIndexed(PairList.IndexedBiConsumer<T, U> consumer) {
            consumer.accept(0, this.t, this.u);
        }

        @Override
        public <R> List<R> transform(BiFunction<T, U, R> function) {
            return ImmutableList.of(function.apply(this.t, this.u));
        }

        @Override
        public <R> ImmutableList<R> transform2(BiFunction<T, U, R> function) {
            return ImmutableList.of(function.apply(this.t, this.u));
        }

        @Override
        public boolean anyMatch(BiPredicate<T, U> predicate) {
            return predicate.test(this.t, this.u);
        }

        @Override
        public boolean allMatch(BiPredicate<T, U> predicate) {
            return predicate.test(this.t, this.u);
        }

        @Override
        public boolean noMatch(BiPredicate<T, U> predicate) {
            return !predicate.test(this.t, this.u);
        }

        @Override
        public int firstMatch(BiPredicate<T, U> predicate) {
            return predicate.test(this.t, this.u) ? 0 : -1;
        }
    }

    static class ArrayImmutablePairList<T, U>
    extends AbstractPairList<T, U>
    implements ImmutablePairList<T, U> {
        private final Object[] elements;

        ArrayImmutablePairList(Object[] elements) {
            this.elements = PairLists.checkElementsNotNull(elements);
        }

        @Override
        List<Object> backingList() {
            return Arrays.asList(this.elements);
        }

        @Override
        public Map.Entry<T, U> get(int index) {
            int x = index * 2;
            return new MapEntry<Object, Object>(this.elements[x], this.elements[x + 1]);
        }

        @Override
        public T left(int index) {
            int x = index * 2;
            return (T)this.elements[x];
        }

        @Override
        public U right(int index) {
            int x = index * 2;
            return (U)this.elements[x + 1];
        }

        @Override
        public int size() {
            return this.elements.length / 2;
        }

        @Override
        public List<T> leftList() {
            return new RandomAccessList<T>(){

                @Override
                public int size() {
                    return elements.length / 2;
                }

                @Override
                public T get(int index) {
                    return elements[index * 2];
                }
            };
        }

        @Override
        public List<U> rightList() {
            return new RandomAccessList<U>(){

                @Override
                public int size() {
                    return elements.length / 2;
                }

                @Override
                public U get(int index) {
                    return elements[index * 2 + 1];
                }
            };
        }

        @Override
        public void forEach(BiConsumer<T, U> consumer) {
            int x = 0;
            while (x < this.elements.length) {
                Object t = this.elements[x++];
                Object u = this.elements[x++];
                consumer.accept(t, u);
            }
        }

        @Override
        public void forEachIndexed(PairList.IndexedBiConsumer<T, U> consumer) {
            int x = 0;
            int i = 0;
            while (x < this.elements.length) {
                Object t = this.elements[x++];
                Object u = this.elements[x++];
                consumer.accept(i++, t, u);
            }
        }

        @Override
        public <R> List<R> transform(BiFunction<T, U, R> function) {
            return Functions.generate((int)(this.elements.length / 2), index -> {
                int x = index * 2;
                Object t = this.elements[x];
                Object u = this.elements[x + 1];
                return function.apply(t, u);
            });
        }

        @Override
        public <R> ImmutableList<R> transform2(BiFunction<T, U, R> function) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int i = 0;
            while (i < this.elements.length) {
                Object t = this.elements[i++];
                Object u = this.elements[i++];
                builder.add(function.apply(t, u));
            }
            return builder.build();
        }

        @Override
        public boolean anyMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.elements.length) {
                Object u;
                Object t;
                if (!predicate.test(t = this.elements[i++], u = this.elements[i++])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.elements.length) {
                Object u;
                Object t;
                if (predicate.test(t = this.elements[i++], u = this.elements[i++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.elements.length) {
                Object u;
                Object t;
                if (!predicate.test(t = this.elements[i++], u = this.elements[i++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int firstMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            int j = 0;
            while (i < this.elements.length) {
                Object u;
                Object t;
                if (predicate.test(t = this.elements[i++], u = this.elements[i++])) {
                    return j;
                }
                ++j;
            }
            return -1;
        }
    }

    static class EmptyImmutablePairList<T, U>
    extends AbstractPairList<T, U>
    implements ImmutablePairList<T, U> {
        EmptyImmutablePairList() {
        }

        @Override
        List<Object> backingList() {
            return ImmutableList.of();
        }

        @Override
        public Map.Entry<T, U> get(int index) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }

        @Override
        public T left(int index) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }

        @Override
        public U right(int index) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public List<T> leftList() {
            return ImmutableList.of();
        }

        @Override
        public List<U> rightList() {
            return ImmutableList.of();
        }

        @Override
        public void forEach(BiConsumer<T, U> consumer) {
        }

        @Override
        public void forEachIndexed(PairList.IndexedBiConsumer<T, U> consumer) {
        }

        @Override
        public <R> List<R> transform(BiFunction<T, U, R> function) {
            return ImmutableList.of();
        }

        @Override
        public <R> ImmutableList<R> transform2(BiFunction<T, U, R> function) {
            return ImmutableList.of();
        }

        @Override
        public boolean anyMatch(BiPredicate<T, U> predicate) {
            return false;
        }

        @Override
        public boolean allMatch(BiPredicate<T, U> predicate) {
            return true;
        }

        @Override
        public boolean noMatch(BiPredicate<T, U> predicate) {
            return true;
        }

        @Override
        public int firstMatch(BiPredicate<T, U> predicate) {
            return -1;
        }
    }

    static abstract class RandomAccessList<E>
    extends AbstractList<E>
    implements RandomAccess {
        RandomAccessList() {
        }
    }

    static class MutablePairList<T, U>
    extends AbstractPairList<T, U> {
        final List<@Nullable Object> list;

        MutablePairList(List<@Nullable Object> list) {
            this.list = list;
        }

        @Override
        List<Object> backingList() {
            return this.list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size() / 2;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Map.Entry<T, U> get(int index) {
            int x = index * 2;
            return new MapEntry<Object, Object>(this.list.get(x), this.list.get(x + 1));
        }

        @Override
        public T left(int index) {
            int x = index * 2;
            return (T)this.list.get(x);
        }

        @Override
        public U right(int index) {
            int x = index * 2;
            return (U)this.list.get(x + 1);
        }

        @Override
        public Map.Entry<T, U> set(int index, Map.Entry<T, U> entry) {
            return this.set(index, entry.getKey(), entry.getValue());
        }

        @Override
        public Map.Entry<T, U> set(int index, T t, U u) {
            int x = index * 2;
            Object t0 = this.list.set(x, t);
            Object u0 = this.list.set(x + 1, u);
            return new MapEntry<Object, Object>(t0, u0);
        }

        @Override
        public Map.Entry<T, U> remove(int index) {
            int x = index * 2;
            Object t = this.list.remove(x);
            Object u = this.list.remove(x);
            return new MapEntry<Object, Object>(t, u);
        }

        @Override
        public boolean add(Map.Entry<T, U> entry) {
            this.list.add(entry.getKey());
            this.list.add(entry.getValue());
            return true;
        }

        @Override
        public void add(int index, Map.Entry<T, U> entry) {
            int x = index * 2;
            this.list.add(x, entry.getKey());
            this.list.add(x + 1, entry.getValue());
        }

        @Override
        public void add(T t, U u) {
            this.list.add(t);
            this.list.add(u);
        }

        @Override
        public void add(int index, T t, U u) {
            int x = index * 2;
            this.list.add(x, t);
            this.list.add(x + 1, u);
        }

        @Override
        public boolean addAll(PairList<T, U> list2) {
            return this.list.addAll(((AbstractPairList)list2).backingList());
        }

        @Override
        public boolean addAll(int index, PairList<T, U> list2) {
            int x = index * 2;
            return this.list.addAll(x, ((AbstractPairList)list2).backingList());
        }

        @Override
        public List<T> leftList() {
            final int size = this.list.size() / 2;
            return new RandomAccessList<T>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public T get(int index) {
                    return list.get(index * 2);
                }
            };
        }

        @Override
        public List<U> rightList() {
            final int size = this.list.size() / 2;
            return new RandomAccessList<U>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public U get(int index) {
                    return list.get(index * 2 + 1);
                }
            };
        }

        @Override
        public void forEach(BiConsumer<T, U> consumer) {
            Objects.requireNonNull(consumer, "consumer");
            int i = 0;
            while (i < this.list.size()) {
                Object t = this.list.get(i++);
                Object u = this.list.get(i++);
                consumer.accept(t, u);
            }
        }

        @Override
        public void forEachIndexed(PairList.IndexedBiConsumer<T, U> consumer) {
            Objects.requireNonNull(consumer, "consumer");
            int i = 0;
            int j = 0;
            while (i < this.list.size()) {
                Object t = this.list.get(i++);
                Object u = this.list.get(i++);
                consumer.accept(j++, t, u);
            }
        }

        @Override
        public ImmutableMap<T, U> toImmutableMap() {
            ImmutableMap.Builder b = ImmutableMap.builder();
            this.forEach((T t, U u) -> b.put(t, u));
            return b.build();
        }

        @Override
        public ImmutablePairList<T, U> immutable() {
            return PairLists.immutableBackedBy(this.list);
        }

        @Override
        public <R> List<R> transform(BiFunction<T, U, R> function) {
            return Functions.generate((int)(this.list.size() / 2), index -> {
                int x = index * 2;
                Object t = this.list.get(x);
                Object u = this.list.get(x + 1);
                return function.apply(t, u);
            });
        }

        @Override
        public <R> ImmutableList<R> transform2(BiFunction<T, U, R> function) {
            if (this.list.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            int i = 0;
            int n = this.list.size();
            while (i < n) {
                Object t = this.list.get(i++);
                Object u = this.list.get(i++);
                builder.add(function.apply(t, u));
            }
            return builder.build();
        }

        @Override
        public boolean anyMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.list.size()) {
                Object u;
                Object t;
                if (!predicate.test(t = this.list.get(i++), u = this.list.get(i++))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.list.size()) {
                Object u;
                Object t;
                if (predicate.test(t = this.list.get(i++), u = this.list.get(i++))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            while (i < this.list.size()) {
                Object u;
                Object t;
                if (!predicate.test(t = this.list.get(i++), u = this.list.get(i++))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int firstMatch(BiPredicate<T, U> predicate) {
            int i = 0;
            int j = 0;
            while (i < this.list.size()) {
                Object u;
                Object t;
                if (predicate.test(t = this.list.get(i++), u = this.list.get(i++))) {
                    return j;
                }
                ++j;
            }
            return -1;
        }
    }

    static abstract class AbstractPairList<T, U>
    extends AbstractList<Map.Entry<T, U>>
    implements PairList<T, U> {
        AbstractPairList() {
        }

        abstract List<Object> backingList();
    }
}

