/* MorelParserImpl.java */
/* Generated By:JavaCC: Do not edit this line. MorelParserImpl.java */
package net.hydromatic.morel.parse;

import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Ast.*;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.util.Folder;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;

import com.google.common.collect.ImmutableList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static net.hydromatic.morel.ast.AstBuilder.ast;
import static net.hydromatic.morel.parse.Parsers.unquoteCharLiteral;
import static net.hydromatic.morel.parse.Parsers.unquoteIdentifier;
import static net.hydromatic.morel.parse.Parsers.unquoteString;

/**
 * Parser for Standard ML, generated from MorelParser.jj by JavaCC.
 */
public class MorelParserImpl implements MorelParser, MorelParserImplConstants {
  private static final Logger LOGGER =
      LoggerFactory.getLogger("net.hydromatic.morel.parse");

  private int lineOffset;
  private String file = "";

  public void setTabSize(int tabSize) {
    jj_input_stream.setTabSize(tabSize);
  }

  public Pos pos() {
    return new Pos(file,
        token.beginLine - lineOffset, token.beginColumn,
        token.endLine - lineOffset, token.endColumn + 1);
  }

  public void zero(String file) {
    this.file = file;
    if (jj_input_stream.bufpos >= 0) {
      this.lineOffset = jj_input_stream.bufline[jj_input_stream.bufpos];
    }
  }

  void debug_message1() throws ParseException {LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

/** Parses a literal expression. */
  final public Literal literal() throws ParseException {final Ast.Literal e;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:{
      e = numericLiteral();
{if ("" != null) return e;}
      break;
      }
    case QUOTED_STRING:{
      e = stringLiteral();
{if ("" != null) return e;}
      break;
      }
    case CHAR_LITERAL:{
      e = charLiteral();
{if ("" != null) return e;}
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a literal expression followed by end-of-file. */
  final public Literal literalEof() throws ParseException {final Literal n;
    n = literal();
    jj_consume_token(0);
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
}

/** Parses a numeric literal */
  final public Literal numericLiteral() throws ParseException {final BigDecimal d;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NON_NEGATIVE_INTEGER_LITERAL:{
        jj_consume_token(NON_NEGATIVE_INTEGER_LITERAL);
        break;
        }
      case NEGATIVE_INTEGER_LITERAL:{
        jj_consume_token(NEGATIVE_INTEGER_LITERAL);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1)).negate();
    } else {
      d = new BigDecimal(token.image);
    }
    {if ("" != null) return ast.intLiteral(pos(), d);}
      break;
      }
    case REAL_LITERAL:{
      jj_consume_token(REAL_LITERAL);
if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1)).negate();
      if (d.compareTo(BigDecimal.ZERO) == 0) {
        // In IEEE floating point, and ML's 'real' type, negative zero is
        // different from positive zero.
        {if ("" != null) return ast.realLiteral(pos(), -0.f);}
      }
    } else {
      d = new BigDecimal(token.image);
    }
    {if ("" != null) return ast.realLiteral(pos(), d);}
      break;
      }
    case SCIENTIFIC_LITERAL:{
      jj_consume_token(SCIENTIFIC_LITERAL);
final int e = Math.max(token.image.indexOf("e"),
      token.image.indexOf("E"));
    if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1, e)).negate();
      if (d.compareTo(BigDecimal.ZERO) == 0) {
        // In IEEE floating point, and ML's 'real' type, negative zero is
        // different from positive zero.
        {if ("" != null) return ast.realLiteral(pos(), -0.f);}
      }
    } else {
      d = new BigDecimal(token.image.substring(0, e));
    }
    final int exponent;
    if (token.image.startsWith("~", e + 1)) {
      exponent = -Integer.parseInt(token.image.substring(e + 2));
    } else {
      exponent = Integer.parseInt(token.image.substring(e + 1));
    }
    {if ("" != null) return ast.realLiteral(pos(), d.scaleByPowerOfTen(exponent));}
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a string literal. */
  final public Literal stringLiteral() throws ParseException {
    jj_consume_token(QUOTED_STRING);
{if ("" != null) return ast.stringLiteral(pos(), unquoteString(token.image));}
    throw new Error("Missing return statement in function");
}

/** Parses a char literal. */
  final public Literal charLiteral() throws ParseException {
    jj_consume_token(CHAR_LITERAL);
{if ("" != null) return ast.charLiteral(pos(), unquoteCharLiteral(token.image));}
    throw new Error("Missing return statement in function");
}

/** Parses an identifier. */
  final public Id identifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
{if ("" != null) return ast.id(pos(), token.image);}
      break;
      }
    case QUOTED_IDENTIFIER:{
      jj_consume_token(QUOTED_IDENTIFIER);
{if ("" != null) return ast.id(pos(), unquoteIdentifier(token.image));}
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a record selector, e.g. "{@code #empno}".
 *
 * <p>You use it as a function to extract a field of a record;
 * for example <code>#empno {empno=10, name="Fred"}</code>
 * yields {@code 10}. */
  final public RecordSelector recordSelector() throws ParseException {
    jj_consume_token(LABEL);
assert token.image.startsWith("#");
    {if ("" != null) return ast.recordSelector(pos(), token.image.substring(1));}
    throw new Error("Missing return statement in function");
}

/** Parses a type variable, e.g. "{@code 'a}". */
  final public TyVar tyVar() throws ParseException {
    jj_consume_token(TY_VAR);
assert token.image.startsWith("'");
    {if ("" != null) return ast.tyVar(pos(), token.image);}
    throw new Error("Missing return statement in function");
}

/** Parses a type variable, or a list of 1 or more type variables in
 *  parentheses, or empty. Valid examples: "", "'a", "('a)", "('a, 'b)". */
  final public List<TyVar> tyVarOptionalList() throws ParseException {TyVar tyVar;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TY_VAR:{
      tyVar = tyVar();
{if ("" != null) return ImmutableList.of(tyVar);}
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
List<TyVar> tyVars = new ArrayList<>();
      tyVar = tyVar();
tyVars.add(tyVar);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        tyVar = tyVar();
tyVars.add(tyVar);
      }
{if ("" != null) return tyVars;}
      break;
      }
    default:
      jj_la1[5] = jj_gen;
{if ("" != null) return ImmutableList.of();}
    }
    throw new Error("Missing return statement in function");
}

/** Parses a record type, e.g. "{@code {a:int,b:string} }". */
  final public RecordType recordType() throws ParseException {final Span span;
    jj_consume_token(LBRACE);
span = Span.of(pos());
  final Map<String, Type> map = new LinkedHashMap<>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      fieldType(map);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        fieldType(map);
      }
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return ast.recordType(span.end(this), map);}
    throw new Error("Missing return statement in function");
}

  final public void fieldType(Map<String, Type> map) throws ParseException {final Id id;
  final Type type;
    id = identifier();
    jj_consume_token(COLON);
    type = type();
map.put(id.name, type);
}

/** Parses a "if ... then ... else ..." expression. */
  final public Exp ifThenElse() throws ParseException {final Span span;
  final Exp condition;
  final Exp ifTrue;
  final Exp ifFalse;
    jj_consume_token(IF);
span = Span.of(pos());
    condition = expression();
    jj_consume_token(THEN);
    ifTrue = expression();
    jj_consume_token(ELSE);
    ifFalse = expression();
{if ("" != null) return ast.ifThenElse(span.end(this), condition, ifTrue, ifFalse);}
    throw new Error("Missing return statement in function");
}

/** Parses a "let ... in expression end" expression. */
  final public Exp let() throws ParseException {final Span span;
  final Exp e;
  Decl decl;
  final List<Decl> declList = new ArrayList<>();
    jj_consume_token(LET);
span = Span.of(pos());
    label_3:
    while (true) {
      decl = decl();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        ;
      }
declList.add(decl);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DATATYPE:
      case FUN:
      case VAL:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_3;
      }
    }
    jj_consume_token(IN);
    e = expression();
    jj_consume_token(END);
{if ("" != null) return ast.let(span.end(this), declList, e);}
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code case exp of pat => exp | pat => exp}" expression. */
  final public Exp caseOf() throws ParseException {final Span span;
  final Exp exp;
  final List<Match> matchList;
    jj_consume_token(CASE);
span = Span.of(pos());
    exp = expression();
    jj_consume_token(OF);
    matchList = matchList();
{if ("" != null) return ast.caseOf(span.end(this), exp, matchList);}
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code from id in exp yield exp}" expression. */
  final public Exp from() throws ParseException {final Span span;
  Span stepSpan;
  final List<FromStep> steps = new ArrayList<>();
    jj_consume_token(FROM);
span = Span.of(pos());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      fromFirstScan(steps);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        fromScan(steps);
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMPUTE:
      case DISTINCT:
      case GROUP:
      case INTO:
      case JOIN:
      case ORDER:
      case REQUIRE:
      case SKIP_:
      case TAKE:
      case THROUGH:
      case WHERE:
      case YIELD:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      fromStep(steps);
    }
{if ("" != null) return ast.from(span.end(this), steps);}
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code exists id in exp where exp}" expression. */
  final public Exp exists() throws ParseException {final Span span;
  Span stepSpan;
  final List<FromStep> steps = new ArrayList<>();
    jj_consume_token(EXISTS);
span = Span.of(pos());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      fromFirstScan(steps);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_6;
        }
        jj_consume_token(COMMA);
        fromScan(steps);
      }
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMPUTE:
      case DISTINCT:
      case GROUP:
      case INTO:
      case JOIN:
      case ORDER:
      case REQUIRE:
      case SKIP_:
      case TAKE:
      case THROUGH:
      case WHERE:
      case YIELD:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
      fromStep(steps);
    }
{if ("" != null) return ast.exists(span.end(this), steps);}
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code forall id in exp require exp}" expression. */
  final public Exp forall() throws ParseException {final Span span;
  Span stepSpan;
  final List<FromStep> steps = new ArrayList<>();
    jj_consume_token(FORALL);
span = Span.of(pos());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      fromFirstScan(steps);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        fromScan(steps);
      }
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMPUTE:
      case DISTINCT:
      case GROUP:
      case INTO:
      case JOIN:
      case ORDER:
      case REQUIRE:
      case SKIP_:
      case TAKE:
      case THROUGH:
      case WHERE:
      case YIELD:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_9;
      }
      fromStep(steps);
    }
{if ("" != null) return ast.forall(span.end(this), steps);}
    throw new Error("Missing return statement in function");
}

  final public void fromFirstScan(List<FromStep> steps) throws ParseException {final Pair<Pat, Exp> patExp;
    patExp = fromSource();
final Span span =
        patExp.right != null
          ? Span.of(patExp.left, patExp.right)
          : Span.of(patExp.left);
    steps.add(ast.scan(span.pos(), patExp.left, patExp.right, null));
}

  final public void fromScan(List<FromStep> steps) throws ParseException {final Pair<Pat, Exp> patExp;
  final Exp condition;
    patExp = fromSource();
final Span span =
        patExp.right != null
          ? Span.of(patExp.left, patExp.right)
          : Span.of(patExp.left);
    if (jj_2_1(2)) {
      jj_consume_token(ON);
      condition = expression();
    } else {
condition = null;
    }
steps.add(ast.scan(span.end(this), patExp.left, patExp.right, condition));
}

  final public void fromStep(List<FromStep> steps) throws ParseException {final Span span;
  final Op op;
  final Exp filterExp;
  final Exp intoExp;
  final Exp skipExp;
  final Exp throughExp;
  final Exp takeExp;
  final Exp requireExp;
  final Exp yieldExp;
  final PairList<Id, Exp> groupExps;
  final Pat pat;
  final List<Aggregate> aggregates;
  final List<OrderItem> orderItems;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case JOIN:{
      jj_consume_token(JOIN);
      fromScan(steps);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        fromScan(steps);
      }
      break;
      }
    case WHERE:{
      jj_consume_token(WHERE);
span = Span.of(pos());
      filterExp = expression();
steps.add(ast.where(span.end(this), filterExp));
      break;
      }
    case GROUP:{
      jj_consume_token(GROUP);
span = Span.of(pos());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        groupExps = namedExpressionCommaList();
        break;
        }
      default:
        jj_la1[20] = jj_gen;
groupExps = ImmutablePairList.of();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMPUTE:{
        jj_consume_token(COMPUTE);
        aggregates = aggregateCommaList();
        break;
        }
      default:
        jj_la1[21] = jj_gen;
aggregates = ImmutableList.of();
      }
steps.add(ast.group(span.end(this), groupExps, aggregates));
      break;
      }
    case COMPUTE:{
      jj_consume_token(COMPUTE);
span = Span.of(pos());
      aggregates = aggregateCommaList();
steps.add(ast.compute(span.end(this), aggregates));
      break;
      }
    case DISTINCT:{
      jj_consume_token(DISTINCT);
steps.add(ast.distinct(pos()));
      break;
      }
    case INTO:{
      jj_consume_token(INTO);
span = Span.of(pos());
      intoExp = expression();
steps.add(ast.into(span.end(this), intoExp));
      break;
      }
    case ORDER:{
      jj_consume_token(ORDER);
span = Span.of(pos());
      orderItems = orderItemCommaList();
steps.add(ast.order(span.end(this), orderItems));
      break;
      }
    case REQUIRE:{
      jj_consume_token(REQUIRE);
span = Span.of(pos());
      requireExp = expression();
steps.add(ast.require(span.end(this), requireExp));
      break;
      }
    case SKIP_:{
      jj_consume_token(SKIP_);
span = Span.of(pos());
      skipExp = expression();
steps.add(ast.skip(span.end(this), skipExp));
      break;
      }
    case TAKE:{
      jj_consume_token(TAKE);
span = Span.of(pos());
      takeExp = expression();
steps.add(ast.take(span.end(this), takeExp));
      break;
      }
    case THROUGH:{
      jj_consume_token(THROUGH);
span = Span.of(pos());
      pat = pat();
      jj_consume_token(IN);
      throughExp = expression();
steps.add(ast.through(span.end(this), pat, throughExp));
      break;
      }
    case YIELD:{
      jj_consume_token(YIELD);
span = Span.of(pos());
      yieldExp = expression();
steps.add(ast.yield(span.end(this), yieldExp));
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Pair<Pat, Exp> fromSource() throws ParseException {final Id id;
  final Exp exp;
  final Pat pat;
    if (jj_2_2(2147483647)) {
      id = identifier();
{if ("" != null) return Pair.of(ast.idPat(id.pos, id.name), null);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        pat = pat();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IN:{
          jj_consume_token(IN);
          exp = expression();
{if ("" != null) return Pair.of(pat, exp);}
          break;
          }
        case EQ:{
          jj_consume_token(EQ);
          exp = expression();
{if ("" != null) return Pair.of(pat, ast.fromEq(exp));}
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public List<Aggregate> aggregateCommaList() throws ParseException {final List<Aggregate> list = new ArrayList<>();
  Aggregate e;
    e = aggregate();
list.add(e);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      e = aggregate();
list.add(e);
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
}

  final public Aggregate aggregate() throws ParseException {final PairList<Id, Exp> aggregateIds = PairList.of();
  final Exp argument;
    namedExpression(aggregateIds);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OF:{
      jj_consume_token(OF);
      argument = expression();
      break;
      }
    default:
      jj_la1[26] = jj_gen;
argument = null;
    }
final Id id = aggregateIds.get(0).getKey();
    final Exp aggregate = aggregateIds.get(0).getValue();
    {if ("" != null) return ast.aggregate(id.pos.plus(pos()), aggregate, argument, id);}
    throw new Error("Missing return statement in function");
}

/** List of order items "e1 desc, e2, e3 desc". */
  final public List<OrderItem> orderItemCommaList() throws ParseException {final List<OrderItem> list = new ArrayList<>();
  OrderItem i;
    i = orderItem();
list.add(i);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      i = orderItem();
list.add(i);
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
}

/** Order item. An expression optionally followed by "desc". */
  final public OrderItem orderItem() throws ParseException {final Span span;
  final Exp exp;
    exp = expression();
span = Span.of(pos());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DESC:{
      jj_consume_token(DESC);
{if ("" != null) return ast.orderItem(span.end(this), exp, Ast.Direction.DESC);}
      break;
      }
    default:
      jj_la1[28] = jj_gen;
{if ("" != null) return ast.orderItem(span.end(this), exp, Ast.Direction.ASC);}
    }
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code fn arg => expression}" lambda expression. */
  final public Exp fn() throws ParseException {final Span span;
  final List<Match> matchList;
    jj_consume_token(FN);
span = Span.of(pos());
    matchList = matchList();
{if ("" != null) return ast.fn(span.end(this), matchList);}
    throw new Error("Missing return statement in function");
}

  final public List<Match> matchList() throws ParseException {Match match;
  final List<Match> matchList = new ArrayList<>();
    match = match();
matchList.add(match);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BAR:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_13;
      }
      jj_consume_token(BAR);
      match = match();
matchList.add(match);
    }
{if ("" != null) return matchList;}
    throw new Error("Missing return statement in function");
}

/** Parses a "{@code pat => expression}" match. */
  final public Match match() throws ParseException {final Pat pat;
  final Exp e;
    pat = pat();
    jj_consume_token(RARROW);
    e = expression();
{if ("" != null) return ast.match(pat.pos.plus(e.pos), pat, e);}
    throw new Error("Missing return statement in function");
}

/** Parses an expression.
 *
 * <p>8 is the highest level of precedence in standard ML,
 and the '.field' extension is at level 9.
 The full list is as follows:
 *
 * <ul>
 * <li>infix 9 {@code .}
 * <li>infix 8 (application)
 * <li>infix 7 {@code * / div mod intersect}
 * <li>infix 6 {@code + - ^ union except}
 * <li>infixr 5 {@code :: @}
 * <li>infix 4 {@code = <> > >= < <=}
 * <li>infix 3 {@code := o}
 * <li>infix 0 {@code before}
 * </ul>
 */
  final public Exp expression9() throws ParseException {Exp e;
  Id id;
    e = atom();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_14;
      }
      jj_consume_token(DOT);
      id = identifier();
final Exp s = ast.recordSelector(pos(), id.name);
      e = ast.apply(s, e);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 8 (function application). */
  final public Exp expression8() throws ParseException {Exp e;
  Exp e2;
    e = expression9();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        ;
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        break label_15;
      }
      e2 = expression9();
e = ast.apply(e, e2);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 7 (*, /, div, mod). */
  final public Exp expression7() throws ParseException {Exp e;
  Exp e2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TILDE:{
      jj_consume_token(TILDE);
      e = expression7();
{if ("" != null) return ast.negate(pos(), e);}
      break;
      }
    case CASE:
    case FN:
    case IF:
    case LET:
    case EXISTS:
    case FORALL:
    case FROM:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case LABEL:{
      e = expression8();
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DIV:
        case MOD:
        case INTERSECT:
        case STAR:
        case SLASH:{
          ;
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STAR:{
          jj_consume_token(STAR);
          e2 = expression8();
e = ast.times(e, e2);
          break;
          }
        case SLASH:{
          jj_consume_token(SLASH);
          e2 = expression8();
e = ast.divide(e, e2);
          break;
          }
        case DIV:{
          jj_consume_token(DIV);
          e2 = expression8();
e = ast.div(e, e2);
          break;
          }
        case INTERSECT:{
          jj_consume_token(INTERSECT);
          e2 = expression8();
e = ast.intersect(e, e2);
          break;
          }
        case MOD:{
          jj_consume_token(MOD);
          e2 = expression8();
e = ast.mod(e, e2);
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return e;}
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 6 (+, -, ^, except, union). */
  final public Exp expression6() throws ParseException {Exp e;
  Exp e2;
    e = expression7();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXCEPT:
      case UNION:
      case PLUS:
      case MINUS:
      case CARET:{
        ;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_17;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
        e2 = expression7();
e = ast.plus(e, e2);
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
        e2 = expression7();
e = ast.minus(e, e2);
        break;
        }
      case CARET:{
        jj_consume_token(CARET);
        e2 = expression7();
e = ast.caret(e, e2);
        break;
        }
      case EXCEPT:{
        jj_consume_token(EXCEPT);
        e2 = expression7();
e = ast.except(e, e2);
        break;
        }
      case UNION:{
        jj_consume_token(UNION);
        e2 = expression7();
e = ast.union(e, e2);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 5 ({@code ::}),
* right-associative. */
  final public Exp expression5() throws ParseException {Exp e;
  final List<Folder<Exp>> list = new ArrayList<>();
    e = expression6();
Folder.start(list, e);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONS:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_18;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        jj_consume_token(AT);
        e = expression6();
Folder.at(list, e);
        break;
        }
      case CONS:{
        jj_consume_token(CONS);
        e = expression6();
Folder.cons(list, e);
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return Folder.combineAll(list);}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 4 ({@code =}, {@code <>},
  * {@code >}, {@code >=}, {@code <}, {@code <=}). */
  final public Exp expression4() throws ParseException {Exp e;
  Exp e2;
    e = expression5();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ELEM:
      case NOT_ELEM:
      case EQ:
      case GT:
      case LT:
      case LE:
      case GE:
      case NE:{
        ;
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
        e2 = expression5();
e = ast.equal(e, e2);
        break;
        }
      case NE:{
        jj_consume_token(NE);
        e2 = expression5();
e = ast.notEqual(e, e2);
        break;
        }
      case LT:{
        jj_consume_token(LT);
        e2 = expression5();
e = ast.lessThan(e, e2);
        break;
        }
      case GT:{
        jj_consume_token(GT);
        e2 = expression5();
e = ast.greaterThan(e, e2);
        break;
        }
      case LE:{
        jj_consume_token(LE);
        e2 = expression5();
e = ast.lessThanOrEqual(e, e2);
        break;
        }
      case GE:{
        jj_consume_token(GE);
        e2 = expression5();
e = ast.greaterThanOrEqual(e, e2);
        break;
        }
      case ELEM:{
        jj_consume_token(ELEM);
        e2 = expression5();
e = ast.elem(e, e2);
        break;
        }
      case NOT_ELEM:{
        jj_consume_token(NOT_ELEM);
        e2 = expression5();
e = ast.notElem(e, e2);
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 3 (o). */
  final public Exp expression3() throws ParseException {Exp e;
  Exp e2;
    e = expression4();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case O:{
        ;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_20;
      }
      jj_consume_token(O);
      e2 = expression4();
e = ast.o(e, e2);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 2 (andalso). */
  final public Exp expression2() throws ParseException {Exp e;
  Exp e2;
    e = expression3();
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANDALSO:{
        ;
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        break label_21;
      }
      jj_consume_token(ANDALSO);
      e2 = expression3();
e = ast.andAlso(e, e2);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 1 (orelse). */
  final public Exp expression1() throws ParseException {Exp e;
  Exp e2;
    e = expression2();
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ORELSE:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_22;
      }
      jj_consume_token(ORELSE);
      e2 = expression2();
e = ast.orElse(e, e2);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** Parses an expression of precedence level 0 (implies). */
  final public Exp expression0() throws ParseException {Exp e;
  Exp e2;
    e = expression1();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPLIES:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_23;
      }
      jj_consume_token(IMPLIES);
      e2 = expression1();
e = ast.implies(e, e2);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Exp expression() throws ParseException {Exp e;
  Type t;
    e = expression0();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_24;
      }
      jj_consume_token(COLON);
      t = type();
e = ast.annotatedExp(e.pos.plus(t.pos), e, t);
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

/** List of expressions "e1 as id1, e2 as id2, e3 as id3". */
  final public PairList<Id, Exp> namedExpressionCommaList() throws ParseException {final PairList<Id, Exp> list = PairList.of();
  Pair<Id, Exp> p;
    namedExpression(list);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      namedExpression(list);
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
}

/** Expression with optional "id =", e.g. "id1 = e1";
 * "#deptno e" and "e.deptno" are equivalent to "deptno = e.deptno";
 * "x" is equivalent to "x = x". */
  final public void namedExpression(PairList<Id, Exp> list) throws ParseException {final Exp exp;
  final Id id;
    if (jj_2_3(2147483647)) {
      id = identifier();
      jj_consume_token(EQ);
      exp = expression();
list.add(id, exp);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        exp = expression();
final String name = ast.implicitLabel(exp);
    list.add(ast.id(exp.pos, name), exp);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/** Parses an atomic expression. */
  final public Exp atom() throws ParseException {final Exp e;
  final Span span;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      e = identifier();
{if ("" != null) return e;}
      break;
      }
    case LABEL:{
      e = recordSelector();
{if ("" != null) return e;}
      break;
      }
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:{
      e = literal();
{if ("" != null) return e;}
      break;
      }
    case LET:{
      e = let();
{if ("" != null) return e;}
      break;
      }
    case FN:{
      e = fn();
{if ("" != null) return e;}
      break;
      }
    case IF:{
      e = ifThenElse();
{if ("" != null) return e;}
      break;
      }
    case CASE:{
      e = caseOf();
{if ("" != null) return e;}
      break;
      }
    case FROM:{
      e = from();
{if ("" != null) return e;}
      break;
      }
    case EXISTS:{
      e = exists();
{if ("" != null) return e;}
      break;
      }
    case FORALL:{
      e = forall();
{if ("" != null) return e;}
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
span = Span.of(pos());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RPAREN:{
        jj_consume_token(RPAREN);
{if ("" != null) return ast.unitLiteral(span.end(this));}
        break;
        }
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        e = expression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case RPAREN:{
          jj_consume_token(RPAREN);
{if ("" != null) return e;}
          break;
          }
        case COMMA:{
final List<Exp> list = new ArrayList<>();
        list.add(e);
        Exp e2;
          label_26:
          while (true) {
            jj_consume_token(COMMA);
            e2 = expression();
list.add(e2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[48] = jj_gen;
              break label_26;
            }
          }
          jj_consume_token(RPAREN);
{if ("" != null) return ast.tuple(span.end(this), list);}
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
span = Span.of(pos());
    final List<Exp> list = new ArrayList<>();
    Exp e2;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        e2 = expression();
list.add(e2);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[51] = jj_gen;
            break label_27;
          }
          jj_consume_token(COMMA);
          e2 = expression();
list.add(e2);
        }
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
{if ("" != null) return ast.list(span.end(this), list);}
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
span = Span.of(pos());
    final PairList<String, Exp> nameExps = PairList.of();
    Exp exp;
    Exp with = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        if (jj_2_4(2147483647)) {
          labeledRecordExp(nameExps);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CASE:
          case FN:
          case IF:
          case LET:
          case EXISTS:
          case FORALL:
          case FROM:
          case NON_NEGATIVE_INTEGER_LITERAL:
          case NEGATIVE_INTEGER_LITERAL:
          case REAL_LITERAL:
          case SCIENTIFIC_LITERAL:
          case QUOTED_STRING:
          case CHAR_LITERAL:
          case LPAREN:
          case LBRACE:
          case LBRACKET:
          case TILDE:
          case IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case LABEL:{
            exp = expression();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WITH:{
              jj_consume_token(WITH);
              recordExp(nameExps);
with = exp;
              break;
              }
            default:
              jj_la1[53] = jj_gen;
final String label = ast.implicitLabel(exp);
          nameExps.add(label, exp);
            }
            break;
            }
          default:
            jj_la1[54] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[55] = jj_gen;
            break label_28;
          }
          jj_consume_token(COMMA);
          recordExp(nameExps);
        }
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
{if ("" != null) return ast.record(span.end(this), with, nameExps);}
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a "label = expression" inside a record. */
  final public void labeledRecordExp(PairList<String, Exp> nameExps) throws ParseException {final String id;
  final Ast.Exp exp;
    if (jj_2_5(2147483647)) {
      jj_consume_token(NON_NEGATIVE_INTEGER_LITERAL);
id = token.image;
      jj_consume_token(EQ);
      exp = expression();
nameExps.add(id, exp);
    } else if (jj_2_6(2147483647)) {
      jj_consume_token(IDENTIFIER);
id = token.image;
      jj_consume_token(EQ);
      exp = expression();
nameExps.add(id, exp);
    } else if (jj_2_7(2147483647)) {
      jj_consume_token(QUOTED_IDENTIFIER);
id = unquoteIdentifier(token.image);
      jj_consume_token(EQ);
      exp = expression();
nameExps.add(id, exp);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/** Parses a "label = expression" inside a record. */
  final public void recordExp(PairList<String, Exp> nameExps) throws ParseException {final String id;
  final Ast.Exp exp;
    if (jj_2_8(2147483647)) {
      labeledRecordExp(nameExps);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case EXISTS:
      case FORALL:
      case FROM:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case LABEL:{
        exp = expression();
final String label = ast.implicitLabel(exp);
    nameExps.add(label, exp);
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/** Parses a value declaration, and adds it to a list. */
  final public void addValDecl(List decls) throws ParseException {final ValDecl decl;
    decl = valDecl();
decls.add(decl);
}

/** Parses a value declaration. */
  final public ValDecl valDecl() throws ParseException {final Span span;
  boolean rec = false;
  final List<Ast.ValBind> valBinds = new ArrayList<>();
    jj_consume_token(VAL);
span = Span.of(pos());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REC:{
      jj_consume_token(REC);
rec = true;
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    valBind(valBinds);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_29;
      }
      jj_consume_token(AND);
      valBind(valBinds);
    }
{if ("" != null) return ast.valDecl(span.end(this), rec, valBinds);}
    throw new Error("Missing return statement in function");
}

  final public void valBind(List<Ast.ValBind> valBinds) throws ParseException {final Pat pat;
  final Exp e;
    pat = pat();
    jj_consume_token(EQ);
    e = expression();
valBinds.add(ast.valBind(pat.pos.plus(e.pos), pat, e));
}

/** Parses a declaration. */
  final public Ast.Decl decl() throws ParseException {final Ast.Decl n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATATYPE:{
      n = datatypeDecl();
{if ("" != null) return n;}
      break;
      }
    case VAL:{
      n = valDecl();
{if ("" != null) return n;}
      break;
      }
    case FUN:{
      n = funDecl();
{if ("" != null) return n;}
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a declaration followed by end-of-file. */
  final public Ast.Decl declEof() throws ParseException {Ast.Decl d;
    d = decl();
    jj_consume_token(0);
{if ("" != null) return d;}
    throw new Error("Missing return statement in function");
}

/** Parses a type declaration, e.g.
 * {@code datatype 'a option = NONE | SOME of 'a}
 */
  final public Ast.DatatypeDecl datatypeDecl() throws ParseException {final Span span;
  final List<DatatypeBind> binds = new ArrayList<>();
    jj_consume_token(DATATYPE);
span = Span.of(pos());
    datatypeBind(binds);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_30;
      }
      jj_consume_token(AND);
      datatypeBind(binds);
    }
{if ("" != null) return ast.datatypeDecl(span.end(this), binds);}
    throw new Error("Missing return statement in function");
}

  final public void datatypeBind(List<Ast.DatatypeBind> datatypeBinds) throws ParseException {final List<TyVar> tyVars = new ArrayList<>();
  TyVar tyVar;
  final Ast.Id id;
  final List<TyCon> tyCons = new ArrayList<>();
  TyCon tyCon;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:
    case TY_VAR:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TY_VAR:{
        tyVar = tyVar();
tyVars.add(tyVar);
        break;
        }
      case LPAREN:{
        jj_consume_token(LPAREN);
        tyVar = tyVar();
tyVars.add(tyVar);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            break label_31;
          }
          jj_consume_token(COMMA);
          tyVar = tyVar();
tyVars.add(tyVar);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    id = identifier();
    jj_consume_token(EQ);
    tyCon = typeConstructor();
tyCons.add(tyCon);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BAR:{
        ;
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        break label_32;
      }
      jj_consume_token(BAR);
      tyCon = typeConstructor();
tyCons.add(tyCon);
    }
final List<AstNode> nodes = ImmutableList.<AstNode>builder().addAll(tyVars)
        .add(id).addAll(tyCons).build();
    datatypeBinds.add(ast.datatypeBind(Pos.sum(nodes), id, tyVars, tyCons));
}

  final public Ast.TyCon typeConstructor() throws ParseException {final Ast.Id tag;
  final Ast.Type type;
    tag = identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OF:{
      jj_consume_token(OF);
      type = type();
      break;
      }
    default:
      jj_la1[67] = jj_gen;
type = null;
    }
final Pos pos = type == null ? tag.pos : tag.pos.plus(type.pos);
    {if ("" != null) return ast.typeConstructor(pos, tag, type);}
    throw new Error("Missing return statement in function");
}

/** Parses a function declaration, e.g.
* {@code fun f 1 y = y + 1 | f x y = 0 and g x = 0}. */
  final public Ast.FunDecl funDecl() throws ParseException {final Span span;
  final List<FunBind> funBindList = new ArrayList<>();
    jj_consume_token(FUN);
span = Span.of(pos());
    funBind(funBindList);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        break label_33;
      }
      jj_consume_token(AND);
      funBind(funBindList);
    }
{if ("" != null) return ast.funDecl(span.end(this), funBindList);}
    throw new Error("Missing return statement in function");
}

/** Parses a function binding, e.g.
* {@code f 1 y = y + 1 | f x y = 0},
* and adds it to a list. */
  final public void funBind(List<FunBind> list) throws ParseException {final List<FunMatch> matchList = new ArrayList<>();
    funMatch(matchList);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BAR:{
        ;
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_34;
      }
      jj_consume_token(BAR);
      funMatch(matchList);
    }
list.add(ast.funBind(Pos.sum(matchList), matchList));
}

/** Parses a function match, e.g.
* {@code f 1 y = y + 1},
* and adds it to a list. */
  final public void funMatch(List<FunMatch> list) throws ParseException {final Ast.Id id;
  Ast.Pat pat;
  final List<Ast.Pat> patList = new ArrayList<>();
  final Ast.Exp expression;
  Ast.Type returnType = null;
    id = identifier();
    label_35:
    while (true) {
      pat = atomPat();
patList.add(pat);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        break label_35;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      returnType = type();
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    jj_consume_token(EQ);
    expression = expression();
list.add(
        ast.funMatch(id.pos.plus(expression.pos), id.name, patList, returnType,
            expression));
}

/** Parses a pattern. */
  final public Pat pat() throws ParseException {Pat pat;
  Type type;
    pat = pat5();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        ;
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        break label_36;
      }
      jj_consume_token(COLON);
      type = type();
pat = ast.annotatedPat(pat.pos.plus(type.pos), pat, type);
    }
{if ("" != null) return pat;}
    throw new Error("Missing return statement in function");
}

/** Parses a pattern of precedence level 5 ({@code ::}),
* right-associative. */
  final public Pat pat5() throws ParseException {Pat pat;
  final List<Pat> list = new ArrayList<>();
    pat = pat4();
list.add(pat);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONS:{
        ;
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        break label_37;
      }
      jj_consume_token(CONS);
      pat = pat4();
list.add(pat);
    }
pat = list.get(list.size() - 1);
    for (int i = list.size() - 2; i >= 0; i--) {
      pat = ast.consPat(list.get(i), pat);
    }
    {if ("" != null) return pat;}
    throw new Error("Missing return statement in function");
}

/** Parses a pattern that is a type constructor (an identifier) followed by a
 * pattern. For now, assume that it has precedence level 4. */
  final public Pat pat4() throws ParseException {final Id id;
  final Pat pat;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      id = identifier();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        pat = pat();
{if ("" != null) return ast.asPat(id.pos.plus(pat.pos),
          (Ast.IdPat) ast.idPat(id.pos, id.name), pat);}
        break;
        }
      case 1:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        pat = pat();
{if ("" != null) return ast.conPat(id.pos.plus(pat.pos), id, pat);}
        break;
        }
      default:
        jj_la1[74] = jj_gen;
{if ("" != null) return ast.idPat(id.pos, id.name);}
      }
      break;
      }
    case 1:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:{
      pat = atomPat();
{if ("" != null) return pat;}
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses an atomic pattern. */
  final public Pat atomPat() throws ParseException {final Span span;
  final Ast.Id id;
  final Ast.Literal literal;
  Ast.Pat p;
  final List<Pat> list = new ArrayList<>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:{
      id = identifier();
{if ("" != null) return ast.idPat(id.pos, id.name);}
      break;
      }
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:{
      literal = literal();
{if ("" != null) return ast.literalPat(literal.pos, literal.op.toPat(), literal.value);}
      break;
      }
    case 1:{
      jj_consume_token(1);
{if ("" != null) return ast.wildcardPat(pos());}
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
span = Span.of(pos());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        p = pat();
list.add(p);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[76] = jj_gen;
            break label_38;
          }
          jj_consume_token(COMMA);
          p = pat();
list.add(p);
        }
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
if (list.size() == 1) {
      {if ("" != null) return list.get(0);}
    } else {
      {if ("" != null) return ast.tuplePat(span.end(this), list);}
    }
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
span = Span.of(pos());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:
      case NON_NEGATIVE_INTEGER_LITERAL:
      case NEGATIVE_INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        p = pat();
list.add(p);
        label_39:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[78] = jj_gen;
            break label_39;
          }
          jj_consume_token(COMMA);
          p = pat();
list.add(p);
        }
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
{if ("" != null) return ast.listPat(span.end(this), list);}
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
span = Span.of(pos());
    final Map<String, Pat> map = new LinkedHashMap<>();
    boolean ellipsis = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NON_NEGATIVE_INTEGER_LITERAL:
      case ELLIPSIS:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ELLIPSIS:{
          jj_consume_token(ELLIPSIS);
ellipsis = true;
          break;
          }
        case NON_NEGATIVE_INTEGER_LITERAL:
        case IDENTIFIER:
        case QUOTED_IDENTIFIER:{
          recordPat(map);
          label_40:
          while (true) {
            if (jj_2_9(2)) {
              ;
            } else {
              break label_40;
            }
            jj_consume_token(COMMA);
            recordPat(map);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            jj_consume_token(ELLIPSIS);
ellipsis = true;
            break;
            }
          default:
            jj_la1[80] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
{if ("" != null) return ast.recordPat(span.end(this), ellipsis, map);}
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a "label = pat" inside a record pattern. */
  final public void recordPat(Map<String, Pat> map) throws ParseException {final String id;
  final Ast.Pat pat;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NON_NEGATIVE_INTEGER_LITERAL:{
      jj_consume_token(NON_NEGATIVE_INTEGER_LITERAL);
id = token.image;
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
id = token.image;
      break;
      }
    case QUOTED_IDENTIFIER:{
      jj_consume_token(QUOTED_IDENTIFIER);
id = unquoteIdentifier(token.image);
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQ:{
      jj_consume_token(EQ);
      pat = pat();
map.put(id, pat);
      break;
      }
    default:
      jj_la1[85] = jj_gen;
map.put(id, ast.idPat(pos(), id));
    }
}

/** Parses a type. */
  final public Ast.Type atomicType() throws ParseException {final Span span;
  final Type type;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TY_VAR:{
      type = tyVar();
{if ("" != null) return type;}
      break;
      }
    case IDENTIFIER:{
      type = namedType();
{if ("" != null) return type;}
      break;
      }
    case LBRACE:{
      type = recordType();
{if ("" != null) return type;}
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
span = Span.of(pos());
      type = type();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RPAREN:{
        jj_consume_token(RPAREN);
{if ("" != null) return type;}
        break;
        }
      case COMMA:{
final List<Type> list = new ArrayList<>();
      list.add(type);
      Type type2;
        label_41:
        while (true) {
          jj_consume_token(COMMA);
          type2 = type();
list.add(type2);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[86] = jj_gen;
            break label_41;
          }
        }
        jj_consume_token(RPAREN);
{if ("" != null) return ast.compositeType(span.end(this), list);}
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Ast.Type type7() throws ParseException {Type t;
    t = atomicType();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_42;
      }
      jj_consume_token(IDENTIFIER);
final List<Type> types =
        t instanceof Ast.CompositeType
          ? ((Ast.CompositeType) t).types
          : ImmutableList.of(t);
      t = ast.namedType(t.pos.plus(pos()), types, token.image);
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
}

  final public Ast.Type type6() throws ParseException {final List<Type> types = new ArrayList<>();
  Type t;
    t = type7();
types.add(t);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        ;
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        break label_43;
      }
      jj_consume_token(STAR);
      t = type7();
types.add(t);
    }
{if ("" != null) return types.size() == 1 ? t
      : ast.tupleType(Pos.sum(types), types);}
    throw new Error("Missing return statement in function");
}

  final public Ast.Type type() throws ParseException {final List<Type> types = new ArrayList<>();
  Type t;
    t = type6();
types.add(t);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RTHINARROW:{
        ;
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        break label_44;
      }
      jj_consume_token(RTHINARROW);
      t = type6();
types.add(t);
    }
{if ("" != null) return types.size() == 1 ? t
        : ast.foldFunctionType(types);}
    throw new Error("Missing return statement in function");
}

  final public Ast.Type namedType() throws ParseException {
    jj_consume_token(IDENTIFIER);
{if ("" != null) return ast.namedType(pos(), ImmutableList.of(), token.image);}
    throw new Error("Missing return statement in function");
}

  final public AstNode statement() throws ParseException {final AstNode n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CASE:
    case FN:
    case IF:
    case LET:
    case EXISTS:
    case FORALL:
    case FROM:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case TILDE:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case LABEL:{
      n = expression();
{if ("" != null) return n;}
      break;
      }
    case DATATYPE:
    case FUN:
    case VAL:{
      n = decl();
{if ("" != null) return n;}
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public AstNode statementSemicolon() throws ParseException {final AstNode n;
    n = statement();
    jj_consume_token(SEMICOLON);
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
}

/** Parses a statement followed by semicolon or end-of-file.
 * Returns null if there is no statement. */
  final public AstNode statementSemicolonOrEof() throws ParseException {final AstNode n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 0:{
      jj_consume_token(0);
{if ("" != null) return null;}
      break;
      }
    case CASE:
    case DATATYPE:
    case FN:
    case FUN:
    case IF:
    case LET:
    case VAL:
    case EXISTS:
    case FORALL:
    case FROM:
    case NON_NEGATIVE_INTEGER_LITERAL:
    case NEGATIVE_INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case TILDE:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case LABEL:{
      n = statement();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return n;}
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Parses a statement followed by end-of-file. */
  final public AstNode statementEof() throws ParseException {final AstNode n;
    n = statement();
    jj_consume_token(0);
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_3R_expression8_661_3_60()
 {
    if (jj_3R_expression9_644_3_61()) return true;
    return false;
  }

  private boolean jj_3R_charLiteral_183_3_93()
 {
    if (jj_scan_token(CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_atom_939_3_73()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_forall_368_3_85()
 {
    if (jj_scan_token(FORALL)) return true;
    return false;
  }

  private boolean jj_3R_atom_937_3_72()
 {
    if (jj_3R_forall_368_3_85()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_atom_935_3_71()
 {
    if (jj_3R_exists_350_3_84()) return true;
    return false;
  }

  private boolean jj_3R_expression5_744_3_55()
 {
    if (jj_3R_expression6_711_3_56()) return true;
    return false;
  }

  private boolean jj_3R_stringLiteral_173_3_92()
 {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_atom_933_3_70()
 {
    if (jj_3R_from_332_3_83()) return true;
    return false;
  }

  private boolean jj_3R_expression1_837_3_51()
 {
    if (jj_3R_expression2_821_3_52()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(NON_NEGATIVE_INTEGER_LITERAL)) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_atom_931_3_69()
 {
    if (jj_3R_caseOf_318_3_82()) return true;
    return false;
  }

  private boolean jj_3R_expression9_644_3_61()
 {
    if (jj_3R_atom_919_3_62()) return true;
    return false;
  }

  private boolean jj_3R_atom_929_3_68()
 {
    if (jj_3R_ifThenElse_287_3_81()) return true;
    return false;
  }

  private boolean jj_3R_atom_927_3_67()
 {
    if (jj_3R_fn_591_3_80()) return true;
    return false;
  }

  private boolean jj_3R_atom_925_3_66()
 {
    if (jj_3R_let_303_3_79()) return true;
    return false;
  }

  private boolean jj_3R_atom_923_3_65()
 {
    if (jj_3R_literal_100_3_78()) return true;
    return false;
  }

  private boolean jj_3R_atom_921_3_64()
 {
    if (jj_3R_recordSelector_210_3_77()) return true;
    return false;
  }

  private boolean jj_3R_exists_350_3_84()
 {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_atom_919_3_62()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_atom_919_3_63()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_921_3_64()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_923_3_65()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_925_3_66()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_927_3_67()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_929_3_68()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_931_3_69()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_933_3_70()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_935_3_71()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_937_3_72()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_939_3_73()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_963_3_74()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_978_3_75()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_atom_919_3_63()
 {
    if (jj_3R_identifier_193_3_76()) return true;
    return false;
  }

  private boolean jj_3R_expression2_821_3_52()
 {
    if (jj_3R_expression3_805_3_53()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_numericLiteral_145_3_96()
 {
    if (jj_scan_token(SCIENTIFIC_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_recordPat_1376_5_50()
 {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_from_332_3_83()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_recordPat_1375_5_49()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_expression6_711_3_56()
 {
    if (jj_3R_expression7_677_3_57()) return true;
    return false;
  }

  private boolean jj_3R_recordPat_1374_5_48()
 {
    if (jj_scan_token(NON_NEGATIVE_INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_expression3_805_3_53()
 {
    if (jj_3R_expression4_761_3_54()) return true;
    return false;
  }

  private boolean jj_3R_recordPat_1374_3_46()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_recordPat_1374_5_48()) {
    jj_scanpos = xsp;
    if (jj_3R_recordPat_1375_5_49()) {
    jj_scanpos = xsp;
    if (jj_3R_recordPat_1376_5_50()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_numericLiteral_131_3_95()
 {
    if (jj_scan_token(REAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_caseOf_318_3_82()
 {
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_recordPat_1374_3_46()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_atom_978_3_75()
 {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_numericLiteral_122_3_94()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    return false;
  }

  private boolean jj_3R_numericLiteral_122_3_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_numericLiteral_122_3_94()) {
    jj_scanpos = xsp;
    if (jj_3R_numericLiteral_131_3_95()) {
    jj_scanpos = xsp;
    if (jj_3R_numericLiteral_145_3_96()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_3R_expression_868_3_45()) return true;
    return false;
  }

  private boolean jj_3R_fn_591_3_80()
 {
    if (jj_scan_token(FN)) return true;
    return false;
  }

  private boolean jj_3R_recordSelector_210_3_77()
 {
    if (jj_scan_token(LABEL)) return true;
    return false;
  }

  private boolean jj_3R_let_303_3_79()
 {
    if (jj_scan_token(LET)) return true;
    return false;
  }

  private boolean jj_3R_expression7_679_3_59()
 {
    if (jj_3R_expression8_661_3_60()) return true;
    return false;
  }

  private boolean jj_3R_atom_963_3_74()
 {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_expression_868_3_45()
 {
    if (jj_3R_expression0_853_3_47()) return true;
    return false;
  }

  private boolean jj_3R_expression7_677_3_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_expression7_677_3_58()) {
    jj_scanpos = xsp;
    if (jj_3R_expression7_679_3_59()) return true;
    }
    return false;
  }

  private boolean jj_3R_expression7_677_3_58()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_literal_104_3_90()
 {
    if (jj_3R_charLiteral_183_3_93()) return true;
    return false;
  }

  private boolean jj_3R_literal_102_3_89()
 {
    if (jj_3R_stringLiteral_173_3_92()) return true;
    return false;
  }

  private boolean jj_3R_identifier_196_3_87()
 {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_literal_100_3_88()
 {
    if (jj_3R_numericLiteral_122_3_91()) return true;
    return false;
  }

  private boolean jj_3R_literal_100_3_78()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_literal_100_3_88()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_102_3_89()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_104_3_90()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_identifier_193_3_86()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_identifier_193_3_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_identifier_193_3_86()) {
    jj_scanpos = xsp;
    if (jj_3R_identifier_196_3_87()) return true;
    }
    return false;
  }

  private boolean jj_3R_ifThenElse_287_3_81()
 {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_expression4_761_3_54()
 {
    if (jj_3R_expression5_744_3_55()) return true;
    return false;
  }

  private boolean jj_3R_expression0_853_3_47()
 {
    if (jj_3R_expression1_837_3_51()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public MorelParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[95];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200840,0x0,0x2,0x41400000,0x0,0x2,0x41400000,0x0,0x2,0x41400000,0x0,0x38005420,0x400000,0x41400000,0x2000,0x2,0x0,0x20000,0x0,0x800000,0x0,0x0,0x38005420,0x8080,0x8080,0x38005420,0x4000000,0x4000000,0x0,0x0,0x2000000,0x2000000,0x10000,0x8,0x40000,0x80000000,0x0,0x0,0x38005420,0x0,0x0,0x38005420,0x0,0x38005420,0x0,0x38005420,0x0,0x38005420,0x38005420,0x38005420,0x80000,0x4,0x200840,0x4,0x0,0x0,0x0,0x0,0x20000,0x4,0x0,0x2,0x0,0x0,0x0,0x12,0x2,0x0,0x2,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38205c60,0x1,0x38205c61,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x33c000,0xc000,0x3c000,0x0,0x80000000,0x400000,0x80000000,0x0,0x10000000,0x0,0x80000000,0x573c000,0x2be6,0x80000000,0x573c000,0x2be6,0x80000000,0x573c000,0x2be6,0x80000000,0x573c000,0x0,0x2be6,0x0,0x573c000,0x80000000,0x0,0x80000000,0x0,0x20000000,0x40000000,0x573c000,0x1,0x1,0x573c000,0x400,0x400,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x80000000,0x573c000,0x80000000,0x80800000,0x5f3c000,0x80000000,0x573c000,0x1000,0x573c000,0x80000000,0x573c000,0x573c000,0x573c000,0x0,0x0,0x0,0x0,0x80000000,0x400000,0x400000,0x20000000,0x0,0x0,0x20000000,0x573c000,0x0,0x0,0x0,0x573c000,0x573c000,0x80000000,0x573c000,0x80000000,0x573c000,0x80000000,0x4000,0x4000,0x573c000,0x4000,0x0,0x80000000,0x80800000,0x1400000,0x0,0x0,0x0,0x573c000,0x10000000,0x573c000,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x80004000,0x0,0x0,0x4,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x3000,0x3000,0x80004000,0xe00,0xe00,0x18000,0x18000,0x1dc,0x1dc,0x0,0x0,0x0,0x0,0x20,0x0,0x80004000,0x0,0x0,0x80004000,0x0,0x80004000,0x0,0x80004000,0x0,0x80004000,0x80000000,0x80004000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x20,0x20,0x8000,0x80000000,0x80000000,0x0,0x80000000,0x0,0x80000000,0x0,0x80020000,0x80020000,0x80000000,0x80000000,0x4,0x0,0x0,0x80000000,0x80000000,0x1000,0x2,0x80004000,0x0,0x80004000,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x1,0x0,0x2,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x5,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x0,0x0,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x0,0x0,0x5,0x0,0x5,0x0,0x5,0x0,0x5,0x5,0x5,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x1,0x0,0x1,0x0,0x1,0x0,0x1,0x1,0x1,0x1,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x5,0x0,0x5,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[9];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public MorelParserImpl(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MorelParserImpl(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new MorelParserImplTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public MorelParserImpl(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new MorelParserImplTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new MorelParserImplTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public MorelParserImpl(MorelParserImplTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(MorelParserImplTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 95; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[101];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 95; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 101; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 9; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
