/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.util.PairList;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum AstBuilder {
    ast;


    public String implicitLabel(Ast.Exp exp) {
        if (exp instanceof Ast.Apply) {
            Ast.Apply apply = (Ast.Apply)exp;
            if (apply.fn instanceof Ast.RecordSelector) {
                Ast.RecordSelector selector = (Ast.RecordSelector)apply.fn;
                return selector.name;
            }
        }
        if (exp instanceof Ast.Id) {
            return ((Ast.Id)exp).name;
        }
        throw new IllegalArgumentException("cannot derive label for expression " + exp);
    }

    private Ast.InfixCall infix(Op op, Ast.Exp a0, Ast.Exp a1) {
        return new Ast.InfixCall(a0.pos.plus(a1.pos), op, a0, a1);
    }

    public Ast.PrefixCall prefixCall(Pos p, Op op, Ast.Exp a) {
        return new Ast.PrefixCall(p.plus(a.pos), op, a);
    }

    public Ast.Literal boolLiteral(Pos p, boolean b) {
        return new Ast.Literal(p, Op.BOOL_LITERAL, Boolean.valueOf(b));
    }

    public Ast.Literal charLiteral(Pos p, char c) {
        return new Ast.Literal(p, Op.CHAR_LITERAL, Character.valueOf(c));
    }

    public Ast.Literal intLiteral(Pos pos, BigDecimal value) {
        return new Ast.Literal(pos, Op.INT_LITERAL, value);
    }

    public Ast.Literal realLiteral(Pos pos, BigDecimal value) {
        return new Ast.Literal(pos, Op.REAL_LITERAL, value);
    }

    public Ast.Literal realLiteral(Pos pos, Float value) {
        return new Ast.Literal(pos, Op.REAL_LITERAL, value);
    }

    public Ast.Literal stringLiteral(Pos pos, String value) {
        return new Ast.Literal(pos, Op.STRING_LITERAL, (Comparable)((Object)value));
    }

    public Ast.Literal unitLiteral(Pos p) {
        return new Ast.Literal(p, Op.UNIT_LITERAL, Unit.INSTANCE);
    }

    public Ast.Id id(Pos pos, String name) {
        return new Ast.Id(pos, name);
    }

    public Ast.TyVar tyVar(Pos pos, String name) {
        return new Ast.TyVar(pos, name);
    }

    public Ast.RecordType recordType(Pos pos, Map<String, Ast.Type> fieldTypes) {
        return new Ast.RecordType(pos, (ImmutableMap<String, Ast.Type>)ImmutableMap.copyOf(fieldTypes));
    }

    public Ast.RecordSelector recordSelector(Pos pos, String name) {
        return new Ast.RecordSelector(pos, name);
    }

    public Ast.Type namedType(Pos pos, Iterable<? extends Ast.Type> types, String name) {
        return new Ast.NamedType(pos, (ImmutableList<Ast.Type>)ImmutableList.copyOf(types), name);
    }

    public Ast.Pat idPat(Pos pos, String name) {
        switch (name) {
            case "false": {
                return this.literalPat(pos, Op.BOOL_LITERAL_PAT, Boolean.valueOf(false));
            }
            case "true": {
                return this.literalPat(pos, Op.BOOL_LITERAL_PAT, Boolean.valueOf(true));
            }
            case "nil": {
                return this.listPat(pos, new Ast.Pat[0]);
            }
        }
        return new Ast.IdPat(pos, name);
    }

    public Ast.LiteralPat literalPat(Pos pos, Op op, Comparable value) {
        return new Ast.LiteralPat(pos, op, value);
    }

    public Ast.WildcardPat wildcardPat(Pos pos) {
        return new Ast.WildcardPat(pos);
    }

    public Ast.AsPat asPat(Pos pos, Ast.IdPat id, Ast.Pat pat) {
        return new Ast.AsPat(pos, id, pat);
    }

    public Ast.ConPat conPat(Pos pos, Ast.Id tyCon, Ast.Pat pat) {
        return new Ast.ConPat(pos, tyCon, pat);
    }

    public Ast.Con0Pat con0Pat(Pos pos, Ast.Id tyCon) {
        return new Ast.Con0Pat(pos, tyCon);
    }

    public Ast.TuplePat tuplePat(Pos pos, Iterable<? extends Ast.Pat> args) {
        return new Ast.TuplePat(pos, (ImmutableList<Ast.Pat>)ImmutableList.copyOf(args));
    }

    public Ast.TuplePat tuplePat(Pos pos, Ast.Pat ... args) {
        return new Ast.TuplePat(pos, (ImmutableList<Ast.Pat>)ImmutableList.copyOf((Object[])args));
    }

    public Ast.ListPat listPat(Pos pos, Iterable<? extends Ast.Pat> args) {
        return new Ast.ListPat(pos, (ImmutableList<Ast.Pat>)ImmutableList.copyOf(args));
    }

    public Ast.ListPat listPat(Pos pos, Ast.Pat ... args) {
        return new Ast.ListPat(pos, (ImmutableList<Ast.Pat>)ImmutableList.copyOf((Object[])args));
    }

    public Ast.RecordPat recordPat(Pos pos, boolean ellipsis, Map<String, ? extends Ast.Pat> args) {
        return new Ast.RecordPat(pos, ellipsis, (ImmutableSortedMap<String, Ast.Pat>)ImmutableSortedMap.copyOf(args, RecordType.ORDERING));
    }

    public Ast.AnnotatedPat annotatedPat(Pos pos, Ast.Pat pat, Ast.Type type) {
        return new Ast.AnnotatedPat(pos, pat, type);
    }

    public Ast.InfixPat consPat(Ast.Pat p0, Ast.Pat p1) {
        return this.infixPat(p0.pos.plus(p1.pos), Op.CONS_PAT, p0, p1);
    }

    public Ast.Tuple tuple(Pos pos, Iterable<? extends Ast.Exp> list) {
        return new Ast.Tuple(pos, list);
    }

    public Ast.ListExp list(Pos pos, Iterable<? extends Ast.Exp> list) {
        return new Ast.ListExp(pos, list);
    }

    public Ast.Record record(Pos pos,  @Nullable Ast.Exp with, Map<String, Ast.Exp> map) {
        return new Ast.Record(pos, with, (ImmutableSortedMap<String, Ast.Exp>)ImmutableSortedMap.copyOf(map, RecordType.ORDERING));
    }

    public Ast.Record record(Pos pos,  @Nullable Ast.Exp with, Collection<Map.Entry<String, Ast.Exp>> map) {
        return this.record(pos, with, (Map<String, Ast.Exp>)ImmutableSortedMap.copyOf(map, RecordType.ORDERING));
    }

    public Ast.Exp equal(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.EQ, a0, a1);
    }

    public Ast.Exp notEqual(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.NE, a0, a1);
    }

    public Ast.Exp lessThan(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.LT, a0, a1);
    }

    public Ast.Exp greaterThan(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.GT, a0, a1);
    }

    public Ast.Exp lessThanOrEqual(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.LE, a0, a1);
    }

    public Ast.Exp greaterThanOrEqual(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.GE, a0, a1);
    }

    public Ast.Exp elem(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.ELEM, a0, a1);
    }

    public Ast.Exp notElem(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.NOT_ELEM, a0, a1);
    }

    public Ast.Exp andAlso(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.ANDALSO, a0, a1);
    }

    public Ast.Exp orElse(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.ORELSE, a0, a1);
    }

    public Ast.Exp implies(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.IMPLIES, a0, a1);
    }

    public Ast.Exp plus(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.PLUS, a0, a1);
    }

    public Ast.Exp minus(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.MINUS, a0, a1);
    }

    public Ast.Exp times(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.TIMES, a0, a1);
    }

    public Ast.Exp divide(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.DIVIDE, a0, a1);
    }

    public Ast.Exp div(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.DIV, a0, a1);
    }

    public Ast.Exp mod(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.MOD, a0, a1);
    }

    public Ast.Exp caret(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.CARET, a0, a1);
    }

    public Ast.Exp o(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.COMPOSE, a0, a1);
    }

    public Ast.Exp except(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.EXCEPT, a0, a1);
    }

    public Ast.Exp intersect(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.INTERSECT, a0, a1);
    }

    public Ast.Exp union(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.UNION, a0, a1);
    }

    public Ast.Exp negate(Pos p, Ast.Exp a) {
        return this.prefixCall(p, Op.NEGATE, a);
    }

    public Ast.Exp cons(Ast.Exp a0, Ast.Exp a1) {
        return this.infix(Op.CONS, a0, a1);
    }

    public Ast.Exp foldCons(List<Ast.Exp> list) {
        return this.foldRight(list, this::cons);
    }

    public Ast.Let let(Pos pos, Iterable<? extends Ast.Decl> decls, Ast.Exp exp) {
        return new Ast.Let(pos, (ImmutableList<Ast.Decl>)ImmutableList.copyOf(decls), exp);
    }

    public Ast.ValDecl valDecl(Pos pos, boolean rec, Iterable<? extends Ast.ValBind> valBinds) {
        return new Ast.ValDecl(pos, rec, (ImmutableList<Ast.ValBind>)ImmutableList.copyOf(valBinds));
    }

    public Ast.ValDecl valDecl(Pos pos, boolean rec, Ast.ValBind ... valBinds) {
        return new Ast.ValDecl(pos, rec, (ImmutableList<Ast.ValBind>)ImmutableList.copyOf((Object[])valBinds));
    }

    public Ast.ValBind valBind(Pos pos, Ast.Pat pat, Ast.Exp exp) {
        return new Ast.ValBind(pos, pat, exp);
    }

    public Ast.Match match(Pos pos, Ast.Pat pat, Ast.Exp exp) {
        return new Ast.Match(pos, pat, exp);
    }

    public Ast.Case caseOf(Pos pos, Ast.Exp exp, Iterable<? extends Ast.Match> matchList) {
        return new Ast.Case(pos, exp, (ImmutableList<Ast.Match>)ImmutableList.copyOf(matchList));
    }

    public Ast.Exists exists(Pos pos, List<Ast.FromStep> steps) {
        return new Ast.Exists(pos, (ImmutableList<Ast.FromStep>)ImmutableList.copyOf(steps));
    }

    public Ast.Forall forall(Pos pos, List<Ast.FromStep> steps) {
        return new Ast.Forall(pos, (ImmutableList<Ast.FromStep>)ImmutableList.copyOf(steps));
    }

    public Ast.From from(Pos pos, List<Ast.FromStep> steps) {
        Ast.Exp implicitYieldExp = Ast.From.implicitYieldExp(pos, steps);
        return this.from(pos, (List<Ast.FromStep>)ImmutableList.copyOf(steps), implicitYieldExp);
    }

    public Ast.From from(Pos pos, List<Ast.FromStep> steps,  @Nullable Ast.Exp implicitYieldExp) {
        return new Ast.From(pos, (ImmutableList<Ast.FromStep>)ImmutableList.copyOf(steps), implicitYieldExp);
    }

    public Ast.Exp fromEq(Ast.Exp exp) {
        return new Ast.PrefixCall(exp.pos, Op.FROM_EQ, exp);
    }

    public Ast.Fn fn(Pos pos, Ast.Match ... matchList) {
        return new Ast.Fn(pos, (ImmutableList<Ast.Match>)ImmutableList.copyOf((Object[])matchList));
    }

    public Ast.Fn fn(Pos pos, Iterable<? extends Ast.Match> matchList) {
        return new Ast.Fn(pos, (ImmutableList<Ast.Match>)ImmutableList.copyOf(matchList));
    }

    public Ast.FunDecl funDecl(Pos pos, Iterable<? extends Ast.FunBind> valBinds) {
        return new Ast.FunDecl(pos, (ImmutableList<Ast.FunBind>)ImmutableList.copyOf(valBinds));
    }

    public Ast.FunBind funBind(Pos pos, Iterable<? extends Ast.FunMatch> matchList) {
        return new Ast.FunBind(pos, (ImmutableList<Ast.FunMatch>)ImmutableList.copyOf(matchList));
    }

    public Ast.FunMatch funMatch(Pos pos, String name, Iterable<? extends Ast.Pat> patList,  @Nullable Ast.Type returnType, Ast.Exp exp) {
        return new Ast.FunMatch(pos, name, (ImmutableList<Ast.Pat>)ImmutableList.copyOf(patList), returnType, exp);
    }

    public Ast.Apply apply(Ast.Exp fn, Ast.Exp arg) {
        return new Ast.Apply(fn.pos.plus(arg.pos), fn, arg);
    }

    public Ast.Exp ifThenElse(Pos pos, Ast.Exp condition, Ast.Exp ifTrue, Ast.Exp ifFalse) {
        return new Ast.If(pos, condition, ifTrue, ifFalse);
    }

    public Ast.InfixPat infixPat(Pos pos, Op op, Ast.Pat p0, Ast.Pat p1) {
        return new Ast.InfixPat(pos, op, p0, p1);
    }

    public Ast.AnnotatedExp annotatedExp(Pos pos, Ast.Exp expression, Ast.Type type) {
        return new Ast.AnnotatedExp(pos, expression, type);
    }

    public Ast.Exp infixCall(Pos pos, Op op, Ast.Exp a0, Ast.Exp a1) {
        return new Ast.InfixCall(pos, op, a0, a1);
    }

    public Ast.DatatypeDecl datatypeDecl(Pos pos, Iterable<Ast.DatatypeBind> binds) {
        return new Ast.DatatypeDecl(pos, (ImmutableList<Ast.DatatypeBind>)ImmutableList.copyOf(binds));
    }

    public Ast.DatatypeBind datatypeBind(Pos pos, Ast.Id name, Iterable<Ast.TyVar> tyVars, Iterable<Ast.TyCon> tyCons) {
        return new Ast.DatatypeBind(pos, (ImmutableList<Ast.TyVar>)ImmutableList.copyOf(tyVars), name, (ImmutableList<Ast.TyCon>)ImmutableList.copyOf(tyCons));
    }

    public Ast.TyCon typeConstructor(Pos pos, Ast.Id id, Ast.Type type) {
        return new Ast.TyCon(pos, id, type);
    }

    public Ast.Type tupleType(Pos pos, Iterable<Ast.Type> types) {
        return new Ast.TupleType(pos, (ImmutableList<Ast.Type>)ImmutableList.copyOf(types));
    }

    public Ast.Type compositeType(Pos pos, Iterable<Ast.Type> types) {
        return new Ast.CompositeType(pos, (ImmutableList<Ast.Type>)ImmutableList.copyOf(types));
    }

    public Ast.FunctionType functionType(Pos pos, Ast.Type fromType, Ast.Type toType) {
        return new Ast.FunctionType(pos, fromType, toType);
    }

    public Ast.Type foldFunctionType(List<Ast.Type> types) {
        return this.foldRight(types, (t1, t2) -> this.functionType(t1.pos.plus(t2.pos), (Ast.Type)t1, (Ast.Type)t2));
    }

    private <E> E foldRight(List<E> list, BiFunction<E, E, E> fold) {
        E e = list.get(list.size() - 1);
        for (int i = list.size() - 2; i >= 0; --i) {
            e = fold.apply(list.get(i), e);
        }
        return e;
    }

    public Ast.Aggregate aggregate(Pos pos, Ast.Exp aggregate, Ast.Exp argument, Ast.Id id) {
        return new Ast.Aggregate(pos, aggregate, argument, id);
    }

    private Ast.Exp ref(Pos pos, BuiltIn builtIn) {
        if (builtIn.structure == null) {
            return this.id(pos, builtIn.mlName);
        }
        return this.apply(this.id(pos, builtIn.structure), this.id(pos, builtIn.mlName));
    }

    public Ast.Exp map(Pos pos, Ast.Exp e1, Ast.Exp e2) {
        return this.apply(this.apply(this.ref(pos, BuiltIn.LIST_MAP), e1), e2);
    }

    public Ast.Scan scan(Pos pos, Ast.Pat pat, Ast.Exp exp,  @Nullable Ast.Exp condition) {
        return new Ast.Scan(pos, pat, exp, condition);
    }

    public Ast.Order order(Pos pos, Iterable<Ast.OrderItem> orderItems) {
        return new Ast.Order(pos, (ImmutableList<Ast.OrderItem>)ImmutableList.copyOf(orderItems));
    }

    public Ast.OrderItem orderItem(Pos pos, Ast.Exp exp, Ast.Direction direction) {
        return new Ast.OrderItem(pos, exp, direction);
    }

    public Ast.Compute compute(Pos pos, List<Ast.Aggregate> aggregates) {
        return new Ast.Compute(pos, (ImmutableList<Ast.Aggregate>)ImmutableList.copyOf(aggregates));
    }

    public Ast.Group group(Pos pos, PairList<Ast.Id, Ast.Exp> groupExps, List<Ast.Aggregate> aggregates) {
        return new Ast.Group(pos, Op.GROUP, groupExps.immutable(), (ImmutableList<Ast.Aggregate>)ImmutableList.copyOf(aggregates));
    }

    public Ast.FromStep where(Pos pos, Ast.Exp exp) {
        return new Ast.Where(pos, exp);
    }

    public Ast.FromStep distinct(Pos pos) {
        return new Ast.Distinct(pos);
    }

    public Ast.FromStep require(Pos pos, Ast.Exp exp) {
        return new Ast.Require(pos, exp);
    }

    public Ast.FromStep skip(Pos pos, Ast.Exp exp) {
        return new Ast.Skip(pos, exp);
    }

    public Ast.FromStep take(Pos pos, Ast.Exp exp) {
        return new Ast.Take(pos, exp);
    }

    public Ast.FromStep yield(Pos pos, Ast.Exp exp) {
        return new Ast.Yield(pos, exp);
    }

    public Ast.FromStep into(Pos pos, Ast.Exp exp) {
        return new Ast.Into(pos, exp);
    }

    public Ast.FromStep through(Pos pos, Ast.Pat pat, Ast.Exp exp) {
        return new Ast.Through(pos, pat, exp);
    }
}

