/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.BuiltIn;

public class AstWriter {
    private final StringBuilder b;
    private final boolean parenthesize;

    private AstWriter(StringBuilder b, boolean parenthesize) {
        this.b = b;
        this.parenthesize = parenthesize;
    }

    public AstWriter() {
        this(new StringBuilder(), false);
    }

    public String toString() {
        return this.b.toString();
    }

    public AstWriter withParenthesize(boolean parenthesize) {
        return parenthesize == this.parenthesize ? this : new AstWriter(this.b, parenthesize);
    }

    public AstWriter append(String s) {
        this.b.append(s);
        return this;
    }

    public AstWriter id(String name) {
        this.b.append(name);
        return this;
    }

    public AstWriter id(String name, int i) {
        this.b.append(name);
        if (i > 0) {
            this.b.append('_').append(i);
        }
        return this;
    }

    public AstWriter infix(int left, AstNode a0, Op op, AstNode a1, int right) {
        boolean p;
        if (op == Op.APPLY && a0.op == Op.ID) {
            Op op2;
            if (a0 instanceof Ast.Id && (op2 = (Op)((Object)Op.BY_OP_NAME.get((Object)((Ast.Id)a0).name))) != null && op2.left > 0) {
                List<Ast.Exp> args = ((Ast.Tuple)a1).args;
                Ast.InfixCall call = new Ast.InfixCall(Pos.ZERO, op2, args.get(0), args.get(1));
                return call.unparse(this, left, right);
            }
            if (a0 instanceof Core.Id && (op2 = (Op)((Object)Op.BY_OP_NAME.get((Object)((Core.Id)a0).idPat.name))) != null && op2.left > 0) {
                List<Core.Exp> args = ((Core.Tuple)a1).args;
                return this.infix(left, args.get(0), op2, args.get(1), right);
            }
        }
        boolean bl = p = this.parenthesize || left > op.left || op.right < right;
        if (p) {
            this.b.append('(');
            right = 0;
            left = 0;
        }
        this.append(a0, left, op.left);
        this.append(op.padded);
        this.append(a1, op.right, right);
        if (p) {
            this.b.append(')');
        }
        return this;
    }

    public AstWriter prefix(int left, Op op, AstNode a, int right) {
        boolean p;
        boolean bl = p = this.parenthesize || left > op.left || op.right < right;
        if (p) {
            this.b.append('(');
            right = 0;
        }
        this.append(op.padded);
        a.unparse(this, op.right, right);
        if (p) {
            this.b.append(')');
        }
        return this;
    }

    public AstWriter binary(String left, AstNode a0, String mid, AstNode a1, int right) {
        this.append(left);
        a0.unparse(this, 0, 0);
        this.append(mid);
        a1.unparse(this, 0, right);
        return this;
    }

    public AstWriter binary(String left, AstNode a0, String mid, AstNode a1, String right) {
        this.append(left);
        a0.unparse(this, 0, 0);
        this.append(mid);
        a1.unparse(this, 0, 0);
        this.append(right);
        return this;
    }

    public AstWriter append(AstNode node, int left, int right) {
        boolean p;
        boolean bl = p = this.parenthesize || left > node.op.left || node.op.right < right;
        if (p) {
            this.b.append('(');
            right = 0;
            left = 0;
        }
        node.unparse(this, left, right);
        if (p) {
            this.b.append(')');
        }
        return this;
    }

    public AstWriter appendAll(Iterable<? extends AstNode> nodes, int left, Op op, int right) {
        List nodeList = nodes instanceof List ? (List)nodes : Lists.newArrayList(nodes);
        for (int i = 0; i < nodeList.size(); ++i) {
            int thisRight;
            AstNode node = (AstNode)nodeList.get(i);
            int thisLeft = i == 0 ? left : op.left;
            int n = thisRight = i == nodeList.size() - 1 ? right : op.right;
            if (i > 0) {
                this.append(op.padded);
            }
            this.append(node, thisLeft, thisRight);
        }
        return this;
    }

    public AstWriter appendAll(Iterable<? extends AstNode> list, String sep) {
        return this.appendAll(list, "", sep, "");
    }

    public AstWriter appendAll(Iterable<? extends AstNode> list, String start, String sep, String end) {
        return this.appendAll(list, start, sep, end, "");
    }

    public AstWriter appendAll(Iterable<? extends AstNode> list, String start, String sep, String end, String empty) {
        String s = start;
        int i = 0;
        for (AstNode astNode : list) {
            ++i;
            this.append(s);
            s = sep;
            this.append(astNode, 0, 0);
        }
        if (i == 0 && empty != null) {
            this.append(empty);
        } else {
            this.append(end);
        }
        return this;
    }

    public AstWriter appendLiteral(Comparable value) {
        if (value instanceof String) {
            this.append("\"").append(((String)((Object)value)).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
        } else if (value instanceof Character) {
            Character c = (Character)value;
            this.append("#\"").append(c.charValue() == '\"' ? "\\\"" : (c.charValue() == '\\' ? "\\\\" : c.toString())).append("\"");
        } else if (value instanceof BigDecimal) {
            BigDecimal c = (BigDecimal)value;
            if (c.compareTo(BigDecimal.ZERO) < 0) {
                this.append("~");
                c = c.negate();
            }
            this.append(c.toString());
        } else if (value instanceof BuiltIn) {
            BuiltIn builtIn = (BuiltIn)((Object)value);
            if (builtIn.structure != null && !builtIn.structure.equals("$")) {
                this.append("#").append(builtIn.mlName).append(" ").append(builtIn.structure);
            } else {
                this.append(builtIn.mlName);
            }
        } else {
            this.append(value.toString());
        }
        return this;
    }
}

