/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.FromBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Extents;
import net.hydromatic.morel.compile.NameGenerator;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RangeExtent;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum CoreBuilder {
    core;

    private final Core.LiteralPat truePat = this.literalPat(Op.BOOL_LITERAL_PAT, PrimitiveType.BOOL, Boolean.TRUE);
    private final Core.WildcardPat boolWildcardPat = this.wildcardPat(PrimitiveType.BOOL);
    private final Core.Literal trueLiteral = CoreBuilder.boolLiteral_(true);
    private final Core.Literal falseLiteral = CoreBuilder.boolLiteral_(false);

    public Core.Literal literal(PrimitiveType type, Object value) {
        switch (type) {
            case BOOL: {
                return this.boolLiteral((Boolean)value);
            }
            case CHAR: {
                return this.charLiteral(((Character)value).charValue());
            }
            case INT: {
                return this.intLiteral(value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Number)value).longValue()));
            }
            case REAL: {
                if (value instanceof Float && ((Float)value).isNaN()) {
                    return new Core.Literal(Op.REAL_LITERAL, PrimitiveType.REAL, (Float)value);
                }
                return this.realLiteral(value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Number)value).doubleValue()));
            }
            case STRING: {
                return this.stringLiteral((String)value);
            }
            case UNIT: {
                return this.unitLiteral();
            }
        }
        throw new AssertionError((Object)("unexpected " + type));
    }

    private static Core.Literal boolLiteral_(boolean b) {
        return new Core.Literal(Op.BOOL_LITERAL, PrimitiveType.BOOL, Boolean.valueOf(b));
    }

    public Core.Literal boolLiteral(boolean b) {
        return b ? this.trueLiteral : this.falseLiteral;
    }

    public Core.Literal charLiteral(char c) {
        return new Core.Literal(Op.CHAR_LITERAL, PrimitiveType.CHAR, Character.valueOf(c));
    }

    public Core.Literal intLiteral(BigDecimal value) {
        return new Core.Literal(Op.INT_LITERAL, PrimitiveType.INT, value);
    }

    public Core.Literal realLiteral(BigDecimal value) {
        return new Core.Literal(Op.REAL_LITERAL, PrimitiveType.REAL, value);
    }

    public Core.Literal realLiteral(Float value) {
        return new Core.Literal(Op.REAL_LITERAL, PrimitiveType.REAL, value);
    }

    public Core.Literal stringLiteral(String value) {
        return new Core.Literal(Op.STRING_LITERAL, PrimitiveType.STRING, (Comparable)((Object)value));
    }

    public Core.Literal unitLiteral() {
        return new Core.Literal(Op.UNIT_LITERAL, PrimitiveType.UNIT, Unit.INSTANCE);
    }

    public Core.Literal functionLiteral(TypeSystem typeSystem, BuiltIn builtIn) {
        Type type = builtIn.typeFunction.apply(typeSystem);
        return new Core.Literal(Op.FN_LITERAL, type, (Comparable)((Object)builtIn));
    }

    public Core.Literal valueLiteral(Core.Exp exp, Object value) {
        return new Core.Literal(Op.VALUE_LITERAL, exp.type, Core.Literal.wrap(exp, value));
    }

    public Core.Literal internalLiteral(Object value) {
        Core.Literal exp = this.unitLiteral();
        return new Core.Literal(Op.INTERNAL_LITERAL, exp.type, Core.Literal.wrap(exp, value));
    }

    public Core.Id id(Core.NamedPat idPat) {
        return new Core.Id(idPat);
    }

    public Core.RecordSelector recordSelector(TypeSystem typeSystem, RecordLikeType recordType, String fieldName) {
        @Nullable TypedValue typedValue = recordType.asTypedValue();
        if (typedValue != null) {
            TypedValue typedValue2 = typedValue.discoverField(typeSystem, fieldName);
            recordType = (RecordLikeType)typedValue2.typeKey().toType(typeSystem);
        }
        int slot = 0;
        for (Map.Entry<String, Type> pair : recordType.argNameTypes().entrySet()) {
            if (pair.getKey().equals(fieldName)) {
                Type fieldType = pair.getValue();
                FnType fnType = typeSystem.fnType(recordType, fieldType);
                return this.recordSelector(fnType, slot);
            }
            ++slot;
        }
        throw new IllegalArgumentException("no field '" + fieldName + "' in type '" + recordType + "'");
    }

    public Core.RecordSelector recordSelector(TypeSystem typeSystem, RecordLikeType recordType, int slot) {
        Type fieldType = recordType.argType(slot);
        FnType fnType = typeSystem.fnType(recordType, fieldType);
        return this.recordSelector(fnType, slot);
    }

    public Core.RecordSelector recordSelector(FnType fnType, int slot) {
        return new Core.RecordSelector(fnType, slot);
    }

    public Core.IdPat idPat(Type type, String name, int i) {
        return new Core.IdPat(type, name, i);
    }

    public Core.IdPat idPat(Type type, Supplier<String> nameGenerator) {
        return this.idPat(type, nameGenerator.get(), 0);
    }

    public Core.IdPat idPat(Type type, String name, ToIntFunction<String> nameGenerator) {
        return this.idPat(type, name, nameGenerator.applyAsInt(name));
    }

    public Core.LiteralPat literalPat(Op op, Type type, Comparable value) {
        return new Core.LiteralPat(op, type, value);
    }

    public Core.WildcardPat wildcardPat(Type type) {
        return new Core.WildcardPat(type);
    }

    public Core.AsPat asPat(Type type, String name, int i, Core.Pat pat) {
        return new Core.AsPat(type, name, i, pat);
    }

    public Core.AsPat asPat(Type type, String name, NameGenerator nameGenerator, Core.Pat pat) {
        return this.asPat(type, name, nameGenerator.inc(name), pat);
    }

    public Core.ConPat consPat(Type type, String tyCon, Core.Pat pat) {
        return new Core.ConPat(Op.CONS_PAT, type, tyCon, pat);
    }

    public Core.ConPat conPat(Type type, String tyCon, Core.Pat pat) {
        return new Core.ConPat(type, tyCon, pat);
    }

    public Core.Con0Pat con0Pat(DataType type, String tyCon) {
        return new Core.Con0Pat(type, tyCon);
    }

    public Core.TuplePat tuplePat(RecordLikeType type, Iterable<? extends Core.Pat> args) {
        return new Core.TuplePat(type, (ImmutableList<Core.Pat>)ImmutableList.copyOf(args));
    }

    public Core.TuplePat tuplePat(RecordLikeType type, Core.Pat ... args) {
        return new Core.TuplePat(type, (ImmutableList<Core.Pat>)ImmutableList.copyOf((Object[])args));
    }

    public Core.TuplePat tuplePat(TypeSystem typeSystem, List<Core.Pat> args) {
        return this.tuplePat(typeSystem.tupleType(Static.transform(args, Core.Pat::type)), args);
    }

    public Core.ListPat listPat(Type type, Iterable<? extends Core.Pat> args) {
        return new Core.ListPat(type, (ImmutableList<Core.Pat>)ImmutableList.copyOf(args));
    }

    public Core.ListPat listPat(Type type, Core.Pat ... args) {
        return new Core.ListPat(type, (ImmutableList<Core.Pat>)ImmutableList.copyOf((Object[])args));
    }

    public Core.ListPat listPat(TypeSystem typeSystem, List<Core.Pat> args) {
        return this.listPat((Type)typeSystem.listType(args.get((int)0).type), args);
    }

    public Core.RecordPat recordPat(RecordType type, List<? extends Core.Pat> args) {
        return new Core.RecordPat(type, (ImmutableList<Core.Pat>)ImmutableList.copyOf(args));
    }

    public Core.Pat recordPat(TypeSystem typeSystem, Set<String> argNames, List<Core.Pat> args) {
        ImmutableSortedMap.Builder argNameTypes = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        Pair.forEach(argNames, args, (argName, arg) -> argNameTypes.put(argName, (Object)arg.type));
        return this.recordPat((RecordType)typeSystem.recordType((SortedMap<String, ? extends Type>)argNameTypes.build()), args);
    }

    public Core.Tuple tuple(RecordLikeType type, Iterable<? extends Core.Exp> args) {
        return new Core.Tuple(type, (ImmutableList<Core.Exp>)ImmutableList.copyOf(args));
    }

    public Core.Tuple tuple(RecordLikeType type, Core.Exp ... args) {
        return new Core.Tuple(type, (ImmutableList<Core.Exp>)ImmutableList.copyOf((Object[])args));
    }

    public Core.Tuple tuple(TypeSystem typeSystem, Core.Exp ... args) {
        return this.tuple(typeSystem, null, (Iterable<? extends Core.Exp>)ImmutableList.copyOf((Object[])args));
    }

    public Core.Tuple tuple(TypeSystem typeSystem, @Nullable RecordLikeType type, Iterable<? extends Core.Exp> args) {
        RecordLikeType tupleType;
        ImmutableList argList = ImmutableList.copyOf(args);
        if (type instanceof RecordType) {
            PairList<String, Type> argNameTypes = PairList.of();
            Pair.forEach(type.argNameTypes().keySet(), argList, (name, arg) -> argNameTypes.add((String)name, arg.type));
            tupleType = typeSystem.recordType(argNameTypes);
        } else {
            tupleType = typeSystem.tupleType(Static.transform(argList, Core.Exp::type));
        }
        return new Core.Tuple(tupleType, (ImmutableList<Core.Exp>)argList);
    }

    public Core.Let let(Core.ValDecl decl, Core.Exp exp) {
        return new Core.Let(decl, exp);
    }

    public Core.Local local(DataType dataType, Core.Exp exp) {
        return new Core.Local(dataType, exp);
    }

    public Core.NonRecValDecl nonRecValDecl(Pos pos, Core.NamedPat pat, Core.Exp exp) {
        return new Core.NonRecValDecl(pat, exp, pos);
    }

    public Core.RecValDecl recValDecl(Iterable<? extends Core.NonRecValDecl> list) {
        return new Core.RecValDecl((ImmutableList<Core.NonRecValDecl>)ImmutableList.copyOf(list));
    }

    public Core.Match match(Pos pos, Core.Pat pat, Core.Exp exp) {
        return new Core.Match(pos, pat, exp);
    }

    public Core.Case caseOf(Pos pos, Type type, Core.Exp exp, Iterable<? extends Core.Match> matchList) {
        return new Core.Case(pos, type, exp, (ImmutableList<Core.Match>)ImmutableList.copyOf(matchList));
    }

    public Core.From from(ListType type, List<Core.FromStep> steps) {
        return new Core.From(type, (ImmutableList<Core.FromStep>)ImmutableList.copyOf(steps));
    }

    public Core.From from(TypeSystem typeSystem, List<Core.FromStep> steps) {
        Type elementType = this.fromElementType(typeSystem, steps);
        return this.from(typeSystem.listType(elementType), steps);
    }

    private Type fromElementType(TypeSystem typeSystem, List<Core.FromStep> steps) {
        if (!steps.isEmpty() && Iterables.getLast(steps) instanceof Core.Yield) {
            return ((Core.Yield)Iterables.getLast(steps)).exp.type;
        }
        List<Binding> lastBindings = this.lastBindings(steps);
        if (lastBindings.size() == 1) {
            return lastBindings.get((int)0).id.type;
        }
        PairList<String, Type> argNameTypes = PairList.of();
        lastBindings.forEach(b -> argNameTypes.add(b.id.name, b.id.type));
        return typeSystem.recordType(argNameTypes);
    }

    public Core.Exp implicitYieldExp(TypeSystem typeSystem, List<Core.FromStep> steps) {
        List<Binding> bindings = this.lastBindings(steps);
        if (bindings.size() == 1) {
            return this.id(((Binding)Iterables.getOnlyElement(bindings)).id);
        }
        TreeMap map = new TreeMap();
        PairList<String, Type> argNameTypes = PairList.of();
        bindings.forEach(b -> {
            map.put(b.id, this.id(b.id));
            argNameTypes.add(b.id.name, b.id.type);
        });
        return this.tuple(typeSystem.recordType(argNameTypes), map.values());
    }

    public List<Binding> lastBindings(List<? extends Core.FromStep> steps) {
        return steps.isEmpty() ? ImmutableList.of() : ((Core.FromStep)Iterables.getLast(steps)).bindings;
    }

    public FromBuilder fromBuilder(TypeSystem typeSystem, @Nullable Environment env) {
        return new FromBuilder(typeSystem, env);
    }

    public FromBuilder fromBuilder(TypeSystem typeSystem) {
        return this.fromBuilder(typeSystem, null);
    }

    public Core.Fn fn(FnType type, Core.IdPat idPat, Core.Exp exp) {
        return new Core.Fn(type, idPat, exp);
    }

    public Core.Fn fn(Pos pos, FnType type, List<Core.Match> matchList, ToIntFunction<String> nameGenerator) {
        if (matchList.size() == 1) {
            Core.Match match = matchList.get(0);
            if (match.pat instanceof Core.IdPat) {
                return this.fn(type, (Core.IdPat)match.pat, match.exp);
            }
            if (match.pat instanceof Core.TuplePat && ((Core.TuplePat)match.pat).args.isEmpty()) {
                Core.IdPat idPat = this.idPat(type.paramType, "v", nameGenerator);
                return this.fn(type, idPat, match.exp);
            }
        }
        Core.IdPat idPat = this.idPat(type.paramType, "v", nameGenerator);
        Core.Id id = this.id(idPat);
        return this.fn(type, idPat, this.caseOf(pos, type.resultType, id, matchList));
    }

    public Core.Apply apply(Pos pos, Type type, Core.Exp fn, Core.Exp arg) {
        return new Core.Apply(pos, type, fn, arg);
    }

    public Core.Apply apply(Pos pos, TypeSystem typeSystem, BuiltIn builtIn, Core.Exp arg0, Core.Exp arg1, Core.Exp ... args) {
        Core.Literal fn = this.functionLiteral(typeSystem, builtIn);
        FnType fnType = (FnType)fn.type;
        TupleType tupleType = (TupleType)fnType.paramType;
        return this.apply(pos, fnType.resultType, fn, this.tuple((RecordLikeType)tupleType, Lists.asList((Object)arg0, (Object)arg1, (Object[])args)));
    }

    public Core.Case ifThenElse(Core.Exp condition, Core.Exp ifTrue, Core.Exp ifFalse) {
        Pos pos = Pos.ZERO;
        return new Core.Case(pos, ifTrue.type, condition, (ImmutableList<Core.Match>)ImmutableList.of((Object)this.match(pos, this.truePat, ifTrue), (Object)this.match(pos, this.boolWildcardPat, ifFalse)));
    }

    public Core.DatatypeDecl datatypeDecl(Iterable<DataType> dataTypes) {
        return new Core.DatatypeDecl((ImmutableList<DataType>)ImmutableList.copyOf(dataTypes));
    }

    public Core.Scan scan(List<Binding> bindings, Core.Pat pat, Core.Exp exp, Core.Exp condition) {
        return new Core.Scan((ImmutableList<Binding>)ImmutableList.copyOf(bindings), pat, exp, condition);
    }

    public Core.Aggregate aggregate(Type type, Core.Exp aggregate, @Nullable Core.Exp argument) {
        return new Core.Aggregate(type, aggregate, argument);
    }

    public Core.Order order(List<Binding> bindings, Iterable<Core.OrderItem> orderItems) {
        return new Core.Order((ImmutableList<Binding>)ImmutableList.copyOf(bindings), (ImmutableList<Core.OrderItem>)ImmutableList.copyOf(orderItems));
    }

    public Core.OrderItem orderItem(Core.Exp exp, Ast.Direction direction) {
        return new Core.OrderItem(exp, direction);
    }

    public Core.Group group(SortedMap<Core.IdPat, Core.Exp> groupExps, SortedMap<Core.IdPat, Core.Aggregate> aggregates) {
        ArrayList bindings = new ArrayList();
        groupExps.keySet().forEach(id -> bindings.add(Binding.of(id)));
        aggregates.keySet().forEach(id -> bindings.add(Binding.of(id)));
        return new Core.Group((ImmutableList<Binding>)ImmutableList.copyOf(bindings), (ImmutableSortedMap<Core.IdPat, Core.Exp>)ImmutableSortedMap.copyOfSorted(groupExps), (ImmutableSortedMap<Core.IdPat, Core.Aggregate>)ImmutableSortedMap.copyOfSorted(aggregates));
    }

    public Core.Where where(List<Binding> bindings, Core.Exp exp) {
        return new Core.Where((ImmutableList<Binding>)ImmutableList.copyOf(bindings), exp);
    }

    public Core.Skip skip(List<Binding> bindings, Core.Exp exp) {
        return new Core.Skip((ImmutableList<Binding>)ImmutableList.copyOf(bindings), exp);
    }

    public Core.Take take(List<Binding> bindings, Core.Exp exp) {
        return new Core.Take((ImmutableList<Binding>)ImmutableList.copyOf(bindings), exp);
    }

    public Core.Yield yield_(List<Binding> bindings, Core.Exp exp) {
        return new Core.Yield((ImmutableList<Binding>)ImmutableList.copyOf(bindings), exp);
    }

    public Core.Yield yield_(TypeSystem typeSystem, Core.Exp exp) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        block0 : switch (exp.type.op()) {
            case RECORD_TYPE: 
            case TUPLE_TYPE: {
                Pair.forEachIndexed(((RecordLikeType)exp.type).argNameTypes(), (i, name, type) -> {
                    Core.NamedPat idPat = exp.op == Op.TUPLE && exp.arg(i) instanceof Core.Id && ((Core.Id)exp.arg((int)i)).idPat.name.equals(name) ? ((Core.Id)exp.arg((int)i)).idPat : this.idPat((Type)type, (String)name, typeSystem.nameGenerator::inc);
                    bindings.add(Binding.of(idPat));
                });
                break;
            }
            default: {
                switch (exp.op) {
                    case ID: {
                        bindings.add(Binding.of(((Core.Id)exp).idPat));
                        break block0;
                    }
                }
                bindings.add(Binding.of(this.idPat(exp.type, typeSystem.nameGenerator::get)));
            }
        }
        return this.yield_(bindings, exp);
    }

    public Core.Exp field(TypeSystem typeSystem, Core.Exp exp, int slot) {
        Core.RecordSelector selector = this.recordSelector(typeSystem, (RecordLikeType)exp.type, slot);
        return this.apply(exp.pos, selector.type().resultType, selector, exp);
    }

    public Core.Exp list(TypeSystem typeSystem, Type elementType, List<Core.Exp> args) {
        Core.Literal literal = this.functionLiteral(typeSystem, BuiltIn.Z_LIST);
        ListType listType = typeSystem.listType(elementType);
        return this.apply(Pos.ZERO, listType, literal, core.tuple(typeSystem, null, args));
    }

    public Core.Exp list(TypeSystem typeSystem, Core.Exp arg0, Core.Exp ... args) {
        return this.list(typeSystem, arg0.type, Lists.asList((Object)arg0, (Object[])args));
    }

    public Core.Exp extent(TypeSystem typeSystem, Type type, RangeSet rangeSet) {
        ImmutableMap map = rangeSet.complement().isEmpty() ? ImmutableMap.of() : ImmutableMap.of((Object)"/", (Object)ImmutableRangeSet.copyOf((RangeSet)rangeSet));
        return this.extent(typeSystem, type, (Map<String, ImmutableRangeSet>)map);
    }

    public Core.Exp extent(TypeSystem typeSystem, Type type, Map<String, ImmutableRangeSet> rangeSetMap) {
        ListType listType = typeSystem.listType(type);
        return core.apply(Pos.ZERO, listType, core.functionLiteral(typeSystem, BuiltIn.Z_EXTENT), core.internalLiteral(new RangeExtent(typeSystem, type, rangeSetMap)));
    }

    public Pair<Core.Exp, List<Core.Exp>> intersectExtents(TypeSystem typeSystem, List<? extends Core.Exp> exps) {
        switch (exps.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return Pair.of(this.simplify(typeSystem, exps.get(0)), ImmutableList.of());
            }
        }
        ArrayList rangeSetMaps = new ArrayList();
        ArrayList<Core.Exp> remainingExps = new ArrayList<Core.Exp>();
        for (Core.Exp exp : exps) {
            if (exp.isCallTo(BuiltIn.Z_EXTENT)) {
                Core.Literal argLiteral = (Core.Literal)((Core.Apply)exp).arg;
                RangeExtent list = argLiteral.unwrap(RangeExtent.class);
                rangeSetMaps.add(list.rangeSetMap);
                continue;
            }
            remainingExps.add(exp);
        }
        ListType listType = (ListType)exps.get((int)0).type;
        Map<String, ImmutableRangeSet> map = Extents.intersect(rangeSetMaps);
        Core.Exp exp = core.extent(typeSystem, listType.elementType, map);
        for (Core.Exp remainingExp : remainingExps) {
            exp = core.intersect(typeSystem, exp, remainingExp);
        }
        return Pair.of(exp, remainingExps);
    }

    public Pair<Core.Exp, List<Core.Exp>> unionExtents(TypeSystem typeSystem, List<? extends Core.Exp> exps) {
        switch (exps.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return Pair.of(this.simplify(typeSystem, exps.get(0)), ImmutableList.of());
            }
        }
        ArrayList rangeSetMaps = new ArrayList();
        ArrayList<Core.Exp> remainingExps = new ArrayList<Core.Exp>();
        for (Core.Exp exp : exps) {
            if (exp.isCallTo(BuiltIn.Z_EXTENT)) {
                Core.Literal argLiteral = (Core.Literal)((Core.Apply)exp).arg;
                Core.Wrapper wrapper = (Core.Wrapper)argLiteral.value;
                RangeExtent list = wrapper.unwrap(RangeExtent.class);
                rangeSetMaps.add(list.rangeSetMap);
                continue;
            }
            remainingExps.add(exp);
        }
        ListType listType = (ListType)exps.get((int)0).type;
        Map<String, ImmutableRangeSet> map = Extents.union(rangeSetMaps);
        Core.Exp exp = core.extent(typeSystem, listType.elementType, map);
        for (Core.Exp remainingExp : remainingExps) {
            exp = core.union(typeSystem, exp, remainingExp);
        }
        return Pair.of(exp, remainingExps);
    }

    public Core.Exp simplify(TypeSystem typeSystem, Core.Exp exp) {
        switch (exp.op) {
            case TUPLE: {
                Core.Tuple tuple = (Core.Tuple)exp;
                return tuple.copy(typeSystem, Static.transform(tuple.args, e -> this.simplify(typeSystem, (Core.Exp)e)));
            }
            case APPLY: {
                Pair<Core.Exp, List<Core.Exp>> pair;
                Core.Apply apply = (Core.Apply)exp;
                Core.Exp simplifiedArgs = this.simplify(typeSystem, apply.arg);
                if (!simplifiedArgs.equals(apply.arg)) {
                    apply = apply.copy(apply.fn, simplifiedArgs);
                }
                if (apply.isCallTo(BuiltIn.OP_UNION) && apply.args().stream().allMatch(exp1 -> exp1.isCallTo(BuiltIn.Z_EXTENT))) {
                    pair = this.unionExtents(typeSystem, apply.args());
                    if (((List)pair.right).isEmpty()) {
                        return (Core.Exp)pair.left;
                    }
                }
                if (!apply.isCallTo(BuiltIn.OP_INTERSECT) || !apply.args().stream().allMatch(exp1 -> exp1.isCallTo(BuiltIn.Z_EXTENT))) break;
                pair = this.intersectExtents(typeSystem, apply.args());
                if (!((List)pair.right).isEmpty()) break;
                return (Core.Exp)pair.left;
            }
        }
        return exp;
    }

    public Core.Exp record(TypeSystem typeSystem, Map<String, ? extends Core.Exp> nameExps) {
        return this.record_(typeSystem, (ImmutableSortedMap<String, Core.Exp>)ImmutableSortedMap.copyOf(nameExps, RecordType.ORDERING));
    }

    public Core.Exp record(TypeSystem typeSystem, Collection<? extends Map.Entry<String, ? extends Core.Exp>> nameExps) {
        return this.record_(typeSystem, (ImmutableSortedMap<String, Core.Exp>)ImmutableSortedMap.copyOf(nameExps, RecordType.ORDERING));
    }

    private Core.Tuple record_(TypeSystem typeSystem, ImmutableSortedMap<String, Core.Exp> nameExps) {
        PairList<String, Type> argNameTypes = PairList.of();
        nameExps.forEach((name, exp) -> argNameTypes.add((String)name, exp.type));
        return this.tuple(typeSystem, typeSystem.recordType(argNameTypes), (Iterable<? extends Core.Exp>)nameExps.values());
    }

    private Core.Apply call(TypeSystem typeSystem, BuiltIn builtIn, Core.Exp ... args) {
        Core.Literal literal = this.functionLiteral(typeSystem, builtIn);
        FnType fnType = (FnType)literal.type;
        return this.apply(Pos.ZERO, fnType.resultType, literal, this.args(fnType.paramType, args));
    }

    public Core.Apply call(TypeSystem typeSystem, BuiltIn builtIn, Type type, Pos pos, Core.Exp ... args) {
        Core.Literal literal = this.functionLiteral(typeSystem, builtIn);
        ForallType forallType = (ForallType)literal.type;
        FnType fnType = (FnType)typeSystem.apply((Type)forallType, type);
        return this.apply(pos, fnType.resultType, literal, this.args(fnType.paramType, args));
    }

    private Core.Exp args(Type paramType, Core.Exp[] args) {
        return args.length == 1 ? args[0] : this.tuple((RecordLikeType)((TupleType)paramType), args);
    }

    public Core.Exp equal(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_EQ, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp notEqual(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_NE, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp lessThan(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_LT, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp greaterThan(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_GT, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp greaterThanOrEqualTo(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_GE, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp elem(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        if (a1.isCallTo(BuiltIn.Z_LIST) && ((Core.Apply)a1).args().size() == 1) {
            return this.equal(typeSystem, a0, ((Core.Apply)a1).args().get(0));
        }
        return this.call(typeSystem, BuiltIn.OP_ELEM, a0.type, Pos.ZERO, a0, a1);
    }

    public Core.Exp not(TypeSystem typeSystem, Core.Exp a0) {
        Core.Literal not = this.functionLiteral(typeSystem, BuiltIn.NOT);
        return this.apply(a0.pos, PrimitiveType.BOOL, not, a0);
    }

    public Core.Exp andAlso(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.Z_ANDALSO, a0, a1);
    }

    public Core.Exp andAlso(TypeSystem typeSystem, Iterable<Core.Exp> exps) {
        ImmutableList expList = ImmutableList.copyOf(exps);
        if (expList.isEmpty()) {
            return this.trueLiteral;
        }
        return this.foldRight((List)expList, (BiFunction)(e1, e2) -> this.andAlso(typeSystem, (Core.Exp)e1, (Core.Exp)e2));
    }

    public Core.Exp orElse(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.Z_ORELSE, a0, a1);
    }

    public Core.Exp orElse(TypeSystem typeSystem, Iterable<Core.Exp> exps) {
        ImmutableList expList = ImmutableList.copyOf(exps);
        if (expList.isEmpty()) {
            return this.falseLiteral;
        }
        return this.foldRight((List)expList, (BiFunction)(e1, e2) -> this.orElse(typeSystem, (Core.Exp)e1, (Core.Exp)e2));
    }

    private <E> E foldRight(List<E> list, BiFunction<E, E, E> fold) {
        E e = list.get(list.size() - 1);
        for (int i = list.size() - 2; i >= 0; --i) {
            e = fold.apply(list.get(i), e);
        }
        return e;
    }

    public Core.Exp only(TypeSystem typeSystem, Pos pos, Core.Exp a0) {
        return this.call(typeSystem, BuiltIn.RELATIONAL_ONLY, ((ListType)a0.type).elementType, pos, a0);
    }

    public Core.Exp nonEmpty(TypeSystem typeSystem, Pos pos, Core.Exp a0) {
        return this.call(typeSystem, BuiltIn.RELATIONAL_NON_EMPTY, PrimitiveType.BOOL, pos, a0);
    }

    public Core.Exp empty(TypeSystem typeSystem, Pos pos, Core.Exp a0) {
        return this.call(typeSystem, BuiltIn.RELATIONAL_EMPTY, PrimitiveType.BOOL, pos, a0);
    }

    public Core.Exp union(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_UNION, ((ListType)a0.type).elementType, Pos.ZERO, a0, a1);
    }

    public Core.Exp union(TypeSystem typeSystem, Iterable<Core.Exp> exps) {
        return this.foldRight((List)ImmutableList.copyOf(exps), (BiFunction)(e1, e2) -> this.union(typeSystem, (Core.Exp)e1, (Core.Exp)e2));
    }

    public Core.Exp intersect(TypeSystem typeSystem, Core.Exp a0, Core.Exp a1) {
        return this.call(typeSystem, BuiltIn.OP_INTERSECT, ((ListType)a0.type).elementType, Pos.ZERO, a0, a1);
    }

    public Core.Exp intersect(TypeSystem typeSystem, Iterable<Core.Exp> exps) {
        return this.foldRight((List)ImmutableList.copyOf(exps), (BiFunction)(e1, e2) -> this.intersect(typeSystem, (Core.Exp)e1, (Core.Exp)e2));
    }

    public Core.Exp subTrue(TypeSystem typeSystem, Core.Exp exp, List<Core.Exp> trueExps) {
        List<Core.Exp> conjunctions = this.decomposeAnd(exp);
        ArrayList<Core.Exp> conjunctions2 = new ArrayList<Core.Exp>();
        for (Core.Exp conjunction : conjunctions) {
            if (trueExps.contains(conjunction)) continue;
            conjunctions2.add(conjunction);
        }
        if (conjunctions.size() == conjunctions2.size()) {
            return exp;
        }
        return this.andAlso(typeSystem, conjunctions2);
    }

    public List<Core.Exp> decomposeAnd(Core.Exp exp) {
        ImmutableList.Builder list = ImmutableList.builder();
        this.flattenAnd(exp, arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
        return list.build();
    }

    public List<Core.Exp> decomposeOr(Core.Exp exp) {
        ImmutableList.Builder list = ImmutableList.builder();
        this.flattenOr(exp, arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
        return list.build();
    }

    public void flattenAnd(Core.Exp exp, Consumer<Core.Exp> consumer) {
        if (exp.op != Op.BOOL_LITERAL || !((Boolean)((Core.Literal)exp).value).booleanValue()) {
            if (exp.op == Op.APPLY && ((Core.Apply)exp).fn.op == Op.FN_LITERAL && ((Core.Literal)((Core.Apply)exp).fn).value == BuiltIn.Z_ANDALSO) {
                this.flattenAnds(((Core.Apply)exp).args(), consumer);
            } else {
                consumer.accept(exp);
            }
        }
    }

    public void flattenAnds(List<Core.Exp> exps, Consumer<Core.Exp> consumer) {
        exps.forEach(arg -> this.flattenAnd((Core.Exp)arg, consumer));
    }

    public void flattenOr(Core.Exp exp, Consumer<Core.Exp> consumer) {
        if (exp.op != Op.BOOL_LITERAL || ((Boolean)((Core.Literal)exp).value).booleanValue()) {
            if (exp.op == Op.APPLY && ((Core.Apply)exp).fn.op == Op.FN_LITERAL && ((Core.Literal)((Core.Apply)exp).fn).value == BuiltIn.Z_ORELSE) {
                this.flattenOrs(((Core.Apply)exp).args(), consumer);
            } else {
                consumer.accept(exp);
            }
        }
    }

    public void flattenOrs(List<Core.Exp> exps, Consumer<Core.Exp> consumer) {
        exps.forEach(arg -> this.flattenOr((Core.Exp)arg, consumer));
    }
}

