/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.RefChecker;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FromBuilder {
    private final TypeSystem typeSystem;
    private final @Nullable Environment env;
    private final List<Core.FromStep> steps = new ArrayList<Core.FromStep>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private int removeIfNotLastIndex = Integer.MIN_VALUE;
    private int removeIfLastIndex = Integer.MIN_VALUE;

    FromBuilder(TypeSystem typeSystem, @Nullable Environment env) {
        this.typeSystem = typeSystem;
        this.env = env;
    }

    public void clear() {
        this.steps.clear();
        this.bindings.clear();
        this.removeIfNotLastIndex = Integer.MIN_VALUE;
        this.removeIfLastIndex = Integer.MIN_VALUE;
    }

    public String toString() {
        return this.steps.toString();
    }

    public List<Binding> bindings() {
        return ImmutableList.copyOf(this.bindings);
    }

    private FromBuilder addStep(Core.FromStep step) {
        if (this.env != null) {
            RefChecker.of(this.typeSystem, this.env.bindAll(this.bindings)).visitStep(step, (List)this.bindings);
        }
        if (this.removeIfNotLastIndex == this.steps.size() - 1) {
            this.removeIfNotLastIndex = Integer.MIN_VALUE;
            this.removeIfLastIndex = Integer.MIN_VALUE;
            Core.FromStep lastStep = (Core.FromStep)Iterables.getLast(this.steps);
            if (lastStep.op == Op.YIELD) {
                Core.Yield yield = (Core.Yield)lastStep;
                if (yield.exp.op == Op.TUPLE) {
                    Core.Tuple tuple = (Core.Tuple)yield.exp;
                    Core.FromStep previousStep = this.steps.get(this.steps.size() - 2);
                    ImmutableList<Binding> previousBindings = previousStep.bindings;
                    if (tuple.args.size() == 1 && FromBuilder.isTrivial(tuple, previousBindings, (List<Binding>)yield.bindings)) {
                        this.steps.remove(this.steps.size() - 1);
                    }
                }
            }
        }
        this.steps.add(step);
        if (!this.bindings.equals(step.bindings)) {
            this.bindings.clear();
            this.bindings.addAll((Collection<Binding>)step.bindings);
        }
        return this;
    }

    public FromBuilder scan(Core.Pat pat) {
        Core.Exp extent = CoreBuilder.core.extent(this.typeSystem, pat.type, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        return this.scan(pat, extent, CoreBuilder.core.boolLiteral(true));
    }

    public FromBuilder scan(Core.Pat pat, Core.Exp exp) {
        return this.scan(pat, exp, CoreBuilder.core.boolLiteral(true));
    }

    public FromBuilder scan(Core.Pat pat, Core.Exp exp, Core.Exp condition) {
        if (exp.op == Op.FROM && CoreBuilder.core.boolLiteral(true).equals(condition) && (pat instanceof Core.IdPat && !((Core.From)exp).steps.isEmpty() && ((Core.FromStep)Iterables.getLast(((Core.From)exp).steps)).bindings.size() == 1 || pat instanceof Core.RecordPat && ((Core.RecordPat)pat).args.stream().allMatch(a -> a instanceof Core.IdPat) || pat instanceof Core.TuplePat && ((Core.TuplePat)pat).args.stream().allMatch(a -> a instanceof Core.IdPat))) {
            List<Binding> bindings;
            Core.From from = (Core.From)exp;
            Core.FromStep lastStep = (Core.FromStep)Iterables.getLast(from.steps);
            Object steps = lastStep.op == Op.YIELD ? Static.skipLast(from.steps) : from.steps;
            PairList<String, Core.Exp> nameExps = PairList.of();
            boolean uselessIfLast = this.bindings.isEmpty();
            if (pat instanceof Core.RecordPat) {
                Core.RecordPat recordPat = (Core.RecordPat)pat;
                this.bindings.forEach(b -> nameExps.add(b.id.name, CoreBuilder.core.id(b.id)));
                Pair.forEach(recordPat.type().argNameTypes.keySet(), recordPat.args, (name, arg) -> nameExps.add((String)name, CoreBuilder.core.id((Core.IdPat)arg)));
                bindings = null;
            } else if (pat instanceof Core.TuplePat) {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                Pair.forEach(tuplePat.args, lastStep.bindings, (arg, binding) -> nameExps.add(((Core.IdPat)arg).name, CoreBuilder.core.id(binding.id)));
                bindings = null;
            } else if (!this.bindings.isEmpty()) {
                Core.IdPat idPat = (Core.IdPat)pat;
                this.bindings.forEach(b -> nameExps.add(b.id.name, CoreBuilder.core.id(b.id)));
                lastStep.bindings.forEach(b -> nameExps.add(idPat.name, CoreBuilder.core.id(b.id)));
                bindings = null;
            } else {
                Core.IdPat idPat = (Core.IdPat)pat;
                if (lastStep instanceof Core.Yield && ((Core.Yield)lastStep).exp.op != Op.RECORD) {
                    this.addAll((Iterable<? extends Core.FromStep>)steps);
                    if (((Core.Yield)lastStep).exp.op == Op.ID && this.bindings.size() == 1) {
                        return this;
                    }
                    nameExps.add(idPat.name, ((Core.Yield)lastStep).exp);
                    ImmutableList bindings2 = ImmutableList.of((Object)Binding.of(idPat));
                    return this.yield_(false, (List<Binding>)bindings2, CoreBuilder.core.record(this.typeSystem, nameExps));
                }
                Binding binding2 = (Binding)Iterables.getOnlyElement(lastStep.bindings);
                nameExps.add(idPat.name, CoreBuilder.core.id(binding2.id));
                bindings = Static.append(this.bindings, Binding.of(idPat));
            }
            this.addAll((Iterable<? extends Core.FromStep>)steps);
            return this.yield_(uselessIfLast, bindings, CoreBuilder.core.record(this.typeSystem, nameExps));
        }
        Compiles.acceptBinding(this.typeSystem, pat, this.bindings);
        return this.addStep(CoreBuilder.core.scan(this.bindings, pat, exp, condition));
    }

    public FromBuilder addAll(Iterable<? extends Core.FromStep> steps) {
        StepHandler stepHandler = new StepHandler();
        steps.forEach(stepHandler::accept);
        return this;
    }

    public FromBuilder where(Core.Exp condition) {
        if (condition.op == Op.BOOL_LITERAL && ((Core.Literal)condition).unwrap(Boolean.class).booleanValue()) {
            return this;
        }
        return this.addStep(CoreBuilder.core.where(this.bindings, condition));
    }

    public FromBuilder skip(Core.Exp count) {
        if (count.op == Op.INT_LITERAL && ((Core.Literal)count).value.equals(BigDecimal.ZERO)) {
            return this;
        }
        return this.addStep(CoreBuilder.core.skip(this.bindings, count));
    }

    public FromBuilder take(Core.Exp count) {
        return this.addStep(CoreBuilder.core.take(this.bindings, count));
    }

    public FromBuilder distinct() {
        ImmutableSortedMap.Builder groupExpsB = ImmutableSortedMap.naturalOrder();
        this.bindings.forEach(b -> groupExpsB.put((Object)((Core.IdPat)b.id), (Object)CoreBuilder.core.id(b.id)));
        return this.addStep(CoreBuilder.core.group((SortedMap<Core.IdPat, Core.Exp>)groupExpsB.build(), (SortedMap<Core.IdPat, Core.Aggregate>)ImmutableSortedMap.of()));
    }

    public FromBuilder group(SortedMap<Core.IdPat, Core.Exp> groupExps, SortedMap<Core.IdPat, Core.Aggregate> aggregates) {
        return this.addStep(CoreBuilder.core.group(groupExps, aggregates));
    }

    public FromBuilder order(Iterable<Core.OrderItem> orderItems) {
        ImmutableList orderItemList = ImmutableList.copyOf(orderItems);
        if (orderItemList.isEmpty()) {
            return this;
        }
        return this.addStep(CoreBuilder.core.order(this.bindings, orderItems));
    }

    public FromBuilder yield_(Core.Exp exp) {
        return this.yield_(false, exp);
    }

    public FromBuilder yield_(boolean uselessIfLast, Core.Exp exp) {
        return this.yield_(uselessIfLast, null, exp);
    }

    public FromBuilder yield_(boolean uselessIfLast, @Nullable List<Binding> bindings2, Core.Exp exp) {
        boolean uselessIfNotLast = false;
        switch (exp.op) {
            case TUPLE: {
                TupleType tupleType = FromBuilder.tupleType((Core.Tuple)exp, this.bindings, bindings2);
                switch (tupleType.ordinal()) {
                    case 1: {
                        if (this.bindings.size() == 1) {
                            if (bindings2 == null) {
                                bindings2 = ImmutableList.copyOf(this.bindings);
                            }
                            uselessIfNotLast = true;
                            break;
                        }
                        return this;
                    }
                    case 0: {
                        if (this.bindings.size() != 1) break;
                    }
                }
                break;
            }
            case ID: {
                if (this.bindings.size() != 1 || !((Core.Id)exp).idPat.equals(this.bindings.get((int)0).id) || !this.steps.isEmpty() && Static.last(this.steps).op == Op.YIELD && ((Core.Yield)Static.last(this.steps)).exp.op == Op.TUPLE) break;
                return this;
            }
        }
        this.addStep(bindings2 != null ? CoreBuilder.core.yield_((List<Binding>)bindings2, exp) : CoreBuilder.core.yield_(this.typeSystem, exp));
        this.removeIfNotLastIndex = uselessIfNotLast ? this.steps.size() - 1 : Integer.MIN_VALUE;
        this.removeIfLastIndex = uselessIfLast ? this.steps.size() - 1 : Integer.MIN_VALUE;
        return this;
    }

    private static boolean isTrivial(Core.Tuple tuple, List<Binding> bindings, @Nullable List<Binding> bindings2) {
        return FromBuilder.tupleType(tuple, bindings, bindings2) == TupleType.IDENTITY;
    }

    private static TupleType tupleType(Core.Tuple tuple, List<Binding> bindings, @Nullable List<Binding> bindings2) {
        if (tuple.args.size() != bindings.size()) {
            return TupleType.OTHER;
        }
        ImmutableList argNames = ImmutableList.copyOf(tuple.type().argNameTypes().keySet());
        boolean identity = bindings2 == null || bindings.equals(bindings2);
        for (int i = 0; i < tuple.args.size(); ++i) {
            Core.Exp exp = tuple.args.get(i);
            if (exp.op != Op.ID) {
                return TupleType.OTHER;
            }
            if (((Core.Id)exp).idPat.name.equals(argNames.get(i))) continue;
            identity = false;
        }
        return identity ? TupleType.IDENTITY : TupleType.RENAME;
    }

    private Core.Exp build(boolean simplify) {
        if (this.removeIfLastIndex == this.steps.size() - 1) {
            this.removeIfLastIndex = Integer.MIN_VALUE;
            Core.Yield yield = (Core.Yield)Iterables.getLast(this.steps);
            if (yield.exp.op != Op.TUPLE || ((Core.Tuple)yield.exp).args.size() != 1) {
                throw new AssertionError(yield.exp);
            }
            this.steps.remove(this.steps.size() - 1);
        }
        if (simplify && this.steps.size() == 1 && this.steps.get((int)0).op == Op.SCAN) {
            Core.Scan scan = (Core.Scan)this.steps.get(0);
            if (scan.pat.op == Op.ID_PAT) {
                return scan.exp;
            }
        }
        return CoreBuilder.core.from(this.typeSystem, this.steps);
    }

    public Core.From build() {
        return (Core.From)this.build(false);
    }

    public Core.Exp buildSimplify() {
        return this.build(true);
    }

    private class StepHandler
    extends Visitor {
        private StepHandler() {
        }

        @Override
        protected void visit(Core.Group group) {
            FromBuilder.this.group(group.groupExps, group.aggregates);
        }

        @Override
        protected void visit(Core.Order order) {
            FromBuilder.this.order((Iterable<Core.OrderItem>)order.orderItems);
        }

        @Override
        protected void visit(Core.Scan scan) {
            FromBuilder.this.scan(scan.pat, scan.exp, scan.condition);
        }

        @Override
        protected void visit(Core.Where where) {
            FromBuilder.this.where(where.exp);
        }

        @Override
        protected void visit(Core.Skip skip) {
            FromBuilder.this.skip(skip.exp);
        }

        @Override
        protected void visit(Core.Take take) {
            FromBuilder.this.take(take.exp);
        }

        @Override
        protected void visit(Core.Yield yield) {
            FromBuilder.this.yield_(false, (List<Binding>)yield.bindings, yield.exp);
        }
    }

    private static enum TupleType {
        RENAME,
        IDENTITY,
        OTHER;

    }
}

