/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum BuiltIn {
    TRUE(null, "true", ts -> PrimitiveType.BOOL),
    FALSE(null, "false", ts -> PrimitiveType.BOOL),
    NOT(null, "not", ts -> ts.fnType(PrimitiveType.BOOL, PrimitiveType.BOOL)),
    ABS(null, "abs", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    OP_CARET(null, "op ^", ts -> ts.fnType(ts.tupleType(PrimitiveType.STRING, PrimitiveType.STRING), PrimitiveType.STRING)),
    OP_EXCEPT(null, "op except", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(ts.listType(h.get(0)), ts.listType(h.get(0))), ts.listType(h.get(0))))),
    OP_INTERSECT(null, "op intersect", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(ts.listType(h.get(0)), ts.listType(h.get(0))), ts.listType(h.get(0))))),
    OP_UNION(null, "op union", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(ts.listType(h.get(0)), ts.listType(h.get(0))), ts.listType(h.get(0))))),
    OP_CONS(null, "op ::", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), ts.listType(h.get(0))), ts.listType(h.get(0))))),
    OP_DIV(null, "op div", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    OP_DIVIDE(null, "op /", PrimitiveType.INT, ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), h.get(0)))),
    OP_EQ(null, "op =", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_GE(null, "op >=", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_GT(null, "op >", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_LE(null, "op <=", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_LT(null, "op <", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_NE(null, "op <>", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), PrimitiveType.BOOL))),
    OP_ELEM(null, "op elem", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), ts.listType(h.get(0))), PrimitiveType.BOOL))),
    OP_NOT_ELEM(null, "op notelem", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), ts.listType(h.get(0))), PrimitiveType.BOOL))),
    OP_MINUS(null, "op -", PrimitiveType.INT, ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), h.get(0)))),
    OP_MOD(null, "op mod", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    OP_PLUS(null, "op +", PrimitiveType.INT, ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), h.get(0)))),
    OP_NEGATE(null, "op ~", ts -> ts.forallType(1, h -> ts.fnType(h.get(0), h.get(0)))),
    OP_TIMES(null, "op *", PrimitiveType.INT, ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.get(0), h.get(0)), h.get(0)))),
    IGNORE("General", "ignore", "ignore", ts -> ts.forallType(1, h -> ts.fnType(h.get(0), PrimitiveType.UNIT))),
    GENERAL_OP_O("General", "op o", "op o", ts -> ts.forallType(3, h -> ts.fnType(ts.tupleType(ts.fnType(h.get(1), h.get(2)), ts.fnType(h.get(0), h.get(1))), ts.fnType(h.get(0), h.get(2))))),
    INT_ABS("Int", "abs", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_COMPARE("Int", "compare", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), ts.order())),
    INT_DIV("Int", "div", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_TO_INT("Int", "toInt", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_FROM_INT("Int", "fromInt", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_TO_LARGE("Int", "toLarge", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_FROM_LARGE("Int", "fromLarge", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_FROM_STRING("Int", "fromString", ts -> ts.fnType(PrimitiveType.STRING, ts.option(PrimitiveType.INT))),
    INT_MIN_INT("Int", "minInt", ts -> ts.option(PrimitiveType.INT)),
    INT_MAX_INT("Int", "maxInt", ts -> ts.option(PrimitiveType.INT)),
    INT_PRECISION("Int", "precision", ts -> ts.option(PrimitiveType.INT)),
    INT_MAX("Int", "max", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_MIN("Int", "min", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_QUOT("Int", "quot", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_MOD("Int", "mod", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_REM("Int", "rem", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    INT_SAME_SIGN("Int", "sameSign", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.BOOL)),
    INT_SIGN("Int", "sign", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    INT_TO_STRING("Int", "toString", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.STRING)),
    INTERACT_USE("Interact", "use", "use", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.UNIT)),
    INTERACT_USE_SILENTLY("Interact", "useSilently", "useSilently", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.UNIT)),
    STRING_MAX_SIZE("String", "maxSize", ts -> PrimitiveType.INT),
    STRING_SIZE("String", "size", "size", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.INT)),
    STRING_SUB("String", "sub", ts -> ts.fnType(ts.tupleType(PrimitiveType.STRING, PrimitiveType.INT), PrimitiveType.CHAR)),
    STRING_EXTRACT("String", "extract", ts -> ts.fnType(ts.tupleType(PrimitiveType.STRING, PrimitiveType.INT, ts.option(PrimitiveType.INT)), PrimitiveType.STRING)),
    STRING_SUBSTRING("String", "substring", "substring", ts -> ts.fnType(ts.tupleType(PrimitiveType.STRING, PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.STRING)),
    STRING_CONCAT("String", "concat", "concat", ts -> ts.fnType(ts.listType(PrimitiveType.STRING), PrimitiveType.STRING)),
    STRING_CONCAT_WITH("String", "concatWith", ts -> ts.fnType(PrimitiveType.STRING, ts.listType(PrimitiveType.STRING), PrimitiveType.STRING, new Type[0])),
    STRING_STR("String", "str", "str", ts -> ts.fnType(PrimitiveType.CHAR, PrimitiveType.STRING)),
    STRING_IMPLODE("String", "implode", "implode", ts -> ts.fnType(ts.listType(PrimitiveType.CHAR), PrimitiveType.STRING)),
    STRING_EXPLODE("String", "explode", "explode", ts -> ts.fnType(PrimitiveType.STRING, ts.listType(PrimitiveType.CHAR))),
    STRING_MAP("String", "map", ts -> ts.fnType(ts.fnType(PrimitiveType.CHAR, PrimitiveType.CHAR), PrimitiveType.STRING, PrimitiveType.STRING, new Type[0])),
    STRING_TRANSLATE("String", "translate", ts -> ts.fnType(ts.fnType(PrimitiveType.CHAR, PrimitiveType.STRING), PrimitiveType.STRING, PrimitiveType.STRING, new Type[0])),
    STRING_IS_PREFIX("String", "isPrefix", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.STRING, PrimitiveType.BOOL, new Type[0])),
    STRING_IS_SUBSTRING("String", "isSubstring", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.STRING, PrimitiveType.BOOL, new Type[0])),
    STRING_IS_SUFFIX("String", "isSuffix", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.STRING, PrimitiveType.BOOL, new Type[0])),
    LIST_NIL("List", "nil", ts -> ts.forallType(1, h -> h.list(0))),
    LIST_NULL("List", "null", "null", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), PrimitiveType.BOOL))),
    LIST_LENGTH("List", "length", "length", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), PrimitiveType.INT))),
    LIST_AT("List", "at", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), h.list(0)), h.list(0)))),
    LIST_OP_AT("List", "op @", "op @", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), h.list(0)), h.list(0)))),
    LIST_HD("List", "hd", "hd", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.get(0)))),
    LIST_TL("List", "tl", "tl", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.list(0)))),
    LIST_LAST("List", "last", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.get(0)))),
    LIST_GET_ITEM("List", "getItem", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), ts.option(ts.tupleType(h.get(0), h.list(0)))))),
    LIST_NTH("List", "nth", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), PrimitiveType.INT), h.get(0)))),
    LIST_TAKE("List", "take", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), PrimitiveType.INT), h.list(0)))),
    LIST_DROP("List", "drop", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), PrimitiveType.INT), h.list(0)))),
    LIST_REV("List", "rev", "rev", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.list(0)))),
    LIST_CONCAT("List", "concat", ts -> ts.forallType(1, h -> ts.fnType(ts.listType(h.list(0)), h.list(0)))),
    LIST_REV_APPEND("List", "revAppend", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.list(0), h.list(0)), h.list(0)))),
    LIST_APP("List", "app", "app", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.UNIT), h.list(0), PrimitiveType.UNIT, new Type[0]))),
    LIST_MAP("List", "map", "map", ts -> ts.forallType(2, t -> ts.fnType(ts.fnType(t.get(0), t.get(1)), ts.listType(t.get(0)), ts.listType(t.get(1)), new Type[0]))),
    LIST_MAP_PARTIAL("List", "mapPartial", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(h.get(0), h.option(1)), h.list(0), h.list(1), new Type[0]))),
    LIST_FIND("List", "find", ts -> ts.forallType(1, h -> ts.fnType(h.predicate(0), h.list(0), h.option(0), new Type[0]))),
    LIST_FILTER("List", "filter", ts -> ts.forallType(1, h -> ts.fnType(h.predicate(0), h.list(0), h.list(0), new Type[0]))),
    LIST_PARTITION("List", "partition", ts -> ts.forallType(1, h -> ts.fnType(h.predicate(0), h.list(0), ts.tupleType(h.list(0), h.list(0)), new Type[0]))),
    LIST_FOLDL("List", "foldl", "foldl", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(1)), h.get(1)), h.get(1), h.list(0), h.get(1)))),
    LIST_FOLDR("List", "foldr", "foldr", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(1)), h.get(1)), h.get(1), h.list(0), h.get(1)))),
    LIST_EXISTS("List", "exists", ts -> ts.forallType(1, h -> ts.fnType(h.predicate(0), h.list(0), PrimitiveType.BOOL, new Type[0]))),
    LIST_ALL("List", "all", ts -> ts.forallType(1, h -> ts.fnType(h.predicate(0), h.list(0), PrimitiveType.BOOL, new Type[0]))),
    LIST_TABULATE("List", "tabulate", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(PrimitiveType.INT, ts.fnType(PrimitiveType.INT, h.get(0))), h.list(0)))),
    LIST_COLLATE("List", "collate", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(0)), ts.order()), ts.tupleType(h.list(0), h.list(0)), ts.order(), new Type[0]))),
    MATH_ACOS("Math", "acos", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_ASIN("Math", "asin", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_ATAN("Math", "atan", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_ATAN2("Math", "atan2", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    MATH_COS("Math", "cos", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_COSH("Math", "cosh", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_E("Math", "e", ts -> PrimitiveType.REAL),
    MATH_EXP("Math", "exp", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_LN("Math", "ln", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_LOG10("Math", "log10", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_PI("Math", "pi", ts -> PrimitiveType.REAL),
    MATH_POW("Math", "pow", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    MATH_SIN("Math", "sin", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_SINH("Math", "sinh", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_SQRT("Math", "sqrt", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_TAN("Math", "tan", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    MATH_TANH("Math", "tanh", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    OPTION_GET_OPT("Option", "getOpt", "getOpt", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.option(0), h.get(0)), h.get(0)))),
    OPTION_IS_SOME("Option", "isSome", "isSome", ts -> ts.forallType(1, h -> ts.fnType(h.option(0), PrimitiveType.BOOL))),
    OPTION_VAL_OF("Option", "valOf", "valOf", ts -> ts.forallType(1, h -> ts.fnType(h.option(0), h.get(0)))),
    OPTION_FILTER("Option", "filter", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.BOOL), h.get(0), h.option(0), new Type[0]))),
    OPTION_JOIN("Option", "join", ts -> ts.forallType(1, h -> ts.fnType(ts.option(h.option(0)), h.option(0)))),
    OPTION_APP("Option", "app", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.option(0), PrimitiveType.UNIT), h.option(0), PrimitiveType.UNIT, new Type[0]))),
    OPTION_MAP("Option", "map", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(h.get(0), h.get(1)), h.option(0), h.option(1), new Type[0]))),
    OPTION_MAP_PARTIAL("Option", "mapPartial", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(h.get(0), h.option(1)), h.option(0), h.option(1), new Type[0]))),
    OPTION_COMPOSE("Option", "compose", ts -> ts.forallType(3, h -> ts.fnType(ts.tupleType(ts.fnType(h.get(0), h.get(1)), ts.fnType(h.get(2), h.option(0))), h.get(2), h.option(1), new Type[0]))),
    OPTION_COMPOSE_PARTIAL("Option", "composePartial", ts -> ts.forallType(3, h -> ts.fnType(ts.tupleType(ts.fnType(h.get(0), h.option(1)), ts.fnType(h.get(2), h.option(0))), h.get(2), h.option(1), new Type[0]))),
    REAL_ABS("Real", "abs", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_CEIL("Real", "ceil", "ceil", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.INT)),
    REAL_CHECK_FLOAT("Real", "checkFloat", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_COMPARE("Real", "compare", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), ts.order())),
    REAL_COPY_SIGN("Real", "copySign", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    REAL_FLOOR("Real", "floor", "floor", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.INT)),
    REAL_FROM_INT("Real", "fromInt", "real", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.REAL)),
    REAL_FROM_MAN_EXP("Real", "fromManExp", ts -> ts.fnType(ts.recordType(RecordType.map("exp", PrimitiveType.INT, "man", PrimitiveType.REAL)), PrimitiveType.REAL)),
    REAL_FROM_STRING("Real", "fromString", ts -> ts.fnType(PrimitiveType.STRING, ts.option(PrimitiveType.REAL))),
    REAL_IS_FINITE("Real", "isFinite", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.BOOL)),
    REAL_IS_NAN("Real", "isNan", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.BOOL)),
    REAL_IS_NORMAL("Real", "isNormal", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.BOOL)),
    REAL_NEG_INF("Real", "negInf", ts -> PrimitiveType.REAL),
    REAL_POS_INF("Real", "posInf", ts -> PrimitiveType.REAL),
    REAL_RADIX("Real", "radix", ts -> PrimitiveType.INT),
    REAL_PRECISION("Real", "precision", ts -> PrimitiveType.INT),
    REAL_MAX("Real", "max", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    REAL_MAX_FINITE("Real", "maxFinite", ts -> PrimitiveType.REAL),
    REAL_MIN("Real", "min", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    REAL_MIN_POS("Real", "minPos", ts -> PrimitiveType.REAL),
    REAL_MIN_NORMAL_POS("Real", "minNormalPos", ts -> PrimitiveType.REAL),
    REAL_REAL_MOD("Real", "realMod", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_REAL_CEIL("Real", "realCeil", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_REAL_FLOOR("Real", "realFloor", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_REAL_ROUND("Real", "realRound", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_REAL_TRUNC("Real", "realTrunc", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    REAL_REM("Real", "rem", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    REAL_ROUND("Real", "round", "round", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.INT)),
    REAL_SAME_SIGN("Real", "sameSign", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.BOOL)),
    REAL_SIGN("Real", "sign", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.INT)),
    REAL_SIGN_BIT("Real", "signBit", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.BOOL)),
    REAL_SPLIT("Real", "split", ts -> ts.fnType(PrimitiveType.REAL, ts.recordType(RecordType.map("frac", PrimitiveType.REAL, "whole", PrimitiveType.REAL)))),
    REAL_TO_MAN_EXP("Real", "toManExp", ts -> ts.fnType(PrimitiveType.REAL, ts.recordType(RecordType.map("exp", PrimitiveType.INT, "man", PrimitiveType.REAL)))),
    REAL_TO_STRING("Real", "toString", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.STRING)),
    REAL_TRUNC("Real", "trunc", "trunc", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.INT)),
    REAL_UNORDERED("Real", "unordered", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.BOOL)),
    RELATIONAL_COUNT("Relational", "count", "count", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), PrimitiveType.INT))),
    RELATIONAL_NON_EMPTY("Relational", "nonEmpty", "nonEmpty", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), PrimitiveType.BOOL))),
    RELATIONAL_EMPTY("Relational", "empty", "empty", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), PrimitiveType.BOOL))),
    RELATIONAL_ONLY("Relational", "only", "only", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.get(0)))),
    RELATIONAL_ITERATE("Relational", "iterate", "iterate", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), ts.fnType(ts.tupleType(h.list(0), h.list(0)), h.list(0)), h.list(0), new Type[0]))),
    RELATIONAL_SUM("Relational", "sum", "sum", ts -> ts.forallType(1, h -> ts.fnType(ts.listType(h.get(0)), h.get(0)))),
    RELATIONAL_MAX("Relational", "max", "max", ts -> ts.forallType(1, h -> ts.fnType(ts.listType(h.get(0)), h.get(0)))),
    RELATIONAL_MIN("Relational", "min", "min", ts -> ts.forallType(1, h -> ts.fnType(ts.listType(h.get(0)), h.get(0)))),
    SYS_CLEAR_ENV("Sys", "clearEnv", ts -> ts.fnType(PrimitiveType.UNIT, PrimitiveType.UNIT)),
    SYS_ENV("Sys", "env", "env", ts -> ts.fnType(PrimitiveType.UNIT, ts.listType(ts.tupleType(PrimitiveType.STRING, PrimitiveType.STRING)))),
    SYS_FILE("Sys", "file", "file", ts -> ts.progressiveRecordType((SortedMap<String, Type>)ImmutableSortedMap.orderedBy(RecordType.ORDERING).build()), null, session -> session.file.get()),
    SYS_PLAN("Sys", "plan", "plan", ts -> ts.fnType(PrimitiveType.UNIT, PrimitiveType.STRING)),
    SYS_SET("Sys", "set", "set", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(PrimitiveType.STRING, h.get(0)), PrimitiveType.UNIT))),
    SYS_SHOW("Sys", "show", "show", ts -> ts.fnType(PrimitiveType.STRING, ts.option(PrimitiveType.STRING))),
    SYS_SHOW_ALL("Sys", "showAll", "showAll", ts -> ts.fnType(PrimitiveType.UNIT, ts.listType(ts.tupleType(PrimitiveType.STRING, ts.option(PrimitiveType.STRING))))),
    SYS_UNSET("Sys", "unset", "unset", ts -> ts.fnType(PrimitiveType.STRING, PrimitiveType.UNIT)),
    VECTOR_MAX_LEN("Vector", "maxLen", ts -> PrimitiveType.INT),
    VECTOR_FROM_LIST("Vector", "fromList", "vector", ts -> ts.forallType(1, h -> ts.fnType(h.list(0), h.vector(0)))),
    VECTOR_TABULATE("Vector", "tabulate", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(PrimitiveType.INT, ts.fnType(PrimitiveType.INT, h.get(0))), h.vector(0)))),
    VECTOR_LENGTH("Vector", "length", ts -> ts.forallType(1, h -> ts.fnType(h.vector(0), PrimitiveType.INT))),
    VECTOR_SUB("Vector", "sub", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.vector(0), PrimitiveType.INT), h.get(0)))),
    VECTOR_UPDATE("Vector", "update", ts -> ts.forallType(1, h -> ts.fnType(ts.tupleType(h.vector(0), PrimitiveType.INT, h.get(0)), h.vector(0)))),
    VECTOR_CONCAT("Vector", "concat", ts -> ts.forallType(1, h -> ts.fnType(ts.listType(h.vector(0)), h.vector(0)))),
    VECTOR_APPI("Vector", "appi", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(ts.tupleType(PrimitiveType.INT, h.get(0)), PrimitiveType.UNIT), h.vector(0), PrimitiveType.UNIT, new Type[0]))),
    VECTOR_APP("Vector", "app", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.UNIT), h.vector(0), PrimitiveType.UNIT, new Type[0]))),
    VECTOR_MAPI("Vector", "mapi", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(PrimitiveType.INT, h.get(0)), h.get(1)), h.vector(0), h.vector(1), new Type[0]))),
    VECTOR_MAP("Vector", "map", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(h.get(0), h.get(1)), h.vector(0), h.vector(1), new Type[0]))),
    VECTOR_FOLDLI("Vector", "foldli", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(PrimitiveType.INT, h.get(0), h.get(1)), h.get(1)), h.get(1), h.vector(0), h.get(1)))),
    VECTOR_FOLDRI("Vector", "foldri", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(PrimitiveType.INT, h.get(0), h.get(1)), h.get(1)), h.get(1), h.vector(0), h.get(1)))),
    VECTOR_FOLDL("Vector", "foldl", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(1)), h.get(1)), h.get(1), h.vector(0), h.get(1)))),
    VECTOR_FOLDR("Vector", "foldr", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(1)), h.get(1)), h.get(1), h.vector(0), h.get(1)))),
    VECTOR_FINDI("Vector", "findi", ts -> ts.forallType(2, h -> ts.fnType(ts.fnType(ts.tupleType(PrimitiveType.INT, h.get(0)), PrimitiveType.BOOL), h.vector(0), ts.option(ts.tupleType(PrimitiveType.INT, h.get(0))), new Type[0]))),
    VECTOR_FIND("Vector", "find", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.BOOL), h.vector(0), h.option(0), new Type[0]))),
    VECTOR_EXISTS("Vector", "exists", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.BOOL), h.vector(0), PrimitiveType.BOOL, new Type[0]))),
    VECTOR_ALL("Vector", "all", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(h.get(0), PrimitiveType.BOOL), h.vector(0), PrimitiveType.BOOL, new Type[0]))),
    VECTOR_COLLATE("Vector", "collate", ts -> ts.forallType(1, h -> ts.fnType(ts.fnType(ts.tupleType(h.get(0), h.get(0)), ts.order()), ts.tupleType(h.vector(0), h.vector(0)), ts.order(), new Type[0]))),
    Z_ANDALSO("$", "andalso", ts -> ts.fnType(ts.tupleType(PrimitiveType.BOOL, PrimitiveType.BOOL), PrimitiveType.BOOL)),
    Z_ORELSE("$", "orelse", ts -> ts.fnType(ts.tupleType(PrimitiveType.BOOL, PrimitiveType.BOOL), PrimitiveType.BOOL)),
    Z_NEGATE_INT("$", "~:int", ts -> ts.fnType(PrimitiveType.INT, PrimitiveType.INT)),
    Z_NEGATE_REAL("$", "~:real", ts -> ts.fnType(PrimitiveType.REAL, PrimitiveType.REAL)),
    Z_DIVIDE_INT("$", "/:int", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    Z_DIVIDE_REAL("$", "/:real", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    Z_MINUS_INT("$", "-:int", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    Z_MINUS_REAL("$", "-:real", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    Z_PLUS_INT("$", "+:int", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    Z_PLUS_REAL("$", "+:real", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    Z_TIMES_INT("$", "*:int", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    Z_TIMES_REAL("$", "*:real", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    Z_SUM_INT("$", "sum:int", ts -> ts.fnType(ts.tupleType(PrimitiveType.INT, PrimitiveType.INT), PrimitiveType.INT)),
    Z_SUM_REAL("$", "sum:real", ts -> ts.fnType(ts.tupleType(PrimitiveType.REAL, PrimitiveType.REAL), PrimitiveType.REAL)),
    Z_EXTENT("$", "extent", ts -> ts.forallType(1, h -> ts.fnType(PrimitiveType.UNIT, h.get(0)))),
    Z_LIST("$", "list", ts -> PrimitiveType.UNIT);

    public final String structure;
    public final String mlName;
    public final String alias;
    public final Function<TypeSystem, Type> typeFunction;
    private final PrimitiveType preferredType;
    public final Function<Session, Object> sessionValue;
    public static final ImmutableMap<String, BuiltIn> BY_ML_NAME;
    public static final SortedMap<String, Structure> BY_STRUCTURE;

    private BuiltIn(String structure, String mlName, Function<TypeSystem, Type> typeFunction) {
        this(structure, mlName, null, typeFunction, null, null);
    }

    private BuiltIn(@NonNull String structure, String mlName, PrimitiveType preferredType, Function<TypeSystem, Type> typeFunction) {
        this(structure, mlName, null, typeFunction, preferredType, null);
    }

    private BuiltIn(@Nullable String structure, String mlName, String alias, Function<TypeSystem, Type> typeFunction) {
        this(structure, mlName, alias, typeFunction, null, null);
    }

    private BuiltIn(@Nullable String structure, String mlName, @Nullable String alias, @Nullable Function<TypeSystem, Type> typeFunction, PrimitiveType preferredType, Function<Session, Object> sessionValue) {
        this.structure = structure;
        this.mlName = Objects.requireNonNull(mlName, "mlName");
        this.alias = alias;
        this.typeFunction = Objects.requireNonNull(typeFunction, "typeFunction");
        this.preferredType = preferredType;
        this.sessionValue = sessionValue;
    }

    public static void forEach(TypeSystem typeSystem, BiConsumer<BuiltIn, Type> consumer) {
        if (Static.SKIP) {
            return;
        }
        for (BuiltIn builtIn : BuiltIn.values()) {
            Type type = builtIn.typeFunction.apply(typeSystem);
            consumer.accept(builtIn, type);
        }
    }

    public static void forEachStructure(TypeSystem typeSystem, BiConsumer<Structure, Type> consumer) {
        if (Static.SKIP) {
            return;
        }
        PairList nameTypes = PairList.of();
        BY_STRUCTURE.values().forEach(structure -> {
            nameTypes.clear();
            structure.memberMap.forEach((name, builtIn) -> nameTypes.add(name, builtIn.typeFunction.apply(typeSystem)));
            consumer.accept((Structure)structure, typeSystem.recordType(nameTypes));
        });
    }

    public static void dataTypes(TypeSystem typeSystem, List<Binding> bindings) {
        for (Datatype datatype : Datatype.values()) {
            BuiltIn.defineType(typeSystem, bindings, datatype);
        }
        for (Enum enum_ : Eqtype.values()) {
            BuiltIn.defineType(typeSystem, bindings, (BuiltInType)((Object)enum_));
        }
    }

    private static void defineType(TypeSystem ts, List<Binding> bindings, BuiltInType builtInType) {
        final ArrayList<TypeVar> tyVars = new ArrayList<TypeVar>();
        for (int i = 0; i < builtInType.varCount(); ++i) {
            tyVars.add(ts.typeVariable(i));
        }
        final TreeMap<String, Type.Key> tyCons = new TreeMap<String, Type.Key>();
        builtInType.transform().apply(new DataTypeHelper(){

            @Override
            public DataTypeHelper tyCon(String name, Type.Key typeKey) {
                tyCons.put(name, typeKey);
                return this;
            }

            @Override
            public DataTypeHelper tyCon(String name) {
                return this.tyCon(name, Keys.dummy());
            }

            @Override
            public Type.Key get(int i) {
                return ((TypeVar)tyVars.get(i)).key();
            }
        });
        Type type = ts.dataTypeScheme(builtInType.mlName(), tyVars, tyCons);
        DataType dataType = (DataType)(type instanceof DataType ? type : ((ForallType)type).type);
        ts.setBuiltIn(builtInType);
        if (!builtInType.isInternal()) {
            tyCons.keySet().forEach(tyConName -> bindings.add(ts.bindTyCon(dataType, (String)tyConName)));
        }
    }

    public BuiltIn reverse() {
        switch (this.ordinal()) {
            case 11: 
            case 16: {
                return this;
            }
            case 12: {
                return OP_LE;
            }
            case 13: {
                return OP_LT;
            }
            case 14: {
                return OP_GE;
            }
            case 15: {
                return OP_GT;
            }
        }
        throw new AssertionError((Object)("unexpected: " + (Object)((Object)this)));
    }

    public void prefer(Consumer<PrimitiveType> consumer) {
        if (this.preferredType != null) {
            consumer.accept(this.preferredType);
        }
    }

    static {
        ImmutableMap.Builder byMlName = ImmutableMap.builder();
        TreeMap<String, ImmutableSortedMap.Builder> map = new TreeMap<String, ImmutableSortedMap.Builder>();
        for (BuiltIn builtIn : BuiltIn.values()) {
            if (builtIn.alias != null) {
                byMlName.put((Object)builtIn.alias, (Object)builtIn);
            }
            if (builtIn.structure == null) {
                byMlName.put((Object)builtIn.mlName, (Object)builtIn);
                continue;
            }
            if (builtIn.structure.equals("$")) continue;
            map.compute(builtIn.structure, (name, mapBuilder) -> {
                if (mapBuilder == null) {
                    mapBuilder = ImmutableSortedMap.naturalOrder();
                }
                return mapBuilder.put((Object)builtIn.mlName, (Object)builtIn);
            });
        }
        BY_ML_NAME = byMlName.build();
        ImmutableSortedMap.Builder b = ImmutableSortedMap.naturalOrder();
        map.forEach((structure, mapBuilder) -> b.put(structure, (Object)new Structure((String)structure, (SortedMap<String, BuiltIn>)mapBuilder.build())));
        BY_STRUCTURE = b.build();
    }

    public static enum Datatype implements BuiltInType
    {
        ORDER("order", false, 0, h -> h.tyCon("LESS").tyCon("EQUAL").tyCon("GREATER")),
        OPTION("option", false, 1, h -> h.tyCon("NONE").tyCon("SOME", h.get(0))),
        LIST("$list", true, 1, h -> h.tyCon("NIL").tyCon("CONS", h.get(0))),
        BOOL("$bool", true, 0, h -> h.tyCon("FALSE").tyCon("TRUE"));

        private final String mlName;
        private final boolean internal;
        private final int varCount;
        private final UnaryOperator<DataTypeHelper> transform;

        private Datatype(String mlName, boolean internal, int varCount, UnaryOperator<DataTypeHelper> transform) {
            this.mlName = Objects.requireNonNull(mlName, "mlName");
            this.internal = internal;
            this.varCount = varCount;
            this.transform = Objects.requireNonNull(transform, "transform");
        }

        @Override
        public String mlName() {
            return this.mlName;
        }

        @Override
        public int varCount() {
            return this.varCount;
        }

        @Override
        public UnaryOperator<DataTypeHelper> transform() {
            return this.transform;
        }

        @Override
        public boolean isInternal() {
            return this.internal;
        }
    }

    public static interface BuiltInType {
        public String mlName();

        public int varCount();

        default public UnaryOperator<DataTypeHelper> transform() {
            return UnaryOperator.identity();
        }

        default public boolean isInternal() {
            return false;
        }
    }

    public static enum Eqtype implements BuiltInType
    {
        VECTOR("vector", 1);

        private final String mlName;
        private final int varCount;

        private Eqtype(String mlName, int varCount) {
            this.mlName = Objects.requireNonNull(mlName, "mlName");
            this.varCount = varCount;
        }

        @Override
        public String mlName() {
            return this.mlName;
        }

        @Override
        public int varCount() {
            return this.varCount;
        }
    }

    public static class Structure {
        public final String name;
        public final SortedMap<String, BuiltIn> memberMap;

        Structure(String name, SortedMap<String, BuiltIn> memberMap) {
            this.name = Objects.requireNonNull(name, "name");
            this.memberMap = ImmutableSortedMap.copyOf(memberMap);
        }
    }

    private static interface DataTypeHelper {
        public DataTypeHelper tyCon(String var1);

        public DataTypeHelper tyCon(String var1, Type.Key var2);

        public Type.Key get(int var1);
    }
}

