/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.CompiledStatement;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Macro;
import net.hydromatic.morel.compile.Pretty;
import net.hydromatic.morel.eval.Applicable;
import net.hydromatic.morel.eval.Applicable2;
import net.hydromatic.morel.eval.Applicable3;
import net.hydromatic.morel.eval.Closure;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Describable;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.foreign.CalciteFunctions;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.TailList;
import net.hydromatic.morel.util.ThreadLocals;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Compiler {
    protected static final EvalEnv EMPTY_ENV = Codes.emptyEnv();
    protected final TypeSystem typeSystem;

    public Compiler(TypeSystem typeSystem) {
        this.typeSystem = Objects.requireNonNull(typeSystem, "typeSystem");
    }

    CompiledStatement compileStatement(Environment env, Core.Decl decl, @Nullable Core.NamedPat skipPat, Set<Core.Exp> queriesToWrap) {
        ArrayList<Code> matchCodes = new ArrayList<Code>();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        final ArrayList<Action> actions = new ArrayList<Action>();
        Context cx = Context.of(env);
        this.compileDecl(cx, decl, skipPat, queriesToWrap, matchCodes, bindings, actions);
        final PrimitiveType type = decl instanceof Core.NonRecValDecl ? ((Core.NonRecValDecl)decl).pat.type : PrimitiveType.UNIT;
        final CalciteFunctions.Context context = this.createContext(env);
        return new CompiledStatement(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public void eval(Session session, Environment env, Consumer<String> outLines, Consumer<Binding> outBindings) {
                ThreadLocals.let(CalciteFunctions.THREAD_ENV, context, () -> {
                    EvalEnv evalEnv = Codes.emptyEnvWith(session, env);
                    for (Action action : actions) {
                        action.apply(outLines, outBindings, evalEnv);
                    }
                });
            }
        };
    }

    protected CalciteFunctions.Context createContext(Environment env) {
        Session dummySession = new Session((Map<Prop, Object>)ImmutableMap.of());
        return new CalciteFunctions.Context(dummySession, env, this.typeSystem, null);
    }

    public final Code compile(Environment env, Core.Exp expression) {
        return this.compile(Context.of(env), expression);
    }

    public Code compileArg(Context cx, Core.Exp expression) {
        return this.compile(cx, expression);
    }

    public List<Code> compileArgs(Context cx, List<? extends Core.Exp> expressions) {
        return Static.transformEager(expressions, e -> this.compile(cx, (Core.Exp)e));
    }

    public Code compile(Context cx, Core.Exp expression) {
        switch (expression.op) {
            case BOOL_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                Boolean boolValue = literal.unwrap(Boolean.class);
                return Codes.constant(boolValue);
            }
            case CHAR_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                Character charValue = literal.unwrap(Character.class);
                return Codes.constant(charValue);
            }
            case INT_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                return Codes.constant(literal.unwrap(Integer.class));
            }
            case REAL_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                return Codes.constant(literal.unwrap(Float.class));
            }
            case STRING_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                String stringValue = literal.unwrap(String.class);
                return Codes.constant(stringValue);
            }
            case UNIT_LITERAL: {
                return Codes.constant(Unit.INSTANCE);
            }
            case FN_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                BuiltIn builtIn = literal.unwrap(BuiltIn.class);
                return Codes.constant(Codes.BUILT_IN_VALUES.get((Object)builtIn));
            }
            case INTERNAL_LITERAL: 
            case VALUE_LITERAL: {
                Core.Literal literal = (Core.Literal)expression;
                return Codes.constant(literal.unwrap(Object.class));
            }
            case LET: {
                return this.compileLet(cx, (Core.Let)expression);
            }
            case LOCAL: {
                return this.compileLocal(cx, (Core.Local)expression);
            }
            case FN: {
                Core.Fn fn = (Core.Fn)expression;
                return this.compileMatchList(cx, (List<Core.Match>)ImmutableList.of((Object)CoreBuilder.core.match(fn.pos, fn.idPat, fn.exp)));
            }
            case CASE: {
                Core.Case case_ = (Core.Case)expression;
                Code matchCode = this.compileMatchList(cx, case_.matchList);
                Code argCode = this.compile(cx, case_.exp);
                return Codes.apply(matchCode, argCode);
            }
            case RECORD_SELECTOR: {
                Core.RecordSelector recordSelector = (Core.RecordSelector)expression;
                return Codes.nth(recordSelector.slot).asCode();
            }
            case APPLY: {
                return this.compileApply(cx, (Core.Apply)expression);
            }
            case FROM: {
                return this.compileFrom(cx, (Core.From)expression);
            }
            case ID: {
                Core.Id id = (Core.Id)expression;
                return this.compileFieldName(cx, id.idPat);
            }
            case TUPLE: {
                Core.Tuple tuple = (Core.Tuple)expression;
                ArrayList<Code> codes = new ArrayList<Code>();
                for (Core.Exp arg : tuple.args) {
                    codes.add(this.compile(cx, arg));
                }
                return Codes.tuple(codes);
            }
        }
        throw new AssertionError((Object)("op not handled: " + (Object)((Object)expression.op)));
    }

    private Code compileFieldName(Context cx, Core.NamedPat idPat) {
        Binding binding = cx.env.getOpt(idPat.name);
        if (binding != null && binding.value instanceof Code) {
            return (Code)binding.value;
        }
        return Codes.get(idPat.name);
    }

    protected Code compileApply(Context cx, Core.Apply apply) {
        switch (apply.fn.op) {
            case FN_LITERAL: {
                BuiltIn builtIn = ((Core.Literal)apply.fn).unwrap(BuiltIn.class);
                return this.compileCall(cx, builtIn, apply.arg, apply.pos);
            }
        }
        Code argCode = this.compileArg(cx, apply.arg);
        Type argType = apply.arg.type;
        Applicable fnValue = this.compileApplicable(cx, apply.fn, argType, apply.pos);
        if (fnValue != null) {
            return this.finishCompileApply(cx, fnValue, argCode, argType);
        }
        Code fnCode = this.compile(cx, apply.fn);
        return this.finishCompileApply(cx, fnCode, argCode, argType);
    }

    protected Code finishCompileApply(Context cx, Applicable fnValue, Code argCode, Type argType) {
        return Codes.apply(fnValue, argCode);
    }

    protected Code finishCompileApply(Context cx, Code fnCode, Code argCode, Type argType) {
        return Codes.apply(fnCode, argCode);
    }

    protected Code compileFrom(Context cx, Core.From from) {
        Supplier<Codes.RowSink> rowSinkFactory = this.createRowSinkFactory(cx, (ImmutableList<Binding>)ImmutableList.of(), (List<Core.FromStep>)from.steps, from.type().elementType);
        return Codes.from(rowSinkFactory);
    }

    protected Supplier<Codes.RowSink> createRowSinkFactory(Context cx0, ImmutableList<Binding> bindings, List<Core.FromStep> steps, Type elementType) {
        Context cx = cx0.bindAll((Iterable<Binding>)bindings);
        if (steps.isEmpty()) {
            List fieldNames = (List)bindings.stream().map(b -> b.id.name).sorted().collect(ImmutableList.toImmutableList());
            Code code = fieldNames.size() == 1 && ((Binding)Iterables.getOnlyElement(bindings)).id.type.equals(elementType) ? Codes.get((String)fieldNames.get(0)) : Codes.getTuple(fieldNames);
            return () -> Codes.collectRowSink(code);
        }
        Core.FromStep firstStep = steps.get(0);
        Supplier<Codes.RowSink> nextFactory = this.createRowSinkFactory(cx, firstStep.bindings, Static.skip(steps), elementType);
        switch (firstStep.op) {
            case SCAN: {
                Core.Scan scan = (Core.Scan)firstStep;
                Code code = this.compile(cx, scan.exp);
                Code conditionCode = this.compile(cx, scan.condition);
                return () -> Codes.scanRowSink(firstStep.op, scan.pat, code, conditionCode, (Codes.RowSink)nextFactory.get());
            }
            case WHERE: {
                Core.Where where = (Core.Where)firstStep;
                Code filterCode = this.compile(cx, where.exp);
                return () -> Codes.whereRowSink(filterCode, (Codes.RowSink)nextFactory.get());
            }
            case SKIP: {
                Core.Skip skip = (Core.Skip)firstStep;
                Code skipCode = this.compile(cx, skip.exp);
                return () -> Codes.skipRowSink(skipCode, (Codes.RowSink)nextFactory.get());
            }
            case TAKE: {
                Core.Take take = (Core.Take)firstStep;
                Code takeCode = this.compile(cx, take.exp);
                return () -> Codes.takeRowSink(takeCode, (Codes.RowSink)nextFactory.get());
            }
            case YIELD: {
                Core.Yield yield = (Core.Yield)firstStep;
                if (steps.size() == 1) {
                    Code yieldCode = this.compile(cx, yield.exp);
                    return () -> Codes.collectRowSink(yieldCode);
                }
                if (yield.exp instanceof Core.Tuple) {
                    Core.Tuple tuple = (Core.Tuple)yield.exp;
                    RecordLikeType recordType = tuple.type();
                    ImmutableSortedMap.Builder mapCodes = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
                    Pair.forEach(tuple.args, recordType.argNameTypes().keySet(), (exp, name) -> mapCodes.put(name, (Object)this.compile(cx, (Core.Exp)exp)));
                    return () -> Codes.yieldRowSink((Map<String, Code>)mapCodes.build(), (Codes.RowSink)nextFactory.get());
                }
                ImmutableSortedMap.Builder mapCodes = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
                Binding binding = (Binding)yield.bindings.get(0);
                mapCodes.put((Object)binding.id.name, (Object)this.compile(cx, yield.exp));
                return () -> Codes.yieldRowSink((Map<String, Code>)mapCodes.build(), (Codes.RowSink)nextFactory.get());
            }
            case ORDER: {
                Core.Order order = (Core.Order)firstStep;
                PairList codes = PairList.of();
                order.orderItems.forEach(e -> codes.add(this.compile(cx, e.exp), e.direction == Ast.Direction.DESC));
                return () -> Codes.orderRowSink(codes, bindings, (Codes.RowSink)nextFactory.get());
            }
            case GROUP: {
                Core.Group group = (Core.Group)firstStep;
                ImmutableList.Builder groupCodesB = ImmutableList.builder();
                for (Core.Exp exp2 : group.groupExps.values()) {
                    groupCodesB.add((Object)this.compile(cx, exp2));
                }
                ImmutableList.Builder valueCodesB = ImmutableList.builder();
                ImmutableSortedMap<String, Binding> bindingMap = this.sortedBindingMap((Iterable<Binding>)bindings);
                for (Binding binding : bindingMap.values()) {
                    valueCodesB.add((Object)this.compile(cx, (Core.Exp)CoreBuilder.core.id(binding.id)));
                }
                ImmutableList names = ImmutableList.copyOf(bindingMap.keySet());
                ImmutableList.Builder aggregateCodesB = ImmutableList.builder();
                for (Core.Aggregate aggregate : group.aggregates.values()) {
                    Code argumentCode;
                    Type argumentType;
                    if (aggregate.argument == null) {
                        PairList<String, Type> argNameTypes = PairList.of();
                        bindings.forEach(b -> argNameTypes.add(b.id.name, b.id.type));
                        argumentType = this.typeSystem.recordOrScalarType(argNameTypes);
                        argumentCode = null;
                    } else {
                        argumentType = aggregate.argument.type;
                        argumentCode = this.compile(cx, aggregate.argument);
                    }
                    Applicable aggregateApplicable = this.compileApplicable(cx, aggregate.aggregate, this.typeSystem.listType(argumentType), aggregate.pos);
                    Code aggregateCode = aggregateApplicable == null ? this.compile(cx, aggregate.aggregate) : aggregateApplicable.asCode();
                    aggregateCodesB.add((Object)Codes.aggregate(cx.env, aggregateCode, (List<String>)names, argumentCode));
                }
                ImmutableList groupCodes = groupCodesB.build();
                Code keyCode = Codes.tuple((Iterable<? extends Code>)groupCodes);
                ImmutableList aggregateCodes = aggregateCodesB.build();
                ImmutableList<String> outNames = this.bindingNames((List<Binding>)firstStep.bindings);
                ImmutableList keyNames = outNames.subList(0, group.groupExps.size());
                return () -> Codes.groupRowSink(keyCode, (ImmutableList<Applicable>)aggregateCodes, (ImmutableList<String>)names, (ImmutableList<String>)keyNames, outNames, (Codes.RowSink)nextFactory.get());
            }
        }
        throw new AssertionError((Object)("unknown step type " + (Object)((Object)firstStep.op)));
    }

    private ImmutableSortedMap<String, Binding> sortedBindingMap(Iterable<Binding> bindings) {
        ImmutableSortedMap.Builder b = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        bindings.forEach(binding -> b.put((Object)binding.id.name, binding));
        return b.build();
    }

    private ImmutableList<String> bindingNames(List<Binding> bindings) {
        return Static.transformEager(bindings, b -> b.id.name);
    }

    private Applicable compileApplicable(Context cx, Core.Exp fn, Type argType, Pos pos) {
        switch (fn.op) {
            case FN_LITERAL: {
                BuiltIn builtIn = ((Core.Literal)fn).unwrap(BuiltIn.class);
                Object o = Codes.BUILT_IN_VALUES.get((Object)builtIn);
                return this.toApplicable(cx, o, argType, pos);
            }
            case VALUE_LITERAL: {
                Core.Literal literal = (Core.Literal)fn;
                return this.toApplicable(cx, literal.unwrap(Object.class), argType, pos);
            }
            case ID: {
                Binding binding = cx.env.getOpt(((Core.Id)fn).idPat);
                if (binding == null || binding.value instanceof LinkCode || binding.value == Unit.INSTANCE) {
                    return null;
                }
                return this.toApplicable(cx, binding.value, argType, pos);
            }
            case RECORD_SELECTOR: {
                Core.RecordSelector recordSelector = (Core.RecordSelector)fn;
                return Codes.nth(recordSelector.slot);
            }
        }
        return null;
    }

    private @Nullable Applicable toApplicable(Context cx, Object o, Type argType, Pos pos) {
        if (o instanceof Applicable) {
            Applicable applicable = (Applicable)o;
            if (applicable instanceof Codes.Positioned) {
                return ((Codes.Positioned)applicable).withPos(pos);
            }
            return applicable;
        }
        if (o instanceof Macro) {
            Macro value = (Macro)o;
            Core.Exp exp = value.expand(this.typeSystem, cx.env, argType);
            switch (exp.op) {
                case FN_LITERAL: {
                    Core.Literal literal = (Core.Literal)exp;
                    BuiltIn builtIn = literal.unwrap(BuiltIn.class);
                    return (Applicable)Codes.BUILT_IN_VALUES.get((Object)builtIn);
                }
            }
            final Code code = this.compile(cx, exp);
            return new Applicable(){

                @Override
                public Describer describe(Describer describer) {
                    return code.describe(describer);
                }

                @Override
                public Object apply(EvalEnv evalEnv, Object arg) {
                    return code.eval(evalEnv);
                }
            };
        }
        return null;
    }

    private Code compileLet(Context cx, Core.Let let) {
        ArrayList<Code> matchCodes = new ArrayList<Code>();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        this.compileValDecl(cx, let.decl, null, (Set<Core.Exp>)ImmutableSet.of(), matchCodes, bindings, null);
        Context cx2 = cx.bindAll(bindings);
        Code resultCode = this.compile(cx2, let.exp);
        return this.finishCompileLet(cx2, matchCodes, resultCode, let.type);
    }

    protected Code finishCompileLet(Context cx, List<Code> matchCodes, Code resultCode, Type resultType) {
        return Codes.let(matchCodes, resultCode);
    }

    private Code compileLocal(Context cx, Core.Local local) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        this.compileDatatypeDecl((List<DataType>)ImmutableList.of((Object)local.dataType), bindings, null);
        Context cx2 = cx.bindAll(bindings);
        return this.compile(cx2, local.exp);
    }

    void compileDecl(Context cx, Core.Decl decl, @Nullable Core.NamedPat skipPat, Set<Core.Exp> queriesToWrap, List<Code> matchCodes, List<Binding> bindings, List<Action> actions) {
        switch (decl.op) {
            case VAL_DECL: 
            case REC_VAL_DECL: {
                Core.ValDecl valDecl = (Core.ValDecl)decl;
                this.compileValDecl(cx, valDecl, skipPat, queriesToWrap, matchCodes, bindings, actions);
                break;
            }
            case DATATYPE_DECL: {
                Core.DatatypeDecl datatypeDecl = (Core.DatatypeDecl)decl;
                this.compileDatatypeDecl(datatypeDecl.dataTypes, bindings, actions);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown " + (Object)((Object)decl.op) + " [" + decl + "]"));
            }
        }
    }

    private void compileDatatypeDecl(List<DataType> dataTypes, List<Binding> bindings, List<Action> actions) {
        for (DataType dataType : dataTypes) {
            TailList<Binding> newBindings = new TailList<Binding>(bindings);
            dataType.typeConstructors.keySet().forEach(name -> bindings.add(this.typeSystem.bindTyCon(dataType, (String)name)));
            if (actions == null) continue;
            ImmutableList immutableBindings = ImmutableList.copyOf(newBindings);
            actions.add((arg_0, arg_1, arg_2) -> Compiler.lambda$compileDatatypeDecl$18(dataType, (List)immutableBindings, arg_0, arg_1, arg_2));
        }
    }

    private Code compileCall(Context cx, BuiltIn builtIn, Core.Exp arg, Pos pos) {
        switch (builtIn) {
            case Z_ANDALSO: {
                List<Code> argCodes = this.compileArgs(cx, ((Core.Tuple)arg).args);
                return Codes.andAlso(argCodes.get(0), argCodes.get(1));
            }
            case Z_ORELSE: {
                List<Code> argCodes = this.compileArgs(cx, ((Core.Tuple)arg).args);
                return Codes.orElse(argCodes.get(0), argCodes.get(1));
            }
            case Z_LIST: {
                List<Code> argCodes = this.compileArgs(cx, ((Core.Tuple)arg).args);
                return Codes.list(argCodes);
            }
        }
        Object o0 = Codes.BUILT_IN_VALUES.get((Object)builtIn);
        Object o = o0 instanceof Codes.Positioned ? ((Codes.Positioned)o0).withPos(pos) : o0;
        if (o instanceof Applicable) {
            Code argCode = this.compile(cx, arg);
            if (argCode instanceof Codes.TupleCode) {
                Codes.TupleCode tupleCode = (Codes.TupleCode)argCode;
                if (tupleCode.codes.size() == 2 && o instanceof Applicable2) {
                    return Codes.apply2((Applicable2)o, tupleCode.codes.get(0), tupleCode.codes.get(1));
                }
                if (tupleCode.codes.size() == 3 && o instanceof Applicable3) {
                    return Codes.apply3((Applicable3)o, tupleCode.codes.get(0), tupleCode.codes.get(1), tupleCode.codes.get(2));
                }
            }
            return Codes.apply((Applicable)o, argCode);
        }
        throw new AssertionError((Object)("unknown " + (Object)((Object)builtIn)));
    }

    private Code compileMatchList(Context cx, List<Core.Match> matchList) {
        PairList patCodes = PairList.of();
        matchList.forEach(match -> this.compileMatch(cx, (Core.Match)match, patCodes::add));
        return new MatchCode(patCodes.immutable(), ((Core.Match)Iterables.getLast(matchList)).pos);
    }

    private void compileMatch(Context cx, Core.Match match, BiConsumer<Core.Pat, Code> consumer) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.bindPattern(this.typeSystem, bindings, match.pat);
        Code code = this.compile(cx.bindAll(bindings), match.exp);
        consumer.accept(match.pat, code);
    }

    private void compileValDecl(Context cx, Core.ValDecl valDecl, @Nullable Core.Pat skipPat, Set<Core.Exp> queriesToWrap, List<Code> matchCodes, List<Binding> bindings, List<Action> actions) {
        Compiles.bindPattern(this.typeSystem, bindings, valDecl);
        TailList<Binding> newBindings = new TailList<Binding>(bindings);
        HashMap linkCodes = new HashMap();
        if (valDecl.op == Op.REC_VAL_DECL) {
            valDecl.forEachBinding((pat, exp, pos) -> {
                LinkCode linkCode = new LinkCode();
                linkCodes.put(pat, linkCode);
                bindings.add(Binding.of(pat, linkCode));
            });
        }
        Context cx1 = cx.bindAll(newBindings);
        valDecl.forEachBinding((pat, exp, pos) -> {
            Code code;
            Code code0 = this.compileArg(cx1, exp);
            Code code2 = code = queriesToWrap.contains(exp) ? Codes.wrapRelList(code0) : code0;
            if (!linkCodes.isEmpty()) {
                this.link(linkCodes, pat, code);
            }
            matchCodes.add(new MatchCode(ImmutablePairList.of(pat, code), pos));
            if (actions != null) {
                Type type0 = exp.type;
                Type type = this.typeSystem.ensureClosed(type0);
                actions.add((outLines, outBindings, evalEnv) -> {
                    Session session = (Session)evalEnv.getOpt("$session");
                    StringBuilder buf = new StringBuilder();
                    ArrayList<String> outs = new ArrayList<String>();
                    try {
                        Object o = code.eval(evalEnv);
                        LinkedHashMap<Core.NamedPat, Object> pairs = new LinkedHashMap<Core.NamedPat, Object>();
                        if (!Closure.bindRecurse(pat.withType(type), o, pairs::put)) {
                            throw new Codes.MorelRuntimeException(Codes.BuiltInExn.BIND, pos);
                        }
                        pairs.forEach((pat2, o2) -> {
                            outBindings.accept(Binding.of(pat2, o2));
                            if (pat2 != skipPat) {
                                Pretty.TypedVal typedVal;
                                int stringDepth = Prop.STRING_DEPTH.intValue(session.map);
                                int lineWidth = Prop.LINE_WIDTH.intValue(session.map);
                                int printDepth = Prop.PRINT_DEPTH.intValue(session.map);
                                int printLength = Prop.PRINT_LENGTH.intValue(session.map);
                                Prop.Output output = Prop.OUTPUT.enumValue(session.map, Prop.Output.class);
                                Pretty pretty = new Pretty(this.typeSystem, lineWidth, output, printLength, printDepth, stringDepth);
                                if (o2 instanceof TypedValue) {
                                    TypedValue typedValue = (TypedValue)o2;
                                    typedVal = new Pretty.TypedVal(pat2.name, typedValue.valueAs(Object.class), Keys.toProgressive(pat2.type().key()).toType(this.typeSystem));
                                } else {
                                    typedVal = new Pretty.TypedVal(pat2.name, o2, pat2.type);
                                }
                                pretty.pretty(buf, pat2.type, typedVal);
                                String line = Static.str(buf);
                                outs.add(line);
                                outLines.accept(line);
                            }
                        });
                    }
                    catch (Codes.MorelRuntimeException e) {
                        session.handle(e, buf);
                        String line = Static.str(buf);
                        outs.add(line);
                        outLines.accept(line);
                    }
                    session.code = code;
                    session.out = ImmutableList.copyOf(outs);
                });
            }
        });
        newBindings.clear();
    }

    private void link(Map<Core.NamedPat, LinkCode> linkCodes, Core.Pat pat, Code code) {
        if (pat instanceof Core.IdPat) {
            LinkCode linkCode = linkCodes.get(pat);
            if (linkCode != null) {
                linkCode.refCode = code;
            }
        } else if (pat instanceof Core.TuplePat && code instanceof Codes.TupleCode) {
            List<Code> codes = ((Codes.TupleCode)code).codes;
            List<Core.Pat> pats = ((Core.TuplePat)pat).args;
            Pair.forEach(codes, pats, (code1, pat1) -> this.link(linkCodes, (Core.Pat)pat1, (Code)code1));
        }
    }

    private static /* synthetic */ void lambda$compileDatatypeDecl$18(DataType dataType, List immutableBindings, Consumer outLines, Consumer outBindings, EvalEnv evalEnv) {
        String line = dataType.describe(new StringBuilder()).toString();
        outLines.accept(line);
        immutableBindings.forEach(outBindings);
    }

    public static class Context {
        final Environment env;

        Context(Environment env) {
            this.env = env;
        }

        static Context of(Environment env) {
            return new Context(env);
        }

        Context bindAll(Iterable<Binding> bindings) {
            return Context.of(this.env.bindAll(bindings));
        }
    }

    private static class LinkCode
    implements Code {
        private Code refCode;

        private LinkCode() {
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("link", d -> {});
        }

        @Override
        public Object eval(EvalEnv env) {
            assert (this.refCode != null);
            return this.refCode.eval(env);
        }
    }

    static interface Action {
        public void apply(Consumer<String> var1, Consumer<Binding> var2, EvalEnv var3);
    }

    private static class MatchCode
    implements Code {
        private final ImmutablePairList<Core.Pat, Code> patCodes;
        private final Pos pos;

        MatchCode(ImmutablePairList<Core.Pat, Code> patCodes, Pos pos) {
            this.patCodes = patCodes;
            this.pos = pos;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("match", d -> this.patCodes.forEach((pat, code) -> d.arg("", pat.describe(describer)).arg("", (Describable)code)));
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            return new Closure(evalEnv, this.patCodes, this.pos);
        }
    }
}

