/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Environments {
    private static final Environment BASIC_ENVIRONMENT = EmptyEnvironment.INSTANCE.bind(CoreBuilder.core.idPat((Type)PrimitiveType.BOOL, "true", 0), true).bind(CoreBuilder.core.idPat((Type)PrimitiveType.BOOL, "false", 0), false);

    private Environments() {
    }

    public static Environment empty() {
        return BASIC_ENVIRONMENT;
    }

    public static Environment env(TypeSystem typeSystem, @Nullable Session session, Map<String, ForeignValue> valueMap) {
        return Environments.env(EmptyEnvironment.INSTANCE, typeSystem, session, valueMap);
    }

    private static Environment env(Environment environment, TypeSystem typeSystem, @Nullable Session session, Map<String, ForeignValue> valueMap) {
        if (Static.SKIP) {
            return environment;
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BuiltIn.dataTypes(typeSystem, bindings);
        ToIntFunction<String> nameGen = typeSystem.nameGenerator::inc;
        Codes.BUILT_IN_VALUES.forEach((key, value) -> {
            if ("$".equals(key.structure)) {
                return;
            }
            Type type = key.typeFunction.apply(typeSystem);
            if (key.sessionValue != null) {
                if (session == null) {
                    return;
                }
                value = key.sessionValue.apply(session);
            }
            if (key.structure == null) {
                bindings.add(Binding.of((Core.NamedPat)CoreBuilder.core.idPat(type, key.mlName, nameGen), value));
            }
            if (key.alias != null) {
                bindings.add(Binding.of((Core.NamedPat)CoreBuilder.core.idPat(type, key.alias, nameGen), value));
            }
        });
        EvalEnv emptyEnv = Codes.emptyEnv();
        BuiltIn.forEachStructure(typeSystem, (structure, type) -> bindings.add(Binding.of((Core.NamedPat)CoreBuilder.core.idPat((Type)type, structure.name, nameGen), emptyEnv.getOpt(structure.name))));
        Environments.foreignBindings(typeSystem, valueMap, bindings);
        return Environments.bind(environment, bindings);
    }

    private static void foreignBindings(TypeSystem typeSystem, Map<String, ForeignValue> map, List<Binding> bindings) {
        map.forEach((name, value) -> bindings.add(Binding.of((Core.NamedPat)CoreBuilder.core.idPat(value.type(typeSystem), (String)name, typeSystem.nameGenerator::inc), value.value()).withParameter(true)));
    }

    static Environment bind(Environment env, Iterable<Binding> bindings) {
        if (Static.shorterThan(bindings, 5)) {
            for (Binding binding2 : bindings) {
                env = env.bind(binding2);
            }
            return env;
        }
        ImmutableMap.Builder b = ImmutableMap.builder();
        bindings.forEach(binding -> b.put((Object)binding.id, binding));
        ImmutableMap map = b.build();
        ImmutableSet names = map.keySet();
        env = env.nearestAncestorNotObscuredBy((Set<Core.NamedPat>)names);
        return new MapEnvironment(env, (ImmutableMap<Core.NamedPat, Binding>)map);
    }

    private static class EmptyEnvironment
    extends Environment {
        static final EmptyEnvironment INSTANCE = new EmptyEnvironment();

        private EmptyEnvironment() {
        }

        @Override
        void visit(Consumer<Binding> consumer) {
        }

        @Override
        public @Nullable Binding getOpt(String name) {
            return null;
        }

        @Override
        public @Nullable Binding getOpt(Core.NamedPat id) {
            return null;
        }

        @Override
        Environment nearestAncestorNotObscuredBy(Set<Core.NamedPat> names) {
            return this;
        }

        @Override
        int distance(int soFar, Core.NamedPat id) {
            return -1;
        }
    }

    static class MapEnvironment
    extends Environment {
        private final Environment parent;
        private final Map<Core.NamedPat, Binding> map;

        MapEnvironment(Environment parent, ImmutableMap<Core.NamedPat, Binding> map) {
            this.parent = Objects.requireNonNull(parent);
            this.map = (Map)Objects.requireNonNull(map);
        }

        @Override
        void visit(Consumer<Binding> consumer) {
            this.map.values().forEach(consumer);
            this.parent.visit(consumer);
        }

        @Override
        public @Nullable Binding getOpt(String name) {
            for (Map.Entry<Core.NamedPat, Binding> entry : this.map.entrySet()) {
                if (!entry.getKey().name.equals(name)) continue;
                return entry.getValue();
            }
            return this.parent.getOpt(name);
        }

        @Override
        public @Nullable Binding getOpt(Core.NamedPat id) {
            Binding binding = this.map.get(id);
            return binding != null && binding.id.i == id.i ? binding : this.parent.getOpt(id);
        }

        @Override
        Environment nearestAncestorNotObscuredBy(Set<Core.NamedPat> names) {
            return names.containsAll(this.map.keySet()) ? this.parent.nearestAncestorNotObscuredBy(names) : this;
        }

        @Override
        int distance(int soFar, Core.NamedPat id) {
            int i = this.find(this.map.keySet(), id);
            if (i >= 0) {
                return soFar + this.map.size() - 1 - i;
            }
            return this.parent.distance(soFar + this.map.size(), id);
        }

        private <E> int find(Iterable<E> iterable, E e) {
            int i = 0;
            for (E e1 : iterable) {
                if (e1.equals(e)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    static class SubEnvironment
    extends Environment {
        private final Environment parent;
        private final Binding binding;

        SubEnvironment(Environment parent, Binding binding) {
            this.parent = Objects.requireNonNull(parent);
            this.binding = Objects.requireNonNull(binding);
        }

        public String toString() {
            return this.binding.id + ", ...";
        }

        @Override
        public @Nullable Binding getOpt(String name) {
            if (name.equals(this.binding.id.name)) {
                return this.binding;
            }
            return this.parent.getOpt(name);
        }

        @Override
        public @Nullable Binding getOpt(Core.NamedPat id) {
            if (id.equals(this.binding.id)) {
                return this.binding;
            }
            return this.parent.getOpt(id);
        }

        @Override
        protected Environment bind(Binding binding) {
            Environment env;
            if (this.binding.id.equals(binding.id)) {
                env = this.parent;
                while (env instanceof SubEnvironment && env.binding.id.name.equals(binding.id.name)) {
                    env = env.parent;
                }
            } else {
                env = this;
            }
            return new SubEnvironment(env, binding);
        }

        @Override
        void visit(Consumer<Binding> consumer) {
            consumer.accept(this.binding);
            this.parent.visit(consumer);
        }

        @Override
        Environment nearestAncestorNotObscuredBy(Set<Core.NamedPat> names) {
            return names.contains(this.binding.id) ? this.parent.nearestAncestorNotObscuredBy(names) : this;
        }

        @Override
        int distance(int soFar, Core.NamedPat id) {
            if (id.equals(this.binding.id)) {
                return soFar;
            }
            return this.parent.distance(soFar + 1, id);
        }
    }
}

