/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.FromBuilder;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.EnvVisitor;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.compile.Extents;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.util.Holder;
import org.checkerframework.checker.nullness.qual.Nullable;

class SuchThatShuttle
extends Shuttle {
    final @Nullable Environment env;

    SuchThatShuttle(TypeSystem typeSystem, @Nullable Environment env) {
        super(typeSystem);
        this.env = env;
    }

    static boolean containsUnbounded(Core.Decl decl) {
        final Holder found = Holder.of((Object)false);
        decl.accept(new Visitor(){

            @Override
            protected void visit(Core.Scan scan) {
                super.visit(scan);
                if (Extents.isInfinite(scan.exp)) {
                    found.set((Object)true);
                }
            }
        });
        return (Boolean)found.get();
    }

    @Override
    protected Core.Exp visit(Core.From from) {
        Core.From from2 = new FromVisitor(this.typeSystem, this.env).visit(from);
        return from2.equals(from) ? from : from2;
    }

    static class FromVisitor {
        final TypeSystem typeSystem;
        final FromBuilder fromBuilder;
        final List<Core.Exp> satisfiedFilters = new ArrayList<Core.Exp>();

        FromVisitor(TypeSystem typeSystem, @Nullable Environment env) {
            this.typeSystem = typeSystem;
            this.fromBuilder = CoreBuilder.core.fromBuilder(typeSystem, env);
        }

        Core.From visit(Core.From from) {
            ImmutableList<Core.FromStep> steps = from.steps;
            DeferredStepList deferredScans = DeferredStepList.create(this.typeSystem, steps);
            Environment env = Environments.empty();
            PairList<Core.IdPat, Core.Exp> idPats = PairList.of();
            for (int i = 0; i < steps.size(); ++i) {
                Core.FromStep step = (Core.FromStep)steps.get(i);
                switch (step.op) {
                    case SCAN: {
                        Core.Scan scan = (Core.Scan)step;
                        if (Extents.isInfinite(scan.exp)) {
                            int idPatCount = idPats.size();
                            Core.From rewritten = this.rewrite1(scan, Static.skip(steps, i), idPats);
                            idPats.forEachIndexed((j, pat, extent) -> {
                                if (j >= idPatCount) {
                                    this.fromBuilder.scan((Core.Pat)pat, (Core.Exp)extent);
                                }
                            });
                            deferredScans.scan(env, scan.pat, rewritten, scan.condition);
                            break;
                        }
                        deferredScans.scan(env, scan.pat, scan.exp);
                        break;
                    }
                    case YIELD: {
                        Core.Yield yield = (Core.Yield)step;
                        this.killTemporaryScans(idPats);
                        deferredScans.flush(this.fromBuilder);
                        this.fromBuilder.yield_(false, (List<Binding>)yield.bindings, yield.exp);
                        break;
                    }
                    case WHERE: {
                        Core.Where where = (Core.Where)step;
                        Core.Exp condition = CoreBuilder.core.subTrue(this.typeSystem, where.exp, this.satisfiedFilters);
                        deferredScans.where(env, condition);
                        break;
                    }
                    case GROUP: {
                        Core.Group group = (Core.Group)step;
                        this.killTemporaryScans(idPats);
                        deferredScans.flush(this.fromBuilder);
                        this.fromBuilder.group(group.groupExps, group.aggregates);
                        break;
                    }
                    case ORDER: {
                        Core.Order order = (Core.Order)step;
                        this.killTemporaryScans(idPats);
                        deferredScans.flush(this.fromBuilder);
                        this.fromBuilder.order((Iterable<Core.OrderItem>)order.orderItems);
                        break;
                    }
                    case SKIP: {
                        Core.Skip skip = (Core.Skip)step;
                        this.killTemporaryScans(idPats);
                        deferredScans.flush(this.fromBuilder);
                        this.fromBuilder.skip(skip.exp);
                        break;
                    }
                    case TAKE: {
                        Core.Take take = (Core.Take)step;
                        this.killTemporaryScans(idPats);
                        deferredScans.flush(this.fromBuilder);
                        this.fromBuilder.take(take.exp);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)step.op);
                    }
                }
                env = Environments.empty().bindAll((Iterable<Binding>)step.bindings);
            }
            deferredScans.flush(this.fromBuilder);
            this.killTemporaryScans(idPats);
            return this.fromBuilder.build();
        }

        private void killTemporaryScans(PairList<Core.IdPat, Core.Exp> idPats) {
            if (idPats.isEmpty()) {
                return;
            }
            PairList<String, Core.Id> nameExps = PairList.of();
            for (Binding b : this.fromBuilder.bindings()) {
                Core.IdPat id = (Core.IdPat)b.id;
                if (idPats.leftList().contains(id)) continue;
                nameExps.add(id.name, CoreBuilder.core.id(id));
            }
            if (nameExps.size() == 1) {
                this.fromBuilder.yield_(false, null, (Core.Exp)((Map.Entry)nameExps.get(0)).getValue());
            } else {
                this.fromBuilder.yield_(false, null, CoreBuilder.core.record(this.typeSystem, nameExps));
            }
            idPats.clear();
        }

        private Core.From rewrite1(Core.Scan scan, List<? extends Core.FromStep> laterSteps, PairList<Core.IdPat, Core.Exp> idPats) {
            Extents.Analysis analysis = Extents.create(this.typeSystem, scan.pat, (SortedMap<Core.NamedPat, Core.Exp>)ImmutableSortedMap.of(), laterSteps, idPats);
            this.satisfiedFilters.addAll(analysis.satisfiedFilters);
            FromBuilder fromBuilder = CoreBuilder.core.fromBuilder(this.typeSystem);
            fromBuilder.scan(scan.pat, analysis.extentExp);
            return fromBuilder.build();
        }
    }

    private static class FreeFinder
    extends EnvVisitor {
        final Consumer<Core.NamedPat> consumer;

        FreeFinder(TypeSystem typeSystem, Environment env, Deque<EnvVisitor.FromContext> fromStack, Consumer<Core.NamedPat> consumer) {
            super(typeSystem, env, fromStack);
            this.consumer = consumer;
        }

        @Override
        protected EnvVisitor push(Environment env) {
            return new FreeFinder(this.typeSystem, env, this.fromStack, this.consumer);
        }

        @Override
        protected void visit(Core.Id id) {
            if (this.env.getOpt(id.idPat) == null) {
                this.consumer.accept(id.idPat);
            }
        }
    }

    static class DeferredStepList {
        final PairList<Set<Core.Pat>, Consumer<FromBuilder>> steps = PairList.of();
        final FreeFinder freeFinder;
        final List<Core.NamedPat> refs;

        DeferredStepList(FreeFinder freeFinder, List<Core.NamedPat> refs) {
            this.freeFinder = freeFinder;
            this.refs = refs;
        }

        static DeferredStepList create(TypeSystem typeSystem, List<Core.FromStep> steps) {
            ImmutableSet forwardRefs = (ImmutableSet)steps.stream().filter(step -> step instanceof Core.Scan).map(step -> ((Core.Scan)step).pat).collect(ImmutableSet.toImmutableSet());
            ArrayList<Core.NamedPat> refs = new ArrayList<Core.NamedPat>();
            Consumer<Core.NamedPat> consumer = p -> {
                if (forwardRefs.contains(p)) {
                    refs.add((Core.NamedPat)p);
                }
            };
            FreeFinder freeFinder = new FreeFinder(typeSystem, Environments.empty(), new ArrayDeque<EnvVisitor.FromContext>(), consumer);
            return new DeferredStepList(freeFinder, refs);
        }

        void scan(Environment env, Core.Pat pat, Core.Exp exp, Core.Exp condition) {
            Set<Core.Pat> unresolvedRefs = this.unresolvedRefs(env, exp);
            this.steps.add(unresolvedRefs, fromBuilder -> {
                fromBuilder.scan(pat, exp, condition);
                this.resolve(pat);
            });
        }

        void scan(Environment env, Core.Pat pat, Core.Exp exp) {
            Set<Core.Pat> unresolvedRefs = this.unresolvedRefs(env, exp);
            this.steps.add(unresolvedRefs, fromBuilder -> {
                fromBuilder.scan(pat, exp);
                this.resolve(pat);
            });
        }

        void where(Environment env, Core.Exp condition) {
            Set<Core.Pat> unresolvedRefs = this.unresolvedRefs(env, condition);
            this.steps.add(unresolvedRefs, fromBuilder -> fromBuilder.where(condition));
        }

        private Set<Core.Pat> unresolvedRefs(Environment env, Core.Exp exp) {
            this.refs.clear();
            exp.accept(this.freeFinder.push(env));
            return new LinkedHashSet<Core.Pat>(this.refs);
        }

        void resolve(Core.Pat pat) {
            this.steps.forEach((unresolvedRefs, consumer) -> unresolvedRefs.remove(pat));
        }

        void flush(FromBuilder fromBuilder) {
            int j;
            while ((j = this.steps.firstMatch((unresolvedRefs, consumer) -> unresolvedRefs.isEmpty())) >= 0) {
                Object step = this.steps.remove(j);
                ((Consumer)step.getValue()).accept(fromBuilder);
            }
        }
    }
}

