/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import java.util.List;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.Tracer;
import net.hydromatic.morel.compile.TypeResolver;
import net.hydromatic.morel.eval.Code;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Tracers {
    public static Tracer empty() {
        return EmptyTracer.INSTANCE;
    }

    public static Tracer withOnCore(Tracer tracer, int pass, final Consumer<Core.Decl> consumer) {
        final int expectedPass = pass;
        return new DelegatingTracer(tracer){

            @Override
            public void onCore(int pass, Core.Decl e) {
                if (pass == expectedPass) {
                    consumer.accept(e);
                }
                super.onCore(pass, e);
            }
        };
    }

    public static Tracer withOnPlan(Tracer tracer, final Consumer<Code> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public void onPlan(Code code) {
                consumer.accept(code);
                super.onPlan(code);
            }
        };
    }

    public static Tracer withOnResult(Tracer tracer, final Consumer<Object> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public void onResult(Object o) {
                consumer.accept(o);
                super.onResult(o);
            }
        };
    }

    public static Tracer withOnWarnings(Tracer tracer, final Consumer<List<Throwable>> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public void onWarnings(List<Throwable> warningList) {
                consumer.accept(warningList);
                super.onWarnings(warningList);
            }
        };
    }

    public static Tracer withOnException(Tracer tracer, final Consumer<@Nullable Throwable> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public boolean onException(@Nullable Throwable e) {
                consumer.accept(e);
                super.onException(e);
                return true;
            }
        };
    }

    public static Tracer withOnCompileException(Tracer tracer, final Consumer<CompileException> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public boolean handleCompileException(@Nullable CompileException e) {
                consumer.accept(e);
                super.handleCompileException(e);
                return true;
            }
        };
    }

    public static Tracer withOnTypeException(Tracer tracer, final Consumer<TypeResolver.TypeException> consumer) {
        return new DelegatingTracer(tracer){

            @Override
            public boolean onTypeException(TypeResolver.TypeException e) {
                consumer.accept(e);
                super.onTypeException(e);
                return true;
            }
        };
    }

    private static class EmptyTracer
    implements Tracer {
        static final Tracer INSTANCE = new EmptyTracer();

        private EmptyTracer() {
        }

        @Override
        public void onCore(int pass, Core.Decl e) {
        }

        @Override
        public void onPlan(Code code) {
        }

        @Override
        public void onResult(Object o) {
        }

        @Override
        public void onWarnings(List<Throwable> warningList) {
        }

        @Override
        public boolean onTypeException(TypeResolver.TypeException e) {
            return false;
        }

        @Override
        public boolean onException(@Nullable Throwable e) {
            return false;
        }

        @Override
        public boolean handleCompileException(@Nullable CompileException e) {
            return false;
        }
    }

    private static class DelegatingTracer
    implements Tracer {
        final Tracer tracer;

        DelegatingTracer(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public void onCore(int pass, Core.Decl e) {
            this.tracer.onCore(pass, e);
        }

        @Override
        public void onPlan(Code code) {
            this.tracer.onPlan(code);
        }

        @Override
        public void onResult(Object o) {
            this.tracer.onResult(o);
        }

        @Override
        public void onWarnings(List<Throwable> warningList) {
            this.tracer.onWarnings(warningList);
        }

        @Override
        public boolean onException(@Nullable Throwable e) {
            return this.tracer.onException(e);
        }

        @Override
        public boolean onTypeException(TypeResolver.TypeException e) {
            return this.tracer.onTypeException(e);
        }

        @Override
        public boolean handleCompileException(@Nullable CompileException e) {
            return this.tracer.handleCompileException(e);
        }
    }
}

