/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.eval.Applicable;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;

public class Closure
implements Comparable<Closure>,
Applicable {
    private final EvalEnv evalEnv;
    private final ImmutablePairList<Core.Pat, Code> patCodes;
    private final Pos pos;

    public Closure(EvalEnv evalEnv, ImmutablePairList<Core.Pat, Code> patCodes, Pos pos) {
        this.evalEnv = Objects.requireNonNull(evalEnv).fix();
        this.patCodes = Objects.requireNonNull(patCodes);
        this.pos = pos;
    }

    public String toString() {
        return "Closure(evalEnv = " + this.evalEnv + ", patCodes = " + this.patCodes + ")";
    }

    @Override
    public int compareTo(Closure o) {
        return 0;
    }

    EvalEnv bind(Object argValue) {
        EvalEnvHolder envRef = new EvalEnvHolder(this.evalEnv);
        for (Core.Pat pat : this.patCodes.leftList()) {
            if (!Closure.bindRecurse(pat, argValue, envRef)) continue;
            return envRef.env;
        }
        throw new AssertionError((Object)"no match");
    }

    EvalEnv evalBind(EvalEnv env) {
        EvalEnvHolder envRef = new EvalEnvHolder(env);
        for (Map.Entry entry : this.patCodes) {
            Object argValue = ((Code)entry.getValue()).eval(env);
            Core.Pat pat = (Core.Pat)entry.getKey();
            if (!Closure.bindRecurse(pat, argValue, envRef)) continue;
            return envRef.env;
        }
        throw new AssertionError((Object)"no match");
    }

    Object bindEval(Object argValue) {
        EvalEnvHolder envRef = new EvalEnvHolder(this.evalEnv);
        for (Map.Entry entry : this.patCodes) {
            Core.Pat pat = (Core.Pat)entry.getKey();
            if (!Closure.bindRecurse(pat, argValue, envRef)) continue;
            Code code = (Code)entry.getValue();
            return code.eval(envRef.env);
        }
        throw new Codes.MorelRuntimeException(Codes.BuiltInExn.BIND, this.pos);
    }

    @Override
    public Object apply(EvalEnv env, Object argValue) {
        return this.bindEval(argValue);
    }

    @Override
    public Describer describe(Describer describer) {
        return describer.start("closure", d -> {});
    }

    public static boolean bindRecurse(Core.Pat pat, Object argValue, BiConsumer<Core.NamedPat, Object> envRef) {
        switch (pat.op) {
            case ID_PAT: {
                Core.IdPat idPat = (Core.IdPat)pat;
                envRef.accept(idPat, argValue);
                return true;
            }
            case WILDCARD_PAT: {
                return true;
            }
            case AS_PAT: {
                Core.AsPat asPat = (Core.AsPat)pat;
                envRef.accept(asPat, argValue);
                return Closure.bindRecurse(asPat.pat, argValue, envRef);
            }
            case BOOL_LITERAL_PAT: 
            case CHAR_LITERAL_PAT: 
            case STRING_LITERAL_PAT: {
                Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                return literalPat.value.equals(argValue);
            }
            case INT_LITERAL_PAT: {
                Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                return ((BigDecimal)literalPat.value).intValue() == ((Integer)argValue).intValue();
            }
            case REAL_LITERAL_PAT: {
                Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                return ((BigDecimal)literalPat.value).doubleValue() == ((Double)argValue).doubleValue();
            }
            case TUPLE_PAT: {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                List listValue = (List)argValue;
                return Pair.allMatch(tuplePat.args, listValue, (pat1, value) -> Closure.bindRecurse(pat1, value, envRef));
            }
            case RECORD_PAT: {
                Core.RecordPat recordPat = (Core.RecordPat)pat;
                List listValue = (List)argValue;
                return Pair.allMatch(recordPat.args, listValue, (pat1, value) -> Closure.bindRecurse(pat1, value, envRef));
            }
            case LIST_PAT: {
                Core.ListPat listPat = (Core.ListPat)pat;
                List listValue = (List)argValue;
                if (listValue.size() != listPat.args.size()) {
                    return false;
                }
                return Pair.allMatch(listPat.args, listValue, (pat1, value) -> Closure.bindRecurse(pat1, value, envRef));
            }
            case CONS_PAT: {
                Core.ConPat consPat = (Core.ConPat)pat;
                List consValue = (List)argValue;
                if (consValue.isEmpty()) {
                    return false;
                }
                Object head = consValue.get(0);
                List tail = Static.skip(consValue);
                List<Core.Pat> patArgs = ((Core.TuplePat)consPat.pat).args;
                return Closure.bindRecurse(patArgs.get(0), head, envRef) && Closure.bindRecurse(patArgs.get(1), tail, envRef);
            }
            case CON0_PAT: {
                Core.Con0Pat con0Pat = (Core.Con0Pat)pat;
                List con0Value = (List)argValue;
                return con0Value.get(0).equals(con0Pat.tyCon);
            }
            case CON_PAT: {
                Core.ConPat conPat = (Core.ConPat)pat;
                List conValue = (List)argValue;
                return conValue.get(0).equals(conPat.tyCon) && Closure.bindRecurse(conPat.pat, conValue.get(1), envRef);
            }
        }
        throw new AssertionError((Object)("cannot compile " + (Object)((Object)pat.op) + ": " + pat));
    }

    private static class EvalEnvHolder
    implements BiConsumer<Core.NamedPat, Object> {
        EvalEnv env;

        EvalEnvHolder(EvalEnv env) {
            this.env = env;
        }

        @Override
        public void accept(Core.NamedPat namedPat, Object o) {
            this.env = this.env.bind(namedPat.name, o);
        }
    }
}

