/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.eval.EvalEnvs;
import net.hydromatic.morel.eval.MutableEvalEnv;

public interface EvalEnv {
    public static final String SESSION = "$session";

    public Object getOpt(String var1);

    default public EvalEnv bind(String name, Object value) {
        return new EvalEnvs.SubEvalEnv(this, name, value);
    }

    default public MutableEvalEnv bindMutable(String name) {
        return new EvalEnvs.MutableSubEvalEnv(this, name);
    }

    default public MutableEvalEnv bindMutablePat(Core.Pat pat) {
        if (pat instanceof Core.IdPat) {
            return this.bindMutable(((Core.IdPat)pat).name);
        }
        final ArrayList<String> names = new ArrayList<String>();
        pat.accept(new Visitor(){

            @Override
            protected void visit(Core.IdPat idPat) {
                names.add(idPat.name);
            }

            @Override
            protected void visit(Core.AsPat asPat) {
                names.add(asPat.name);
                super.visit(asPat);
            }
        });
        return new EvalEnvs.MutablePatSubEvalEnv(this, pat, names);
    }

    default public MutableEvalEnv bindMutableArray(List<String> names) {
        if (names.size() == 1) {
            return this.bindMutable(names.get(0));
        }
        return new EvalEnvs.MutableArraySubEvalEnv(this, names);
    }

    public void visit(BiConsumer<String, Object> var1);

    default public Map<String, Object> valueMap() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        this.visit(valueMap::putIfAbsent);
        return valueMap;
    }

    default public EvalEnv fix() {
        return this;
    }
}

