/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import net.hydromatic.morel.eval.File;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.PairList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Files {
    private Files() {
    }

    public static File create(java.io.File ioFile) {
        return Files.createUnknown(null, ioFile).expand();
    }

    static UnknownFile createUnknown(@Nullable Directory directory, java.io.File ioFile) {
        FileType fileType;
        if (ioFile.isDirectory()) {
            fileType = FileType.DIRECTORY;
        } else {
            fileType = FileType.FILE;
            for (FileType fileType2 : FileType.INSTANCES) {
                if (!ioFile.getName().endsWith(fileType2.suffix)) continue;
                fileType = fileType2;
                break;
            }
        }
        if (directory != null) {
            return new UnknownChildFile(directory, ioFile, fileType);
        }
        return new UnknownFile(ioFile, fileType);
    }

    private static String removeSuffix(String s, String suffix) {
        if (!s.endsWith(suffix)) {
            return s;
        }
        return s.substring(0, s.length() - suffix.length());
    }

    private static PairList<String, Type.Key> deduceFieldsCsv(BufferedReader r) throws IOException {
        String firstLine = r.readLine();
        if (firstLine == null) {
            return ImmutablePairList.of();
        }
        PairList<String, Type.Key> nameTypes = PairList.of();
        for (String field : firstLine.split(",")) {
            Type.Key subType;
            String subFieldType;
            String[] split = field.split(":");
            String subFieldName = split[0];
            switch (subFieldType = split.length > 1 ? split[1] : "string") {
                case "bool": {
                    subType = PrimitiveType.BOOL.key();
                    break;
                }
                case "decimal": 
                case "double": {
                    subType = PrimitiveType.REAL.key();
                    break;
                }
                case "int": {
                    subType = PrimitiveType.INT.key();
                    break;
                }
                default: {
                    subType = PrimitiveType.STRING.key();
                }
            }
            nameTypes.add(subFieldName, subType);
        }
        return nameTypes;
    }

    static Function<String, Object> parser(Type.Key type) {
        switch (type.op) {
            case DATA_TYPE: {
                switch (type.toString()) {
                    case "int": {
                        return s -> s.equals("NULL") ? 0 : Integer.parseInt(s);
                    }
                    case "real": {
                        return s -> Float.valueOf(s.equals("NULL") ? 0.0f : Float.parseFloat(s));
                    }
                    case "string": {
                        return Files::unquoteString;
                    }
                }
                throw new IllegalArgumentException("unknown type " + type);
            }
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    static Object unquoteString(String s) {
        if (s.startsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static class Directory
    extends AbstractList<File>
    implements File {
        final java.io.File ioFile;
        final SortedMap<String, File> entries;

        Directory(java.io.File file) {
            this.ioFile = file;
            this.entries = new TreeMap<String, File>((Comparator<String>)RecordType.ORDERING);
            for (java.io.File subFile : (java.io.File[])Util.first((Object)this.ioFile.listFiles(), (Object)new java.io.File[0])) {
                UnknownFile f = Files.createUnknown(this, subFile);
                this.entries.put(f.baseName, f);
            }
        }

        @Override
        public Type.Key typeKey() {
            return Keys.progressiveRecord(Maps.transformValues(this.entries, TypedValue::typeKey));
        }

        @Override
        public File discoverField(TypeSystem typeSystem, String fieldName) {
            File file2;
            File file = (File)this.entries.get(fieldName);
            if (file != null && (file2 = file.expand()) != file) {
                typeSystem.expandCount.incrementAndGet();
            }
            return this;
        }

        @Override
        public File get(int index) {
            return (File)Iterables.get(this.entries.values(), (int)index);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public <V> V valueAs(Class<V> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            throw new IllegalArgumentException("not a " + clazz);
        }

        @Override
        public <V> V fieldValueAs(String fieldName, Class<V> clazz) {
            return clazz.cast(this.entries.get(fieldName));
        }

        @Override
        public <V> V fieldValueAs(int fieldIndex, Class<V> clazz) {
            return clazz.cast(Iterables.get(this.entries.values(), (int)fieldIndex));
        }
    }

    private static class UnknownFile
    extends AbstractFile {
        static final Type.Key PROGRESSIVE_UNIT = Keys.progressiveRecord((SortedMap<String, ? extends Type.Key>)ImmutableSortedMap.of());
        static final Type.Key PROGRESSIVE_UNIT_LIST = Keys.list(PROGRESSIVE_UNIT);

        protected UnknownFile(java.io.File file, FileType fileType) {
            super(file, fileType);
        }

        @Override
        public <V> V valueAs(Class<V> clazz) {
            if (clazz.isAssignableFrom(ImmutableList.class)) {
                return clazz.cast(ImmutableList.of());
            }
            throw new IllegalArgumentException("not a " + clazz);
        }

        @Override
        public Type.Key typeKey() {
            return this.fileType.list ? PROGRESSIVE_UNIT_LIST : PROGRESSIVE_UNIT;
        }

        @Override
        public File expand() {
            DataFile dataFile;
            block12: {
                switch (this.fileType.ordinal()) {
                    case 0: {
                        return new Directory(this.ioFile);
                    }
                    case 1: {
                        return this;
                    }
                }
                BufferedReader r = this.fileType.open(this.ioFile);
                try {
                    PairList<String, Type.Key> nameTypes = this.fileType.deduceFields(r);
                    ImmutableSortedMap sortedNameTypes = ImmutableSortedMap.orderedBy(RecordType.ORDERING).putAll(nameTypes).build();
                    PairList<Integer, Function<String, Object>> fieldParsers = PairList.of();
                    nameTypes.forEach((name, typeKey) -> {
                        int j = sortedNameTypes.keySet().asList().indexOf(name);
                        fieldParsers.add(Integer.valueOf(j), Files.parser(typeKey));
                    });
                    Type.Key listType = Keys.list(Keys.record((SortedMap<String, ? extends Type.Key>)sortedNameTypes));
                    dataFile = new DataFile(this.ioFile, this.fileType, listType, fieldParsers);
                    if (r == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return this;
                    }
                }
                r.close();
            }
            return dataFile;
        }

        @Override
        public File discoverField(TypeSystem typeSystem, String fieldName) {
            File file = this.expand();
            if (file == this) {
                return this;
            }
            typeSystem.expandCount.incrementAndGet();
            return file.discoverField(typeSystem, fieldName);
        }
    }

    static enum FileType {
        DIRECTORY("", false),
        FILE("", false),
        CSV(".csv", true),
        CSV_GZ(".csv.gz", true);

        static final List<FileType> INSTANCES;
        final String suffix;
        final boolean list;

        private FileType(String suffix, boolean list) {
            this.suffix = suffix;
            this.list = list;
        }

        BufferedReader open(java.io.File file) throws IOException {
            switch (this.ordinal()) {
                case 2: {
                    return Util.reader((java.io.File)file);
                }
                case 3: {
                    return Util.reader((InputStream)new GZIPInputStream(java.nio.file.Files.newInputStream(file.toPath(), new OpenOption[0])));
                }
            }
            throw new IllegalArgumentException("cannot open file " + file + " of type " + (Object)((Object)this));
        }

        PairList<String, Type.Key> deduceFields(BufferedReader r) throws IOException {
            return Files.deduceFieldsCsv(r);
        }

        static {
            INSTANCES = (List)Arrays.stream(FileType.values()).filter(f -> !f.suffix.isEmpty()).collect(ImmutableList.toImmutableList());
        }
    }

    private static class UnknownChildFile
    extends UnknownFile {
        private final Directory directory;

        protected UnknownChildFile(Directory directory, java.io.File file, FileType fileType) {
            super(file, fileType);
            this.directory = Objects.requireNonNull(directory, "directory");
        }

        @Override
        public File expand() {
            File file = super.expand();
            if (file != this) {
                this.directory.entries.put(this.baseName, file);
            }
            return file;
        }
    }

    private static class DataFile
    extends AbstractFile {
        final Type.Key typeKey;
        final PairList<Integer, Function<String, Object>> parsers;

        DataFile(java.io.File file, FileType fileType, Type.Key typeKey, PairList<Integer, Function<String, Object>> parsers) {
            super(file, fileType);
            this.typeKey = Objects.requireNonNull(typeKey, "typeKey");
            this.parsers = parsers.immutable();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V valueAs(Class<V> clazz) {
            try (BufferedReader r = this.fileType.open(this.ioFile);){
                String firstLine = r.readLine();
                if (firstLine == null) {
                    V v = null;
                    return v;
                }
                Object[] values = new Object[this.parsers.size()];
                ArrayList<ImmutableList> list = new ArrayList<ImmutableList>();
                while (true) {
                    String line;
                    if ((line = r.readLine()) == null) {
                        V v = clazz.cast(list);
                        return v;
                    }
                    String[] fields = line.split(",");
                    this.parsers.forEachIndexed((i, j, parser) -> {
                        values[j.intValue()] = parser.apply(fields[i]);
                    });
                    list.add(ImmutableList.copyOf((Object[])values));
                }
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public Type.Key typeKey() {
            return this.typeKey;
        }
    }

    static abstract class AbstractFile
    implements File {
        final java.io.File ioFile;
        final String baseName;
        final FileType fileType;

        AbstractFile(java.io.File ioFile, FileType fileType) {
            this.ioFile = Objects.requireNonNull(ioFile, "file");
            this.baseName = Files.removeSuffix(ioFile.getName(), fileType.suffix);
            this.fileType = Objects.requireNonNull(fileType, "fileType");
        }

        public String toString() {
            return this.baseName;
        }
    }
}

