/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Prop {
    DIRECTORY("directory", File.class, true, new File("")),
    SCRIPT_DIRECTORY("scriptDirectory", File.class, true, new File("")),
    HYBRID("hybrid", Boolean.class, true, false),
    INLINE_PASS_COUNT("inlinePassCount", Integer.class, true, 5),
    MATCH_COVERAGE_ENABLED("matchCoverageEnabled", Boolean.class, true, true),
    OPTIONAL_INT("optionalInt", Integer.class, false, null),
    OUTPUT("output", Output.class, true, (Object)((Object)Output.CLASSIC)),
    PRINT_DEPTH("printDepth", Integer.class, true, 5),
    PRINT_LENGTH("printLength", Integer.class, true, 12),
    RELATIONALIZE("relationalize", Boolean.class, true, false),
    STRING_DEPTH("stringDepth", Integer.class, true, 70),
    LINE_WIDTH("lineWidth", Integer.class, true, 79);

    public final String camelName;
    private final Class<?> type;
    private final boolean required;
    private final Object defaultValue;
    public static final ImmutableMap<String, Prop> BY_NAME;
    public static final List<Prop> BY_CAMEL_NAME;

    private Prop(String camelName, Class<?> type, boolean required, Object defaultValue) {
        this.camelName = camelName;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
        Preconditions.checkArgument((boolean)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelName).equals(this.name()));
        if (defaultValue == null) {
            Preconditions.checkArgument((!required ? 1 : 0) != 0, (String)"required property %s must have default value", (Object)camelName);
        } else {
            Preconditions.checkArgument((boolean)this.validValue(type, defaultValue));
        }
    }

    private boolean validValue(Class<?> type, Object value) {
        if (type == Boolean.class || type == File.class || type == Integer.class || type == String.class || type.isEnum()) {
            return type.isInstance(value);
        }
        return false;
    }

    public static Prop lookup(String propName) {
        Prop prop = (Prop)((Object)BY_NAME.get((Object)propName));
        if (prop == null) {
            throw new RuntimeException("property " + propName + " not found");
        }
        return prop;
    }

    public Object get(Map<Prop, Object> map) {
        Object o = map.get((Object)this);
        return o != null ? o : this.defaultValue;
    }

    private void checkType(Class<?> requestedType) {
        Preconditions.checkArgument((this.type == requestedType ? 1 : 0) != 0, (String)"invalid type %s for property %s", this.type, (Object)this.camelName);
    }

    public boolean booleanValue(Map<Prop, Object> map) {
        this.checkType(Boolean.class);
        Object o = map.get((Object)this);
        return (Boolean)this.typeValue(o);
    }

    public int intValue(Map<Prop, Object> map) {
        this.checkType(Integer.class);
        Object o = map.get((Object)this);
        return (Integer)this.typeValue(o);
    }

    public String stringValue(Map<Prop, Object> map) {
        this.checkType(String.class);
        Object o = map.get((Object)this);
        return (String)this.typeValue(o);
    }

    public File fileValue(Map<Prop, Object> map) {
        this.checkType(File.class);
        Object o = map.get((Object)this);
        return (File)this.typeValue(o);
    }

    public <E extends Enum<E>> E enumValue(Map<Prop, Object> map, Class<E> type) {
        this.checkType(type);
        Object o = map.get((Object)this);
        return (E)((Enum)this.typeValue(o));
    }

    private <T> T typeValue(Object o) {
        if (o == null) {
            if (this.defaultValue == null) {
                throw new RuntimeException("no value for property " + this.camelName + " and no default value");
            }
            return (T)this.defaultValue;
        }
        return (T)o;
    }

    public void setLenient(Map<Prop, Object> map, @Nullable Object value) {
        if (this.type.isEnum() && value instanceof String) {
            Optional optional = Enums.getIfPresent(this.type, (String)((String)value).toUpperCase(Locale.ROOT));
            if (!optional.isPresent()) {
                String values = Arrays.stream((Enum[])this.type.getEnumConstants()).map(Enum::name).collect(Collectors.joining("', '", "'", "'"));
                throw new RuntimeException("value must be one of: " + values);
            }
            this.set(map, optional.get());
            return;
        }
        this.set(map, value);
    }

    public void set(Map<Prop, Object> map, @Nullable Object value) {
        if (value == null) {
            if (this.required) {
                throw new RuntimeException("property is required");
            }
            map.remove((Object)this);
        } else {
            if (!this.type.isInstance(value)) {
                throw new RuntimeException("value for property must have type " + this.type);
            }
            map.put(this, value);
        }
    }

    public Object remove(Map<Prop, Object> map) {
        return map.remove((Object)this);
    }

    static {
        List<Prop> list = Arrays.asList(Prop.values());
        Ordering ordering = Ordering.from(Comparator.comparing(o -> o.camelName));
        BY_CAMEL_NAME = ordering.sortedCopy(list);
        LinkedHashMap<String, Prop> map = new LinkedHashMap<String, Prop>();
        for (Prop value : BY_CAMEL_NAME) {
            map.put(value.name(), value);
            map.put(value.camelName, value);
        }
        BY_NAME = ImmutableMap.copyOf(map);
    }

    public static enum Output {
        CLASSIC,
        TABULAR;

    }
}

