/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.foreign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.foreign.CalciteFunctions;
import net.hydromatic.morel.foreign.Converters;
import net.hydromatic.morel.foreign.DataSet;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.util.ThreadLocals;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;

public class Calcite {
    final RelBuilder relBuilder;
    final JavaTypeFactory typeFactory;
    public final SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false).plus();
    public final DataContext dataContext;

    protected Calcite() {
        this.relBuilder = RelBuilder.create((FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new RaggedTypeSystem()).defaultSchema(this.rootSchema).build());
        this.typeFactory = (JavaTypeFactory)this.relBuilder.getTypeFactory();
        this.dataContext = new EmptyDataContext(this.typeFactory, this.rootSchema);
    }

    public Map<String, ForeignValue> foreignValues() {
        return ImmutableMap.of();
    }

    public static Calcite withDataSets(Map<String, DataSet> dataSetMap) {
        return new CalciteMap(dataSetMap);
    }

    public RelBuilder relBuilder() {
        return this.relBuilder.transform(c -> c);
    }

    public Code code(Environment env, RelNode rel, Type type) {
        Program program = Programs.sequence((Program[])new Program[]{Programs.subQuery((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE), new DecorrelateProgram()});
        RelOptPlanner planner = rel.getCluster().getPlanner();
        RelTraitSet traitSet = rel.getCluster().traitSet();
        RelNode rel2 = program.run(planner, rel, traitSet, (List)ImmutableList.of(), (List)ImmutableList.of());
        Function<Enumerable<Object[]>, List<Object>> converter = Converters.fromEnumerable(rel, type);
        return new CalciteCode(this.dataContext, rel2, env, converter);
    }

    public static class RaggedTypeSystem
    extends DelegatingTypeSystem {
        public RaggedTypeSystem() {
            super(RelDataTypeSystem.DEFAULT);
        }

        public boolean shouldConvertRaggedUnionTypesToVarying() {
            return true;
        }
    }

    private static class EmptyDataContext
    implements DataContext {
        private final JavaTypeFactory typeFactory;
        private final SchemaPlus rootSchema;

        EmptyDataContext(JavaTypeFactory typeFactory, SchemaPlus rootSchema) {
            this.typeFactory = typeFactory;
            this.rootSchema = rootSchema;
        }

        public SchemaPlus getRootSchema() {
            return this.rootSchema;
        }

        public JavaTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        public QueryProvider getQueryProvider() {
            throw new UnsupportedOperationException();
        }

        public Object get(String name) {
            return null;
        }
    }

    private static class CalciteMap
    extends Calcite {
        final ImmutableMap<String, ForeignValue> valueMap;

        CalciteMap(Map<String, DataSet> dataSetMap) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            dataSetMap.forEach((name, dataSet) -> b.put(name, (Object)dataSet.foreignValue(this)));
            this.valueMap = b.build();
        }

        @Override
        public Map<String, ForeignValue> foreignValues() {
            return this.valueMap;
        }
    }

    private static class DecorrelateProgram
    implements Program {
        private DecorrelateProgram() {
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            CalciteConnectionConfig config = (CalciteConnectionConfig)planner.getContext().maybeUnwrap(CalciteConnectionConfig.class).orElse(CalciteConnectionConfig.DEFAULT);
            if (config.forceDecorrelate()) {
                RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
                return RelDecorrelator.decorrelateQuery((RelNode)rel, (RelBuilder)relBuilder);
            }
            return rel;
        }
    }

    private static class CalciteCode
    implements Code {
        final DataContext dataContext;
        final RelNode rel;
        final Environment env;
        final Function<Enumerable<Object[]>, List<Object>> converter;

        CalciteCode(DataContext dataContext, RelNode rel, Environment env, Function<Enumerable<Object[]>, List<Object>> converter) {
            this.dataContext = dataContext;
            this.rel = rel;
            this.env = env;
            this.converter = converter;
        }

        public String toString() {
            return Codes.describe(this);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("calcite", d -> d.arg("plan", RelOptUtil.toString((RelNode)this.rel)));
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            return ThreadLocals.let(CalciteFunctions.THREAD_EVAL_ENV, evalEnv, () -> ThreadLocals.mutate(CalciteFunctions.THREAD_ENV, c -> c.withEnv(this.env), () -> {
                Interpreter interpreter = new Interpreter(this.dataContext, this.rel);
                return this.converter.apply((Enumerable<Object[]>)interpreter);
            }));
        }
    }
}

