/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.foreign;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.compile.Compiler;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Resolver;
import net.hydromatic.morel.compile.TypeResolver;
import net.hydromatic.morel.eval.Closure;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.foreign.Converters;
import net.hydromatic.morel.parse.MorelParserImpl;
import net.hydromatic.morel.parse.ParseException;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.rel.externalize.RelJsonReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalciteFunctions {
    public static final ThreadLocal<Context> THREAD_ENV = new ThreadLocal();
    public static final ThreadLocal<EvalEnv> THREAD_EVAL_ENV = new ThreadLocal();
    public static final SqlOperator TABLE_OPERATOR = new SqlUserDefinedTableFunction(new SqlIdentifier("morelTable", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, InferTypes.ANY_NULLABLE, Arg.metadata(Arg.of("code", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false), Arg.of("typeJson", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false)), TableFunctionImpl.create(MorelTableFunction.class, (String)"eval"));
    public static final SqlOperator SCALAR_OPERATOR = new SqlUserDefinedFunction(new SqlIdentifier("morelScalar", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, CalciteFunctions::inferReturnType, InferTypes.ANY_NULLABLE, Arg.metadata(Arg.of("code", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false), Arg.of("typeJson", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false)), (Function)ScalarFunctionImpl.create(MorelScalarFunction.class, (String)"eval"));
    public static final SqlOperator APPLY_OPERATOR = new SqlUserDefinedFunction(new SqlIdentifier("morelScalar", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, CalciteFunctions::inferReturnType, InferTypes.ANY_NULLABLE, Arg.metadata(Arg.of("typeJson", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false), Arg.of("fn", f -> f.createSqlType(SqlTypeName.INTEGER), SqlTypeFamily.INTEGER, false), Arg.of("arg", f -> f.createSqlType(SqlTypeName.VARCHAR), SqlTypeFamily.STRING, false)), (Function)ScalarFunctionImpl.create(MorelApplyFunction.class, (String)"eval"));

    private CalciteFunctions() {
    }

    private static RelDataType inferReturnType(SqlOperatorBinding b) {
        return b.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
    }

    private static interface Arg {
        public String name();

        public RelDataType type(RelDataTypeFactory var1);

        public SqlTypeFamily family();

        public boolean optional();

        public static SqlOperandMetadata metadata(Arg ... args) {
            List<Arg> argList = Arrays.asList(args);
            return OperandTypes.operandMetadata(Static.transform(argList, Arg::family), typeFactory -> Static.transform(argList, arg -> arg.type((RelDataTypeFactory)typeFactory)), i -> args[i].name(), i -> args[i].optional());
        }

        public static Arg of(final String name, final java.util.function.Function<RelDataTypeFactory, RelDataType> protoType, final SqlTypeFamily family, final boolean optional) {
            return new Arg(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public RelDataType type(RelDataTypeFactory typeFactory) {
                    return (RelDataType)protoType.apply(typeFactory);
                }

                @Override
                public SqlTypeFamily family() {
                    return family;
                }

                @Override
                public boolean optional() {
                    return optional;
                }
            };
        }
    }

    public static class MorelTableFunction {
        private final Context cx = THREAD_ENV.get();
        private final Compiled compiled;

        public MorelTableFunction(org.apache.calcite.plan.Context context) {
            List args = (List)context.unwrap(List.class);
            if (args != null) {
                String ml = (String)args.get(0);
                String typeJson = (String)args.get(1);
                this.compiled = Compiled.create(ml, typeJson, this.cx.typeFactory, this.cx.env, this.cx.typeSystem, this.cx.session);
            } else {
                this.compiled = null;
            }
        }

        public MorelTableFunction() {
            this((org.apache.calcite.plan.Context)Contexts.EMPTY_CONTEXT);
        }

        public ScannableTable eval(String ml, final String typeJson) {
            final Compiled compiled = this.compiled != null ? this.compiled : Compiled.create(ml, typeJson, this.cx.typeFactory, this.cx.env, this.cx.typeSystem, this.cx.session);
            return new ScannableTable(){

                public RelDataType getRowType(RelDataTypeFactory factory) {
                    try {
                        return RelJsonReader.readType((RelDataTypeFactory)factory, (String)typeJson);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public Enumerable<Object[]> scan(DataContext root) {
                    Object v = compiled.code.eval(compiled.evalEnv);
                    return compiled.f.apply(v);
                }

                public Statistic getStatistic() {
                    return Statistics.UNKNOWN;
                }

                public Schema.TableType getJdbcTableType() {
                    return Schema.TableType.OTHER;
                }

                public boolean isRolledUp(String column) {
                    return false;
                }

                public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
                    return false;
                }
            };
        }

        private static class Compiled {
            final Code code;
            final EvalEnv evalEnv;
            final java.util.function.Function<Object, Enumerable<Object[]>> f;

            Compiled(String ml, Code code, EvalEnv evalEnv, java.util.function.Function<Object, Enumerable<Object[]>> f) {
                this.code = code;
                this.evalEnv = evalEnv;
                this.f = f;
            }

            static Compiled create(String ml, String typeJson, RelDataTypeFactory typeFactory, Environment env, TypeSystem typeSystem, Session session) {
                Ast.Exp exp;
                try {
                    exp = new MorelParserImpl(new StringReader(ml)).expression();
                }
                catch (ParseException pe) {
                    throw new RuntimeException("Error while parsing\n" + ml, pe);
                }
                Ast.ValDecl valDecl = Compiles.toValDecl(exp);
                TypeResolver.Resolved resolved = TypeResolver.deduceType(env, valDecl, typeSystem);
                Ast.ValDecl valDecl2 = (Ast.ValDecl)resolved.node;
                Core.NonRecValDecl valDecl3 = (Core.NonRecValDecl)Resolver.of(resolved.typeMap, env, session).toCore(valDecl2);
                Core.Exp e3 = Compiles.toExp(valDecl3);
                Compiler compiler = new Compiler(typeSystem);
                return new Compiled(ml, compiler.compile(env, e3), Codes.emptyEnvWith(session, env), Converters.toCalciteEnumerable(e3.type, typeFactory));
            }
        }
    }

    public static class MorelScalarFunction {
        private final Context cx = THREAD_ENV.get();
        private final Compiled compiled;

        public MorelScalarFunction(org.apache.calcite.plan.Context context) {
            List args = (List)context.unwrap(List.class);
            this.compiled = args != null ? new Compiled(this.cx.env, this.cx.typeSystem, this.cx.typeFactory, (String)args.get(0), (String)args.get(1)) : null;
        }

        public MorelScalarFunction() {
            this((org.apache.calcite.plan.Context)Contexts.EMPTY_CONTEXT);
        }

        public Object eval(String ml, String typeJson) {
            Compiled compiled = this.compiled != null ? this.compiled : new Compiled(this.cx.env, this.cx.typeSystem, this.cx.typeFactory, ml, typeJson);
            EvalEnv evalEnv = THREAD_EVAL_ENV.get();
            Object v = compiled.code.eval(evalEnv);
            return compiled.f.apply(v);
        }

        private static class Compiled {
            final Code code;
            final java.util.function.Function<Object, Object> f;

            Compiled(Environment env, TypeSystem typeSystem, RelDataTypeFactory typeFactory, String ml, String typeJson) {
                Ast.Exp exp;
                try {
                    exp = new MorelParserImpl(new StringReader(ml)).expression();
                }
                catch (ParseException pe) {
                    throw new RuntimeException(pe);
                }
                Ast.ValDecl valDecl = Compiles.toValDecl(exp);
                TypeResolver.Resolved resolved = TypeResolver.deduceType(env, valDecl, typeSystem);
                Ast.ValDecl valDecl2 = (Ast.ValDecl)resolved.node;
                Core.NonRecValDecl valDecl3 = (Core.NonRecValDecl)Resolver.of(resolved.typeMap, env, null).toCore(valDecl2);
                Core.Exp e3 = Compiles.toExp(valDecl3);
                this.code = new Compiler(typeSystem).compile(env, e3);
                this.f = Converters.toCalcite(e3.type, typeFactory);
            }
        }
    }

    public static class MorelApplyFunction {
        final Context cx = THREAD_ENV.get();
        final Compiled compiled;

        public MorelApplyFunction(org.apache.calcite.plan.Context context) {
            List args = (List)context.unwrap(List.class);
            if (args != null) {
                String morelArgTypeJson = (String)args.get(0);
                this.compiled = new Compiled(morelArgTypeJson, this.cx.typeFactory, this.cx.typeSystem);
            } else {
                this.compiled = null;
            }
        }

        public MorelApplyFunction() {
            this((org.apache.calcite.plan.Context)Contexts.EMPTY_CONTEXT);
        }

        public Object eval(String morelArgTypeJson, Object closure, Object arg) {
            Compiled compiled = this.compiled != null ? this.compiled : new Compiled(morelArgTypeJson, this.cx.typeFactory, this.cx.typeSystem);
            Closure fn = (Closure)closure;
            EvalEnv evalEnv = THREAD_EVAL_ENV.get();
            Object o = compiled.converter.apply(arg);
            return fn.apply(evalEnv, o);
        }

        private static class Compiled {
            final java.util.function.Function<Object, Object> converter;

            Compiled(String morelArgType, RelDataTypeFactory typeFactory, TypeSystem typeSystem) {
                Ast.Type typeAst;
                try {
                    typeAst = new MorelParserImpl(new StringReader(morelArgType)).type();
                }
                catch (ParseException pe) {
                    throw new RuntimeException(pe);
                }
                Type argType = TypeResolver.toType(typeAst, typeSystem);
                this.converter = Converters.toMorel(argType, typeFactory);
            }
        }
    }

    public static class Context {
        public final Session session;
        public final Environment env;
        public final TypeSystem typeSystem;
        public final RelDataTypeFactory typeFactory;

        public Context(Session session, Environment env, TypeSystem typeSystem, @Nullable RelDataTypeFactory typeFactory) {
            this.session = session;
            this.env = env.renumber();
            this.typeSystem = typeSystem;
            this.typeFactory = typeFactory;
        }

        public Context withEnv(Environment env) {
            return new Context(this.session, env, this.typeSystem, this.typeFactory);
        }
    }
}

