/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.Objects;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.eval.Unit;

public class Binding {
    public final Core.NamedPat id;
    public final Core.Exp exp;
    public final Object value;
    public final boolean parameter;

    private Binding(Core.NamedPat id, Core.Exp exp, Object value, boolean parameter) {
        this.id = Objects.requireNonNull(id);
        this.exp = exp;
        this.value = Objects.requireNonNull(value);
        assert (!(value instanceof Core.IdPat));
        this.parameter = parameter;
    }

    public static Binding of(Core.NamedPat id) {
        return new Binding(id, null, Unit.INSTANCE, false);
    }

    public static Binding of(Core.NamedPat id, Core.Exp exp) {
        return new Binding(id, exp, Unit.INSTANCE, false);
    }

    public static Binding of(Core.NamedPat id, Object value) {
        return new Binding(id, null, value, false);
    }

    public Binding withFlattenedName() {
        if (this.id.i == 0) {
            return this;
        }
        return new Binding(this.id.withName(this.id.name + '_' + this.id.i), this.exp, this.value, this.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.exp, this.value);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Binding && this.id.equals(((Binding)o).id) && Objects.equals(this.exp, ((Binding)o).exp) && this.value.equals(((Binding)o).value);
    }

    public Binding withParameter(boolean parameter) {
        return new Binding(this.id, this.exp, this.value, parameter);
    }

    public String toString() {
        if (this.exp != null) {
            return this.id + " = " + this.exp;
        }
        if (this.value == Unit.INSTANCE) {
            return this.id + " : " + this.id.type.moniker();
        }
        return this.id + " = " + this.value + " : " + this.id.type.moniker();
    }
}

