/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;

public class ForallType
extends BaseType {
    public final int parameterCount;
    public final Type type;

    ForallType(int parameterCount, Type type) {
        super(Op.FORALL_TYPE);
        this.parameterCount = parameterCount;
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public Type.Key key() {
        return Keys.forall(this.type, this.parameterCount);
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public ForallType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        Type type2 = this.type.copy(typeSystem, transform);
        return type2 == this.type ? this : typeSystem.forallType(this.parameterCount, type2);
    }

    @Override
    public Type substitute(TypeSystem typeSystem, List<? extends Type> types) {
        switch (this.type.op()) {
            case DATA_TYPE: {
                DataType dataType = (DataType)this.type;
                Keys.DataTypeKey key = Keys.datatype(dataType.name, Keys.toKeys(types), Maps.transformValues(dataType.typeConstructors, k -> k.substitute(types)));
                return typeSystem.typeFor(key);
            }
            case FUNCTION_TYPE: {
                return this.type.substitute(typeSystem, types);
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.type.op()) + ": " + this.type));
    }
}

