/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;

public class ListType
extends BaseType {
    public final Type elementType;

    ListType(Type elementType) {
        super(Op.LIST);
        this.elementType = Objects.requireNonNull(elementType);
    }

    @Override
    public Type.Key key() {
        return Keys.list(this.elementType.key());
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public ListType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        Type elementType2 = this.elementType.copy(typeSystem, transform);
        return elementType2 == this.elementType ? this : typeSystem.listType(elementType2);
    }
}

