/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.List;
import java.util.Objects;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.NamedType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.MapList;
import net.hydromatic.morel.util.Ord;

public abstract class ParameterizedType
extends BaseType
implements NamedType {
    public final String name;
    public final String moniker;
    public final List<Type> parameterTypes;

    ParameterizedType(Op op, String name, String moniker, int parameterCount) {
        super(op);
        this.name = Objects.requireNonNull(name);
        this.moniker = Objects.requireNonNull(moniker);
        this.parameterTypes = MapList.of(parameterCount, TypeVar::new);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String moniker() {
        return this.moniker;
    }

    @Override
    public String toString() {
        return this.moniker;
    }

    static String computeMoniker(String name, List<? extends Type> typeVars) {
        if (typeVars.isEmpty()) {
            return name;
        }
        StringBuilder b = new StringBuilder();
        if (typeVars.size() > 1) {
            b.append('(');
        }
        Ord.forEachIndexed(typeVars, (t, i) -> {
            if (i > 0) {
                b.append(",");
            }
            if (t instanceof TupleType) {
                b.append('(').append(t.moniker()).append(')');
            } else {
                b.append(t.moniker());
            }
        });
        if (typeVars.size() > 1) {
            b.append(')');
        }
        return b.append(' ').append(name).toString();
    }
}

