/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArrayQueue<E> {
    private E[] elements = new Object[16];
    private int start;
    private int end;

    public String toString() {
        return this.asList().toString();
    }

    public @Nullable E poll() {
        if (this.start == this.end) {
            return null;
        }
        E e = this.elements[this.start];
        this.elements[this.start] = null;
        this.start = ArrayQueue.inc(this.start, this.elements.length);
        return e;
    }

    public int size() {
        return ArrayQueue.sub(this.end, this.start, this.elements.length);
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public E get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[ArrayQueue.add(this.start, i, this.elements.length)];
    }

    public E set(int i, E e) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Objects.requireNonNull(e);
        int k = ArrayQueue.add(this.start, i, this.elements.length);
        E previous = this.elements[k];
        this.elements[k] = e;
        return previous;
    }

    public void add(E e) {
        Objects.requireNonNull(e);
        this.elements[this.end] = e;
        this.end = ArrayQueue.inc(this.end, this.elements.length);
        if (this.start == this.end) {
            this.grow();
        }
    }

    private void grow() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity * 2;
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        E[] es = this.elements;
        if (this.end < this.start || this.end == this.start && es[this.start] != null) {
            int newSpace = newCapacity - oldCapacity;
            System.arraycopy(es, this.start, es, this.start + newSpace, oldCapacity - this.start);
            int to = this.start += newSpace;
            for (int i = this.start; i < to; ++i) {
                es[i] = null;
            }
        }
    }

    public List<E> asList() {
        return new AbstractList<E>(){

            @Override
            public int size() {
                return ArrayQueue.this.size();
            }

            @Override
            public E get(int index) {
                return ArrayQueue.this.get(index);
            }

            @Override
            public E set(int index, E element) {
                return ArrayQueue.this.set(index, element);
            }

            @Override
            public E remove(int index) {
                return ArrayQueue.this.remove(index);
            }
        };
    }

    private static int inc(int i, int modulus) {
        if (++i == modulus) {
            i = 0;
        }
        return i;
    }

    private static int dec(int i, int modulus) {
        i = i == 0 ? modulus - 1 : --i;
        return i;
    }

    private static int add(int i, int j, int modulus) {
        int k = i + j;
        if (k >= modulus) {
            k -= modulus;
        }
        return k;
    }

    private static int sub(int i, int j, int modulus) {
        int k = i - j;
        if (k < 0) {
            k += modulus;
        }
        return k;
    }

    public void forEach(Consumer<? super E> consumer) {
        if (this.start <= this.end) {
            for (int i = this.start; i < this.end; ++i) {
                consumer.accept(this.elements[i]);
            }
        } else {
            int i;
            for (i = this.start; i < this.elements.length; ++i) {
                consumer.accept(this.elements[i]);
            }
            for (i = 0; i < this.end; ++i) {
                consumer.accept(this.elements[i]);
            }
        }
    }

    public E remove(int i) {
        E e;
        int size = this.size();
        if (i < 0 || i >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (i == 0) {
            e = this.elements[this.start];
            this.elements[this.start] = null;
            this.start = ArrayQueue.inc(this.start, this.elements.length);
        } else if (i == size - 1) {
            this.end = ArrayQueue.dec(this.end, this.elements.length);
            e = this.elements[this.end];
            this.elements[this.end] = null;
        } else {
            int k = ArrayQueue.add(this.start, i, this.elements.length);
            e = this.elements[k];
            this.end = ArrayQueue.dec(this.end, this.elements.length);
            this.elements[k] = this.elements[this.end];
            this.elements[this.end] = null;
        }
        return e;
    }

    public ListIterator<E> listIterator() {
        return this.asList().listIterator();
    }
}

