/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.util.Static;

public abstract class Folder<E> {
    final E e;

    Folder(E e) {
        this.e = Objects.requireNonNull(e);
    }

    abstract E combine(List<Folder<E>> var1);

    public static <E> E combineAll(List<Folder<E>> list) {
        if (list.size() == 0) {
            throw new AssertionError();
        }
        Folder<E> head = list.get(0);
        List<Folder<E>> tail = Static.skip(list);
        return head.combine(tail);
    }

    private static <E> Folder<E> end(E e) {
        return new End<E>(e);
    }

    public static void at(List<Folder<Ast.Exp>> list, Ast.Exp exp) {
        Folder.append(list, exp, e1 -> Folder.op(e1, Op.AT));
    }

    public static void cons(List<Folder<Ast.Exp>> list, Ast.Exp exp) {
        Folder.append(list, exp, e1 -> Folder.op(e1, Op.CONS));
    }

    public static <E> void start(List<Folder<E>> list, E e) {
        if (!list.isEmpty()) {
            throw new AssertionError();
        }
        list.add(Folder.end(e));
    }

    private static <E> void append(List<Folder<E>> list, E e, Function<E, Folder<E>> fn) {
        if (list.isEmpty()) {
            throw new AssertionError();
        }
        End end = (End)list.get(list.size() - 1);
        list.set(list.size() - 1, fn.apply(end.e));
        list.add(Folder.end(e));
    }

    private static Folder<Ast.Exp> op(Ast.Exp exp, final Op at) {
        return new Folder<Ast.Exp>(exp){

            @Override
            Ast.Exp combine(List<Folder<Ast.Exp>> list) {
                Ast.Exp rest = (Ast.Exp)1.combineAll(list);
                return AstBuilder.ast.infixCall(((Ast.Exp)this.e).pos.plus(rest.pos), at, (Ast.Exp)this.e, rest);
            }
        };
    }

    private static class End<E>
    extends Folder<E> {
        End(E e) {
            super(e);
        }

        @Override
        E combine(List<Folder<E>> list) {
            assert (list.isEmpty());
            return (E)this.e;
        }
    }
}

