/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.hydromatic.morel.util.ArrayQueue;
import net.hydromatic.morel.util.Unifier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MartelliUnifier
extends Unifier {
    @Override
    public @NonNull Unifier.Result unify(List<Unifier.TermTerm> termPairs, Map<Unifier.Variable, Unifier.Action> termActions, Unifier.Tracer tracer) {
        long start = System.nanoTime();
        Work work = new Work(tracer, termPairs);
        LinkedHashMap<Unifier.Variable, Unifier.Term> result = new LinkedHashMap<Unifier.Variable, Unifier.Term>();
        int iteration = 0;
        while (true) {
            Unifier.TermTerm pair;
            if (!work.deleteQueue.isEmpty() && (pair = work.deleteQueue.remove(0)) != null) {
                tracer.onDelete(pair.left, pair.right);
            } else if (!work.seqSeqQueue.isEmpty()) {
                pair = work.seqSeqQueue.remove(0);
                Unifier.Sequence left = (Unifier.Sequence)pair.left;
                Unifier.Sequence right = (Unifier.Sequence)pair.right;
                if (!left.operator.equals(right.operator) || left.terms.size() != right.terms.size()) {
                    tracer.onConflict(left, right);
                    return this.failure("conflict: " + left + " vs " + right);
                }
                tracer.onSequence(left, right);
                for (int j = 0; j < left.terms.size(); ++j) {
                    work.add(new Unifier.TermTerm(left.terms.get(j), right.terms.get(j)));
                }
            } else if (!work.varAnyQueue.isEmpty()) {
                pair = work.varAnyQueue.remove(0);
                Unifier.Term term = pair.right;
                Unifier.Variable variable = (Unifier.Variable)pair.left;
                if (term.contains(variable)) {
                    tracer.onCycle(variable, term);
                    return this.failure("cycle: variable " + variable + " in " + term);
                }
                tracer.onVariable(variable, term);
                result.put(variable, term);
                if (!termActions.isEmpty()) {
                    this.act(variable, term, work, new Unifier.Substitution(result), termActions, 0);
                }
                work.substituteList(variable, term);
            } else {
                long duration = System.nanoTime() - start;
                return Unifier.SubstitutionResult.create(result);
            }
            ++iteration;
        }
    }

    private void act(Unifier.Variable variable, Unifier.Term term, Work work, Unifier.Substitution substitution, Map<Unifier.Variable, Unifier.Action> termActions, int depth) {
        Unifier.Action action = termActions.get(variable);
        if (action != null) {
            action.accept(variable, term, substitution, (leftTerm, rightTerm) -> work.add(new Unifier.TermTerm((Unifier.Term)leftTerm, (Unifier.Term)rightTerm)));
        }
        if (term instanceof Unifier.Variable && depth < 2) {
            List<Unifier.TermTerm> termPairsCopy = work.allTermPairs();
            termPairsCopy.forEach(termPair -> {
                if (termPair.left.equals(term)) {
                    this.act(variable, termPair.right, work, substitution, termActions, depth + 1);
                }
            });
            if (depth < 1) {
                this.act((Unifier.Variable)term, variable, work, substitution, termActions, depth + 1);
            }
        }
        substitution.resultMap.forEach((variable2, v) -> {
            if (v.equals(variable)) {
                this.act((Unifier.Variable)variable2, term, work, substitution, termActions, depth + 1);
            }
        });
    }

    static class Work {
        final Unifier.Tracer tracer;
        final ArrayQueue<Unifier.TermTerm> deleteQueue = new ArrayQueue();
        final ArrayQueue<Unifier.TermTerm> seqSeqQueue = new ArrayQueue();
        final ArrayQueue<Unifier.TermTerm> varAnyQueue = new ArrayQueue();

        Work(Unifier.Tracer tracer, List<Unifier.TermTerm> termPairs) {
            this.tracer = tracer;
            termPairs.forEach(this::add);
        }

        public String toString() {
            return "delete " + this.deleteQueue + " seqSeq " + this.seqSeqQueue + " varAny " + this.varAnyQueue;
        }

        void add(Unifier.TermTerm pair) {
            switch (Kind.of(pair).ordinal()) {
                case 0: {
                    this.deleteQueue.add(pair);
                    break;
                }
                case 1: {
                    this.seqSeqQueue.add(pair);
                    break;
                }
                case 3: {
                    this.tracer.onSwap(pair.left, pair.right);
                    pair = new Unifier.TermTerm(pair.right, pair.left);
                }
                case 2: {
                    this.varAnyQueue.add(pair);
                }
            }
        }

        List<Unifier.TermTerm> allTermPairs() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.deleteQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.seqSeqQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.varAnyQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }

        private void substituteList(Unifier.Variable variable, Unifier.Term term) {
            this.sub(variable, term, this.deleteQueue, Kind.DELETE);
            this.sub(variable, term, this.seqSeqQueue, Kind.SEQ_SEQ);
            this.sub(variable, term, this.varAnyQueue, Kind.VAR_ANY);
        }

        private void sub(Unifier.Variable variable, Unifier.Term term, ArrayQueue<Unifier.TermTerm> queue, Kind kind) {
            ListIterator<Unifier.TermTerm> iter = queue.listIterator();
            while (iter.hasNext()) {
                Unifier.TermTerm pair = iter.next();
                Unifier.Term left2 = pair.left.apply1(variable, term);
                Unifier.Term right2 = pair.right.apply1(variable, term);
                if (left2 == pair.left && right2 == pair.right) continue;
                this.tracer.onSubstitute(pair.left, pair.right, left2, right2);
                Unifier.TermTerm pair2 = new Unifier.TermTerm(left2, right2);
                Kind kind2 = Kind.of(pair2);
                if (kind2 == kind) {
                    iter.set(pair2);
                    continue;
                }
                if (kind2 == Kind.NON_VAR_VAR && kind == Kind.VAR_ANY) {
                    iter.set(new Unifier.TermTerm(pair2.right, pair2.left));
                    continue;
                }
                iter.remove();
                this.add(pair2);
            }
        }
    }

    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind DELETE = new Kind();
        public static final /* enum */ Kind SEQ_SEQ = new Kind();
        public static final /* enum */ Kind VAR_ANY = new Kind();
        public static final /* enum */ Kind NON_VAR_VAR = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        static Kind of(Unifier.TermTerm pair) {
            if (pair.left.equals(pair.right)) {
                return DELETE;
            }
            if (pair.left instanceof Unifier.Sequence) {
                if (pair.right instanceof Unifier.Sequence) {
                    return SEQ_SEQ;
                }
                assert (pair.right instanceof Unifier.Variable);
                return NON_VAR_VAR;
            }
            assert (pair.left instanceof Unifier.Variable);
            return VAR_ANY;
        }

        private static /* synthetic */ Kind[] $values() {
            return new Kind[]{DELETE, SEQ_SEQ, VAR_ANY, NON_VAR_VAR};
        }

        static {
            $VALUES = Kind.$values();
        }
    }
}

