/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Sat {
    private final Map<Integer, Variable> variablesById = new HashMap<Integer, Variable>();
    private final Map<String, Variable> variablesByName = new HashMap<String, Variable>();
    private int nextVariable = 0;

    public @Nullable Map<Variable, Boolean> solve(Term term) {
        ArrayList<ImmutableList> allAssignments = new ArrayList<ImmutableList>();
        for (Variable variable : this.variablesById.values()) {
            allAssignments.add(ImmutableList.of((Object)new Assignment(variable, false), (Object)new Assignment(variable, true)));
        }
        boolean[] env = new boolean[this.nextVariable];
        for (List assignments : Lists.cartesianProduct(allAssignments)) {
            assignments.forEach(a -> {
                env[a.variable.id] = a.value;
            });
            if (!term.evaluate(env)) continue;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            assignments.forEach(a -> builder.put((Object)a.variable, (Object)a.value));
            return builder.build();
        }
        return null;
    }

    public Variable variable(String name) {
        Variable variable = this.variablesByName.get(name);
        if (variable != null) {
            return variable;
        }
        int id = this.nextVariable++;
        variable = new Variable(id, name);
        this.variablesById.put(id, variable);
        this.variablesByName.put(name, variable);
        return variable;
    }

    public Term not(Term term) {
        return new Not(term);
    }

    public Term and(Term ... terms) {
        return new And((ImmutableList<Term>)ImmutableList.copyOf((Object[])terms));
    }

    public Term and(Iterable<? extends Term> terms) {
        return new And((ImmutableList<Term>)ImmutableList.copyOf(terms));
    }

    public Term or(Term ... terms) {
        return new Or((ImmutableList<Term>)ImmutableList.copyOf((Object[])terms));
    }

    public Term or(Iterable<? extends Term> terms) {
        return new Or((ImmutableList<Term>)ImmutableList.copyOf(terms));
    }

    public static class Variable
    extends Term {
        public final int id;
        public final String name;

        Variable(int id, String name) {
            super(Op.VARIABLE);
            this.id = id;
            this.name = Objects.requireNonNull(name, "name");
        }

        @Override
        protected StringBuilder unparse(StringBuilder buf, int left, int right) {
            return buf.append(this.name);
        }

        @Override
        public boolean evaluate(boolean[] env) {
            return env[this.id];
        }
    }

    private static class Assignment {
        final Variable variable;
        final boolean value;

        Assignment(Variable variable, boolean value) {
            this.variable = Objects.requireNonNull(variable, "variable");
            this.value = value;
        }
    }

    public static abstract class Term {
        final Op op;

        Term(Op op) {
            this.op = Objects.requireNonNull(op, "op");
        }

        public String toString() {
            return this.unparse(new StringBuilder(), 0, 0).toString();
        }

        protected abstract StringBuilder unparse(StringBuilder var1, int var2, int var3);

        public abstract boolean evaluate(boolean[] var1);
    }

    static class Not
    extends Term {
        public final Term term;

        Not(Term term) {
            super(Op.NOT);
            this.term = Objects.requireNonNull(term, "term");
        }

        @Override
        protected StringBuilder unparse(StringBuilder buf, int left, int right) {
            return this.term.unparse(buf.append(this.op.str), this.op.right, right);
        }

        @Override
        public boolean evaluate(boolean[] env) {
            return !this.term.evaluate(env);
        }
    }

    static class And
    extends Node {
        And(ImmutableList<Term> terms) {
            super(Op.AND, terms);
        }

        @Override
        public boolean evaluate(boolean[] env) {
            for (Term term : this.terms) {
                if (term.evaluate(env)) continue;
                return false;
            }
            return true;
        }
    }

    static class Or
    extends Node {
        Or(ImmutableList<Term> terms) {
            super(Op.OR, terms);
        }

        @Override
        public boolean evaluate(boolean[] env) {
            for (Term term : this.terms) {
                if (!term.evaluate(env)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum Op {
        AND(3, 4, " \u2227 ", "true"),
        OR(1, 2, " \u2228 ", "false"),
        NOT(5, 5, "\u00ac", ""),
        VARIABLE(0, 0, "", "");

        final int left;
        final int right;
        final String str;
        final String emptyName;

        private Op(int left, int right, String str, String emptyName) {
            this.left = left;
            this.right = right;
            this.str = str;
            this.emptyName = emptyName;
        }
    }

    static abstract class Node
    extends Term {
        public final ImmutableList<Term> terms;

        Node(Op op, ImmutableList<Term> terms) {
            super(op);
            this.terms = Objects.requireNonNull(terms);
        }

        @Override
        protected StringBuilder unparse(StringBuilder buf, int left, int right) {
            switch (this.terms.size()) {
                case 0: {
                    return buf.append(this.op.emptyName);
                }
                case 1: {
                    return ((Term)this.terms.get(0)).unparse(buf, left, right);
                }
            }
            if (left > this.op.left || right > this.op.right) {
                return this.unparse(buf.append('('), 0, 0).append(')');
            }
            for (int i = 0; i < this.terms.size(); ++i) {
                Term term = (Term)this.terms.get(i);
                if (i > 0) {
                    buf.append(this.op.str);
                }
                term.unparse(buf, i == 0 ? left : this.op.right, i == this.terms.size() - 1 ? right : this.op.left);
            }
            return buf;
        }
    }
}

