/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.AstWriter;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Ast {
    private Ast() {
    }

    public static class Aggregate
    extends AstNode {
        public final Exp aggregate;
        public final Exp argument;
        public final Id id;

        Aggregate(Pos pos, Exp aggregate, @Nullable Exp argument, Id id) {
            super(pos, Op.AGGREGATE);
            this.aggregate = Objects.requireNonNull(aggregate);
            this.argument = argument;
            this.id = Objects.requireNonNull(id);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.id(this.id.name).append(" = ").append(this.aggregate, 0, 0);
            if (this.argument != null) {
                w.append(" of ").append(this.argument, 0, 0);
            }
            return w;
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Aggregate copy(Exp aggregate, Exp argument, Id id) {
            return this.aggregate.equals(aggregate) && Objects.equals(this.argument, argument) && this.id.equals(id) ? this : AstBuilder.ast.aggregate(this.pos, aggregate, argument, id);
        }
    }

    public static class Apply
    extends Exp {
        public final Exp fn;
        public final Exp arg;

        Apply(Pos pos, Exp fn, Exp arg) {
            super(pos, Op.APPLY);
            this.fn = fn;
            this.arg = arg;
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.fn, this.op, this.arg, right);
        }

        public Apply copy(Exp fn, Exp arg) {
            return this.fn.equals(fn) && this.arg.equals(arg) ? this : new Apply(this.pos, fn, arg);
        }
    }

    public static class Compute
    extends Group {
        Compute(Pos pos, ImmutableList<Aggregate> aggregates) {
            super(pos, Op.COMPUTE, ImmutablePairList.of(), aggregates);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Compute copy(List<Aggregate> aggregates) {
            return this.aggregates.equals(aggregates) ? this : AstBuilder.ast.compute(this.pos, aggregates);
        }
    }

    public static class Group
    extends FromStep {
        public final ImmutablePairList<Id, Exp> groupExps;
        public final ImmutableList<Aggregate> aggregates;

        Group(Pos pos, Op op, ImmutablePairList<Id, Exp> groupExps, ImmutableList<Aggregate> aggregates) {
            super(pos, op);
            this.groupExps = groupExps;
            this.aggregates = aggregates;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            if (this.op == Op.GROUP) {
                w.append(" group");
            }
            Pair.forEachIndexed(this.groupExps, (i, id, exp) -> w.append(i == 0 ? " " : ", ").append((AstNode)id, 0, 0).append(" = ").append((AstNode)exp, 0, 0));
            Ord.forEachIndexed(this.aggregates, (aggregate, i) -> w.append(i == 0 ? " compute " : ", ").append((AstNode)aggregate, 0, 0));
            return w;
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Group copy(PairList<Id, Exp> groupExps, List<Aggregate> aggregates) {
            Preconditions.checkArgument((this.op == Op.GROUP ? 1 : 0) != 0, (Object)"use Compute.copy instead?");
            return this.groupExps.equals(groupExps) && this.aggregates.equals(aggregates) ? this : AstBuilder.ast.group(this.pos, groupExps, aggregates);
        }
    }

    public static class Order
    extends FromStep {
        public final Exp exp;

        Order(Pos pos, Exp exp) {
            super(pos, Op.ORDER);
            this.exp = Objects.requireNonNull(exp);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" order ").append(this.exp, 0, right);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Order copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Order(this.pos, exp);
        }
    }

    public static class Through
    extends FromStep {
        public final Pat pat;
        public final Exp exp;

        Through(Pos pos, Pat pat, Exp exp) {
            super(pos, Op.THROUGH);
            this.pat = pat;
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" through ").append(this.pat, 0, 0).append(" in ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Through copy(Pat pat, Exp exp) {
            return this.pat.equals(pat) && this.exp.equals(exp) ? this : new Through(this.pos, pat, exp);
        }
    }

    public static class Into
    extends FromStep {
        public final Exp exp;

        Into(Pos pos, Exp exp) {
            super(pos, Op.INTO);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" into ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Into copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Into(this.pos, exp);
        }
    }

    public static class Yield
    extends FromStep {
        public final Exp exp;

        Yield(Pos pos, Exp exp) {
            super(pos, Op.YIELD);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" yield ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Yield copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Yield(this.pos, exp);
        }
    }

    public static class Unorder
    extends FromStep {
        Unorder(Pos pos) {
            super(pos, Op.UNORDER);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" unorder");
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Take
    extends FromStep {
        public final Exp exp;

        Take(Pos pos, Exp exp) {
            super(pos, Op.TAKE);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" take ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Take copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Take(this.pos, exp);
        }
    }

    public static class Skip
    extends FromStep {
        public final Exp exp;

        Skip(Pos pos, Exp exp) {
            super(pos, Op.SKIP);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" skip ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Skip copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Skip(this.pos, exp);
        }
    }

    public static class Require
    extends FromStep {
        public final Exp exp;

        Require(Pos pos, Exp exp) {
            super(pos, Op.REQUIRE);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" require ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Require copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Require(this.pos, exp);
        }
    }

    public static class Where
    extends FromStep {
        public final Exp exp;

        Where(Pos pos, Exp exp) {
            super(pos, Op.WHERE);
            this.exp = exp;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" where ").append(this.exp, 0, 0);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Where copy(Exp exp) {
            return this.exp.equals(exp) ? this : new Where(this.pos, exp);
        }
    }

    public static class Union
    extends SetStep {
        Union(Pos pos, boolean distinct, ImmutableList<Exp> args) {
            super(pos, Op.UNION, distinct, args);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public Union copy(boolean distinct, List<Exp> args) {
            return this.distinct && distinct && this.args.equals(args) ? this : AstBuilder.ast.union(this.pos, distinct, args);
        }
    }

    public static class Intersect
    extends SetStep {
        Intersect(Pos pos, boolean distinct, ImmutableList<Exp> args) {
            super(pos, Op.INTERSECT, distinct, args);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public Intersect copy(boolean distinct, List<Exp> args) {
            return this.distinct && distinct && this.args.equals(args) ? this : AstBuilder.ast.intersect(this.pos, distinct, args);
        }
    }

    public static class Except
    extends SetStep {
        Except(Pos pos, boolean distinct, ImmutableList<Exp> args) {
            super(pos, Op.EXCEPT, distinct, args);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public Except copy(boolean distinct, List<Exp> args) {
            return this.distinct && distinct && this.args.equals(args) ? this : AstBuilder.ast.except(this.pos, distinct, args);
        }
    }

    public static abstract class SetStep
    extends FromStep {
        public final ImmutableList<Exp> args;
        public final boolean distinct;

        SetStep(Pos pos, Op op, boolean distinct, ImmutableList<Exp> args) {
            super(pos, op);
            this.distinct = distinct;
            Preconditions.checkArgument((op == Op.UNION || op == Op.INTERSECT || op == Op.EXCEPT ? 1 : 0) != 0);
            Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0);
            this.args = args;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.op, this.distinct, this.args});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SetStep && this.getClass() == obj.getClass() && this.op == ((SetStep)obj).op && this.distinct == ((SetStep)obj).distinct && this.args.equals(((SetStep)obj).args);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            Ord.forEachIndexed(this.args, (exp, i) -> w.append(i == 0 ? this.op.padded : ", ").append(this.distinct ? "distinct " : "").append((AstNode)exp, Op.EQ.right, 0));
            return w;
        }

        public abstract SetStep copy(boolean var1, List<Exp> var2);
    }

    public static class Distinct
    extends FromStep {
        Distinct(Pos pos) {
            super(pos, Op.DISTINCT);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(" distinct");
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Scan
    extends FromStep {
        public final Pat pat;
        public final @Nullable Exp exp;
        public final @Nullable Exp condition;

        Scan(Pos pos, Pat pat, @Nullable Exp exp, @Nullable Exp condition) {
            super(pos, Op.SCAN);
            this.pat = pat;
            this.exp = exp;
            this.condition = condition;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append(this.op.padded).append(this.pat, 0, 0);
            if (this.exp != null) {
                if (this.exp.op == Op.FROM_EQ) {
                    w.append(" = ").append(((PrefixCall)this.exp).a, Op.EQ.right, 0);
                } else {
                    w.append(" in ").append(this.exp, Op.EQ.right, 0);
                }
            }
            if (this.condition != null) {
                w.append(" on ").append(this.condition, 0, 0);
            }
            return w;
        }

        @Override
        public Scan accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Scan copy(Pat pat, @Nullable Exp exp, @Nullable Exp condition) {
            return this.pat.equals(pat) && Objects.equals(this.exp, exp) && Objects.equals(this.condition, condition) ? this : new Scan(this.pos, pat, exp, condition);
        }
    }

    public static abstract class FromStep
    extends AstNode {
        FromStep(Pos pos, Op op) {
            super(pos, op);
        }
    }

    public static class Forall
    extends Query {
        Forall(Pos pos, ImmutableList<FromStep> steps) {
            super(pos, Op.FORALL, steps);
        }

        @Override
        public Forall copy(List<FromStep> steps) {
            return this.steps.equals(steps) ? this : AstBuilder.ast.forall(this.pos, steps);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Exists
    extends Query {
        Exists(Pos pos, ImmutableList<FromStep> steps) {
            super(pos, Op.EXISTS, steps);
        }

        @Override
        public Exists copy(List<FromStep> steps) {
            return this.steps.equals(steps) ? this : AstBuilder.ast.exists(this.pos, steps);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class From
    extends Query {
        From(Pos pos, ImmutableList<FromStep> steps) {
            super(pos, Op.FROM, steps);
        }

        @Override
        public From copy(List<FromStep> steps) {
            return this.steps.equals(steps) ? this : AstBuilder.ast.from(this.pos, steps);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class Query
    extends Exp {
        public final ImmutableList<FromStep> steps;

        Query(Pos pos, Op op, ImmutableList<FromStep> steps) {
            super(pos, op);
            this.steps = Objects.requireNonNull(steps);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            if (left > this.op.left || this.op.right < right) {
                return w.append("(").append(this, 0, 0).append(")");
            }
            w.append(this.op.lowerName());
            Ord.forEachIndexed(this.steps, (step, i) -> {
                if (step.op == Op.SCAN && i > 0) {
                    if (((FromStep)this.steps.get((int)(i - 1))).op == Op.SCAN) {
                        w.append(",");
                    } else {
                        w.append(" join");
                    }
                }
                step.unparse(w, 0, 0);
            });
            return w;
        }

        public abstract Query copy(List<FromStep> var1);

        public boolean isCompute() {
            return !this.steps.isEmpty() && ((FromStep)this.steps.get((int)(this.steps.size() - 1))).op == Op.COMPUTE;
        }

        public boolean isInto() {
            return !this.steps.isEmpty() && ((FromStep)this.steps.get((int)(this.steps.size() - 1))).op == Op.INTO;
        }
    }

    public static class Case
    extends Exp {
        public final Exp exp;
        public final List<Match> matchList;

        Case(Pos pos, Exp exp, ImmutableList<Match> matchList) {
            super(pos, Op.CASE);
            this.exp = exp;
            this.matchList = matchList;
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("case ").append(this.exp, 0, 0).append(" of ").appendAll(this.matchList, left, Op.BAR, right);
        }

        public Case copy(Exp exp, List<Match> matchList) {
            return this.exp.equals(exp) && this.matchList.equals(matchList) ? this : AstBuilder.ast.caseOf(this.pos, exp, matchList);
        }
    }

    public static class Fn
    extends Exp {
        public final List<Match> matchList;

        Fn(Pos pos, ImmutableList<Match> matchList) {
            super(pos, Op.FN);
            this.matchList = (List)Objects.requireNonNull(matchList);
            Preconditions.checkArgument((!matchList.isEmpty() ? 1 : 0) != 0);
        }

        @Override
        public Fn accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("fn ").appendAll(this.matchList, 0, Op.BAR, right);
        }

        public Fn copy(List<Match> matchList) {
            return this.matchList.equals(matchList) ? this : AstBuilder.ast.fn(this.pos, matchList);
        }
    }

    public static class Match
    extends AstNode {
        public final Pat pat;
        public final Exp exp;

        Match(Pos pos, Pat pat, Exp exp) {
            super(pos, Op.MATCH);
            this.pat = pat;
            this.exp = exp;
        }

        @Override
        public Match accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(this.pat, 0, 0).append(" => ").append(this.exp, 0, right);
        }

        public Match copy(Pat pat, Exp exp) {
            return this.pat.equals(pat) && this.exp.equals(exp) ? this : AstBuilder.ast.match(this.pos, pat, exp);
        }
    }

    public static class ValBind
    extends AstNode {
        public final Pat pat;
        public final Exp exp;

        ValBind(Pos pos, Pat pat, Exp exp) {
            super(pos, Op.VAL_BIND);
            this.pat = pat;
            this.exp = exp;
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(this.pat, 0, 0).append(" = ").append(this.exp, 0, right);
        }

        public ValBind copy(Pat pat, Exp exp) {
            return this.pat.equals(pat) && this.exp.equals(exp) ? this : AstBuilder.ast.valBind(this.pos, pat, exp);
        }
    }

    public static class Let
    extends Exp {
        public final List<Decl> decls;
        public final Exp exp;

        Let(Pos pos, ImmutableList<Decl> decls, Exp exp) {
            super(pos, Op.LET);
            this.decls = (List)Objects.requireNonNull(decls);
            this.exp = Objects.requireNonNull(exp);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendAll(this.decls, "let ", "; ", " in ").append(this.exp, 0, 0).append(" end");
        }

        public Let copy(Iterable<Decl> decls, Exp exp) {
            return Iterables.elementsEqual(this.decls, decls) && Objects.equals(this.exp, exp) ? this : AstBuilder.ast.let(this.pos, decls, exp);
        }
    }

    public static class If
    extends Exp {
        public final Exp condition;
        public final Exp ifTrue;
        public final Exp ifFalse;

        public If(Pos pos, Exp condition, Exp ifTrue, Exp ifFalse) {
            super(pos, Op.IF);
            this.condition = Objects.requireNonNull(condition);
            this.ifTrue = Objects.requireNonNull(ifTrue);
            this.ifFalse = Objects.requireNonNull(ifFalse);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("if ").append(this.condition, 0, 0).append(" then ").append(this.ifTrue, 0, 0).append(" else ").append(this.ifFalse, 0, right);
        }

        public If copy(Exp condition, Exp ifTrue, Exp ifFalse) {
            return this.condition.equals(condition) && this.ifTrue.equals(ifTrue) && this.ifFalse.equals(ifFalse) ? this : new If(this.pos, condition, ifTrue, ifFalse);
        }
    }

    public static class PrefixCall
    extends Exp {
        public final Exp a;

        PrefixCall(Pos pos, Op op, Exp a) {
            super(pos, op);
            this.a = Objects.requireNonNull(a);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            action.accept(this.a, 0);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.prefix(left, this.op, this.a, right);
        }
    }

    public static class InfixCall
    extends Exp {
        public final Exp a0;
        public final Exp a1;

        InfixCall(Pos pos, Op op, Exp a0, Exp a1) {
            super(pos, op);
            this.a0 = Objects.requireNonNull(a0);
            this.a1 = Objects.requireNonNull(a1);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            action.accept(this.a0, 0);
            action.accept(this.a1, 1);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.a0, this.op, this.a1, right);
        }

        public InfixCall copy(Exp a0, Exp a1) {
            return this.a0.equals(a0) && this.a1.equals(a1) ? this : new InfixCall(this.pos, this.op, a0, a1);
        }
    }

    public static class Record
    extends Exp {
        public final @Nullable Exp with;
        public final SortedMap<String, Exp> args;

        Record(Pos pos, @Nullable Exp with, ImmutableSortedMap<String, Exp> args) {
            super(pos, Op.RECORD);
            this.with = with;
            this.args = (SortedMap)Objects.requireNonNull(args);
            Preconditions.checkArgument((args.comparator() == net.hydromatic.morel.type.RecordType.ORDERING ? 1 : 0) != 0);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            Ord.forEachIndexed(this.args.values(), action);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("{");
            if (this.with != null) {
                this.with.unparse(w, 0, 0);
                w.append(" with ");
            }
            Ord.forEachIndexed(this.args, (i, k, v) -> w.append(i > 0 ? ", " : "").append((String)k).append(" = ").append((AstNode)v, 0, 0));
            return w.append("}");
        }

        public Record copy(@Nullable Exp with, Map<String, Exp> args) {
            return Objects.equals(with, this.with) && args.equals(this.args) ? this : AstBuilder.ast.record(this.pos, with, args);
        }
    }

    public static class ListExp
    extends Exp {
        public final List<Exp> args;

        ListExp(Pos pos, Iterable<? extends Exp> args) {
            super(pos, Op.LIST);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            Ord.forEachIndexed(this.args, action);
        }

        @Override
        public ListExp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("[");
            this.forEachArg((arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append("]");
        }

        public ListExp copy(List<Exp> args) {
            return args.equals(this.args) ? this : AstBuilder.ast.list(this.pos, args);
        }
    }

    public static class Tuple
    extends Exp {
        public final List<Exp> args;

        Tuple(Pos pos, Iterable<? extends Exp> args) {
            super(pos, Op.TUPLE);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            Ord.forEachIndexed(this.args, action);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("(");
            this.forEachArg((arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append(")");
        }

        public Tuple copy(List<Exp> args) {
            return this.args.equals(args) ? this : new Tuple(this.pos, args);
        }
    }

    public static class FunMatch
    extends AstNode {
        public final String name;
        public final List<Pat> patList;
        public final @Nullable Type returnType;
        public final Exp exp;

        FunMatch(Pos pos, String name, ImmutableList<Pat> patList, @Nullable Type returnType, Exp exp) {
            super(pos, Op.FUN_MATCH);
            this.name = name;
            this.patList = patList;
            this.returnType = returnType;
            this.exp = exp;
        }

        @Override
        public FunMatch accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.id(this.name);
            for (Pat pat : this.patList) {
                w.append(" ").append(pat, Op.APPLY.left, Op.APPLY.right);
            }
            return w.append(" = ").append(this.exp, 0, right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FunBind
    extends AstNode {
        public final List<FunMatch> matchList;
        public final String name;

        FunBind(Pos pos, ImmutableList<FunMatch> matchList) {
            super(pos, Op.FUN_BIND);
            Preconditions.checkArgument((!matchList.isEmpty() ? 1 : 0) != 0);
            this.matchList = matchList;
            this.name = ((FunMatch)matchList.get((int)0)).name;
        }

        @Override
        public FunBind accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendAll(this.matchList, " | ");
        }
    }

    public static class FunDecl
    extends Decl {
        public final List<FunBind> funBinds;

        FunDecl(Pos pos, ImmutableList<FunBind> funBinds) {
            super(pos, Op.FUN_DECL);
            this.funBinds = (List)Objects.requireNonNull(funBinds);
            Preconditions.checkArgument((!funBinds.isEmpty() ? 1 : 0) != 0);
        }

        public int hashCode() {
            return this.funBinds.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FunDecl && this.funBinds.equals(((FunDecl)o).funBinds);
        }

        @Override
        public Decl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendAll(this.funBinds, "fun ", " and ", "");
        }
    }

    public static class ValDecl
    extends Decl {
        public final boolean rec;
        public final boolean inst;
        public final List<ValBind> valBinds;

        protected ValDecl(Pos pos, boolean rec, boolean inst, ImmutableList<ValBind> valBinds) {
            super(pos, Op.VAL_DECL);
            this.rec = rec;
            this.inst = inst;
            this.valBinds = (List)Objects.requireNonNull(valBinds);
            Preconditions.checkArgument((!valBinds.isEmpty() ? 1 : 0) != 0);
        }

        public int hashCode() {
            return Objects.hash(this.rec, this.valBinds);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ValDecl && this.rec == ((ValDecl)o).rec && this.valBinds.equals(((ValDecl)o).valBinds);
        }

        @Override
        public ValDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            String sep = this.rec ? (this.inst ? "val rec inst " : "val rec ") : (this.inst ? "val inst " : "val ");
            for (ValBind valBind : this.valBinds) {
                w.append(sep);
                sep = " and ";
                valBind.unparse(w, 0, right);
            }
            return w;
        }

        public ValDecl copy(Iterable<ValBind> valBinds) {
            return Iterables.elementsEqual(this.valBinds, valBinds) ? this : AstBuilder.ast.valDecl(this.pos, this.rec, this.inst, valBinds);
        }
    }

    public static class TyCon
    extends AstNode {
        public final Id id;
        public final @Nullable Type type;

        TyCon(Pos pos, Id id, Type type) {
            super(pos, Op.TY_CON);
            this.id = Objects.requireNonNull(id);
            this.type = type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            if (this.type != null) {
                return w.append(this.id, left, this.op.left).append(" of ").append(this.type, this.op.right, right);
            }
            return w.append(this.id, left, right);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }
    }

    public static class DatatypeBind
    extends AstNode {
        public final List<TyVar> tyVars;
        public final Id name;
        public final List<TyCon> tyCons;

        DatatypeBind(Pos pos, ImmutableList<TyVar> tyVars, Id name, ImmutableList<TyCon> tyCons) {
            super(pos, Op.DATATYPE_DECL);
            this.tyVars = (List)Objects.requireNonNull(tyVars);
            this.name = Objects.requireNonNull(name);
            this.tyCons = (List)Objects.requireNonNull(tyCons);
            Preconditions.checkArgument((!this.tyCons.isEmpty() ? 1 : 0) != 0);
        }

        public int hashCode() {
            return Objects.hash(this.tyVars, this.tyCons);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof DatatypeBind && this.name.equals(((DatatypeBind)o).name) && this.tyVars.equals(((DatatypeBind)o).tyVars) && this.tyCons.equals(((DatatypeBind)o).tyCons);
        }

        @Override
        public DatatypeBind accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            switch (this.tyVars.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    w.append(this.tyVars.get(0), 0, 0).append(" ");
                    break;
                }
                default: {
                    w.appendAll(this.tyVars, "(", ", ", ") ");
                }
            }
            return w.id(this.name.name).appendAll(this.tyCons, " = ", " | ", "");
        }
    }

    public static class DatatypeDecl
    extends Decl {
        public final List<DatatypeBind> binds;

        DatatypeDecl(Pos pos, ImmutableList<DatatypeBind> binds) {
            super(pos, Op.DATATYPE_DECL);
            this.binds = (List)Objects.requireNonNull(binds);
            Preconditions.checkArgument((!this.binds.isEmpty() ? 1 : 0) != 0);
        }

        public int hashCode() {
            return Objects.hash(this.binds);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof DatatypeDecl && this.binds.equals(((DatatypeDecl)o).binds);
        }

        @Override
        public DatatypeDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendAll(this.binds, "datatype ", " and ", "");
        }
    }

    public static class OverDecl
    extends Decl {
        public final IdPat pat;

        OverDecl(Pos pos, IdPat pat) {
            super(pos, Op.OVER_DECL);
            this.pat = Objects.requireNonNull(pat);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Op.OVER_DECL, this.pat});
        }

        public boolean equals(Object o) {
            return o == this || o instanceof OverDecl && this.pat.equals(((OverDecl)o).pat);
        }

        @Override
        public OverDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("over ").append(this.pat.name);
        }
    }

    public static abstract class Decl
    extends AstNode {
        Decl(Pos pos, Op op) {
            super(pos, op);
        }

        @Override
        public abstract Decl accept(Shuttle var1);
    }

    public static class Literal
    extends Exp {
        public final Comparable value;

        Literal(Pos pos, Op op, Comparable value) {
            super(pos, op);
            this.value = Objects.requireNonNull(value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Literal && this.value.equals(((Literal)o).value);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendLiteral(this.value);
        }
    }

    public static class RecordSelector
    extends Exp {
        public final String name;

        RecordSelector(Pos pos, String name) {
            super(pos, Op.RECORD_SELECTOR);
            this.name = Objects.requireNonNull(name);
            assert (!name.startsWith("#"));
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Id && this.name.equals(((Id)o).name);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("#").append(this.name);
        }
    }

    public static class Ordinal
    extends Exp {
        Ordinal(Pos pos) {
            super(pos, Op.ORDINAL);
        }

        @Override
        public Ordinal accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id("ordinal");
        }
    }

    public static class Current
    extends Exp {
        Current(Pos pos) {
            super(pos, Op.CURRENT);
        }

        @Override
        public Current accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id("current");
        }
    }

    public static class Id
    extends Exp {
        public final String name;

        Id(Pos pos, String name) {
            super(pos, Op.ID);
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public Id accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.name);
        }
    }

    public static abstract class Exp
    extends AstNode {
        Exp(Pos pos, Op op) {
            super(pos, op);
        }

        public void forEachArg(ObjIntConsumer<Exp> action) {
        }

        @Override
        public abstract Exp accept(Shuttle var1);

        public final List<Exp> args() {
            ImmutableList.Builder args = ImmutableList.builder();
            this.forEachArg((exp, value) -> args.add(exp));
            return args.build();
        }
    }

    public static class FunctionType
    extends Type {
        public final Type paramType;
        public final Type resultType;

        FunctionType(Pos pos, Type paramType, Type resultType) {
            super(pos, Op.FUNCTION_TYPE);
            this.paramType = Objects.requireNonNull(paramType);
            this.resultType = Objects.requireNonNull(resultType);
        }

        @Override
        public Type accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(this.paramType, left, this.op.left).append(" -> ").append(this.resultType, this.op.right, right);
        }
    }

    public static class CompositeType
    extends Type {
        public final List<Type> types;

        CompositeType(Pos pos, ImmutableList<Type> types) {
            super(pos, Op.TUPLE_TYPE);
            this.types = (List)Objects.requireNonNull(types);
        }

        @Override
        public Type accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("(");
            Ord.forEachIndexed(this.types, (arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append(")");
        }
    }

    public static class TupleType
    extends Type {
        public final List<Type> types;

        TupleType(Pos pos, ImmutableList<Type> types) {
            super(pos, Op.TUPLE_TYPE);
            this.types = (List)Objects.requireNonNull(types);
        }

        @Override
        public Type accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            Ord.forEachIndexed(this.types, (arg, i) -> w.append(i == 0 ? "" : " * ").append((AstNode)arg, this.op.left + 1, this.op.right + 1));
            return w;
        }
    }

    public static class RecordType
    extends Type {
        public final Map<String, Type> fieldTypes;

        RecordType(Pos pos, ImmutableMap<String, Type> fieldTypes) {
            super(pos, Op.RECORD_TYPE);
            this.fieldTypes = (Map)Objects.requireNonNull(fieldTypes);
        }

        public int hashCode() {
            return this.fieldTypes.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof RecordType && this.fieldTypes.equals(((RecordType)o).fieldTypes);
        }

        @Override
        public RecordType accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("{");
            Ord.forEachIndexed(this.fieldTypes, (i, field, type) -> w.append(i > 0 ? ", " : "").id((String)field).append(": ").append((AstNode)type, 0, 0));
            return w.append("}");
        }
    }

    public static class TyVar
    extends Type {
        public final String name;

        TyVar(Pos pos, String name) {
            super(pos, Op.TY_VAR);
            this.name = Objects.requireNonNull(name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TyVar && this.name.equals(((TyVar)o).name);
        }

        @Override
        public TyVar accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.name);
        }
    }

    public static class NamedType
    extends Type {
        public final List<Type> types;
        public final String name;

        NamedType(Pos pos, ImmutableList<Type> types, String name) {
            super(pos, Op.NAMED_TYPE);
            this.types = (List)Objects.requireNonNull(types);
            this.name = Objects.requireNonNull(name);
        }

        public int hashCode() {
            return Objects.hash(this.types, this.name);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof NamedType && this.types.equals(((NamedType)obj).types) && this.name.equals(((NamedType)obj).name);
        }

        @Override
        public Type accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            switch (this.types.size()) {
                case 0: {
                    return w.id(this.name);
                }
                case 1: {
                    return w.append(this.types.get(0), left, this.op.left).append(" ").id(this.name);
                }
            }
            w.append("(");
            Ord.forEachIndexed(this.types, (type, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)type, 0, 0));
            return w.append(") ").id(this.name);
        }
    }

    public static class AnnotatedExp
    extends Exp {
        public final Type type;
        public final Exp exp;

        AnnotatedExp(Pos pos, Exp exp, Type type) {
            super(pos, Op.ANNOTATED_EXP);
            this.type = Objects.requireNonNull(type);
            this.exp = Objects.requireNonNull(exp);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.exp);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof AnnotatedExp && this.type.equals(((AnnotatedExp)obj).type) && this.exp.equals(((AnnotatedExp)obj).exp);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.exp, this.op, this.type, right);
        }

        public AnnotatedExp copy(Exp exp, Type type) {
            return this.exp.equals(exp) && this.type.equals(type) ? this : AstBuilder.ast.annotatedExp(this.pos, exp, type);
        }
    }

    public static abstract class Type
    extends AstNode {
        Type(Pos pos, Op op) {
            super(pos, op);
        }

        @Override
        public abstract Type accept(Shuttle var1);
    }

    public static class AnnotatedPat
    extends Pat {
        public final Pat pat;
        public final Type type;

        AnnotatedPat(Pos pos, Pat pat, Type type) {
            super(pos, Op.ANNOTATED_PAT);
            this.pat = pat;
            this.type = type;
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.pat, this.op, this.type, right);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            action.accept(this.pat, 0);
        }

        public AnnotatedPat copy(Pat pat, Type type) {
            return this.pat.equals(pat) && this.type.equals(type) ? this : AstBuilder.ast.annotatedPat(this.pos, pat, type);
        }
    }

    public static class RecordPat
    extends Pat {
        public final boolean ellipsis;
        public final SortedMap<String, Pat> args;

        RecordPat(Pos pos, boolean ellipsis, ImmutableSortedMap<String, Pat> args) {
            super(pos, Op.RECORD_PAT);
            this.ellipsis = ellipsis;
            this.args = (SortedMap)Objects.requireNonNull(args);
            Preconditions.checkArgument((args.comparator() == net.hydromatic.morel.type.RecordType.ORDERING ? 1 : 0) != 0);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            Ord.forEachIndexed(this.args.values(), action);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("{");
            Ord.forEachIndexed(this.args, (i, k, v) -> w.append(i > 0 ? ", " : "").append((String)k).append(" = ").append((AstNode)v, 0, 0));
            if (this.ellipsis) {
                w.append(this.args.isEmpty() ? "..." : ", ...");
            }
            return w.append("}");
        }

        public RecordPat copy(boolean ellipsis, Map<String, ? extends Pat> args) {
            return this.ellipsis == ellipsis && this.args.equals(args) ? this : AstBuilder.ast.recordPat(this.pos, ellipsis, args);
        }
    }

    public static class ListPat
    extends Pat {
        public final List<Pat> args;

        ListPat(Pos pos, ImmutableList<Pat> args) {
            super(pos, Op.LIST_PAT);
            this.args = (List)Objects.requireNonNull(args);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            Ord.forEachIndexed(this.args, action);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("[");
            this.forEachArg((arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append("]");
        }

        public ListPat copy(List<Pat> args) {
            return this.args.equals(args) ? this : AstBuilder.ast.listPat(this.pos, args);
        }
    }

    public static class TuplePat
    extends Pat {
        public final List<Pat> args;

        TuplePat(Pos pos, ImmutableList<Pat> args) {
            super(pos, Op.TUPLE_PAT);
            this.args = (List)Objects.requireNonNull(args);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            Ord.forEachIndexed(this.args, action);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("(");
            this.forEachArg((arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append(")");
        }

        public TuplePat copy(List<Pat> args) {
            return this.args.equals(args) ? this : AstBuilder.ast.tuplePat(this.pos, args);
        }
    }

    public static class Con0Pat
    extends Pat {
        public final Id tyCon;

        Con0Pat(Pos pos, Id tyCon) {
            super(pos, Op.CON0_PAT);
            this.tyCon = Objects.requireNonNull(tyCon);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return this.tyCon.unparse(w, left, right);
        }

        public Con0Pat copy(Id tyCon) {
            return this.tyCon.equals(tyCon) ? this : AstBuilder.ast.con0Pat(this.pos, tyCon);
        }
    }

    public static class AsPat
    extends Pat {
        public final IdPat id;
        public final Pat pat;

        AsPat(Pos pos, IdPat id, Pat pat) {
            super(pos, Op.AS_PAT);
            this.id = Objects.requireNonNull(id);
            this.pat = Objects.requireNonNull(pat);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            action.accept(this.id, 0);
            action.accept(this.pat, 1);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.id, this.op, this.pat, right);
        }

        public AsPat copy(IdPat id, Pat pat) {
            return this.id.equals(id) && this.pat.equals(pat) ? this : AstBuilder.ast.asPat(this.pos, id, pat);
        }
    }

    public static class ConPat
    extends Pat {
        public final Id tyCon;
        public final Pat pat;

        ConPat(Pos pos, Id tyCon, Pat pat) {
            super(pos, Op.CON_PAT);
            this.tyCon = Objects.requireNonNull(tyCon);
            this.pat = Objects.requireNonNull(pat);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            action.accept(this.pat, 0);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.tyCon, this.op, this.pat, right);
        }

        public ConPat copy(Id tyCon, Pat pat) {
            return this.tyCon.equals(tyCon) && this.pat.equals(pat) ? this : AstBuilder.ast.conPat(this.pos, tyCon, pat);
        }
    }

    public static class InfixPat
    extends Pat {
        public final Pat p0;
        public final Pat p1;

        InfixPat(Pos pos, Op op, Pat p0, Pat p1) {
            super(pos, op);
            this.p0 = Objects.requireNonNull(p0);
            this.p1 = Objects.requireNonNull(p1);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachArg(ObjIntConsumer<Pat> action) {
            action.accept(this.p0, 0);
            action.accept(this.p1, 1);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.infix(left, this.p0, this.op, this.p1, right);
        }

        public InfixPat copy(Pat p0, Pat p1) {
            return this.p0.equals(p0) && this.p1.equals(p1) ? this : AstBuilder.ast.infixPat(this.pos, this.op, p0, p1);
        }
    }

    public static class WildcardPat
    extends Pat {
        WildcardPat(Pos pos) {
            super(pos, Op.WILDCARD_PAT);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("_");
        }
    }

    public static class LiteralPat
    extends Pat {
        public final Comparable value;

        LiteralPat(Pos pos, Op op, Comparable value) {
            super(pos, op);
            this.value = Objects.requireNonNull(value);
            Preconditions.checkArgument((op == Op.BOOL_LITERAL_PAT || op == Op.CHAR_LITERAL_PAT || op == Op.INT_LITERAL_PAT || op == Op.REAL_LITERAL_PAT || op == Op.STRING_LITERAL_PAT ? 1 : 0) != 0);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof LiteralPat && this.value.equals(((LiteralPat)o).value);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendLiteral(this.value);
        }
    }

    public static class IdPat
    extends Pat {
        public final String name;

        IdPat(Pos pos, String name) {
            super(pos, Op.ID_PAT);
            this.name = name;
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.name);
        }
    }

    public static abstract class Pat
    extends AstNode {
        Pat(Pos pos, Op op) {
            super(pos, op);
        }

        public void forEachArg(ObjIntConsumer<Pat> action) {
        }

        @Override
        public abstract Pat accept(Shuttle var1);

        public void visit(Consumer<Pat> consumer) {
            consumer.accept(this);
            this.forEachArg((arg, i) -> arg.visit(consumer));
        }
    }
}

