/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.RefChecker;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FromBuilder {
    private final TypeSystem typeSystem;
    private final @Nullable Environment env;
    private final List<Core.FromStep> steps = new ArrayList<Core.FromStep>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private boolean atom;
    private int removeIfNotLastIndex = Integer.MIN_VALUE;
    private int removeIfLastIndex = Integer.MIN_VALUE;

    FromBuilder(TypeSystem typeSystem, @Nullable Environment env) {
        this.typeSystem = typeSystem;
        this.env = env;
    }

    public void clear() {
        this.steps.clear();
        this.bindings.clear();
        this.removeIfNotLastIndex = Integer.MIN_VALUE;
        this.removeIfLastIndex = Integer.MIN_VALUE;
    }

    public String toString() {
        return this.steps.toString();
    }

    public Core.StepEnv stepEnv() {
        return Core.StepEnv.of(this.bindings, this.atom);
    }

    private FromBuilder addStep(Core.FromStep step) {
        if (this.env != null) {
            RefChecker.of(this.typeSystem, this.env.bindAll(this.bindings)).visitStep(step, this.stepEnv());
        }
        if (this.removeIfNotLastIndex == this.steps.size() - 1) {
            this.removeIfNotLastIndex = Integer.MIN_VALUE;
            this.removeIfLastIndex = Integer.MIN_VALUE;
            Core.FromStep lastStep = Static.last(this.steps);
            if (lastStep.op == Op.YIELD) {
                Core.Yield yield = (Core.Yield)lastStep;
                if (yield.exp.op == Op.TUPLE) {
                    Core.Tuple tuple = (Core.Tuple)yield.exp;
                    Core.FromStep previousStep = this.steps.get(this.steps.size() - 2);
                    Core.StepEnv previousEnv = previousStep.env;
                    if (tuple.args.size() == 1 && FromBuilder.isTrivial(tuple, previousEnv, yield.env)) {
                        this.steps.remove(this.steps.size() - 1);
                    }
                }
            }
        }
        this.steps.add(step);
        if (!this.bindings.equals(step.env.bindings)) {
            this.bindings.clear();
            this.bindings.addAll((Collection<Binding>)step.env.bindings);
        }
        this.atom = step.env.atom;
        return this;
    }

    public FromBuilder scan(Core.Pat pat) {
        Core.Exp extent = CoreBuilder.core.extent(this.typeSystem, pat.type, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        return this.scan(pat, extent, CoreBuilder.core.boolLiteral(true));
    }

    public FromBuilder scan(Core.Pat pat, Core.Exp exp) {
        return this.scan(pat, exp, CoreBuilder.core.boolLiteral(true));
    }

    public FromBuilder scan(Core.Pat pat, Core.Exp exp, Core.Exp condition) {
        if (exp.op == Op.FROM && CoreBuilder.core.boolLiteral(true).equals(condition) && FromBuilder.isSimplePat(pat, (Core.From)exp) && !FromBuilder.containsOrdinal(exp)) {
            Core.StepEnv env;
            Core.From from = (Core.From)exp;
            Core.FromStep lastStep = Static.last(from.steps);
            Object steps = lastStep.op == Op.YIELD ? Static.skipLast(from.steps) : from.steps;
            boolean atom1 = this.steps.isEmpty() && lastStep.env.atom;
            PairList<String, Core.Exp> nameExps = PairList.of();
            boolean uselessIfLast = this.bindings.isEmpty();
            if (pat instanceof Core.RecordPat) {
                Core.RecordPat recordPat = (Core.RecordPat)pat;
                this.bindings.forEach(b -> nameExps.add(b.id.name, CoreBuilder.core.id(b.id)));
                Pair.forEach(recordPat.type().argNameTypes.keySet(), recordPat.args, (name, arg) -> nameExps.add((String)name, CoreBuilder.core.id((Core.IdPat)arg)));
                env = null;
            } else if (pat instanceof Core.TuplePat) {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                Pair.forEach(tuplePat.args, lastStep.env.bindings, (arg, binding) -> nameExps.add(((Core.IdPat)arg).name, CoreBuilder.core.id(binding.id)));
                env = null;
            } else if (!this.bindings.isEmpty()) {
                Core.IdPat idPat = (Core.IdPat)pat;
                this.bindings.forEach(b -> nameExps.add(b.id.name, CoreBuilder.core.id(b.id)));
                lastStep.env.bindings.forEach(b -> nameExps.add(idPat.name, CoreBuilder.core.id(b.id)));
                env = null;
            } else {
                Core.IdPat idPat = (Core.IdPat)pat;
                if (lastStep instanceof Core.Yield && ((Core.Yield)lastStep).exp.op != Op.RECORD) {
                    this.addAll((Iterable<? extends Core.FromStep>)steps);
                    if (((Core.Yield)lastStep).exp.op == Op.ID && this.bindings.size() == 1) {
                        return this;
                    }
                    nameExps.add(idPat.name, ((Core.Yield)lastStep).exp);
                    Core.StepEnv env2 = Core.StepEnv.atom(Binding.of(idPat));
                    return this.yield_(false, env2, CoreBuilder.core.record(this.typeSystem, nameExps), atom1);
                }
                Binding binding2 = (Binding)lastStep.env.bindings.get(0);
                nameExps.add(idPat.name, CoreBuilder.core.id(binding2.id));
                env = Core.StepEnv.of(Static.append(this.bindings, Binding.of(idPat)), atom1);
            }
            this.addAll((Iterable<? extends Core.FromStep>)steps);
            return this.yield_(uselessIfLast, env, CoreBuilder.core.record(this.typeSystem, nameExps), atom1);
        }
        Compiles.acceptBinding(this.typeSystem, pat, this.bindings);
        this.atom = this.bindings.size() == 1;
        return this.addStep(CoreBuilder.core.scan(this.stepEnv(), pat, exp, condition));
    }

    private static boolean containsOrdinal(Core.Exp exp) {
        final AtomicBoolean b = new AtomicBoolean();
        exp.accept(new Visitor(){

            @Override
            protected void visit(Core.Apply apply) {
                if (apply.isCallTo(BuiltIn.Z_ORDINAL)) {
                    b.set(true);
                }
                super.visit(apply);
            }
        });
        return b.get();
    }

    private static boolean isSimplePat(Core.Pat pat, Core.From exp) {
        switch (pat.op) {
            case ID_PAT: {
                return !exp.steps.isEmpty() && Static.last(exp.steps).env.bindings.size() == 1;
            }
            case RECORD_PAT: {
                return Static.allMatch(((Core.RecordPat)pat).args, a -> a instanceof Core.IdPat);
            }
            case TUPLE_PAT: {
                return Static.allMatch(((Core.TuplePat)pat).args, a -> a instanceof Core.IdPat);
            }
        }
        return false;
    }

    public FromBuilder addAll(Iterable<? extends Core.FromStep> steps) {
        StepHandler stepHandler = new StepHandler();
        steps.forEach(stepHandler::accept);
        return this;
    }

    public FromBuilder where(Core.Exp condition) {
        if (condition.op == Op.BOOL_LITERAL && ((Core.Literal)condition).unwrap(Boolean.class).booleanValue()) {
            return this;
        }
        return this.addStep(CoreBuilder.core.where(this.stepEnv(), condition));
    }

    public FromBuilder skip(Core.Exp count) {
        if (count.op == Op.INT_LITERAL && ((Core.Literal)count).value.equals(BigDecimal.ZERO)) {
            return this;
        }
        return this.addStep(CoreBuilder.core.skip(this.stepEnv(), count));
    }

    public FromBuilder take(Core.Exp count) {
        return this.addStep(CoreBuilder.core.take(this.stepEnv(), count));
    }

    public FromBuilder except(boolean distinct, List<Core.Exp> args) {
        return this.addStep(CoreBuilder.core.except(this.stepEnv(), distinct, args));
    }

    public FromBuilder intersect(boolean distinct, List<Core.Exp> args) {
        return this.addStep(CoreBuilder.core.intersect(this.stepEnv(), distinct, args));
    }

    public FromBuilder union(boolean distinct, List<Core.Exp> args) {
        return this.addStep(CoreBuilder.core.union(this.stepEnv(), distinct, args));
    }

    public FromBuilder unorder() {
        return this.addStep(CoreBuilder.core.unorder(this.stepEnv()));
    }

    public FromBuilder distinct() {
        ImmutableSortedMap.Builder groupExpsB = ImmutableSortedMap.naturalOrder();
        this.bindings.forEach(b -> groupExpsB.put((Object)((Core.IdPat)b.id), (Object)CoreBuilder.core.id(b.id)));
        return this.addStep(new Core.Group(this.stepEnv(), (ImmutableSortedMap<Core.IdPat, Core.Exp>)groupExpsB.build(), (ImmutableSortedMap<Core.IdPat, Core.Aggregate>)ImmutableSortedMap.of()));
    }

    public FromBuilder group(SortedMap<Core.IdPat, Core.Exp> groupExps, SortedMap<Core.IdPat, Core.Aggregate> aggregates) {
        return this.addStep(CoreBuilder.core.group(groupExps, aggregates));
    }

    public FromBuilder order(Core.Exp exp) {
        return this.addStep(CoreBuilder.core.order(this.stepEnv(), exp));
    }

    public FromBuilder yield_(Core.Exp exp) {
        boolean atom = exp.op != Op.TUPLE || exp.type.op() != Op.RECORD_TYPE;
        return this.yield_(false, exp, atom);
    }

    public FromBuilder yield_(boolean uselessIfLast, Core.Exp exp, boolean atom) {
        return this.yield_(uselessIfLast, null, exp, atom);
    }

    public FromBuilder yield_(boolean uselessIfLast,  @Nullable Core.StepEnv env2, Core.Exp exp, boolean atom) {
        Preconditions.checkArgument((env2 == null || env2.atom == atom ? 1 : 0) != 0);
        boolean uselessIfNotLast = false;
        switch (exp.op) {
            case TUPLE: {
                TupleType tupleType = FromBuilder.tupleType((Core.Tuple)exp, this.stepEnv(), env2);
                switch (tupleType.ordinal()) {
                    case 1: {
                        if (this.bindings.size() == 1) {
                            if (env2 == null) {
                                env2 = Core.StepEnv.of(this.bindings, false);
                            }
                            uselessIfNotLast = true;
                            break;
                        }
                        return this;
                    }
                    case 0: {
                        if (this.bindings.size() != 1) break;
                    }
                }
                break;
            }
            case ID: {
                if (this.bindings.size() != 1 || !((Core.Id)exp).idPat.equals(this.bindings.get((int)0).id) || !this.steps.isEmpty() && Static.last(this.steps).op == Op.YIELD && ((Core.Yield)Static.last(this.steps)).exp.op == Op.TUPLE) break;
                return this;
            }
        }
        Core.Yield step = env2 != null ? CoreBuilder.core.yield_(env2, exp) : CoreBuilder.core.yield_(this.typeSystem, exp, atom);
        this.addStep(step);
        this.removeIfNotLastIndex = uselessIfNotLast ? this.steps.size() - 1 : Integer.MIN_VALUE;
        this.removeIfLastIndex = uselessIfLast ? this.steps.size() - 1 : Integer.MIN_VALUE;
        return this;
    }

    private static boolean isTrivial(Core.Tuple tuple, Core.StepEnv env,  @Nullable Core.StepEnv env2) {
        return FromBuilder.tupleType(tuple, env, env2) == TupleType.IDENTITY;
    }

    private static TupleType tupleType(Core.Tuple tuple, Core.StepEnv env,  @Nullable Core.StepEnv env2) {
        if (tuple.args.size() != env.bindings.size()) {
            return TupleType.OTHER;
        }
        boolean identity = env2 == null || env.bindings.equals(env2.bindings);
        for (Pair<Core.Exp, String> argName : Pair.zip(tuple.args, tuple.type().argNames())) {
            Core.Exp arg = (Core.Exp)argName.left;
            String name = (String)argName.right;
            if (arg.op != Op.ID) {
                return TupleType.OTHER;
            }
            if (((Core.Id)arg).idPat.name.equals(name)) continue;
            identity = false;
        }
        return identity ? TupleType.IDENTITY : TupleType.RENAME;
    }

    private Core.Exp build(boolean simplify) {
        if (this.removeIfLastIndex == this.steps.size() - 1) {
            this.removeIfLastIndex = Integer.MIN_VALUE;
            Core.Yield yield = (Core.Yield)Static.last(this.steps);
            if (yield.exp.op != Op.TUPLE || ((Core.Tuple)yield.exp).args.size() != 1) {
                throw new AssertionError(yield.exp);
            }
            this.steps.remove(this.steps.size() - 1);
        }
        if (simplify && this.steps.size() == 1 && this.steps.get((int)0).op == Op.SCAN) {
            Core.Scan scan = (Core.Scan)this.steps.get(0);
            if (scan.pat.op == Op.ID_PAT) {
                return scan.exp;
            }
        }
        return CoreBuilder.core.from(this.typeSystem, this.steps);
    }

    public Core.From build() {
        return (Core.From)this.build(false);
    }

    public Core.Exp buildSimplify() {
        return this.build(true);
    }

    private class StepHandler
    extends Visitor {
        private StepHandler() {
        }

        @Override
        protected void visit(Core.Except except) {
            FromBuilder.this.except(except.distinct, (List<Core.Exp>)except.args);
        }

        @Override
        protected void visit(Core.Group group) {
            FromBuilder.this.group(group.groupExps, group.aggregates);
        }

        @Override
        protected void visit(Core.Intersect intersect) {
            FromBuilder.this.intersect(intersect.distinct, (List<Core.Exp>)intersect.args);
        }

        @Override
        protected void visit(Core.Order order) {
            FromBuilder.this.order(order.exp);
        }

        @Override
        protected void visit(Core.Scan scan) {
            FromBuilder.this.scan(scan.pat, scan.exp, scan.condition);
        }

        @Override
        protected void visit(Core.Where where) {
            FromBuilder.this.where(where.exp);
        }

        @Override
        protected void visit(Core.Skip skip) {
            FromBuilder.this.skip(skip.exp);
        }

        @Override
        protected void visit(Core.Take take) {
            FromBuilder.this.take(take.exp);
        }

        @Override
        protected void visit(Core.Union union) {
            FromBuilder.this.union(union.distinct, (List<Core.Exp>)union.args);
        }

        @Override
        protected void visit(Core.Unorder unorder) {
            FromBuilder.this.unorder();
        }

        @Override
        protected void visit(Core.Yield yield) {
            FromBuilder.this.yield_(false, yield.env, yield.exp, yield.env.atom);
        }
    }

    private static enum TupleType {
        RENAME,
        IDENTITY,
        OTHER;

    }
}

