/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Op
extends Enum<Op> {
    public static final /* enum */ Op ID = new Op(true);
    public static final /* enum */ Op CURRENT = new Op(" current ", 99, 99);
    public static final /* enum */ Op ORDINAL = new Op(" ordinal ", 99, 99);
    public static final /* enum */ Op RECORD_SELECTOR = new Op(true);
    public static final /* enum */ Op BOOL_LITERAL = new Op(true);
    public static final /* enum */ Op CHAR_LITERAL = new Op(true);
    public static final /* enum */ Op INT_LITERAL = new Op(true);
    public static final /* enum */ Op REAL_LITERAL = new Op(true);
    public static final /* enum */ Op STRING_LITERAL = new Op(true);
    public static final /* enum */ Op UNIT_LITERAL = new Op(true);
    public static final /* enum */ Op FN_LITERAL = new Op(true);
    public static final /* enum */ Op VALUE_LITERAL = new Op(true);
    public static final /* enum */ Op INTERNAL_LITERAL = new Op(true);
    public static final /* enum */ Op ID_PAT = new Op(true);
    public static final /* enum */ Op WILDCARD_PAT = new Op();
    public static final /* enum */ Op AS_PAT = new Op(" as ");
    public static final /* enum */ Op CON_PAT = new Op(" ");
    public static final /* enum */ Op CON0_PAT = new Op(" ");
    public static final /* enum */ Op TUPLE_PAT = new Op(true);
    public static final /* enum */ Op RECORD_PAT = new Op();
    public static final /* enum */ Op LIST_PAT = new Op();
    public static final /* enum */ Op CONS_PAT = new Op(" :: ");
    public static final /* enum */ Op BOOL_LITERAL_PAT = new Op(true);
    public static final /* enum */ Op CHAR_LITERAL_PAT = new Op(true);
    public static final /* enum */ Op INT_LITERAL_PAT = new Op(true);
    public static final /* enum */ Op REAL_LITERAL_PAT = new Op(true);
    public static final /* enum */ Op STRING_LITERAL_PAT = new Op(true);
    public static final /* enum */ Op ANNOTATED_PAT = new Op(" : ");
    public static final /* enum */ Op BAR = new Op(" | ");
    public static final /* enum */ Op COMMA = new Op(",");
    public static final /* enum */ Op FUN_BIND = new Op(" and ");
    public static final /* enum */ Op FUN_MATCH = new Op();
    public static final /* enum */ Op TY_CON = new Op();
    public static final /* enum */ Op DATATYPE_DECL = new Op();
    public static final /* enum */ Op DATATYPE_BIND = new Op();
    public static final /* enum */ Op FUN_DECL = new Op();
    public static final /* enum */ Op VAL_DECL = new Op(" = ");
    public static final /* enum */ Op REC_VAL_DECL = new Op(" = ");
    public static final /* enum */ Op FROM_EQ = new Op("$FROM_EQ ");
    public static final /* enum */ Op TUPLE = new Op(true);
    public static final /* enum */ Op LIST = new Op(" list", 8);
    public static final /* enum */ Op RECORD = new Op(true);
    public static final /* enum */ Op FN = new Op(" -> ", 6, false);
    public static final /* enum */ Op TY_VAR = new Op(true);
    public static final /* enum */ Op RECORD_TYPE = new Op(true);
    public static final /* enum */ Op PROGRESSIVE_RECORD_TYPE = new Op(true);
    public static final /* enum */ Op DATA_TYPE = new Op(" ", 8);
    public static final /* enum */ Op DUMMY_TYPE = new Op(true);
    public static final /* enum */ Op APPLY_TYPE = new Op(" ", 8);
    public static final /* enum */ Op TUPLE_TYPE = new Op(" * ", 7);
    public static final /* enum */ Op COMPOSITE_TYPE = new Op();
    public static final /* enum */ Op FUNCTION_TYPE = new Op(" -> ", 6, false);
    public static final /* enum */ Op NAMED_TYPE = new Op(" ", 8);
    public static final /* enum */ Op FORALL_TYPE = new Op();
    public static final /* enum */ Op MULTI_TYPE = new Op();
    public static final /* enum */ Op ANNOTATED_EXP = new Op(" : ", 0);
    public static final /* enum */ Op TIMES = new Op(" * ", 7);
    public static final /* enum */ Op DIVIDE = new Op(" / ", 7);
    public static final /* enum */ Op DIV = new Op(" div ", 7);
    public static final /* enum */ Op MOD = new Op(" mod ", 7);
    public static final /* enum */ Op PLUS = new Op(" + ", 6);
    public static final /* enum */ Op MINUS = new Op(" - ", 6);
    public static final /* enum */ Op CARET = new Op(" ^ ", 6);
    public static final /* enum */ Op NEGATE = new Op("~ ");
    public static final /* enum */ Op CONS = new Op(" :: ", 5, false);
    public static final /* enum */ Op AT = new Op(" @ ", 5, false);
    public static final /* enum */ Op LE = new Op(" <= ", 4);
    public static final /* enum */ Op LT = new Op(" < ", 4);
    public static final /* enum */ Op GE = new Op(" >= ", 4);
    public static final /* enum */ Op GT = new Op(" > ", 4);
    public static final /* enum */ Op EQ = new Op(" = ", 4);
    public static final /* enum */ Op NE = new Op(" <> ", 4);
    public static final /* enum */ Op ELEM = new Op(" elem ", 4);
    public static final /* enum */ Op NOT_ELEM = new Op(" notelem ", 4);
    public static final /* enum */ Op ASSIGN = new Op(" := ", 3);
    public static final /* enum */ Op COMPOSE = new Op(" o ", 3);
    public static final /* enum */ Op ANDALSO = new Op(" andalso ", 2);
    public static final /* enum */ Op ORELSE = new Op(" orelse ", 1);
    public static final /* enum */ Op IMPLIES = new Op(" implies ", 0);
    public static final /* enum */ Op BEFORE = new Op(" before ", 0);
    public static final /* enum */ Op LET = new Op();
    public static final /* enum */ Op LOCAL = new Op();
    public static final /* enum */ Op MATCH = new Op();
    public static final /* enum */ Op VAL_BIND = new Op();
    public static final /* enum */ Op APPLY = new Op(" ", 8);
    public static final /* enum */ Op CASE = new Op();
    public static final /* enum */ Op FROM = new Op();
    public static final /* enum */ Op EXISTS = new Op();
    public static final /* enum */ Op FORALL = new Op();
    public static final /* enum */ Op SCAN = new Op(" ");
    public static final /* enum */ Op DISTINCT = new Op();
    public static final /* enum */ Op WHERE = new Op();
    public static final /* enum */ Op GROUP = new Op();
    public static final /* enum */ Op COMPUTE = new Op();
    public static final /* enum */ Op ORDER = new Op();
    public static final /* enum */ Op ORDER_ITEM = new Op();
    public static final /* enum */ Op REQUIRE = new Op();
    public static final /* enum */ Op SKIP = new Op();
    public static final /* enum */ Op TAKE = new Op();
    public static final /* enum */ Op UNORDER = new Op();
    public static final /* enum */ Op EXCEPT = new Op(" except ");
    public static final /* enum */ Op INTERSECT = new Op(" intersect ");
    public static final /* enum */ Op UNION = new Op(" union ");
    public static final /* enum */ Op YIELD = new Op();
    public static final /* enum */ Op INTO = new Op();
    public static final /* enum */ Op THROUGH = new Op();
    public static final /* enum */ Op AGGREGATE = new Op();
    public static final /* enum */ Op IF = new Op();
    public static final /* enum */ Op OVER_DECL = new Op();
    public final String padded;
    public final int left;
    public final int right;
    public final @Nullable String opName;
    public static final ImmutableMap<String, Op> BY_OP_NAME;
    private static final /* synthetic */ Op[] $VALUES;

    public static Op[] values() {
        return (Op[])$VALUES.clone();
    }

    public static Op valueOf(String name) {
        return Enum.valueOf(Op.class, name);
    }

    private Op() {
        this("", 0, 0);
    }

    private Op(boolean atom) {
        this("", 99);
        assert (atom);
    }

    private Op(String padded) {
        this(padded, 0, 0);
    }

    private Op(String padded, int leftPrecedence) {
        this(padded, leftPrecedence, true);
    }

    private Op(String padded, int precedence, boolean leftAssociative) {
        this(padded, precedence * 2 + (leftAssociative ? 0 : 1), precedence * 2 + (leftAssociative ? 1 : 0));
    }

    private Op(String padded, int left, int right) {
        this.padded = Objects.requireNonNull(padded);
        this.left = left;
        this.right = right;
        this.opName = padded.isEmpty() ? null : "op " + padded.trim();
    }

    public String lowerName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Op toPat() {
        switch (this.ordinal()) {
            case 4: {
                return BOOL_LITERAL_PAT;
            }
            case 5: {
                return CHAR_LITERAL_PAT;
            }
            case 6: {
                return INT_LITERAL_PAT;
            }
            case 7: {
                return REAL_LITERAL_PAT;
            }
            case 8: {
                return STRING_LITERAL_PAT;
            }
            case 39: {
                return TUPLE_PAT;
            }
        }
        throw new AssertionError((Object)("unknown op " + (Object)((Object)this)));
    }

    private static /* synthetic */ Op[] $values() {
        return new Op[]{ID, CURRENT, ORDINAL, RECORD_SELECTOR, BOOL_LITERAL, CHAR_LITERAL, INT_LITERAL, REAL_LITERAL, STRING_LITERAL, UNIT_LITERAL, FN_LITERAL, VALUE_LITERAL, INTERNAL_LITERAL, ID_PAT, WILDCARD_PAT, AS_PAT, CON_PAT, CON0_PAT, TUPLE_PAT, RECORD_PAT, LIST_PAT, CONS_PAT, BOOL_LITERAL_PAT, CHAR_LITERAL_PAT, INT_LITERAL_PAT, REAL_LITERAL_PAT, STRING_LITERAL_PAT, ANNOTATED_PAT, BAR, COMMA, FUN_BIND, FUN_MATCH, TY_CON, DATATYPE_DECL, DATATYPE_BIND, FUN_DECL, VAL_DECL, REC_VAL_DECL, FROM_EQ, TUPLE, LIST, RECORD, FN, TY_VAR, RECORD_TYPE, PROGRESSIVE_RECORD_TYPE, DATA_TYPE, DUMMY_TYPE, APPLY_TYPE, TUPLE_TYPE, COMPOSITE_TYPE, FUNCTION_TYPE, NAMED_TYPE, FORALL_TYPE, MULTI_TYPE, ANNOTATED_EXP, TIMES, DIVIDE, DIV, MOD, PLUS, MINUS, CARET, NEGATE, CONS, AT, LE, LT, GE, GT, EQ, NE, ELEM, NOT_ELEM, ASSIGN, COMPOSE, ANDALSO, ORELSE, IMPLIES, BEFORE, LET, LOCAL, MATCH, VAL_BIND, APPLY, CASE, FROM, EXISTS, FORALL, SCAN, DISTINCT, WHERE, GROUP, COMPUTE, ORDER, ORDER_ITEM, REQUIRE, SKIP, TAKE, UNORDER, EXCEPT, INTERSECT, UNION, YIELD, INTO, THROUGH, AGGREGATE, IF, OVER_DECL};
    }

    static {
        $VALUES = Op.$values();
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Op op : Op.values()) {
            if (op.opName == null || !op.opName.startsWith("op ") || op.opName.equals("op ") || op.name().endsWith("_TYPE") || op.name().endsWith("_PAT") || op.name().endsWith("_DECL")) continue;
            b.put((Object)op.opName, (Object)op);
        }
        BY_OP_NAME = b.build();
    }
}

