/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.PairList;

public class Shuttle {
    protected final TypeSystem typeSystem;

    public Shuttle(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    protected <E extends AstNode> List<E> visitList(List<E> nodes) {
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        for (AstNode node : nodes) {
            list.add(node.accept(this));
        }
        return list;
    }

    protected <K, E extends AstNode> Map<K, E> visitMap(Map<K, E> nodes) {
        LinkedHashMap map = new LinkedHashMap();
        nodes.forEach((k, v) -> map.put(k, v.accept(this)));
        return map;
    }

    protected <K, E extends AstNode> SortedMap<K, E> visitSortedMap(SortedMap<K, E> nodes) {
        TreeMap map = new TreeMap(nodes.comparator());
        nodes.forEach((k, v) -> map.put(k, v.accept(this)));
        return map;
    }

    protected Ast.Exp visit(Ast.Literal literal) {
        return literal;
    }

    protected Ast.Id visit(Ast.Id id) {
        return id;
    }

    protected Ast.Current visit(Ast.Current current) {
        return current;
    }

    protected Ast.Ordinal visit(Ast.Ordinal ordinal) {
        return ordinal;
    }

    protected Ast.Exp visit(Ast.AnnotatedExp annotatedExp) {
        return AstBuilder.ast.annotatedExp(annotatedExp.pos, annotatedExp.exp.accept(this), annotatedExp.type.accept(this));
    }

    protected Ast.Exp visit(Ast.If ifThenElse) {
        return AstBuilder.ast.ifThenElse(ifThenElse.pos, ifThenElse.condition.accept(this), ifThenElse.ifTrue.accept(this), ifThenElse.ifFalse.accept(this));
    }

    protected Ast.Let visit(Ast.Let let) {
        return AstBuilder.ast.let(let.pos, this.visitList(let.decls), let.exp);
    }

    protected Ast.Exp visit(Ast.Case caseOf) {
        return AstBuilder.ast.caseOf(caseOf.pos, caseOf.exp.accept(this), this.visitList(caseOf.matchList));
    }

    protected Ast.Exp visit(Ast.InfixCall infixCall) {
        return AstBuilder.ast.infixCall(infixCall.pos, infixCall.op, infixCall.a0.accept(this), infixCall.a1.accept(this));
    }

    protected Ast.Exp visit(Ast.PrefixCall prefixCall) {
        return AstBuilder.ast.prefixCall(prefixCall.pos, prefixCall.op, prefixCall.a.accept(this));
    }

    protected Ast.Pat visit(Ast.IdPat idPat) {
        return idPat;
    }

    protected Ast.Pat visit(Ast.LiteralPat literalPat) {
        return literalPat;
    }

    protected Ast.Pat visit(Ast.WildcardPat wildcardPat) {
        return wildcardPat;
    }

    protected Ast.Pat visit(Ast.InfixPat infixPat) {
        return infixPat.copy(infixPat.p0.accept(this), infixPat.p1.accept(this));
    }

    protected Ast.Pat visit(Ast.TuplePat tuplePat) {
        return tuplePat.copy(this.visitList(tuplePat.args));
    }

    protected Ast.Pat visit(Ast.ListPat listPat) {
        return listPat.copy(this.visitList(listPat.args));
    }

    protected Ast.Pat visit(Ast.RecordPat recordPat) {
        return recordPat.copy(recordPat.ellipsis, this.visitMap(recordPat.args));
    }

    protected Ast.Pat visit(Ast.AnnotatedPat annotatedPat) {
        return annotatedPat.copy(annotatedPat.pat.accept(this), annotatedPat.type.accept(this));
    }

    protected Ast.Pat visit(Ast.AsPat asPat) {
        return asPat.copy((Ast.IdPat)asPat.id.accept(this), asPat.pat.accept(this));
    }

    protected Ast.ConPat visit(Ast.ConPat conPat) {
        return conPat.copy(conPat.tyCon.accept(this), conPat.pat.accept(this));
    }

    protected Ast.Con0Pat visit(Ast.Con0Pat con0Pat) {
        return con0Pat.copy(con0Pat.tyCon.accept(this));
    }

    protected Ast.Exp visit(Ast.Tuple tuple) {
        return AstBuilder.ast.tuple(tuple.pos, this.visitList(tuple.args));
    }

    protected Ast.ListExp visit(Ast.ListExp list) {
        return AstBuilder.ast.list(list.pos, this.visitList(list.args));
    }

    protected Ast.Exp visit(Ast.Record record) {
        return AstBuilder.ast.record(record.pos, record.with == null ? null : record.with.accept(this), this.visitMap(record.args));
    }

    protected Ast.Fn visit(Ast.Fn fn) {
        return AstBuilder.ast.fn(fn.pos, this.visitList(fn.matchList));
    }

    protected Ast.Apply visit(Ast.Apply apply) {
        return AstBuilder.ast.apply(apply.fn.accept(this), apply.arg.accept(this));
    }

    protected Ast.Exp visit(Ast.RecordSelector recordSelector) {
        return recordSelector;
    }

    protected Ast.Match visit(Ast.Match match) {
        return AstBuilder.ast.match(match.pos, match.pat.accept(this), match.exp.accept(this));
    }

    protected Ast.Type visit(Ast.NamedType namedType) {
        return namedType;
    }

    protected Ast.TyVar visit(Ast.TyVar tyVar) {
        return tyVar;
    }

    protected Ast.OverDecl visit(Ast.OverDecl overDecl) {
        return AstBuilder.ast.overDecl(overDecl.pos, overDecl.pat);
    }

    protected Ast.Decl visit(Ast.FunDecl funDecl) {
        return AstBuilder.ast.funDecl(funDecl.pos, this.visitList(funDecl.funBinds));
    }

    protected Ast.FunBind visit(Ast.FunBind funBind) {
        return AstBuilder.ast.funBind(funBind.pos, this.visitList(funBind.matchList));
    }

    protected Ast.FunMatch visit(Ast.FunMatch funMatch) {
        return AstBuilder.ast.funMatch(funMatch.pos, funMatch.name, this.visitList(funMatch.patList), funMatch.returnType == null ? null : funMatch.returnType.accept(this), funMatch.exp.accept(this));
    }

    protected Ast.ValDecl visit(Ast.ValDecl valDecl) {
        return AstBuilder.ast.valDecl(valDecl.pos, valDecl.rec, valDecl.inst, this.visitList(valDecl.valBinds));
    }

    protected Ast.ValBind visit(Ast.ValBind valBind) {
        return AstBuilder.ast.valBind(valBind.pos, valBind.pat, valBind.exp);
    }

    protected Ast.Exp visit(Ast.From from) {
        return AstBuilder.ast.from(from.pos, (List<Ast.FromStep>)from.steps);
    }

    protected Ast.Exp visit(Ast.Exists exists) {
        return AstBuilder.ast.exists(exists.pos, (List<Ast.FromStep>)exists.steps);
    }

    protected Ast.Exp visit(Ast.Forall forall) {
        return AstBuilder.ast.forall(forall.pos, (List<Ast.FromStep>)forall.steps);
    }

    protected AstNode visit(Ast.Order order) {
        return AstBuilder.ast.order(order.pos, order.exp);
    }

    protected Ast.Scan visit(Ast.Scan scan) {
        return AstBuilder.ast.scan(scan.pos, scan.pat.accept(this), scan.exp.accept(this), scan.condition == null ? null : scan.condition.accept(this));
    }

    protected AstNode visit(Ast.Where where) {
        return AstBuilder.ast.where(where.pos, where.exp.accept(this));
    }

    protected AstNode visit(Ast.Distinct distinct) {
        return distinct;
    }

    protected AstNode visit(Ast.Require require) {
        return AstBuilder.ast.require(require.pos, require.exp.accept(this));
    }

    protected AstNode visit(Ast.Skip skip) {
        return AstBuilder.ast.skip(skip.pos, skip.exp.accept(this));
    }

    protected AstNode visit(Ast.Take take) {
        return AstBuilder.ast.take(take.pos, take.exp.accept(this));
    }

    protected AstNode visit(Ast.Except except) {
        return except.copy(except.distinct, this.visitList((List)except.args));
    }

    protected AstNode visit(Ast.Intersect intersect) {
        return intersect.copy(intersect.distinct, this.visitList((List)intersect.args));
    }

    protected AstNode visit(Ast.Union union) {
        return union.copy(union.distinct, this.visitList((List)union.args));
    }

    protected AstNode visit(Ast.Unorder unorder) {
        return unorder;
    }

    protected AstNode visit(Ast.Yield yield) {
        return AstBuilder.ast.yield(yield.pos, yield.exp.accept(this));
    }

    protected AstNode visit(Ast.Into into) {
        return AstBuilder.ast.into(into.pos, into.exp);
    }

    protected AstNode visit(Ast.Through through) {
        return AstBuilder.ast.through(through.pos, through.pat, through.exp);
    }

    protected AstNode visit(Ast.Compute compute) {
        return AstBuilder.ast.compute(compute.pos, (List<Ast.Aggregate>)compute.aggregates);
    }

    protected AstNode visit(Ast.Group group) {
        return AstBuilder.ast.group(group.pos, (PairList<Ast.Id, Ast.Exp>)group.groupExps, (List<Ast.Aggregate>)group.aggregates);
    }

    protected AstNode visit(Ast.Aggregate aggregate) {
        return AstBuilder.ast.aggregate(aggregate.pos, aggregate.aggregate, aggregate.argument, aggregate.id);
    }

    protected Ast.DatatypeDecl visit(Ast.DatatypeDecl datatypeDecl) {
        return AstBuilder.ast.datatypeDecl(datatypeDecl.pos, this.visitList(datatypeDecl.binds));
    }

    protected Ast.DatatypeBind visit(Ast.DatatypeBind datatypeBind) {
        return AstBuilder.ast.datatypeBind(datatypeBind.pos, datatypeBind.name.accept(this), this.visitList(datatypeBind.tyVars), this.visitList(datatypeBind.tyCons));
    }

    protected AstNode visit(Ast.TyCon tyCon) {
        return AstBuilder.ast.typeConstructor(tyCon.pos, tyCon.id.accept(this), tyCon.type == null ? null : tyCon.type.accept(this));
    }

    protected Ast.RecordType visit(Ast.RecordType recordType) {
        return AstBuilder.ast.recordType(recordType.pos, this.visitMap(recordType.fieldTypes));
    }

    protected Ast.Type visit(Ast.TupleType tupleType) {
        return AstBuilder.ast.tupleType(tupleType.pos, this.visitList(tupleType.types));
    }

    protected Ast.Type visit(Ast.FunctionType functionType) {
        return AstBuilder.ast.functionType(functionType.pos, functionType.paramType, functionType.resultType);
    }

    protected Ast.Type visit(Ast.CompositeType compositeType) {
        return AstBuilder.ast.compositeType(compositeType.pos, this.visitList(compositeType.types));
    }

    protected Core.Exp visit(Core.Apply apply) {
        return apply.copy(apply.fn.accept(this), apply.arg.accept(this));
    }

    protected Core.Exp visit(Core.Id id) {
        return id;
    }

    protected Core.RecordSelector visit(Core.RecordSelector recordSelector) {
        return recordSelector;
    }

    protected Core.Exp visit(Core.Literal literal) {
        return literal;
    }

    protected Core.Exp visit(Core.Tuple tuple) {
        return tuple.copy(this.typeSystem, this.visitList(tuple.args));
    }

    protected Core.Exp visit(Core.Let let) {
        return let.copy(let.decl.accept(this), let.exp.accept(this));
    }

    protected Core.Exp visit(Core.Local local) {
        return local.copy(local.dataType, local.exp.accept(this));
    }

    protected Core.DatatypeDecl visit(Core.DatatypeDecl datatypeDecl) {
        return datatypeDecl;
    }

    protected Core.NonRecValDecl visit(Core.NonRecValDecl valDecl) {
        return valDecl.copy(valDecl.pat.accept(this), valDecl.exp.accept(this), valDecl.overloadPat == null ? null : valDecl.overloadPat.accept(this));
    }

    protected Core.RecValDecl visit(Core.RecValDecl valDecl) {
        return valDecl.copy(this.visitList((List)valDecl.list));
    }

    protected Core.IdPat visit(Core.IdPat idPat) {
        return idPat;
    }

    protected Core.AsPat visit(Core.AsPat asPat) {
        return asPat.copy(asPat.name, asPat.i, asPat.pat.accept(this));
    }

    protected Core.Pat visit(Core.LiteralPat literalPat) {
        return literalPat;
    }

    protected Core.Pat visit(Core.WildcardPat wildcardPat) {
        return wildcardPat;
    }

    protected Core.Pat visit(Core.ConPat conPat) {
        return conPat.copy(conPat.tyCon, conPat.pat.accept(this));
    }

    protected Core.Pat visit(Core.Con0Pat con0Pat) {
        return con0Pat;
    }

    protected Core.Pat visit(Core.TuplePat tuplePat) {
        return tuplePat.copy(this.typeSystem, this.visitList(tuplePat.args));
    }

    protected Core.Pat visit(Core.ListPat listPat) {
        return listPat.copy(this.typeSystem, this.visitList(listPat.args));
    }

    protected Core.Pat visit(Core.RecordPat recordPat) {
        return recordPat.copy(this.typeSystem, recordPat.type().argNameTypes.keySet(), this.visitList(recordPat.args));
    }

    protected Core.Exp visit(Core.Fn fn) {
        return fn.copy(fn.idPat.accept(this), fn.exp.accept(this));
    }

    protected Core.Exp visit(Core.Case caseOf) {
        return caseOf.copy(caseOf.exp.accept(this), this.visitList(caseOf.matchList));
    }

    protected Core.Match visit(Core.Match match) {
        return match.copy(match.pat.accept(this), match.exp.accept(this));
    }

    protected Core.Exp visit(Core.From from) {
        return from.copy(this.typeSystem, null, this.visitList((List)from.steps));
    }

    protected Core.Scan visit(Core.Scan scan) {
        return scan.copy(scan.env, scan.pat.accept(this), scan.exp.accept(this), scan.condition.accept(this));
    }

    protected Core.Where visit(Core.Where where) {
        return where.copy(where.exp.accept(this), where.env);
    }

    protected Core.Skip visit(Core.Skip skip) {
        return skip.copy(skip.exp.accept(this), skip.env);
    }

    protected Core.Take visit(Core.Take take) {
        return take.copy(take.exp.accept(this), take.env);
    }

    protected Core.Except visit(Core.Except except) {
        return except.copy(except.distinct, this.visitList((List)except.args), except.env);
    }

    protected Core.Intersect visit(Core.Intersect intersect) {
        return intersect.copy(intersect.distinct, this.visitList((List)intersect.args), intersect.env);
    }

    protected Core.Union visit(Core.Union union) {
        return union.copy(union.distinct, this.visitList((List)union.args), union.env);
    }

    protected Core.Group visit(Core.Group group) {
        return group.copy(this.visitSortedMap(group.groupExps), this.visitSortedMap(group.aggregates));
    }

    protected Core.Aggregate visit(Core.Aggregate aggregate) {
        return aggregate.copy(aggregate.type, aggregate.aggregate.accept(this), aggregate.argument == null ? null : aggregate.argument.accept(this));
    }

    protected Core.Order visit(Core.Order order) {
        return order.copy(order.env, order.exp.accept(this));
    }

    protected Core.Yield visit(Core.Yield yield) {
        return yield.copy(yield.env, yield.exp.accept(this));
    }

    protected Core.Unorder visit(Core.Unorder unorder) {
        return unorder;
    }

    protected Core.OverDecl visit(Core.OverDecl overDecl) {
        return overDecl;
    }
}

