/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.Analyzer;
import net.hydromatic.morel.compile.CalciteCompiler;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.CompiledStatement;
import net.hydromatic.morel.compile.Compiler;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.compile.Extents;
import net.hydromatic.morel.compile.Inliner;
import net.hydromatic.morel.compile.PatternCoverageChecker;
import net.hydromatic.morel.compile.Relationalizer;
import net.hydromatic.morel.compile.Resolver;
import net.hydromatic.morel.compile.SuchThatShuttle;
import net.hydromatic.morel.compile.Tracer;
import net.hydromatic.morel.compile.TypeResolver;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.foreign.Calcite;
import net.hydromatic.morel.foreign.DataSet;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.TypeSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Compiles {
    public static TypeResolver.Resolved validateExpression(AstNode statement, Map<Prop, Object> propMap, Map<String, ForeignValue> valueMap, Consumer<CompileException> warningConsumer) {
        TypeSystem typeSystem = new TypeSystem();
        Session session = new Session(propMap);
        Environment env = Environments.env(typeSystem, session, valueMap);
        return TypeResolver.deduceType(env, Compiles.toDecl(statement), typeSystem, warningConsumer);
    }

    public static CompiledStatement prepareStatement(TypeSystem typeSystem, Session session, Environment env, AstNode statement, @Nullable Calcite calcite, Consumer<CompileException> warningConsumer, Tracer tracer) {
        Ast.Decl decl = statement instanceof Ast.Exp ? Compiles.toValDecl((Ast.Exp)statement) : (Ast.Decl)statement;
        return Compiles.prepareDecl(typeSystem, session, env, calcite, decl, warningConsumer, tracer);
    }

    private static CompiledStatement prepareDecl(TypeSystem typeSystem, Session session, Environment env, @Nullable Calcite calcite, Ast.Decl decl, Consumer<CompileException> warningConsumer, Tracer tracer) {
        Compiler compiler;
        Core.Decl coreDecl;
        TypeResolver.Resolved resolved = TypeResolver.deduceType(env, decl, typeSystem, warningConsumer);
        boolean hybrid = Prop.HYBRID.booleanValue(session.map);
        int inlinePassCount = Math.max(Prop.INLINE_PASS_COUNT.intValue(session.map), 0);
        boolean relationalize = Prop.RELATIONALIZE.booleanValue(session.map);
        Resolver resolver = Resolver.of(resolved.typeMap, env, session);
        Core.Decl coreDecl0 = resolver.toCore(resolved.node);
        tracer.onCore(0, coreDecl0);
        @Nullable Core.NamedPat skipPat = Compiles.getSkipPat(resolved.node, coreDecl0);
        boolean matchCoverageEnabled = Prop.MATCH_COVERAGE_ENABLED.booleanValue(session.map);
        if (matchCoverageEnabled) {
            Compiles.checkPatternCoverage(typeSystem, coreDecl0, warningConsumer);
        }
        boolean mayContainUnbounded = true;
        tracer.onCore(1, coreDecl0);
        if (inlinePassCount == 0) {
            Inliner inliner = Inliner.of(typeSystem, env, null);
            coreDecl = coreDecl0.accept(inliner);
        } else {
            int i;
            Relationalizer relationalizer = relationalize ? Relationalizer.of(typeSystem, env) : null;
            coreDecl = coreDecl0;
            for (i = 0; i < inlinePassCount; ++i) {
                Analyzer.Analysis analysis = Analyzer.analyze(typeSystem, env, coreDecl);
                Inliner inliner = Inliner.of(typeSystem, env, analysis);
                Core.Decl coreDecl2 = coreDecl;
                coreDecl = coreDecl2.accept(inliner);
                if (relationalizer != null) {
                    coreDecl = coreDecl.accept(relationalizer);
                }
                if (coreDecl == coreDecl2) break;
                tracer.onCore(i + 2, coreDecl);
            }
            for (i = 0; i < inlinePassCount; ++i) {
                Core.Decl coreDecl2 = coreDecl;
                if (mayContainUnbounded) {
                    if (SuchThatShuttle.containsUnbounded(coreDecl)) {
                        coreDecl = coreDecl.accept(new SuchThatShuttle(typeSystem, env));
                    } else {
                        mayContainUnbounded = false;
                    }
                }
                if ((coreDecl = Extents.infinitePats(typeSystem, coreDecl)) == coreDecl2) break;
                tracer.onCore(i + 2, coreDecl);
            }
        }
        tracer.onCore(-1, coreDecl);
        if (hybrid) {
            if (calcite == null) {
                calcite = Calcite.withDataSets((Map<String, DataSet>)ImmutableMap.of());
            }
            compiler = new CalciteCompiler(typeSystem, calcite);
        } else {
            compiler = new Compiler(typeSystem);
        }
        ImmutableSet.Builder queriesToWrap = ImmutableSet.builder();
        if (resolved.originalNode instanceof Ast.ValDecl && coreDecl instanceof Core.NonRecValDecl) {
            Ast.ValDecl valDecl = (Ast.ValDecl)resolved.originalNode;
            Ast.ValBind valBind = valDecl.valBinds.get(0);
            Core.NonRecValDecl nonRecValDecl = (Core.NonRecValDecl)coreDecl;
            if (valBind.exp.op == Op.FROM) {
                queriesToWrap.add((Object)nonRecValDecl.exp);
            }
        }
        return compiler.compileStatement(env, coreDecl, skipPat, (Set<Core.Exp>)queriesToWrap.build());
    }

    private static @Nullable Core.NamedPat getSkipPat(Ast.Decl decl, Core.Decl coreDecl) {
        if (coreDecl instanceof Core.NonRecValDecl && decl instanceof Ast.ValDecl) {
            Core.NonRecValDecl nonRecValDecl = (Core.NonRecValDecl)coreDecl;
            Ast.ValDecl valDecl = (Ast.ValDecl)decl;
            if (nonRecValDecl.pat.name.equals("it")) {
                if (valDecl.valBinds.size() == 1) {
                    Ast.Pat pat = valDecl.valBinds.get((int)0).pat;
                    if (pat instanceof Ast.AsPat && ((Ast.AsPat)pat).id.name.equals("it")) {
                        return null;
                    }
                    if (pat instanceof Ast.IdPat && ((Ast.IdPat)pat).name.equals("it")) {
                        return null;
                    }
                }
                return nonRecValDecl.pat;
            }
        }
        return null;
    }

    private static void checkPatternCoverage(final TypeSystem typeSystem, Core.Decl decl, final Consumer<CompileException> warningConsumer) {
        final ArrayList errorList = new ArrayList();
        decl.accept(new Visitor(){

            @Override
            protected void visit(Core.Case kase) {
                super.visit(kase);
                Compiles.checkPatternCoverage(typeSystem, kase, errorList::add, warningConsumer);
            }
        });
        if (!errorList.isEmpty()) {
            throw (CompileException)errorList.get(0);
        }
    }

    private static void checkPatternCoverage(TypeSystem typeSystem, Core.Case kase, Consumer<CompileException> errorConsumer, Consumer<CompileException> warningConsumer) {
        ArrayList<Core.Pat> prevPatList = new ArrayList<Core.Pat>();
        ArrayList<Core.Match> redundantMatchList = new ArrayList<Core.Match>();
        for (Core.Match match : kase.matchList) {
            if (PatternCoverageChecker.isCoveredBy(typeSystem, prevPatList, match.pat)) {
                redundantMatchList.add(match);
            }
            prevPatList.add(match.pat);
        }
        boolean exhaustive = PatternCoverageChecker.isExhaustive(typeSystem, prevPatList);
        if (!redundantMatchList.isEmpty()) {
            String message = exhaustive ? "match redundant" : "match redundant and nonexhaustive";
            errorConsumer.accept(new CompileException(message, false, ((Core.Match)redundantMatchList.get((int)0)).pos));
        } else if (!exhaustive) {
            warningConsumer.accept(new CompileException("match nonexhaustive", true, kase.pos));
        }
    }

    public static Ast.ValDecl toValDecl(Ast.Exp statement) {
        Pos pos = statement.pos;
        Ast.ValBind valBind = AstBuilder.ast.valBind(pos, AstBuilder.ast.idPat(pos, "it"), statement);
        return AstBuilder.ast.valDecl(pos, false, false, (Iterable<? extends Ast.ValBind>)ImmutableList.of((Object)valBind));
    }

    public static Ast.ValDecl toValDecl(AstNode statement) {
        return statement instanceof Ast.ValDecl ? (Ast.ValDecl)statement : Compiles.toValDecl((Ast.Exp)statement);
    }

    public static Ast.Decl toDecl(AstNode statement) {
        return statement instanceof Ast.Decl ? (Ast.Decl)statement : Compiles.toValDecl((Ast.Exp)statement);
    }

    public static Core.Exp toExp(Core.NonRecValDecl decl) {
        return decl.exp;
    }

    static void bindPattern(TypeSystem typeSystem, List<Binding> bindings, Core.ValDecl valDecl) {
        valDecl.forEachBinding((pat, exp, overloadPat, pos) -> {
            if (pat instanceof Core.IdPat) {
                bindings.add(overloadPat == null ? Binding.of(pat, exp) : Binding.inst(pat, overloadPat, exp));
            }
        });
    }

    public static void bindDataType(TypeSystem typeSystem, List<Binding> bindings, DataType dataType) {
        dataType.typeConstructors.keySet().forEach(name -> bindings.add(typeSystem.bindTyCon(dataType, (String)name)));
    }

    static PatternBinder binding(TypeSystem typeSystem, Binding.Kind kind, List<Binding> bindings) {
        return new PatternBinder(typeSystem, bindings);
    }

    public static void acceptBinding(TypeSystem typeSystem, Core.Pat pat, List<Binding> bindings) {
        pat.accept(Compiles.binding(typeSystem, Binding.Kind.VAL, bindings));
    }

    public static void acceptBinding(Core.NamedPat namedPat, List<Binding> bindings) {
        bindings.add(Binding.of(namedPat));
    }

    private static class PatternBinder
    extends Visitor {
        private final TypeSystem typeSystem;
        private final List<Binding> bindings;

        PatternBinder(TypeSystem typeSystem, List<Binding> bindings) {
            this.typeSystem = typeSystem;
            this.bindings = bindings;
        }

        @Override
        protected void visit(Core.IdPat idPat) {
            Compiles.acceptBinding(idPat, this.bindings);
        }

        @Override
        protected void visit(Core.AsPat asPat) {
            Compiles.acceptBinding(asPat, this.bindings);
            super.visit(asPat);
        }

        @Override
        protected void visit(Core.NonRecValDecl valBind) {
            valBind.pat.accept(this);
        }

        @Override
        protected void visit(Core.DatatypeDecl datatypeDecl) {
            datatypeDecl.dataTypes.forEach(dataType -> Compiles.bindDataType(this.typeSystem, this.bindings, dataType));
        }

        @Override
        protected void visit(Core.Local local) {
            Compiles.bindDataType(this.typeSystem, this.bindings, local.dataType);
        }
    }
}

