/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.TriConsumer;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Environment {
    abstract void visit(Consumer<Binding> var1);

    public String asString() {
        StringBuilder b = new StringBuilder();
        this.getValueMap(false).forEach((k, v) -> b.append(v).append("\n"));
        return b.toString();
    }

    public abstract @Nullable Binding getTop(String var1);

    public final @Nullable Binding getOpt(String name) {
        LinkedHashSet idList = new LinkedHashSet();
        this.visit(binding -> {
            if (binding.id.name.equals(name)) {
                idList.add(binding.id);
            }
            if (binding.overloadId != null && binding.overloadId.name.equals(name)) {
                idList.add(binding.overloadId);
            }
        });
        for (Core.NamedPat id : idList) {
            Binding binding2 = this.getOpt(id);
            if (binding2 == null) continue;
            return binding2;
        }
        return null;
    }

    public abstract @Nullable Binding getOpt(Core.NamedPat var1);

    public abstract @Nullable Binding getOpt2(Core.NamedPat var1);

    public abstract void collect(Core.NamedPat var1, Consumer<Binding> var2);

    public Environment bind(Core.IdPat id, Object value) {
        return this.bind(Binding.of((Core.NamedPat)id, value));
    }

    protected Environment bind(Binding binding) {
        return new Environments.SubEnvironment(this, binding);
    }

    public void forEachType(TypeSystem typeSystem, TriConsumer<String, Binding.Kind, Type> consumer) {
        HashSet names = new HashSet();
        this.visit(binding -> {
            if (binding.kind == Binding.Kind.INST && names.add(binding.overloadId.name)) {
                consumer.accept(binding.overloadId.name, Binding.Kind.OVER, typeSystem.lookup(BuiltIn.Datatype.OVERLOAD));
            }
        });
        ArrayList bindings = new ArrayList();
        this.visit(bindings::add);
        bindings.forEach(binding -> {
            if (binding.kind == Binding.Kind.VAL && !names.add(binding.id.name)) {
                return;
            }
            Type type = binding.value instanceof TypedValue ? ((TypedValue)binding.value).typeKey().toType(typeSystem) : binding.id.type;
            consumer.accept(((Core.NamedPat)Util.first((Object)binding.overloadId, (Object)binding.id)).name, binding.kind, type);
        });
    }

    public void forEachValue(BiConsumer<String, Object> consumer) {
        HashSet names = new HashSet();
        this.visit(binding -> {
            if (names.add(binding.id.name) && binding.value != Unit.INSTANCE) {
                consumer.accept(binding.id.name, binding.value);
            }
        });
    }

    public final Map<String, Binding> getValueMap(boolean skipOverloads) {
        HashMap<String, Binding> valueMap = new HashMap<String, Binding>();
        this.visit(binding -> {
            if (skipOverloads && binding.kind == Binding.Kind.INST) {
                return;
            }
            valueMap.putIfAbsent(binding.id.name, (Binding)binding);
        });
        return valueMap;
    }

    public final Environment bindAll(Iterable<Binding> bindings) {
        return Environments.bind(this, bindings);
    }

    abstract Environment nearestAncestorNotObscuredBy(Set<Core.NamedPat> var1);

    abstract int distance(int var1, Core.NamedPat var2);

    public Environment plus(Environment env) {
        ArrayList bindingList = new ArrayList();
        env.visit(bindingList::add);
        return this.bindAll(Lists.reverse(bindingList));
    }

    public Environment renumber() {
        class BindingConsumer
        implements Consumer<Binding> {
            int changeCount = 0;
            final Set<String> names = new HashSet<String>();
            final List<Binding> bindings = new ArrayList<Binding>();

            BindingConsumer() {
            }

            @Override
            public void accept(Binding binding) {
                if (!this.names.add(binding.id.name)) {
                    return;
                }
                Binding binding1 = binding.withFlattenedName();
                if (binding1 != binding) {
                    ++this.changeCount;
                }
                this.bindings.add(binding1);
            }
        }
        BindingConsumer consumer = new BindingConsumer();
        this.visit(consumer);
        if (consumer.changeCount == 0) {
            return this;
        }
        return Environments.empty().bindAll(consumer.bindings);
    }

    public boolean hasOverloaded(String name) {
        ArrayList bindings = new ArrayList();
        this.visit(binding -> {
            if (binding.overloadId != null && binding.overloadId.name.equals(name)) {
                bindings.add(binding);
            }
        });
        return !bindings.isEmpty() && ((Binding)bindings.get(0)).isInst();
    }

    public List<Core.IdPat> getOverloads(Core.IdPat id) {
        ArrayList<Core.IdPat> list = new ArrayList<Core.IdPat>();
        this.visit(binding -> {
            if (binding.overloadId != null && binding.overloadId.equals(id)) {
                list.add((Core.IdPat)binding.id);
            }
        });
        return list;
    }
}

