/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.compile.Analyzer;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Compiler;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.EnvShuttle;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Macro;
import net.hydromatic.morel.compile.Replacer;
import net.hydromatic.morel.eval.Applicable;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Inliner
extends EnvShuttle {
    private final @Nullable Analyzer.Analysis analysis;

    private Inliner(TypeSystem typeSystem, Environment env, Analyzer.Analysis analysis) {
        super(typeSystem, env);
        this.analysis = analysis;
    }

    public static Inliner of(TypeSystem typeSystem, Environment env, @Nullable Analyzer.Analysis analysis) {
        return new Inliner(typeSystem, env, analysis);
    }

    @Override
    protected Inliner push(Environment env) {
        return new Inliner(this.typeSystem, env, this.analysis);
    }

    @Override
    protected Core.Exp visit(Core.Id id) {
        Binding binding = this.env.getOpt(id.idPat);
        if (binding != null && !binding.parameter) {
            Macro macro;
            Core.Exp x;
            Object v;
            if (binding.exp != null) {
                Analyzer.Use use = this.analysis == null ? Analyzer.Use.MULTI_UNSAFE : Objects.requireNonNull((Analyzer.Use)((Object)this.analysis.map.get((Object)id.idPat)));
                switch (use) {
                    case ATOMIC: 
                    case ONCE_SAFE: {
                        return binding.exp.accept(this);
                    }
                }
            }
            if ((v = binding.value) instanceof Macro && (x = (macro = (Macro)binding.value).expand(this.typeSystem, this.env, ((FnType)id.type).paramType)) instanceof Core.Literal) {
                return x;
            }
            if (v != Unit.INSTANCE) {
                Type type = this.typeSystem.unqualified(id.type);
                switch (type.op()) {
                    case ID: {
                        assert (id.type instanceof PrimitiveType);
                        return CoreBuilder.core.literal((PrimitiveType)id.type, v);
                    }
                    case FUNCTION_TYPE: {
                        assert (v instanceof Applicable || v instanceof Macro) : v;
                        BuiltIn builtIn = Codes.BUILT_IN_MAP.get(v);
                        if (builtIn == null) break;
                        return CoreBuilder.core.functionLiteral(this.typeSystem, builtIn);
                    }
                    default: {
                        if (v instanceof Code && (v = ((Code)v).eval(Compiler.EMPTY_ENV)) == null) break;
                        return CoreBuilder.core.valueLiteral(id, v);
                    }
                }
            }
        }
        return super.visit(id);
    }

    @Override
    protected Core.Exp visit(Core.Apply apply) {
        Core.Apply apply2 = (Core.Apply)super.visit(apply);
        if (apply2.fn.op == Op.RECORD_SELECTOR && apply2.arg.op == Op.VALUE_LITERAL) {
            BuiltIn builtIn;
            Core.RecordSelector selector = (Core.RecordSelector)apply2.fn;
            List list = ((Core.Literal)apply2.arg).unwrap(List.class);
            Object o = list.get(selector.slot);
            if ((o instanceof Applicable || o instanceof Macro) && (builtIn = Codes.BUILT_IN_MAP.get(o)) != null) {
                return CoreBuilder.core.functionLiteral(apply2.type, builtIn);
            }
            return CoreBuilder.core.valueLiteral(apply2, o);
        }
        if (apply2.fn.op == Op.FN) {
            Core.Fn fn = (Core.Fn)apply2.fn;
            return CoreBuilder.core.let(CoreBuilder.core.nonRecValDecl(apply2.pos, fn.idPat, null, apply2.arg), fn.exp);
        }
        return apply2;
    }

    @Override
    protected Core.Exp visit(Core.Case caseOf) {
        Core.Match match;
        Map<Core.Id, Core.Id> substitution;
        Core.Exp exp = caseOf.exp.accept(this);
        List<Core.Match> matchList = this.visitList(caseOf.matchList);
        if (matchList.size() == 1 && (substitution = this.getSub(exp, match = matchList.get(0))) != null) {
            return Replacer.substitute(this.typeSystem, substitution, match.exp);
        }
        if (exp.type != caseOf.exp.type) {
            @Nullable Map<Integer, Type> sub = caseOf.exp.type.unifyWith(exp.type);
            if (sub == null) {
                throw new AssertionError((Object)String.format("cannot unify %s with %s", exp.type, caseOf.exp.type));
            }
            Type type = caseOf.type.substitute(this.typeSystem, (List<? extends Type>)ImmutableList.copyOf(sub.values()));
            return CoreBuilder.core.caseOf(caseOf.pos, type, exp, matchList);
        }
        return caseOf.copy(exp, matchList);
    }

    private @Nullable Map<Core.Id, Core.Id> getSub(Core.Exp exp, Core.Match match) {
        if (exp.op == Op.ID && match.pat.op == Op.ID_PAT) {
            return ImmutableMap.of((Object)CoreBuilder.core.id((Core.IdPat)match.pat), (Object)((Core.Id)exp));
        }
        if (exp.op == Op.TUPLE && match.pat.op == Op.TUPLE_PAT) {
            Core.Tuple tuple = (Core.Tuple)exp;
            Core.TuplePat tuplePat = (Core.TuplePat)match.pat;
            if (Static.allMatch(tuple.args, arg -> arg.op == Op.ID) && Static.allMatch(tuplePat.args, arg -> arg.op == Op.ID_PAT)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                Pair.forEach(tuple.args, tuplePat.args, (arg, pat) -> builder.put((Object)CoreBuilder.core.id((Core.IdPat)pat), (Object)((Core.Id)arg)));
                return builder.build();
            }
        }
        return null;
    }

    @Override
    protected Core.Exp visit(Core.Let let) {
        Analyzer.Use use = this.analysis == null ? Analyzer.Use.MULTI_UNSAFE : (let.decl instanceof Core.NonRecValDecl ? Objects.requireNonNull((Analyzer.Use)((Object)this.analysis.map.get((Object)((Core.NonRecValDecl)let.decl).pat))) : Analyzer.Use.MULTI_UNSAFE);
        switch (use) {
            case DEAD: {
                return let.exp.accept(this);
            }
            case ATOMIC: 
            case ONCE_SAFE: {
                ArrayList<Binding> bindings = new ArrayList<Binding>();
                Compiles.bindPattern(this.typeSystem, bindings, let.decl);
                return let.exp.accept(this.bind(bindings));
            }
        }
        return super.visit(let);
    }
}

