/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.EnvVisitor;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.TypeMap;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.MultiType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.MapList;
import net.hydromatic.morel.util.MartelliUnifier;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Tracers;
import net.hydromatic.morel.util.TriConsumer;
import net.hydromatic.morel.util.Unifier;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeResolver {
    private final TypeSystem typeSystem;
    private final Consumer<CompileException> warningConsumer;
    private final PairList<Ast.FromStep, Triple> stepStack = PairList.of();
    private final List<Consumer<Resolved>> validations = new ArrayList<Consumer<Resolved>>();
    private final Unifier unifier = new MartelliUnifier();
    private final List<TermVariable> terms = new ArrayList<TermVariable>();
    private final Map<AstNode, Unifier.Term> map = new HashMap<AstNode, Unifier.Term>();
    private final Map<Unifier.Variable, Unifier.Action> actionMap = new HashMap<Unifier.Variable, Unifier.Action>();
    private final PairList<Unifier.Variable, PrimitiveType> preferredTypes = PairList.of();
    private final List<Inst> overloads = new ArrayList<Inst>();
    private final List<Unifier.Constraint> constraints = new ArrayList<Unifier.Constraint>();
    static final String BAG_TY_CON = BuiltIn.Eqtype.BAG.mlName();
    static final String TUPLE_TY_CON = "tuple";
    static final String ARG_TY_CON = "$arg";
    static final String OVERLOAD_TY_CON = BuiltIn.Datatype.OVERLOAD.mlName();
    static final String LIST_TY_CON = "list";
    static final String RECORD_TY_CON = "record";
    static final String FN_TY_CON = "fn";
    static final String PROGRESSIVE_LABEL = "z$dummy";

    private TypeResolver(TypeSystem typeSystem, Consumer<CompileException> warningConsumer) {
        this.typeSystem = Objects.requireNonNull(typeSystem);
        this.warningConsumer = Objects.requireNonNull(warningConsumer);
    }

    public static Resolved deduceType(Environment env, Ast.Decl decl, TypeSystem typeSystem, Consumer<CompileException> warningConsumer) {
        TypeResolver typeResolver = new TypeResolver(typeSystem, warningConsumer);
        Resolved resolved = typeResolver.deduceTypeWithRetries(env, decl, typeSystem);
        typeResolver.validations.forEach(v -> v.accept(resolved));
        return resolved;
    }

    public static Type toType(Ast.Type type, TypeSystem typeSystem) {
        return typeSystem.typeFor(TypeResolver.toTypeKey(type));
    }

    public static Type.Key toTypeKey(Ast.Type type) {
        return new KeyBuilder().toTypeKey(type);
    }

    private Resolved deduceTypeWithRetries(Environment env, Ast.Decl decl, TypeSystem typeSystem) {
        Resolved resolved;
        int original;
        int attempt = 0;
        do {
            original = typeSystem.expandCount.get();
            resolved = this.deduceType_(env, decl);
        } while (typeSystem.expandCount.get() != original && attempt++ <= 1);
        return resolved;
    }

    private Resolved deduceType_(Environment env, Ast.Decl decl) {
        TypeMap typeMap;
        this.validations.clear();
        TypeEnvHolder typeEnvs = new TypeEnvHolder(new EnvironmentTypeEnv(env, EmptyTypeEnv.INSTANCE));
        env.forEachType(this.typeSystem, typeEnvs);
        TypeEnv typeEnv = typeEnvs.typeEnv;
        Ast.Decl node2 = this.deduceDeclType(typeEnv, decl, PairList.of());
        boolean debug = false;
        Tracers.ConfigurableTracer tracer = Tracers.nullTracer();
        block0: while (true) {
            ArrayList<Unifier.TermTerm> termPairs = new ArrayList<Unifier.TermTerm>();
            this.terms.forEach(tv -> termPairs.add(new Unifier.TermTerm(tv.term, tv.variable)));
            Unifier.Result result = this.unifier.unify(termPairs, this.actionMap, this.constraints, tracer);
            if (result instanceof Unifier.Retry) {
                Unifier.Retry retry = (Unifier.Retry)result;
                retry.amend();
                continue;
            }
            if (result instanceof Unifier.Failure) {
                String extra = ";\n term pairs:\n" + String.join((CharSequence)"\n", Static.transform(this.terms, Object::toString));
                Unifier.Failure failure = (Unifier.Failure)result;
                throw new TypeException("Cannot deduce type: " + failure.reason(), Pos.ZERO);
            }
            typeMap = new TypeMap(this.typeSystem, this.map, (Unifier.Substitution)((Object)result));
            while (!this.preferredTypes.isEmpty()) {
                Object x = this.preferredTypes.remove(0);
                Type type = typeMap.termToType(typeMap.substitution.resultMap.get(x.getKey()));
                if (!(type instanceof TypeVar)) continue;
                this.equiv((Unifier.Variable)x.getKey(), this.toTerm((PrimitiveType)x.getValue()));
                continue block0;
            }
            break;
        }
        AtomicBoolean progressive = new AtomicBoolean();
        TypeResolver.forEachUnresolvedField(node2, typeMap, apply -> {
            Type type = typeMap.getType(apply.arg);
            if (type.isProgressive()) {
                progressive.set(true);
            }
        }, apply -> {}, apply -> {});
        if (progressive.get()) {
            node2.accept(FieldExpander.create(this.typeSystem, env));
        } else {
            TypeResolver.checkNoUnresolvedFieldRefs(node2, typeMap);
        }
        return Resolved.of(env, decl, node2, typeMap);
    }

    private static void checkNoUnresolvedFieldRefs(Ast.Decl decl, TypeMap typeMap) {
        TypeResolver.forEachUnresolvedField(decl, typeMap, apply -> {
            throw new TypeException("unresolved flex record (can't tell what fields there are besides " + apply.fn + ")", apply.arg.pos);
        }, apply -> {
            throw new TypeException("reference to field " + ((Ast.RecordSelector)apply.fn).name + " of non-record type " + typeMap.getType(apply.arg), apply.arg.pos);
        }, apply -> {
            throw new TypeException("no field '" + ((Ast.RecordSelector)apply.fn).name + "' in type '" + typeMap.getType(apply.arg) + "'", apply.arg.pos);
        });
    }

    private static void forEachUnresolvedField(Ast.Decl decl, final TypeMap typeMap, final Consumer<Ast.Apply> variableConsumer, final Consumer<Ast.Apply> notRecordTypeConsumer, final Consumer<Ast.Apply> noFieldConsumer) {
        decl.accept(new Visitor(){

            @Override
            protected void visit(Ast.Apply apply) {
                if (apply.fn.op == Op.RECORD_SELECTOR) {
                    Ast.RecordSelector recordSelector = (Ast.RecordSelector)apply.fn;
                    if (typeMap.typeIsVariable(apply.arg)) {
                        variableConsumer.accept(apply);
                    } else {
                        SortedSet<String> fieldNames = typeMap.typeFieldNames(apply.arg);
                        if (fieldNames == null) {
                            notRecordTypeConsumer.accept(apply);
                        } else if (!fieldNames.contains(recordSelector.name)) {
                            noFieldConsumer.accept(apply);
                        }
                    }
                }
                super.visit(apply);
            }
        });
    }

    private <E extends AstNode> E reg(E node, Unifier.Term term) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(term);
        this.map.put(node, term);
        return node;
    }

    private <E extends AstNode> E reg(E node, Unifier.Variable variable, Unifier.Term term) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(variable);
        Objects.requireNonNull(term);
        this.equiv(variable, term);
        this.map.put(node, term);
        return node;
    }

    private void constrain(Unifier.Variable arg, Unifier.Variable result, PairList<Unifier.Term, Unifier.Term> argResults) {
        this.constraints.add(this.unifier.constraint(arg, result, argResults));
    }

    private void mayBeBagOrList(Unifier.Variable c, Unifier.Variable v) {
        Unifier.Sequence list = this.listTerm(v);
        Unifier.Sequence bag = this.bagTerm(v);
        PairList<Unifier.Term, Unifier.Constraint.Action> termActions = PairList.copyOf(list, Unifier.Constraint.equiv(c, list), bag, Unifier.Constraint.equiv(c, bag));
        this.constraints.add(this.unifier.constraint(c, termActions));
    }

    private void isListOrBagMatchingInput(Unifier.Variable c1, Unifier.Variable v1, Unifier.Variable c2, Unifier.Variable v2) {
        Unifier.Sequence list1 = this.listTerm(v1);
        Unifier.Sequence bag1 = this.bagTerm(v1);
        Unifier.Sequence list2 = this.listTerm(v2);
        Unifier.Sequence bag2 = this.bagTerm(v2);
        this.constraints.add(this.unifier.constraint(c2, c1, PairList.copyOf(list2, list1, bag2, bag1)));
        this.constraints.add(this.unifier.constraint(c1, c2, PairList.copyOf(list1, list2, bag1, bag2)));
    }

    private void isListIfBothAreLists(Unifier.Term c0, Unifier.Variable v0, Unifier.Term c1, Unifier.Variable v1, Unifier.Variable c, Unifier.Variable v) {
        Unifier.Sequence list0 = this.listTerm(v0);
        Unifier.Sequence list1 = this.listTerm(v1);
        Unifier.Sequence bag0 = this.bagTerm(v0);
        Unifier.Sequence bag1 = this.bagTerm(v1);
        Unifier.Sequence listResult = this.listTerm(v);
        Unifier.Sequence bagResult = this.bagTerm(v);
        Unifier.Constraint.Action listAction = Unifier.Constraint.equiv(c, listResult);
        Unifier.Constraint.Action bagAction = Unifier.Constraint.equiv(c, bagResult);
        PairList<Unifier.Term, Unifier.Constraint.Action> termActions = PairList.of();
        termActions.add(this.argTerm(list0, list1), listAction);
        termActions.add(this.argTerm(list0, bag1), bagAction);
        termActions.add(this.argTerm(bag0, list1), bagAction);
        termActions.add(this.argTerm(bag0, bag1), bagAction);
        this.constraints.add(this.unifier.constraint(this.toVariable(this.argTerm(c0, c1)), termActions));
    }

    private void isListIfAllAreLists(List<Unifier.Term> args, Unifier.Variable c, Unifier.Variable v) {
        if (args.isEmpty()) {
            throw new IllegalArgumentException("no args");
        }
        Unifier.Term arg0 = args.get(0);
        this.mayBeBagOrList(this.toVariable(arg0), v);
        this.mayBeBagOrList(c, v);
        for (Unifier.Term arg : Static.skip(args)) {
            this.mayBeBagOrList(this.toVariable(arg), v);
            this.isListIfBothAreLists(arg0, v, arg, v, c, v);
        }
    }

    private Ast.Exp deduceYieldType(TypeEnv env, Ast.Exp node, Unifier.Variable v) {
        return this.deduceType(env, node, v);
    }

    private Ast.Exp deduceType(TypeEnv env, Ast.Exp node, Unifier.Variable v) {
        switch (node.op) {
            case BOOL_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.BOOL));
            }
            case CHAR_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.CHAR));
            }
            case INT_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.INT));
            }
            case REAL_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.REAL));
            }
            case STRING_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.STRING));
            }
            case UNIT_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.UNIT));
            }
            case ANNOTATED_EXP: {
                Ast.AnnotatedExp annotatedExp = (Ast.AnnotatedExp)node;
                Type type = TypeResolver.toType(annotatedExp.type, this.typeSystem);
                Ast.Exp exp2 = this.deduceType(env, annotatedExp.exp, v);
                Ast.AnnotatedExp annotatedExp2 = annotatedExp.copy(exp2, annotatedExp.type);
                return this.reg(annotatedExp2, v, this.toTerm(type, Subst.EMPTY));
            }
            case ANDALSO: 
            case ORELSE: 
            case IMPLIES: {
                return this.infix(env, (Ast.InfixCall)node, v, PrimitiveType.BOOL);
            }
            case TUPLE: {
                Ast.Tuple tuple = (Ast.Tuple)node;
                ArrayList<Unifier.Variable> types = new ArrayList<Unifier.Variable>();
                ArrayList<Ast.Exp> args2 = new ArrayList<Ast.Exp>();
                for (Ast.Exp arg : tuple.args) {
                    Unifier.Variable vArg = this.unifier.variable();
                    args2.add(this.deduceType(env, arg, vArg));
                    types.add(vArg);
                }
                return this.reg(tuple.copy(args2), v, this.tupleTerm(types));
            }
            case LIST: {
                Ast.ListExp list = (Ast.ListExp)node;
                Unifier.Variable vArg2 = this.unifier.variable();
                ArrayList<Ast.Exp> args2 = new ArrayList<Ast.Exp>();
                for (Ast.Exp arg : list.args) {
                    args2.add(this.deduceType(env, arg, vArg2));
                }
                return this.reg(list.copy(args2), v, this.listTerm(vArg2));
            }
            case RECORD: {
                Ast.Record record = (Ast.Record)node;
                TreeMap labelTypes = new TreeMap();
                TreeMap<String, Ast.Exp> map2 = new TreeMap<String, Ast.Exp>();
                record.args.forEach((name, exp) -> {
                    Unifier.Variable vArg = this.unifier.variable();
                    Ast.Exp e2 = this.deduceType(env, (Ast.Exp)exp, vArg);
                    labelTypes.put(name, vArg);
                    map2.put((String)name, e2);
                });
                if (record.with == null) {
                    return this.reg(record.copy(null, map2), v, this.recordTerm(labelTypes));
                }
                Ast.Exp with2 = this.deduceType(env, record.with, v);
                return this.reg(record.copy(with2, map2), v);
            }
            case LET: {
                Ast.Let let = (Ast.Let)node;
                PairList<Ast.IdPat, Unifier.Term> termMap = PairList.of();
                TypeEnv env2 = env;
                ArrayList<Ast.Decl> decls = new ArrayList<Ast.Decl>();
                for (Ast.Decl decl : let.decls) {
                    decls.add(this.deduceDeclType(env2, decl, termMap));
                    env2 = TypeResolver.bindAll(env2, termMap);
                    termMap.clear();
                }
                Ast.Exp e2 = this.deduceType(env2, let.exp, v);
                Ast.Let let2 = let.copy(decls, e2);
                return this.reg(let2, v);
            }
            case RECORD_SELECTOR: {
                Ast.RecordSelector recordSelector = (Ast.RecordSelector)node;
                throw new RuntimeException("Error: unresolved flex record\n   (can't tell what fields there are besides #" + recordSelector.name + ")");
            }
            case IF: {
                Ast.If if_ = (Ast.If)node;
                Unifier.Variable v2 = this.unifier.variable();
                Ast.Exp condition2 = this.deduceType(env, if_.condition, v2);
                this.equiv(v2, this.toTerm(PrimitiveType.BOOL));
                Ast.Exp ifTrue2 = this.deduceType(env, if_.ifTrue, v);
                Ast.Exp ifFalse2 = this.deduceType(env, if_.ifFalse, v);
                Ast.If if2 = if_.copy(condition2, ifTrue2, ifFalse2);
                return this.reg(if2, v);
            }
            case CASE: {
                return this.deduceCaseType(env, (Ast.Case)node, v);
            }
            case FROM: 
            case EXISTS: 
            case FORALL: {
                return this.deduceQueryType(env, (Ast.Query)node, v);
            }
            case ID: {
                Ast.Id id = (Ast.Id)node;
                Unifier.Term term = env.get(this.typeSystem, id.name, TypeEnv.unbound(id));
                return this.reg(id, v, term);
            }
            case ORDINAL: {
                Ast.Ordinal ordinal = (Ast.Ordinal)node;
                Unifier.Term term3 = env.get(this.typeSystem, BuiltIn.Z_CURRENT.mlName, TypeEnv.onlyValidInQuery(ordinal));
                Triple step = Static.last(this.stepStack.rightList());
                this.validations.add(resolved -> {
                    Objects.requireNonNull(step.c);
                    Type stepType = resolved.typeMap.termToType(step.c);
                    if (stepType.op() != Op.LIST) {
                        throw new TypeException("cannot use 'ordinal' in unordered query", ordinal.pos);
                    }
                });
                return this.reg(ordinal, v, this.toTerm(PrimitiveType.INT));
            }
            case CURRENT: {
                Ast.Current current = (Ast.Current)node;
                Unifier.Term term2 = env.get(this.typeSystem, BuiltIn.Z_CURRENT.mlName, TypeEnv.onlyValidInQuery(current));
                return this.reg(current, v, term2);
            }
            case FN: {
                Ast.Fn fn = (Ast.Fn)node;
                Unifier.Variable resultVariable = this.unifier.variable();
                ArrayList<Ast.Match> matchList = new ArrayList<Ast.Match>();
                for (Ast.Match match : fn.matchList) {
                    matchList.add(this.deduceMatchType(env, match, (idPat, term1) -> {}, v, resultVariable));
                }
                Ast.Fn fn2b = fn.copy(matchList);
                return this.reg(fn2b, v);
            }
            case APPLY: {
                return this.deduceApplyType(env, (Ast.Apply)node, v);
            }
            case AT: 
            case CARET: 
            case COMPOSE: 
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: 
            case DIV: 
            case MOD: 
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case ELEM: 
            case NOT_ELEM: 
            case CONS: {
                return this.infix(env, (Ast.InfixCall)node, v);
            }
            case NEGATE: {
                return this.prefix(env, (Ast.PrefixCall)node, v);
            }
        }
        throw new AssertionError((Object)("cannot deduce type for " + (Object)((Object)node.op)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ast.Query deduceQueryType(TypeEnv env, Ast.Query query, Unifier.Variable v) {
        PairList<Ast.Id, Unifier.Variable> fieldVars = PairList.of();
        ArrayList<Ast.FromStep> fromSteps = new ArrayList<Ast.FromStep>();
        Unifier.Variable v11 = this.toVariable(this.recordTerm((NavigableMap<String, ? extends Unifier.Term>)ImmutableSortedMap.of()));
        Unifier.Sequence c11 = this.listTerm(v11);
        Triple p = new Triple(env, v11, this.toVariable(c11));
        for (Ord<Ast.FromStep> step : Ord.zip(query.steps)) {
            boolean lastStep = step.i == query.steps.size() - 1;
            try {
                this.stepStack.add((Ast.FromStep)step.e, p);
                p = this.deduceStepType(env, (Ast.FromStep)step.e, p, fieldVars, fromSteps);
            }
            finally {
                this.stepStack.remove(this.stepStack.size() - 1);
            }
            switch (((Ast.FromStep)step.e).op) {
                case COMPUTE: 
                case INTO: 
                case REQUIRE: {
                    if (((Ast.FromStep)step.e).op == Op.REQUIRE && query.op != Op.FORALL || ((Ast.FromStep)step.e).op == Op.COMPUTE && query.op != Op.FROM || ((Ast.FromStep)step.e).op == Op.INTO && query.op != Op.FROM) {
                        String message = String.format("'%s' step must not occur in '%s'", ((Ast.FromStep)step.e).op.lowerName(), query.op.lowerName());
                        throw new CompileException(message, false, ((Ast.FromStep)step.e).pos);
                    }
                    if (lastStep) break;
                    String message = String.format("'%s' step must be last in '%s'", ((Ast.FromStep)step.e).op.lowerName(), query.op.lowerName());
                    throw new CompileException(message, false, ((Ast.FromStep)query.steps.get((int)(step.i + 1))).pos);
                }
            }
        }
        if (query.op == Op.FORALL) {
            Ast.Query step;
            AstNode astNode = step = query.steps.isEmpty() ? query : (AstNode)Static.last(query.steps);
            if (step.op != Op.REQUIRE) {
                throw new CompileException("last step of 'forall' must be 'require'", false, step.pos);
            }
        }
        Unifier.Term term = query.op == Op.EXISTS || query.op == Op.FORALL ? this.toTerm(PrimitiveType.BOOL) : (query.isCompute() || query.isInto() ? p.v : p.c);
        return this.reg(query.copy(fromSteps), v, term);
    }

    private Triple deduceStepType(TypeEnv env, Ast.FromStep step, Triple p, PairList<Ast.Id, Unifier.Variable> fieldVars, List<Ast.FromStep> fromSteps) {
        switch (step.op) {
            case SCAN: {
                return this.deduceScanStepType((Ast.Scan)step, p, fieldVars, fromSteps);
            }
            case WHERE: {
                Ast.Where where = (Ast.Where)step;
                Unifier.Variable v5 = this.unifier.variable();
                Ast.Exp filter2 = this.deduceType(p.env, where.exp, v5);
                this.equiv(v5, this.toTerm(PrimitiveType.BOOL));
                fromSteps.add(where.copy(filter2));
                return p;
            }
            case REQUIRE: {
                Ast.Require require = (Ast.Require)step;
                Unifier.Variable v21 = this.unifier.variable();
                Ast.Exp filter3 = this.deduceType(p.env, require.exp, v21);
                this.equiv(v21, this.toTerm(PrimitiveType.BOOL));
                fromSteps.add(require.copy(filter3));
                return p;
            }
            case DISTINCT: {
                Ast.Distinct distinct = (Ast.Distinct)step;
                fromSteps.add(distinct);
                return p;
            }
            case SKIP: {
                Ast.Skip skip = (Ast.Skip)step;
                Unifier.Variable v11 = this.unifier.variable();
                Ast.Exp skipCount = this.deduceType(env, skip.exp, v11);
                this.equiv(v11, this.toTerm(PrimitiveType.INT));
                fromSteps.add(skip.copy(skipCount));
                return p;
            }
            case TAKE: {
                Ast.Take take = (Ast.Take)step;
                Unifier.Variable v12 = this.unifier.variable();
                Ast.Exp takeCount = this.deduceType(env, take.exp, v12);
                this.equiv(v12, this.toTerm(PrimitiveType.INT));
                fromSteps.add(take.copy(takeCount));
                return p;
            }
            case UNION: 
            case EXCEPT: 
            case INTERSECT: {
                Ast.SetStep setStep = (Ast.SetStep)step;
                ArrayList<Ast.Exp> args2 = new ArrayList<Ast.Exp>();
                ArrayList<Unifier.Term> terms = new ArrayList<Unifier.Term>();
                terms.add(p.c);
                for (Ast.Exp arg : setStep.args) {
                    Unifier.Variable v15 = this.unifier.variable();
                    terms.add(v15);
                    args2.add(this.deduceType(env, arg, v15));
                }
                Unifier.Variable c4 = this.unifier.variable();
                this.isListIfAllAreLists(terms, c4, p.v);
                fromSteps.add(setStep.copy(setStep.distinct, args2));
                return new Triple(p.env, p.v, c4);
            }
            case YIELD: {
                Ast.Yield yield = (Ast.Yield)step;
                Unifier.Variable v6 = this.unifier.variable();
                Ast.Exp yieldExp2 = this.deduceYieldType(p.env, yield.exp, v6);
                fromSteps.add(yield.copy(yieldExp2));
                TypeEnvHolder envs = new TypeEnvHolder(env);
                Unifier.Variable c6 = this.unifier.variable();
                this.isListOrBagMatchingInput(c6, v6, p.c, p.v);
                if (yieldExp2.op == Op.RECORD) {
                    Ast.Record record2 = (Ast.Record)yieldExp2;
                    Unifier.Term term = this.map.get(yieldExp2);
                    if (record2.with != null) {
                        term = this.map.get(record2.with);
                    }
                    if (term instanceof Unifier.Sequence) {
                        Unifier.Sequence sequence = (Unifier.Sequence)term;
                        fieldVars.clear();
                        Pair.forEach(record2.args.keySet(), sequence.terms, (name, t) -> {
                            fieldVars.add(AstBuilder.ast.id(Pos.ZERO, (String)name), this.toVariable((Unifier.Term)t));
                            envs.bind((String)name, (Unifier.Term)t);
                        });
                    }
                } else {
                    String label = (String)Util.first((Object)AstBuilder.ast.implicitLabelOpt(yield.exp), (Object)Op.CURRENT.opName);
                    envs.bind(label, v6);
                    fieldVars.clear();
                    fieldVars.add(AstBuilder.ast.id(Pos.ZERO, label), v6);
                }
                return Triple.of(envs.typeEnv, v6, c6);
            }
            case ORDER: {
                Ast.Order order = (Ast.Order)step;
                this.validateOrder(order);
                Ast.Exp exp = this.deduceType(p.env, order.exp, this.unifier.variable());
                fromSteps.add(order.copy(exp));
                return Triple.of(p.env, p.v, this.toVariable(this.listTerm(p.v)));
            }
            case UNORDER: {
                Ast.Unorder unorder = (Ast.Unorder)step;
                fromSteps.add(unorder);
                return Triple.of(p.env, p.v, this.toVariable(this.bagTerm(p.v)));
            }
            case COMPUTE: 
            case GROUP: {
                return this.deduceGroupStepType(env, (Ast.Group)step, p, fieldVars, fromSteps);
            }
            case INTO: {
                Ast.Into into = (Ast.Into)step;
                Unifier.Variable v13 = this.unifier.variable();
                Unifier.Variable v14 = this.unifier.variable();
                Ast.Exp intoExp = this.deduceType(p.env, into.exp, v14);
                Unifier.Sequence fnType = this.fnTerm(p.c, v13);
                this.equiv(v14, fnType);
                fromSteps.add(into.copy(intoExp));
                return Triple.singleton(EmptyTypeEnv.INSTANCE, v13);
            }
            case THROUGH: {
                Ast.Through through = (Ast.Through)step;
                Unifier.Variable v18 = this.unifier.variable();
                Unifier.Variable c18 = this.unifier.variable();
                this.reg(through, c18);
                this.mayBeBagOrList(p.c, p.v);
                ArrayList termMap = new ArrayList();
                this.deducePatType(env, through.pat, termMap::add, null, v18, t -> t);
                Unifier.Variable v17 = this.toVariable(this.fnTerm(p.c, c18));
                Ast.Exp throughExp = this.deduceType(p.env, through.exp, v17);
                this.mayBeBagOrList(c18, v18);
                fromSteps.add(through.copy(through.pat, throughExp));
                TypeEnv env5 = env;
                fieldVars.clear();
                for (PatTerm e : termMap) {
                    env5 = env5.bind(e.id.name, e.term);
                    fieldVars.add(AstBuilder.ast.id(Pos.ZERO, e.id.name), (Unifier.Variable)e.term);
                }
                return Triple.of(env5, v18, c18);
            }
        }
        throw new AssertionError((Object)("unknown step type " + (Object)((Object)step.op)));
    }

    private Triple deduceScanStepType(Ast.Scan scan, Triple p, PairList<Ast.Id, Unifier.Variable> fieldVars, List<Ast.FromStep> fromSteps) {
        Ast.Exp scanCondition2;
        Unifier.Variable c;
        Unifier.Variable c0;
        CollectionType containerize;
        Ast.Exp scanExp3;
        Unifier.Variable v0 = this.unifier.variable();
        ArrayList termMap = new ArrayList();
        if (scan.exp == null) {
            scanExp3 = null;
            containerize = CollectionType.BAG;
            c0 = null;
        } else if (scan.exp.op == Op.FROM_EQ) {
            Ast.Exp scanExp = ((Ast.PrefixCall)scan.exp).a;
            Ast.Exp scanExp2 = this.deduceType(p.env, scanExp, v0);
            scanExp3 = AstBuilder.ast.fromEq(scanExp2);
            containerize = CollectionType.INHERIT;
            c0 = null;
            this.reg(scanExp, v0);
        } else {
            c0 = this.unifier.variable();
            scanExp3 = this.deduceType(p.env, scan.exp, c0);
            this.reg(scan.exp, c0);
            containerize = CollectionType.BOTH;
        }
        this.deducePatType(p.env, scan.pat, termMap::add, null, v0, t -> t);
        TypeEnvHolder typeEnvs = new TypeEnvHolder(p.env);
        for (PatTerm patTerm : termMap) {
            typeEnvs.bind(patTerm.id.name, patTerm.term);
            Ast.Id id1 = AstBuilder.ast.id(Pos.ZERO, patTerm.id.name);
            fieldVars.add(id1, (Unifier.Variable)patTerm.term);
            this.reg(id1, patTerm.term);
        }
        TypeEnv env4 = typeEnvs.typeEnv;
        Unifier.Variable v = this.fieldVar(fieldVars);
        switch (containerize.ordinal()) {
            case 0: {
                c = this.toVariable(this.bagTerm(v));
                break;
            }
            case 1: {
                c = this.unifier.variable();
                this.isListOrBagMatchingInput(p.c, p.v, c, v);
                break;
            }
            default: {
                c = this.unifier.variable();
                if (fromSteps.isEmpty()) {
                    this.isListOrBagMatchingInput(c0, v0, c, v);
                    break;
                }
                this.isListIfBothAreLists(p.c, this.unifier.variable(), c0, this.unifier.variable(), c, v);
                this.mayBeBagOrList(c0, v0);
            }
        }
        if (scan.condition != null) {
            Unifier.Variable v5 = this.unifier.variable();
            scanCondition2 = this.deduceType(env4, scan.condition, v5);
            this.equiv(v5, this.toTerm(PrimitiveType.BOOL));
        } else {
            scanCondition2 = null;
        }
        fromSteps.add(scan.copy(scan.pat, scanExp3, scanCondition2));
        return Triple.of(env4, v, c);
    }

    private Unifier.Sequence argTerm(Unifier.Term ... args) {
        return this.unifier.apply(ARG_TY_CON, args);
    }

    private Triple deduceGroupStepType(TypeEnv env, Ast.Group group, Triple p, PairList<Ast.Id, Unifier.Variable> fieldVars, List<Ast.FromStep> fromSteps) {
        this.validateGroup(group);
        TypeEnv env3 = env;
        fieldVars.clear();
        PairList<Ast.Id, Ast.Exp> groupExps = PairList.of();
        for (Map.Entry entry : group.groupExps) {
            Ast.Id id = (Ast.Id)entry.getKey();
            Ast.Exp exp = (Ast.Exp)entry.getValue();
            Unifier.Variable v7 = this.unifier.variable();
            Ast.Exp exp2 = this.deduceType(p.env, exp, v7);
            this.reg(id, v7);
            env3 = env3.bind(id.name, v7);
            fieldVars.add(id, v7);
            groupExps.add(id, exp2);
        }
        ArrayList<Ast.Aggregate> aggregates = new ArrayList<Ast.Aggregate>();
        for (Ast.Aggregate aggregate : group.aggregates) {
            Ast.Exp arg2;
            Unifier.Variable c10;
            Ast.Id id = aggregate.id;
            Unifier.Variable v8 = this.unifier.variable();
            this.reg(id, v8);
            Unifier.Variable v9 = this.unifier.variable();
            if (aggregate.argument == null) {
                c10 = p.c;
                arg2 = null;
            } else {
                Unifier.Variable v10 = this.unifier.variable();
                c10 = this.unifier.variable();
                this.isListOrBagMatchingInput(c10, v10, p.c, p.v);
                arg2 = this.deduceType(p.env, aggregate.argument, v10);
            }
            Ast.Exp aggregateFn2 = this.deduceApplyFnType(p.env, aggregate.aggregate, v9, c10, v8);
            this.reg(aggregate.aggregate, v9);
            Unifier.Sequence fnType = this.fnTerm(c10, v8);
            this.equiv(v9, fnType);
            env3 = env3.bind(id.name, v8);
            fieldVars.add(id, v8);
            Ast.Aggregate aggregate2 = aggregate.copy(aggregateFn2, arg2, aggregate.id);
            aggregates.add(aggregate2);
            this.reg(aggregate2, v8);
        }
        Unifier.Variable variable = this.fieldVar(fieldVars);
        if (group.op == Op.GROUP) {
            fromSteps.add(group.copy(groupExps, aggregates));
            Unifier.Variable c2 = this.unifier.variable();
            this.isListOrBagMatchingInput(c2, variable, p.c, p.v);
            return Triple.of(env3, variable, c2);
        }
        fromSteps.add(((Ast.Compute)group).copy(aggregates));
        return Triple.singleton(env3, variable);
    }

    private void validateGroup(Ast.Group group) {
        ArrayList names = new ArrayList();
        group.groupExps.leftList().forEach(id -> names.add(id.name));
        group.aggregates.forEach(aggregate -> names.add(aggregate.id.name));
        int duplicate = Util.firstDuplicate(names);
        if (duplicate >= 0) {
            throw new RuntimeException("Duplicate field name '" + (String)names.get(duplicate) + "' in group");
        }
    }

    private void validateOrder(Ast.Order order) {
        order.exp.accept(new Visitor(){

            @Override
            protected void visit(Ast.Record record) {
                ImmutableList<Pos> positions = Static.transformEager(record.args.values(), e -> e.pos);
                if (!Ordering.from(Pos::compare).isOrdered(positions)) {
                    String message = "Sorting on a record whose fields are not in alphabetical order. Sort order may not be what you expect.";
                    TypeResolver.this.warningConsumer.accept(new CompileException(message, true, record.pos));
                }
                super.visit(record);
            }
        });
    }

    private Unifier.Variable fieldVar(PairList<Ast.Id, Unifier.Variable> fieldVars) {
        switch (fieldVars.size()) {
            case 0: {
                return this.toVariable(this.toTerm(PrimitiveType.UNIT));
            }
            case 1: {
                return fieldVars.right(0);
            }
        }
        TreeMap map = new TreeMap();
        fieldVars.forEach((k, v) -> map.put(k.name, v));
        Unifier.Term term = this.recordTerm(map);
        return this.equiv(this.unifier.variable(), term);
    }

    private Ast.Apply deduceApplyType(TypeEnv env, Ast.Apply apply, Unifier.Variable v) {
        BuiltIn builtIn;
        Ast.Exp arg2;
        Unifier.Variable vFn = this.unifier.variable();
        Unifier.Variable vArg = this.unifier.variable();
        Unifier.Sequence term1 = this.fnTerm(vArg, v);
        this.equiv(vFn, term1);
        if (apply.arg instanceof Ast.RecordSelector) {
            Unifier.Variable vRec = this.unifier.variable();
            Unifier.Variable vField = this.unifier.variable();
            this.deduceRecordSelectorType(env, (Ast.RecordSelector)apply.arg, vRec, vField);
            arg2 = this.reg(apply.arg, vArg, this.fnTerm(vRec, vField));
        } else {
            arg2 = this.deduceType(env, apply.arg, vArg);
        }
        Ast.Exp fn2 = apply.fn instanceof Ast.RecordSelector ? this.deduceRecordSelectorType(env, (Ast.RecordSelector)apply.fn, vArg, v) : this.deduceApplyFnType(env, apply.fn, vFn, vArg, v);
        if (fn2 instanceof Ast.Id && (builtIn = (BuiltIn)((Object)BuiltIn.BY_ML_NAME.get((Object)((Ast.Id)fn2).name))) != null) {
            builtIn.prefer(t -> this.preferredTypes.add(v, (PrimitiveType)t));
        }
        return this.reg(apply.copy(fn2, arg2), v);
    }

    private Ast.Exp deduceApplyFnType(TypeEnv env, Ast.Exp fn, Unifier.Variable vFn, Unifier.Variable vArg, Unifier.Variable vResult) {
        @Nullable Type type = this.getType(env, fn);
        if (type instanceof MultiType) {
            MultiType multiType = (MultiType)type;
            PairList<Unifier.Term, Unifier.Term> argResults = PairList.of();
            for (Type type1 : multiType.types) {
                Subst subst = Subst.EMPTY;
                if (type1 instanceof ForallType) {
                    for (int i = 0; i < ((ForallType)type1).parameterCount; ++i) {
                        subst = subst.plus(this.typeSystem.typeVariable(i), this.unifier.variable());
                    }
                    type1 = this.typeSystem.unqualified(type1);
                }
                FnType fnType = (FnType)type1;
                argResults.add(this.toTerm(fnType.paramType, subst), this.toTerm(fnType.resultType, subst));
            }
            this.constrain(vArg, vResult, argResults);
            return this.reg(fn, vFn);
        }
        if (!(fn instanceof Ast.Id)) {
            return this.deduceType(env, fn, vFn);
        }
        Ast.Id id = (Ast.Id)fn;
        if (!env.hasOverloaded(id.name)) {
            return this.deduceType(env, fn, vFn);
        }
        ArrayList variables = new ArrayList();
        env.collectInstances(this.typeSystem, id.name, term -> {
            Unifier.Variable variable = this.toVariable((Unifier.Term)term);
            variables.add(variable);
            if (term instanceof Unifier.Sequence) {
                Unifier.Sequence sequence = (Unifier.Sequence)term;
                if (sequence.operator.equals(FN_TY_CON)) {
                    assert (sequence.terms.size() == 2);
                    @Nullable Unifier.Term arg = sequence.terms.get(0);
                    Unifier.Term result = sequence.terms.get(1);
                    this.overloads.add(new Inst(id.name, variable, this.toVariable(arg), this.toVariable(result)));
                }
            }
        });
        PairList<Unifier.Term, Unifier.Term> argResults = PairList.of();
        for (Inst inst : this.overloads) {
            if (!inst.name.equals(id.name) || !variables.contains(inst.vFn)) continue;
            argResults.add(inst.vArg, inst.vResult);
        }
        this.constrain(vArg, vResult, argResults);
        return this.reg(id, vFn);
    }

    private @Nullable Type getType(TypeEnv env, Ast.Exp exp) {
        switch (exp.op) {
            case BOOL_LITERAL: {
                return PrimitiveType.BOOL;
            }
            case CHAR_LITERAL: {
                return PrimitiveType.CHAR;
            }
            case INT_LITERAL: {
                return PrimitiveType.INT;
            }
            case REAL_LITERAL: {
                return PrimitiveType.REAL;
            }
            case STRING_LITERAL: {
                return PrimitiveType.STRING;
            }
            case UNIT_LITERAL: {
                return PrimitiveType.UNIT;
            }
            case ID: {
                Ast.Id id = (Ast.Id)exp;
                Type type = env.getTypeOpt(id.name);
                if (type != null) {
                    this.reg(exp, this.toTerm(type, Subst.EMPTY));
                }
                return type;
            }
            case APPLY: {
                Type argType;
                Ast.Apply apply = (Ast.Apply)exp;
                if (apply.fn.op != Op.RECORD_SELECTOR || !((argType = this.getType(env, apply.arg)) instanceof RecordType)) break;
                Ast.RecordSelector recordSelector = (Ast.RecordSelector)apply.fn;
                return (Type)((RecordType)argType).argNameTypes.get(recordSelector.name);
            }
        }
        return null;
    }

    private Ast.RecordSelector deduceRecordSelectorType(TypeEnv env, Ast.RecordSelector recordSelector, Unifier.Variable vArg, Unifier.Variable vResult) {
        String fieldName = recordSelector.name;
        this.actionMap.put(vArg, (v, t, substitution, termPairs) -> {
            int i;
            Unifier.Sequence sequence;
            List<String> fieldList;
            if (t instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList(sequence = (Unifier.Sequence)t)) != null && (i = fieldList.indexOf(fieldName)) >= 0) {
                Unifier.Term result2 = substitution.resolve(vResult);
                Unifier.Term term = sequence.terms.get(i);
                Unifier.Term term2 = substitution.resolve(term);
                termPairs.accept(result2, term2);
            }
        });
        return recordSelector;
    }

    static List<String> fieldList(Unifier.Sequence sequence) {
        if (sequence.operator.equals(RECORD_TY_CON)) {
            return ImmutableList.of();
        }
        if (sequence.operator.startsWith("record:")) {
            String[] fields = sequence.operator.split(":");
            return Static.skip(Arrays.asList(fields));
        }
        if (sequence.operator.equals(TUPLE_TY_CON)) {
            int size = sequence.terms.size();
            return TupleType.ordinalNames(size);
        }
        return null;
    }

    static String recordLabel(NavigableSet<String> labels) {
        return labels.stream().collect(Collectors.joining(":", "record:", ""));
    }

    private Ast.Match deduceMatchType(TypeEnv env, Ast.Match match, BiConsumer<Ast.IdPat, Unifier.Term> termMap, Unifier.Variable argVariable, Unifier.Variable resultVariable) {
        Unifier.Variable vPat = this.unifier.variable();
        PairList<Ast.IdPat, Unifier.Term> termMap1 = PairList.of();
        Consumer<PatTerm> consumer = p -> termMap1.add(p.id, p.term);
        this.deducePatType(env, match.pat, consumer, null, vPat, t -> t);
        termMap1.forEach(termMap);
        TypeEnv env2 = TypeResolver.bindAll(env, termMap1);
        Ast.Exp exp2 = this.deduceType(env2, match.exp, resultVariable);
        Ast.Match match2 = match.copy(match.pat, exp2);
        return this.reg(match2, argVariable, this.fnTerm(vPat, resultVariable));
    }

    private List<Ast.Match> deduceMatchListType(TypeEnv env, List<Ast.Match> matchList, NavigableSet<String> labelNames, Unifier.Variable argVariable, Unifier.Variable resultVariable) {
        for (Ast.Match match : matchList) {
            if (!(match.pat instanceof Ast.RecordPat)) continue;
            labelNames.addAll(((Ast.RecordPat)match.pat).args.keySet());
        }
        ArrayList<Ast.Match> matchList2 = new ArrayList<Ast.Match>();
        for (Ast.Match match : matchList) {
            PairList<Ast.IdPat, Unifier.Term> termMap = PairList.of();
            Consumer<PatTerm> consumer = p -> termMap.add(p.id, p.term);
            this.deducePatType(env, match.pat, consumer, labelNames, argVariable, t -> t);
            TypeEnv env2 = TypeResolver.bindAll(env, termMap);
            Ast.Exp exp2 = this.deduceType(env2, match.exp, resultVariable);
            matchList2.add(match.copy(match.pat, exp2));
        }
        return matchList2;
    }

    private Ast.Case deduceCaseType(TypeEnv env, Ast.Case case_, Unifier.Variable v) {
        List<String> fieldList;
        Unifier.Variable v2 = this.unifier.variable();
        Ast.Exp e2b = this.deduceType(env, case_.exp, v2);
        TreeSet<String> labelNames = new TreeSet<String>();
        Unifier.Term argType = this.map.get(e2b);
        if (argType instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList((Unifier.Sequence)argType)) != null) {
            labelNames.addAll(fieldList);
        }
        List<Ast.Match> matchList2 = this.deduceMatchListType(env, case_.matchList, labelNames, v2, v);
        return this.reg(case_.copy(e2b, matchList2), v);
    }

    private AstNode deduceValBindType(TypeEnv env, Ast.ValBind valBind, PairList<Ast.IdPat, Unifier.Term> termMap, Unifier.Variable vPat) {
        Consumer<PatTerm> consumer = p -> termMap.add(p.id, p.term);
        this.deducePatType(env, valBind.pat, consumer, null, vPat, t -> t);
        Ast.Exp e2 = this.deduceType(env, valBind.exp, vPat);
        Ast.ValBind valBind2 = valBind.copy(valBind.pat, e2);
        if (valBind2.pat instanceof Ast.IdPat && env.hasOverloaded(((Ast.IdPat)valBind2.pat).name)) {
            Unifier.Variable v2 = this.unifier.variable();
            Unifier.Variable v3 = this.unifier.variable();
            this.overloads.add(new Inst(((Ast.IdPat)valBind2.pat).name, vPat, v2, v3));
            Unifier.Sequence term = this.fnTerm(v2, v3);
            this.equiv(vPat, term);
        }
        this.map.put(valBind2, this.toTerm(PrimitiveType.UNIT));
        return valBind2;
    }

    private static TypeEnv bindAll(TypeEnv env, PairList<Ast.IdPat, Unifier.Term> termMap) {
        for (Map.Entry entry : termMap) {
            env = env.bind(((Ast.IdPat)entry.getKey()).name, (Unifier.Term)entry.getValue());
        }
        return env;
    }

    private Ast.Decl deduceDeclType(TypeEnv env, Ast.Decl node, PairList<Ast.IdPat, Unifier.Term> termMap) {
        switch (node.op) {
            case OVER_DECL: {
                Ast.OverDecl overDecl = (Ast.OverDecl)node;
                return this.deduceOverDeclType(env, overDecl, termMap);
            }
            case VAL_DECL: {
                return this.deduceValDeclType(env, (Ast.ValDecl)node, termMap);
            }
            case FUN_DECL: {
                Ast.ValDecl valDecl = this.toValDecl(env, (Ast.FunDecl)node);
                return this.deduceValDeclType(env, valDecl, termMap);
            }
            case DATATYPE_DECL: {
                Ast.DatatypeDecl datatypeDecl = (Ast.DatatypeDecl)node;
                return this.deduceDataTypeDeclType(env, datatypeDecl, termMap);
            }
        }
        throw new AssertionError((Object)("cannot deduce type for " + (Object)((Object)node.op) + " [" + node + "]"));
    }

    private Ast.Decl deduceDataTypeDeclType(TypeEnv env, Ast.DatatypeDecl datatypeDecl, PairList<Ast.IdPat, Unifier.Term> termMap) {
        ArrayList<Keys.DataTypeKey> keys = new ArrayList<Keys.DataTypeKey>();
        for (Ast.DatatypeBind bind : datatypeDecl.binds) {
            KeyBuilder keyBuilder = new KeyBuilder();
            bind.tyVars.forEach(keyBuilder::toTypeKey);
            PairList<String, Type.Key> tyCons = PairList.of();
            this.deduceDatatypeBindType(bind, tyCons);
            keys.add(Keys.datatype(bind.name.name, Keys.ordinals(keyBuilder.tyVarMap.size()), tyCons.toImmutableMap()));
        }
        List<Type> types = this.typeSystem.dataTypes(keys);
        Pair.forEach(datatypeDecl.binds, types, (datatypeBind, type) -> {
            DataType dataType = (DataType)(type instanceof DataType ? type : ((ForallType)type).type);
            for (Ast.TyCon tyCon : datatypeBind.tyCons) {
                BaseType tyConType;
                if (tyCon.type != null) {
                    Type.Key conKey = TypeResolver.toTypeKey(tyCon.type);
                    tyConType = this.typeSystem.fnType(conKey.toType(this.typeSystem), dataType);
                } else {
                    tyConType = dataType;
                }
                termMap.add((Ast.IdPat)AstBuilder.ast.idPat(tyCon.pos, tyCon.id.name), this.toTerm(tyConType, Subst.EMPTY));
                this.map.put(tyCon, this.toTerm(tyConType, Subst.EMPTY));
            }
        });
        this.map.put(datatypeDecl, this.toTerm(PrimitiveType.UNIT));
        return datatypeDecl;
    }

    private Ast.Decl deduceOverDeclType(TypeEnv env, Ast.OverDecl overDecl, PairList<Ast.IdPat, Unifier.Term> termMap) {
        this.map.put(overDecl, this.toTerm(PrimitiveType.UNIT));
        termMap.add(overDecl.pat, this.toTerm(this.typeSystem.lookup(BuiltIn.Datatype.OVERLOAD), Subst.EMPTY));
        return overDecl;
    }

    private Ast.Decl deduceValDeclType(TypeEnv env, Ast.ValDecl valDecl, PairList<Ast.IdPat, Unifier.Term> termMap) {
        Holder envHolder = Holder.of((Object)env);
        PairList<Ast.ValBind, Supplier> map0 = PairList.of();
        valDecl.valBinds.forEach(b -> map0.add((Ast.ValBind)b, () -> ((com.google.common.base.Supplier)Suppliers.memoize(this.unifier::variable)).get()));
        map0.forEach((valBind, vPatSupplier) -> {
            if (valDecl.rec && valBind.pat instanceof Ast.IdPat) {
                envHolder.set((Object)((TypeEnv)envHolder.get()).bind(((Ast.IdPat)valBind.pat).name, (Unifier.Term)vPatSupplier.get()));
            }
        });
        ArrayList<Ast.ValBind> valBinds = new ArrayList<Ast.ValBind>();
        TypeEnv env2 = (TypeEnv)envHolder.get();
        map0.forEach((valBind, vPatSupplier) -> valBinds.add((Ast.ValBind)this.deduceValBindType(env2, (Ast.ValBind)valBind, termMap, (Unifier.Variable)vPatSupplier.get())));
        Ast.ValDecl node2 = valDecl.copy(valBinds);
        this.map.put(node2, this.toTerm(PrimitiveType.UNIT));
        return node2;
    }

    private void deduceDatatypeBindType(Ast.DatatypeBind datatypeBind, PairList<String, Type.Key> tyCons) {
        KeyBuilder keyBuilder = new KeyBuilder();
        for (Ast.TyCon tyCon : datatypeBind.tyCons) {
            tyCons.add(tyCon.id.name, tyCon.type == null ? Keys.dummy() : keyBuilder.toTypeKey(tyCon.type));
        }
    }

    private Ast.ValDecl toValDecl(TypeEnv env, Ast.FunDecl funDecl) {
        ArrayList<Ast.ValBind> valBindList = new ArrayList<Ast.ValBind>();
        for (Ast.FunBind funBind : funDecl.funBinds) {
            valBindList.add(this.toValBind(env, funBind));
        }
        return AstBuilder.ast.valDecl(funDecl.pos, true, false, valBindList);
    }

    private Ast.ValBind toValBind(TypeEnv env, Ast.FunBind funBind) {
        List<Ast.Pat> vars;
        Ast.Exp exp;
        Ast.Type returnType = null;
        if (funBind.matchList.size() == 1) {
            Ast.FunMatch funMatch = funBind.matchList.get(0);
            exp = funMatch.exp;
            vars = funMatch.patList;
            returnType = funMatch.returnType;
        } else {
            MapList<String> varNames = MapList.of(funBind.matchList.get((int)0).patList.size(), index -> "v" + index);
            vars = Static.transformEager(varNames, v -> AstBuilder.ast.idPat(Pos.ZERO, (String)v));
            ArrayList<Ast.Match> matchList = new ArrayList<Ast.Match>();
            Pos prevReturnTypePos = null;
            for (Ast.FunMatch funMatch : funBind.matchList) {
                matchList.add(AstBuilder.ast.match(funMatch.pos, this.patTuple(env, funMatch.patList), funMatch.exp));
                if (funMatch.returnType == null) continue;
                if (returnType != null && !returnType.equals(funMatch.returnType)) {
                    throw new CompileException("parameter or result constraints of clauses don't agree [tycon mismatch]", false, prevReturnTypePos.plus(funMatch.pos));
                }
                returnType = funMatch.returnType;
                prevReturnTypePos = funMatch.pos;
            }
            exp = AstBuilder.ast.caseOf(Pos.ZERO, TypeResolver.idTuple(varNames), matchList);
        }
        if (returnType != null) {
            exp = AstBuilder.ast.annotatedExp(exp.pos, exp, returnType);
        }
        Pos pos = funBind.pos;
        for (Ast.Pat var : Lists.reverse(vars)) {
            exp = AstBuilder.ast.fn(pos, AstBuilder.ast.match(pos, var, exp));
        }
        return AstBuilder.ast.valBind(pos, AstBuilder.ast.idPat(pos, funBind.name), exp);
    }

    private static Ast.Exp idTuple(List<String> vars) {
        List idList = Lists.transform(vars, v -> AstBuilder.ast.id(Pos.ZERO, (String)v));
        if (idList.size() == 1) {
            return (Ast.Exp)idList.get(0);
        }
        return AstBuilder.ast.tuple(Pos.ZERO, idList);
    }

    private Ast.Pat patTuple(TypeEnv env, List<Ast.Pat> patList) {
        ArrayList<Ast.Pat> list2 = new ArrayList<Ast.Pat>();
        block3: for (int i = 0; i < patList.size(); ++i) {
            Ast.Pat pat = patList.get(i);
            switch (pat.op) {
                case ID_PAT: {
                    Ast.IdPat idPat = (Ast.IdPat)pat;
                    if (env.has(idPat.name) && this.typeSystem.lookupTyCon(idPat.name) != null) {
                        Unifier.Term term = env.get(this.typeSystem, idPat.name, TypeEnv.oops(idPat));
                        if (term instanceof Unifier.Sequence && ((Unifier.Sequence)term).operator.equals(FN_TY_CON)) {
                            list2.add(AstBuilder.ast.conPat(idPat.pos, AstBuilder.ast.id(idPat.pos, idPat.name), patList.get(++i)));
                            continue block3;
                        }
                        list2.add(AstBuilder.ast.con0Pat(idPat.pos, AstBuilder.ast.id(idPat.pos, idPat.name)));
                        continue block3;
                    }
                }
                default: {
                    list2.add(pat);
                }
            }
        }
        if (list2.size() == 1) {
            return (Ast.Pat)list2.get(0);
        }
        return AstBuilder.ast.tuplePat(Pos.sum(list2), list2);
    }

    private void deducePatType(TypeEnv env, Ast.Pat pat, Consumer<PatTerm> termMap, @Nullable NavigableSet<String> labelNames, Unifier.Variable v, UnaryOperator<Unifier.Term> accessor) {
        switch (pat.op) {
            case BOOL_LITERAL_PAT: {
                this.reg(pat, v, this.toTerm(PrimitiveType.BOOL));
                return;
            }
            case CHAR_LITERAL_PAT: {
                this.reg(pat, v, this.toTerm(PrimitiveType.CHAR));
                return;
            }
            case INT_LITERAL_PAT: {
                this.reg(pat, v, this.toTerm(PrimitiveType.INT));
                return;
            }
            case REAL_LITERAL_PAT: {
                this.reg(pat, v, this.toTerm(PrimitiveType.REAL));
                return;
            }
            case STRING_LITERAL_PAT: {
                this.reg(pat, v, this.toTerm(PrimitiveType.STRING));
                return;
            }
            case ID_PAT: {
                Ast.IdPat idPat = (Ast.IdPat)pat;
                Pair<DataType, Type.Key> pair1 = this.typeSystem.lookupTyCon(idPat.name);
                if (pair1 != null) {
                    DataType dataType0 = (DataType)pair1.left;
                    this.reg(pat, v, this.toTerm(dataType0, Subst.EMPTY));
                    return;
                }
                termMap.accept(new PatTerm(idPat, v, accessor));
            }
            case WILDCARD_PAT: {
                this.reg(pat, v);
                return;
            }
            case AS_PAT: {
                Ast.AsPat asPat = (Ast.AsPat)pat;
                termMap.accept(new PatTerm(asPat.id, v, accessor));
                this.deducePatType(env, asPat.pat, termMap, null, v, accessor);
                this.reg(pat, v);
                return;
            }
            case ANNOTATED_PAT: {
                Ast.AnnotatedPat annotatedPat = (Ast.AnnotatedPat)pat;
                Type type = TypeResolver.toType(annotatedPat.type, this.typeSystem);
                this.deducePatType(env, annotatedPat.pat, termMap, null, v, accessor);
                this.reg(pat, v, this.toTerm(type, Subst.EMPTY));
                return;
            }
            case TUPLE_PAT: {
                ArrayList typeTerms = new ArrayList();
                Ast.TuplePat tuple = (Ast.TuplePat)pat;
                Ord.forEachIndexed(tuple.args, (arg, i) -> {
                    Unifier.Variable vArg = this.unifier.variable();
                    UnaryOperator accessor2 = term -> ((Unifier.Sequence)accessor.apply(term)).terms.get(i);
                    this.deducePatType(env, (Ast.Pat)arg, termMap, null, vArg, accessor2);
                    typeTerms.add(vArg);
                });
                this.reg(pat, v, this.tupleTerm(typeTerms));
                return;
            }
            case RECORD_PAT: {
                Ast.RecordPat recordPat = (Ast.RecordPat)pat;
                NavigableMap labelTerms = RecordType.mutableMap();
                if (labelNames == null) {
                    labelNames = new TreeSet<String>(recordPat.args.keySet());
                }
                NavigableMap args = RecordType.mutableMap();
                Ord.forEachIndexed(labelNames, (labelName, i) -> {
                    Unifier.Variable vArg = this.unifier.variable();
                    labelTerms.put((String)labelName, vArg);
                    Ast.Pat argPat = (Ast.Pat)recordPat.args.get(labelName);
                    if (argPat != null) {
                        UnaryOperator accessor2 = term -> ((Unifier.Sequence)accessor.apply(term)).terms.get(i);
                        this.deducePatType(env, argPat, termMap, null, vArg, accessor2);
                        args.put((String)labelName, argPat);
                    }
                });
                Unifier.Term record = this.recordTerm(labelTerms);
                if (!recordPat.ellipsis) {
                    this.reg(recordPat, v, record);
                    return;
                }
                Unifier.Variable v2 = this.unifier.variable();
                this.equiv(v2, record);
                this.actionMap.put(v, (v3, t, substitution, termPairs) -> {
                    Unifier.Sequence sequence;
                    List<String> fieldList;
                    assert (v == v3);
                    if (t instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList(sequence = (Unifier.Sequence)t)) != null) {
                        NavigableMap labelTerms2 = RecordType.mutableMap();
                        Ord.forEachIndexed(fieldList, (fieldName, i) -> {
                            if (labelTerms.containsKey(fieldName)) {
                                labelTerms2.put((String)fieldName, sequence.terms.get(i));
                            }
                        });
                        Unifier.Term result2 = substitution.resolve(v2);
                        Unifier.Term term2 = this.recordTerm(labelTerms2);
                        termPairs.accept(result2, term2);
                    }
                });
                this.reg(recordPat, record);
                return;
            }
            case CON_PAT: {
                Ast.ConPat conPat = (Ast.ConPat)pat;
                Pair<DataType, Type.Key> pair = this.typeSystem.lookupTyCon(conPat.tyCon.name);
                if (pair == null) {
                    throw new AssertionError((Object)("not found: " + conPat.tyCon.name));
                }
                DataType dataType = (DataType)pair.left;
                Type argType = ((Type.Key)pair.right).toType(this.typeSystem);
                Unifier.Variable vArg = this.unifier.variable();
                this.deducePatType(env, conPat.pat, termMap, null, vArg, t -> vArg);
                Unifier.Term argTerm = this.toTerm(argType, Subst.EMPTY);
                this.equiv(vArg, argTerm);
                Unifier.Term term = this.toTerm(dataType, Subst.EMPTY);
                if (argType instanceof TypeVar) {
                    Unifier.Sequence sequence = (Unifier.Sequence)term;
                    TypeVar typeVar = (TypeVar)argType;
                    this.equiv(vArg, sequence.terms.get(typeVar.ordinal));
                }
                this.reg(pat, v, term);
                return;
            }
            case CON0_PAT: {
                Ast.Con0Pat con0Pat = (Ast.Con0Pat)pat;
                Pair<DataType, Type.Key> pair0 = this.typeSystem.lookupTyCon(con0Pat.tyCon.name);
                if (pair0 == null) {
                    throw new AssertionError();
                }
                DataType dataType0 = (DataType)pair0.left;
                this.reg(pat, v, this.toTerm(dataType0, Subst.EMPTY));
                return;
            }
            case LIST_PAT: {
                Ast.ListPat list = (Ast.ListPat)pat;
                Unifier.Variable vArg2 = this.unifier.variable();
                for (Ast.Pat arg2 : list.args) {
                    this.deducePatType(env, arg2, termMap, null, vArg2, t -> vArg2);
                }
                this.reg(list, v, this.listTerm(vArg2));
                return;
            }
            case CONS_PAT: {
                Unifier.Variable elementType = this.unifier.variable();
                Ast.InfixPat call = (Ast.InfixPat)pat;
                this.deducePatType(env, call.p0, termMap, null, elementType, t -> elementType);
                this.deducePatType(env, call.p1, termMap, null, v, accessor);
                this.reg(call, v, this.listTerm(elementType));
                return;
            }
        }
        throw new AssertionError((Object)("cannot deduce type for pattern " + (Object)((Object)pat.op)));
    }

    private Ast.Exp infix(TypeEnv env, Ast.InfixCall call, Unifier.Variable v, Type type) {
        Unifier.Term term = this.toTerm(type, Subst.EMPTY);
        Ast.Exp a0 = this.deduceType(env, call.a0, v);
        Ast.Exp a1 = this.deduceType(env, call.a1, v);
        return this.reg(call.copy(a0, a1), v, term);
    }

    private Ast.Exp infix(TypeEnv env, Ast.InfixCall call, Unifier.Variable v) {
        return this.deduceType(env, AstBuilder.ast.apply(AstBuilder.ast.id(Pos.ZERO, call.op.opName), AstBuilder.ast.tuple(Pos.ZERO, (Iterable<? extends Ast.Exp>)ImmutableList.of((Object)call.a0, (Object)call.a1))), v);
    }

    private Ast.Exp prefix(TypeEnv env, Ast.PrefixCall call, Unifier.Variable v) {
        return this.deduceType(env, AstBuilder.ast.apply(AstBuilder.ast.id(Pos.ZERO, call.op.opName), call.a), v);
    }

    private Unifier.Variable toVariable(Unifier.Term term) {
        if (term instanceof Unifier.Variable) {
            return (Unifier.Variable)term;
        }
        return this.equiv(this.unifier.variable(), term);
    }

    private Unifier.Variable equiv(Unifier.Variable v, Unifier.Term term) {
        if (!v.equals(term)) {
            this.terms.add(new TermVariable(term, v));
        }
        return v;
    }

    private Unifier.Sequence listTerm(Unifier.Term term) {
        return this.unifier.apply(LIST_TY_CON, term);
    }

    private Unifier.Sequence bagTerm(Unifier.Term term) {
        return this.unifier.apply(BAG_TY_CON, term);
    }

    private Unifier.Sequence fnTerm(Unifier.Term arg, Unifier.Term result) {
        return this.unifier.apply(FN_TY_CON, arg, result);
    }

    private Unifier.Term recordTerm(NavigableMap<String, ? extends Unifier.Term> labelTypes) {
        NavigableSet<String> labels = labelTypes.navigableKeySet();
        if (TypeSystem.areContiguousIntegers(labels) && labelTypes.size() != 1) {
            return this.tupleTerm(labelTypes.values());
        }
        return this.unifier.apply(TypeResolver.recordLabel(labels), labelTypes.values());
    }

    private Unifier.Term tupleTerm(Collection<? extends Unifier.Term> types) {
        if (types.isEmpty()) {
            return this.toTerm(PrimitiveType.UNIT);
        }
        return this.unifier.apply(TUPLE_TY_CON, types);
    }

    private List<Unifier.Term> toTerms(List<? extends Type> types, Subst subst) {
        return Static.transformEager(types, type -> this.toTerm((Type)type, subst));
    }

    private List<Unifier.Term> toTerms(Collection<? extends Type> types, Subst subst) {
        return Static.transformEager(types, type -> this.toTerm((Type)type, subst));
    }

    private Unifier.Term toTerm(PrimitiveType type) {
        return this.unifier.atom(type.moniker);
    }

    private Unifier.Term toTerm(Type type, Subst subst) {
        switch (type.op()) {
            case ID: {
                return this.toTerm((PrimitiveType)type);
            }
            case TY_VAR: {
                Unifier.Variable variable = subst.get((TypeVar)type);
                return variable != null ? variable : this.unifier.variable();
            }
            case DATA_TYPE: {
                DataType dataType = (DataType)type;
                if (dataType.name.equals(BAG_TY_CON)) {
                    assert (dataType.arguments.size() == 1);
                    return this.bagTerm(this.toTerm(dataType.arg(0), subst));
                }
                return this.unifier.apply(dataType.name(), this.toTerms(dataType.arguments, subst));
            }
            case FUNCTION_TYPE: {
                FnType fnType = (FnType)type;
                return this.fnTerm(this.toTerm(fnType.paramType, subst), this.toTerm(fnType.resultType, subst));
            }
            case TUPLE_TYPE: {
                TupleType tupleType = (TupleType)type;
                return this.tupleTerm(Static.transform(tupleType.argTypes, t -> this.toTerm((Type)t, subst)));
            }
            case RECORD_TYPE: {
                NavigableSet labels;
                RecordType recordType = (RecordType)type;
                SortedMap<String, Type> argNameTypes = recordType.argNameTypes;
                if (recordType.isProgressive()) {
                    argNameTypes = new TreeMap<String, Type>(argNameTypes);
                    argNameTypes.put(PROGRESSIVE_LABEL, PrimitiveType.UNIT);
                }
                String result = (labels = (NavigableSet)argNameTypes.keySet()).isEmpty() ? PrimitiveType.UNIT.name() : (TypeSystem.areContiguousIntegers(labels) ? TUPLE_TY_CON : TypeResolver.recordLabel(labels));
                List<Unifier.Term> args = this.toTerms(argNameTypes.values(), subst);
                return this.unifier.apply(result, args);
            }
            case LIST: {
                ListType listType = (ListType)type;
                return this.listTerm(this.toTerm(listType.elementType, subst));
            }
            case FORALL_TYPE: {
                ForallType forallType = (ForallType)type;
                Subst subst2 = subst;
                for (int i = 0; i < forallType.parameterCount; ++i) {
                    subst2 = subst2.plus(this.typeSystem.typeVariable(i), this.unifier.variable());
                }
                return this.toTerm(forallType.type, subst2);
            }
            case MULTI_TYPE: {
                MultiType multiType = (MultiType)type;
                return this.toTerm(multiType.types.get(0), subst);
            }
        }
        throw new AssertionError((Object)("unknown type: " + type.moniker()));
    }

    private static abstract class Subst {
        static final Subst EMPTY = new EmptySubst();

        private Subst() {
        }

        Subst plus(TypeVar typeVar, Unifier.Variable variable) {
            return new PlusSubst(this, typeVar, variable);
        }

        abstract Unifier.Variable get(TypeVar var1);
    }

    public static class Resolved {
        public final Environment env;
        public final Ast.Decl originalNode;
        public final Ast.Decl node;
        public final TypeMap typeMap;

        private Resolved(Environment env, Ast.Decl originalNode, Ast.Decl node, TypeMap typeMap) {
            this.env = env;
            this.originalNode = Objects.requireNonNull(originalNode);
            this.node = Objects.requireNonNull(node);
            this.typeMap = Objects.requireNonNull(typeMap);
            Preconditions.checkArgument((boolean)(originalNode instanceof Ast.FunDecl ? node instanceof Ast.ValDecl : originalNode.getClass() == node.getClass()));
        }

        static Resolved of(Environment env, Ast.Decl originalNode, Ast.Decl node, TypeMap typeMap) {
            return new Resolved(env, originalNode, node, typeMap);
        }

        public Ast.Exp exp() {
            if (this.node instanceof Ast.ValDecl) {
                Ast.ValDecl valDecl = (Ast.ValDecl)this.node;
                if (valDecl.valBinds.size() == 1) {
                    Ast.ValBind valBind = valDecl.valBinds.get(0);
                    return valBind.exp;
                }
            }
            throw new AssertionError((Object)("not an expression: " + this.node));
        }
    }

    private static class KeyBuilder {
        final Map<String, Integer> tyVarMap = new HashMap<String, Integer>();

        private KeyBuilder() {
        }

        Type.Key toTypeKey(Ast.Type type) {
            switch (type.op) {
                case TUPLE_TYPE: {
                    Ast.TupleType tupleType = (Ast.TupleType)type;
                    return Keys.tuple(this.toTypeKeys(tupleType.types));
                }
                case RECORD_TYPE: {
                    Ast.RecordType recordType = (Ast.RecordType)type;
                    NavigableMap argNameTypes = RecordType.mutableMap();
                    AtomicBoolean progressive = new AtomicBoolean(false);
                    recordType.fieldTypes.forEach((name, t) -> {
                        if (name.equals(TypeResolver.PROGRESSIVE_LABEL)) {
                            progressive.set(true);
                        } else {
                            argNameTypes.put((String)name, this.toTypeKey((Ast.Type)t));
                        }
                    });
                    return progressive.get() ? Keys.progressiveRecord(argNameTypes) : Keys.record(argNameTypes);
                }
                case FUNCTION_TYPE: {
                    Ast.FunctionType functionType = (Ast.FunctionType)type;
                    Type.Key paramType = this.toTypeKey(functionType.paramType);
                    Type.Key resultType = this.toTypeKey(functionType.resultType);
                    return Keys.fn(paramType, resultType);
                }
                case NAMED_TYPE: {
                    Ast.NamedType namedType = (Ast.NamedType)type;
                    List<Type.Key> typeList = this.toTypeKeys(namedType.types);
                    if (namedType.name.equals(TypeResolver.LIST_TY_CON) && typeList.size() == 1) {
                        return Keys.list(typeList.get(0));
                    }
                    if (typeList.isEmpty()) {
                        return Keys.name(namedType.name);
                    }
                    return Keys.apply(Keys.name(namedType.name), typeList);
                }
                case TY_VAR: {
                    Ast.TyVar tyVar = (Ast.TyVar)type;
                    return Keys.ordinal(this.tyVarMap.computeIfAbsent(tyVar.name, name -> this.tyVarMap.size()));
                }
            }
            throw new AssertionError((Object)("cannot convert type " + type + " " + (Object)((Object)type.op)));
        }

        List<Type.Key> toTypeKeys(Iterable<? extends Ast.Type> types) {
            return Static.transformEager(types, this::toTypeKey);
        }
    }

    private class TypeEnvHolder
    implements TriConsumer<String, Binding.Kind, Type> {
        private TypeEnv typeEnv;

        TypeEnvHolder(TypeEnv typeEnv) {
            this.typeEnv = Objects.requireNonNull(typeEnv);
        }

        @Override
        public void accept(String name, Binding.Kind kind, Type type) {
            if (kind == Binding.Kind.INST && !this.typeEnv.hasOverloaded(name)) {
                Type overload = TypeResolver.this.typeSystem.lookup(BuiltIn.Datatype.OVERLOAD);
                this.typeEnv = this.typeEnv.bind(name, Binding.Kind.OVER, this.typeToTerm(overload));
            }
            this.typeEnv = this.typeEnv.bind(name, kind, this.typeToTerm(type));
        }

        private Function<TypeSystem, Unifier.Term> typeToTerm(final Type type) {
            return new Function<TypeSystem, Unifier.Term>(){

                @Override
                public Unifier.Term apply(TypeSystem typeSystem_) {
                    return TypeResolver.this.toTerm(type, Subst.EMPTY);
                }

                public String toString() {
                    return type.moniker();
                }
            };
        }

        public void bind(String name, Unifier.Term term) {
            this.typeEnv = this.typeEnv.bind(name, term);
        }
    }

    private class EnvironmentTypeEnv
    implements TypeEnv {
        private final Environment env;
        private final TypeEnv parent;

        EnvironmentTypeEnv(Environment env, TypeEnv parent) {
            this.env = Objects.requireNonNull(env);
            this.parent = Objects.requireNonNull(parent);
        }

        @Override
        public Unifier.Term get(TypeSystem typeSystem, String name, Function<String, RuntimeException> exceptionFactory) {
            Binding binding = this.env.getOpt(name);
            if (binding != null) {
                return TypeResolver.this.toTerm(binding.id.type, Subst.EMPTY);
            }
            return this.parent.get(typeSystem, name, exceptionFactory);
        }

        @Override
        public boolean has(String name) {
            return this.env.getOpt(name) != null || this.parent.has(name);
        }

        @Override
        public boolean hasOverloaded(String name) {
            Binding binding = this.env.getOpt(name);
            if (binding != null) {
                return binding.kind != Binding.Kind.VAL;
            }
            return this.parent.hasOverloaded(name);
        }

        @Override
        public @Nullable Type getTypeOpt(String name) {
            Binding binding = this.env.getTop(name);
            if (binding != null) {
                if (binding.kind == Binding.Kind.VAL) {
                    return binding.id.type;
                }
                return TypeResolver.this.typeSystem.multi((List<? extends Type>)Static.transformEager(this.env.getOverloads(binding.overloadId), Core.Pat::type));
            }
            return this.parent.getTypeOpt(name);
        }
    }

    static enum EmptyTypeEnv implements TypeEnv
    {
        INSTANCE;


        @Override
        public Unifier.Term get(TypeSystem typeSystem, String name, Function<String, RuntimeException> exceptionFactory) {
            throw exceptionFactory.apply(name);
        }

        @Override
        public boolean has(String name) {
            return false;
        }

        @Override
        public @Nullable Type getTypeOpt(String name) {
            return null;
        }

        public String toString() {
            return "[]";
        }
    }

    static interface TypeEnv {
        public Unifier.Term get(TypeSystem var1, String var2, Function<String, RuntimeException> var3);

        public @Nullable Type getTypeOpt(String var1);

        default public int count(String name) {
            return 0;
        }

        default public void collectInstances(TypeSystem typeSystem, String name, Consumer<Unifier.Term> consumer) {
        }

        public boolean has(String var1);

        default public boolean hasOverloaded(String name) {
            return false;
        }

        default public TypeEnv bind(String name, Binding.Kind kind, Function<TypeSystem, Unifier.Term> termFactory) {
            return new BindTypeEnv(name, kind, termFactory, this);
        }

        default public TypeEnv bind(String name, Binding.Kind kind, Unifier.Term term) {
            return this.bind(name, kind, new SimpleTermFactory(term));
        }

        default public TypeEnv bind(String name, Unifier.Term term) {
            return this.bind(name, this.getKind(name, term), new SimpleTermFactory(term));
        }

        default public Binding.Kind getKind(String name, Unifier.Term term) {
            if (term instanceof Unifier.Sequence && ((Unifier.Sequence)term).operator.equals(OVERLOAD_TY_CON)) {
                return Binding.Kind.OVER;
            }
            if (this.hasOverloaded(name)) {
                return Binding.Kind.INST;
            }
            return Binding.Kind.VAL;
        }

        public static Function<String, RuntimeException> oops(AstNode node) {
            return name -> new RuntimeException("oops, should have " + node);
        }

        public static Function<String, RuntimeException> onlyValidInQuery(AstNode node) {
            return name -> new CompileException("'" + node + "' is only valid in a query", false, node.pos);
        }

        public static Function<String, RuntimeException> unbound(Ast.Id id) {
            return name -> new CompileException("unbound variable or constructor: " + name, false, id.pos);
        }
    }

    public static class TypeException
    extends CompileException {
        public TypeException(String message, Pos pos) {
            super(message, false, pos);
        }
    }

    static class FieldExpander
    extends EnvVisitor {
        static FieldExpander create(TypeSystem typeSystem, Environment env) {
            return new FieldExpander(typeSystem, env, new ArrayDeque<EnvVisitor.FromContext>());
        }

        private FieldExpander(TypeSystem typeSystem, Environment env, Deque<EnvVisitor.FromContext> fromStack) {
            super(typeSystem, env, fromStack);
        }

        @Override
        protected EnvVisitor push(Environment env) {
            return new FieldExpander(this.typeSystem, env, this.fromStack);
        }

        @Override
        protected void visit(Ast.Apply apply) {
            super.visit(apply);
            this.expandField(this.env, apply);
        }

        @Override
        protected void visit(Ast.Id id) {
            super.visit(id);
            this.expandField(this.env, id);
        }

        private @Nullable TypedValue expandField(Environment env, Ast.Exp exp) {
            switch (exp.op) {
                case APPLY: {
                    Ast.Apply apply = (Ast.Apply)exp;
                    if (apply.fn.op == Op.RECORD_SELECTOR) {
                        Ast.RecordSelector selector = (Ast.RecordSelector)apply.fn;
                        TypedValue typedValue = this.expandField(env, apply.arg);
                        if (typedValue != null) {
                            typedValue.discoverField(this.typeSystem, selector.name);
                            return typedValue.fieldValueAs(selector.name, TypedValue.class);
                        }
                    }
                    return null;
                }
                case ID: {
                    Binding binding = env.getOpt(((Ast.Id)exp).name);
                    if (binding == null || !(binding.value instanceof TypedValue)) break;
                    return (TypedValue)binding.value;
                }
            }
            return null;
        }
    }

    private static class Triple {
        final TypeEnv env;
        final Unifier.Variable v;
        final @Nullable Unifier.Variable c;

        private Triple(TypeEnv env, Unifier.Variable v, Unifier.Variable c) {
            this.env = Objects.requireNonNull(env);
            this.v = Objects.requireNonNull(v);
            this.c = c;
        }

        static Triple singleton(TypeEnv env, Unifier.Variable v) {
            return new Triple(env, v, null);
        }

        static Triple of(TypeEnv env, Unifier.Variable v, Unifier.Variable c) {
            return new Triple(env.bind(BuiltIn.Z_CURRENT.mlName, v), v, c);
        }

        Triple withV(Unifier.Variable v) {
            return v == this.v ? this : new Triple(this.env, v, this.c);
        }

        Triple withEnv(TypeEnv env) {
            return env == this.env ? this : new Triple(env, this.v, this.c);
        }
    }

    private static class PatTerm {
        final Ast.IdPat id;
        final Unifier.Term term;
        final UnaryOperator<Unifier.Term> accessor;

        private PatTerm(Ast.IdPat id, Unifier.Term term, UnaryOperator<Unifier.Term> accessor) {
            this.id = Objects.requireNonNull(id);
            this.term = Objects.requireNonNull(term);
            this.accessor = Objects.requireNonNull(accessor);
        }

        public String toString() {
            return String.format("id %s term %s", this.id, this.term);
        }
    }

    private static enum CollectionType {
        BAG,
        INHERIT,
        BOTH;

    }

    private static class Inst {
        private final String name;
        private final Unifier.Variable vFn;
        private final Unifier.Variable vArg;
        private final Unifier.Variable vResult;

        Inst(String name, Unifier.Variable vFn, Unifier.Variable vArg, Unifier.Variable vResult) {
            this.name = name;
            this.vFn = vFn;
            this.vArg = vArg;
            this.vResult = vResult;
        }

        public String toString() {
            return String.format("overload '%s' %s = %s -> %s", this.name, this.vFn, this.vArg, this.vResult);
        }
    }

    private static class TermVariable {
        final Unifier.Term term;
        final Unifier.Variable variable;

        private TermVariable(Unifier.Term term, Unifier.Variable variable) {
            this.term = term;
            this.variable = variable;
        }

        public String toString() {
            return this.term + " = " + this.variable;
        }
    }

    private static class PlusSubst
    extends Subst {
        final Subst parent;
        final TypeVar typeVar;
        final Unifier.Variable variable;

        PlusSubst(Subst parent, TypeVar typeVar, Unifier.Variable variable) {
            this.parent = parent;
            this.typeVar = typeVar;
            this.variable = variable;
        }

        @Override
        Unifier.Variable get(TypeVar typeVar) {
            return typeVar.equals(this.typeVar) ? this.variable : this.parent.get(typeVar);
        }

        public String toString() {
            LinkedHashMap<TypeVar, Unifier.Variable> map = new LinkedHashMap<TypeVar, Unifier.Variable>();
            PlusSubst e = this;
            while (true) {
                map.putIfAbsent(e.typeVar, e.variable);
                if (!(e.parent instanceof PlusSubst)) break;
                e = (PlusSubst)e.parent;
            }
            return ((Object)map).toString();
        }
    }

    private static class EmptySubst
    extends Subst {
        private EmptySubst() {
        }

        public String toString() {
            return "[]";
        }

        @Override
        Unifier.Variable get(TypeVar typeVar) {
            return null;
        }
    }

    private static class BindTypeEnv
    implements TypeEnv {
        private final String definedName;
        private final Binding.Kind kind;
        private final Function<TypeSystem, Unifier.Term> termFactory;
        private final TypeEnv parent;

        BindTypeEnv(String definedName, Binding.Kind kind, Function<TypeSystem, Unifier.Term> termFactory, TypeEnv parent) {
            this.definedName = Objects.requireNonNull(definedName);
            this.kind = kind;
            this.termFactory = Objects.requireNonNull(termFactory);
            this.parent = Objects.requireNonNull(parent);
        }

        @Override
        public int count(String name) {
            int count = 0;
            BindTypeEnv e = this;
            while (true) {
                if (e.definedName.equals(name)) {
                    ++count;
                }
                if (!(e.parent instanceof BindTypeEnv)) {
                    return count + e.parent.count(name);
                }
                e = (BindTypeEnv)e.parent;
            }
        }

        @Override
        public Unifier.Term get(TypeSystem typeSystem, String name, Function<String, RuntimeException> exceptionFactory) {
            BindTypeEnv e = this;
            while (!e.definedName.equals(name)) {
                if (!(e.parent instanceof BindTypeEnv)) {
                    return e.parent.get(typeSystem, name, exceptionFactory);
                }
                e = (BindTypeEnv)e.parent;
            }
            return e.termFactory.apply(typeSystem);
        }

        @Override
        public @Nullable Type getTypeOpt(String name) {
            return this.getAncestor().getTypeOpt(name);
        }

        private TypeEnv getAncestor() {
            BindTypeEnv e = this;
            while (e.parent instanceof BindTypeEnv) {
                e = (BindTypeEnv)e.parent;
            }
            return e.parent;
        }

        @Override
        public boolean has(String name) {
            BindTypeEnv e = this;
            while (!e.definedName.equals(name)) {
                if (!(e.parent instanceof BindTypeEnv)) {
                    return e.parent.has(name);
                }
                e = (BindTypeEnv)e.parent;
            }
            return true;
        }

        @Override
        public boolean hasOverloaded(String name) {
            BindTypeEnv e = this;
            while (!e.definedName.equals(name) || e.kind == Binding.Kind.VAL) {
                if (!(e.parent instanceof BindTypeEnv)) {
                    return e.parent.hasOverloaded(name);
                }
                e = (BindTypeEnv)e.parent;
            }
            return true;
        }

        @Override
        public void collectInstances(TypeSystem typeSystem, String name, Consumer<Unifier.Term> consumer) {
            BindTypeEnv e = this;
            while (true) {
                if (e.definedName.equals(name)) {
                    if (e.kind == Binding.Kind.OVER) {
                        return;
                    }
                    consumer.accept(e.termFactory.apply(typeSystem));
                }
                if (!(e.parent instanceof BindTypeEnv)) break;
                e = (BindTypeEnv)e.parent;
            }
            e.parent.collectInstances(typeSystem, name, consumer);
        }

        public String toString() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            BindTypeEnv e = this;
            while (true) {
                map.putIfAbsent(e.definedName, e.termFactory.toString());
                if (!(e.parent instanceof BindTypeEnv)) break;
                e = (BindTypeEnv)e.parent;
            }
            return ((Object)map).toString();
        }
    }

    static class SimpleTermFactory
    implements Function<TypeSystem, Unifier.Term> {
        private final Unifier.Term term;

        SimpleTermFactory(Unifier.Term term) {
            this.term = term;
        }

        @Override
        public Unifier.Term apply(TypeSystem typeSystem) {
            return this.term;
        }

        public String toString() {
            return this.term.toString();
        }
    }
}

