/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Chars;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Macro;
import net.hydromatic.morel.eval.Applicable;
import net.hydromatic.morel.eval.Applicable2;
import net.hydromatic.morel.eval.Applicable3;
import net.hydromatic.morel.eval.ApplicableImpl;
import net.hydromatic.morel.eval.Closure;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.CodeVisitor;
import net.hydromatic.morel.eval.Comparators;
import net.hydromatic.morel.eval.Describable;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.eval.DescriberImpl;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.EvalEnvs;
import net.hydromatic.morel.eval.MutableEvalEnv;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.foreign.RelList;
import net.hydromatic.morel.parse.Parsers;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RangeExtent;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.JavaVersion;
import net.hydromatic.morel.util.MapList;
import net.hydromatic.morel.util.MorelException;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.runtime.FlatLists;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Codes {
    private static final Function<Float, String> FLOAT_TO_STRING = JavaVersion.CURRENT.compareTo(JavaVersion.of(19)) >= 0 ? f -> Float.toString(f.floatValue()) : Codes::floatToString0;
    public static final float NEGATIVE_NAN = Float.intBitsToFloat(Float.floatToRawIntBits(Float.NaN) ^ Integer.MIN_VALUE);
    private static final List OPTION_NONE = ImmutableList.of((Object)"NONE");
    private static final Applicable OP_EQ = new Applicable2<Boolean, Object, Object>(BuiltIn.OP_EQ){

        @Override
        public Boolean apply(Object a0, Object a1) {
            return a0.equals(a1);
        }
    };
    private static final Applicable OP_NE = new Applicable2<Boolean, Object, Object>(BuiltIn.OP_NE){

        @Override
        public Boolean apply(Object a0, Object a1) {
            return !a0.equals(a1);
        }
    };
    private static final Applicable OP_LT = new Applicable2<Boolean, Comparable, Comparable>(BuiltIn.OP_LT){

        @Override
        public Boolean apply(Comparable a0, Comparable a1) {
            if (a0 instanceof Float && Float.isNaN(((Float)a0).floatValue()) || a1 instanceof Float && Float.isNaN(((Float)a1).floatValue())) {
                return false;
            }
            return a0.compareTo(a1) < 0;
        }
    };
    private static final Applicable OP_GT = new Applicable2<Boolean, Comparable, Comparable>(BuiltIn.OP_GT){

        @Override
        public Boolean apply(Comparable a0, Comparable a1) {
            if (a0 instanceof Float && Float.isNaN(((Float)a0).floatValue()) || a1 instanceof Float && Float.isNaN(((Float)a1).floatValue())) {
                return false;
            }
            return a0.compareTo(a1) > 0;
        }
    };
    private static final Applicable OP_LE = new Applicable2<Boolean, Comparable, Comparable>(BuiltIn.OP_LE){

        @Override
        public Boolean apply(Comparable a0, Comparable a1) {
            if (a0 instanceof Float && Float.isNaN(((Float)a0).floatValue()) || a1 instanceof Float && Float.isNaN(((Float)a1).floatValue())) {
                return false;
            }
            return a0.compareTo(a1) <= 0;
        }
    };
    private static final Applicable OP_GE = new Applicable2<Boolean, Comparable, Comparable>(BuiltIn.OP_GE){

        @Override
        public Boolean apply(Comparable a0, Comparable a1) {
            if (a0 instanceof Float && Float.isNaN(((Float)a0).floatValue()) || a1 instanceof Float && Float.isNaN(((Float)a1).floatValue())) {
                return false;
            }
            return a0.compareTo(a1) >= 0;
        }
    };
    private static final Applicable OP_ELEM = new Applicable2<Boolean, Object, List>(BuiltIn.OP_ELEM){

        @Override
        public Boolean apply(Object a0, List a1) {
            return a1.contains(a0);
        }
    };
    private static final Applicable OP_NOT_ELEM = new Applicable2<Boolean, Object, List>(BuiltIn.OP_NOT_ELEM){

        @Override
        public Boolean apply(Object a0, List a1) {
            return !a1.contains(a0);
        }
    };
    private static final Applicable Z_NEGATE_INT = new ApplicableImpl(BuiltIn.OP_NEGATE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return -((Integer)arg).intValue();
        }
    };
    private static final Applicable Z_NEGATE_REAL = new ApplicableImpl(BuiltIn.OP_NEGATE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            if (Float.isNaN(f)) {
                return Float.valueOf(Float.floatToRawIntBits(f) == Float.floatToRawIntBits(NEGATIVE_NAN) ? Float.NaN : NEGATIVE_NAN);
            }
            return Float.valueOf(-f);
        }
    };
    private static final Applicable Z_PLUS_INT = new Applicable2<Integer, Integer, Integer>(BuiltIn.OP_PLUS){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 + a1;
        }
    };
    private static final Applicable Z_PLUS_REAL = new Applicable2<Float, Float, Float>(BuiltIn.OP_PLUS){

        @Override
        public Float apply(Float a0, Float a1) {
            return Float.valueOf(a0.floatValue() + a1.floatValue());
        }
    };
    private static final Applicable Z_MINUS_INT = new Applicable2<Integer, Integer, Integer>(BuiltIn.OP_MINUS){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 - a1;
        }
    };
    private static final Applicable Z_MINUS_REAL = new Applicable2<Float, Float, Float>(BuiltIn.OP_MINUS){

        @Override
        public Float apply(Float a0, Float a1) {
            return Float.valueOf(a0.floatValue() - a1.floatValue());
        }
    };
    private static final Applicable Z_TIMES_INT = new Applicable2<Integer, Integer, Integer>(BuiltIn.OP_TIMES){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 * a1;
        }
    };
    private static final Applicable Z_TIMES_REAL = new Applicable2<Float, Float, Float>(BuiltIn.OP_TIMES){

        @Override
        public Float apply(Float a0, Float a1) {
            return Float.valueOf(a0.floatValue() * a1.floatValue());
        }
    };
    private static final Applicable Z_DIVIDE_INT = new Applicable2<Integer, Integer, Integer>(BuiltIn.OP_DIVIDE){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 / a1;
        }
    };
    private static final Applicable Z_DIVIDE_REAL = new Applicable2<Float, Float, Float>(BuiltIn.OP_DIVIDE){

        @Override
        public Float apply(Float a0, Float a1) {
            float v = a0.floatValue() / a1.floatValue();
            if (Float.isNaN(v)) {
                return Float.valueOf(Float.NaN);
            }
            return Float.valueOf(v);
        }
    };
    private static final Macro OP_NEGATE = (typeSystem, env, argType) -> {
        switch ((PrimitiveType)argType) {
            case INT: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_NEGATE_INT);
            }
            case REAL: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_NEGATE_REAL);
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Macro OP_DIVIDE = (typeSystem, env, argType) -> {
        Type resultType = ((TupleType)argType).argTypes.get(0);
        switch ((PrimitiveType)resultType) {
            case INT: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_DIVIDE_INT);
            }
            case REAL: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_DIVIDE_REAL);
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Applicable OP_DIV = new IntDiv(BuiltIn.OP_DIV);
    private static final Applicable GENERAL_OP_O = new ApplicableImpl("o"){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List tuple = (List)arg;
            final Applicable f = (Applicable)tuple.get(0);
            final Applicable g = (Applicable)tuple.get(1);
            return new ApplicableImpl("o$f$g"){

                @Override
                public Object apply(EvalEnv env, Object arg) {
                    return f.apply(env, g.apply(env, arg));
                }
            };
        }
    };
    private static final Applicable CHAR_CHR = new ApplicableImpl(BuiltIn.CHAR_CHR){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            int ord = (Integer)arg;
            if (ord < 0 || ord > 255) {
                throw new MorelRuntimeException(BuiltInExn.CHR, this.pos);
            }
            return Character.valueOf((char)ord);
        }
    };
    private static final Applicable CHAR_COMPARE = new Applicable2<List, Character, Character>(BuiltIn.CHAR_COMPARE){

        @Override
        public List apply(Character a0, Character a1) {
            if (a0.charValue() < a1.charValue()) {
                return ORDER_LESS;
            }
            if (a0.charValue() > a1.charValue()) {
                return ORDER_GREATER;
            }
            return ORDER_EQUAL;
        }
    };
    private static final Applicable CHAR_CONTAINS = new ApplicableImpl(BuiltIn.CHAR_CONTAINS){

        @Override
        public Object apply(EvalEnv env, Object argValue) {
            String s = (String)argValue;
            return Codes.charContains(s, false);
        }
    };
    private static final Applicable CHAR_FROM_CSTRING = new ApplicableImpl(BuiltIn.CHAR_FROM_CSTRING){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            throw new UnsupportedOperationException("CHAR_FROM_CSTRING");
        }
    };
    private static final Applicable CHAR_FROM_STRING = new ApplicableImpl(BuiltIn.CHAR_FROM_STRING){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            Character c = Parsers.fromString(s);
            return c == null ? OPTION_NONE : Codes.optionSome(c);
        }
    };
    private static final Applicable CHAR_IS_ALPHA = new CharPredicate(BuiltIn.CHAR_IS_ALPHA, CharPredicate::isAlpha);
    private static final Applicable CHAR_IS_ALPHA_NUM = new CharPredicate(BuiltIn.CHAR_IS_ALPHA_NUM, CharPredicate::isAlphaNum);
    private static final Applicable CHAR_IS_ASCII = new CharPredicate(BuiltIn.CHAR_IS_ASCII, CharPredicate::isAscii);
    private static final Applicable CHAR_IS_CNTRL = new CharPredicate(BuiltIn.CHAR_IS_CNTRL, CharPredicate::isCntrl);
    private static final Applicable CHAR_IS_DIGIT = new CharPredicate(BuiltIn.CHAR_IS_DIGIT, CharPredicate::isDigit);
    private static final Applicable CHAR_IS_GRAPH = new CharPredicate(BuiltIn.CHAR_IS_GRAPH, CharPredicate::isGraph);
    private static final Applicable CHAR_IS_HEX_DIGIT = new CharPredicate(BuiltIn.CHAR_IS_HEX_DIGIT, CharPredicate::isHexDigit);
    private static final Applicable CHAR_IS_LOWER = new CharPredicate(BuiltIn.CHAR_IS_LOWER, CharPredicate::isLower);
    private static final Applicable CHAR_IS_PRINT = new CharPredicate(BuiltIn.CHAR_IS_PRINT, CharPredicate::isPrint);
    private static final Applicable CHAR_IS_PUNCT = new CharPredicate(BuiltIn.CHAR_IS_PUNCT, CharPredicate::isPunct);
    private static final Applicable CHAR_IS_SPACE = new CharPredicate(BuiltIn.CHAR_IS_SPACE, CharPredicate::isSpace);
    private static final Applicable CHAR_IS_UPPER = new CharPredicate(BuiltIn.CHAR_IS_UPPER, CharPredicate::isUpper);
    private static final Character CHAR_MAX_CHAR = Character.valueOf('\u00ff');
    private static final Integer CHAR_MAX_ORD = 255;
    private static final Character CHAR_MIN_CHAR = Character.valueOf('\u0000');
    private static final Applicable CHAR_NOT_CONTAINS = new ApplicableImpl(BuiltIn.CHAR_CONTAINS){

        @Override
        public Object apply(EvalEnv env, Object argValue) {
            String s = (String)argValue;
            return Codes.charContains(s, true);
        }
    };
    private static final Applicable CHAR_OP_GE = new Applicable2<Boolean, Character, Character>(BuiltIn.CHAR_OP_GE){

        @Override
        public Boolean apply(Character a0, Character a1) {
            return a0.charValue() >= a1.charValue();
        }
    };
    private static final Applicable CHAR_OP_GT = new Applicable2<Boolean, Character, Character>(BuiltIn.CHAR_OP_GT){

        @Override
        public Boolean apply(Character a0, Character a1) {
            return a0.charValue() > a1.charValue();
        }
    };
    private static final Applicable CHAR_OP_LE = new Applicable2<Boolean, Character, Character>(BuiltIn.CHAR_OP_LE){

        @Override
        public Boolean apply(Character a0, Character a1) {
            return a0.charValue() <= a1.charValue();
        }
    };
    private static final Applicable CHAR_OP_LT = new Applicable2<Boolean, Character, Character>(BuiltIn.CHAR_OP_LT){

        @Override
        public Boolean apply(Character a0, Character a1) {
            return a0.charValue() < a1.charValue();
        }
    };
    private static final Applicable CHAR_ORD = new ApplicableImpl(BuiltIn.CHAR_ORD){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return (int)((Character)arg).charValue();
        }
    };
    private static final Applicable CHAR_PRED = new ApplicableImpl(BuiltIn.CHAR_PRED){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            char c = ((Character)arg).charValue();
            if (c == CHAR_MIN_CHAR.charValue()) {
                throw new MorelRuntimeException(BuiltInExn.CHR, this.pos);
            }
            return Character.valueOf((char)(c - '\u0001'));
        }
    };
    private static final Applicable CHAR_SUCC = new ApplicableImpl(BuiltIn.CHAR_SUCC){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            char c = ((Character)arg).charValue();
            if (c == CHAR_MAX_CHAR.charValue()) {
                throw new MorelRuntimeException(BuiltInExn.CHR, this.pos);
            }
            return Character.valueOf((char)(c + '\u0001'));
        }
    };
    private static final Applicable CHAR_TO_CSTRING = new ApplicableImpl(BuiltIn.CHAR_TO_CSTRING){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            throw new UnsupportedOperationException("CHAR_TO_CSTRING");
        }
    };
    private static final Applicable CHAR_TO_LOWER = new ApplicableImpl(BuiltIn.CHAR_TO_LOWER){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Character.valueOf(Character.toLowerCase(((Character)arg).charValue()));
        }
    };
    private static final Applicable CHAR_TO_STRING = new ApplicableImpl(BuiltIn.CHAR_TO_STRING){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Parsers.charToString(((Character)arg).charValue());
        }
    };
    private static final Applicable CHAR_TO_UPPER = new ApplicableImpl(BuiltIn.CHAR_TO_UPPER){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Character.valueOf(Character.toUpperCase(((Character)arg).charValue()));
        }
    };
    private static final Applicable INT_ABS = new ApplicableImpl(BuiltIn.INT_ABS){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Math.abs((Integer)arg);
        }
    };
    private static final Applicable INT_COMPARE = new Applicable2<List, Integer, Integer>(BuiltIn.INT_COMPARE){

        @Override
        public List apply(Integer a0, Integer a1) {
            return Codes.order(Integer.compare(a0, a1));
        }
    };
    private static final Applicable INT_FROM_INT = Codes.identity(BuiltIn.INT_FROM_INT);
    private static final Applicable INT_FROM_LARGE = Codes.identity(BuiltIn.INT_FROM_LARGE);
    static final Pattern INT_PATTERN = Pattern.compile("^ *-?[0-9]+");
    private static final Applicable INT_FROM_STRING = new ApplicableImpl(BuiltIn.INT_FROM_STRING){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            String s2 = s.replace('~', '-');
            Matcher matcher = INT_PATTERN.matcher(s2);
            if (!matcher.find(0)) {
                return OPTION_NONE;
            }
            String s3 = s2.substring(0, matcher.end());
            try {
                int f = Integer.parseInt(s3);
                return Codes.optionSome(f);
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)e);
            }
        }
    };
    private static final Applicable INT_MAX = new Applicable2<Integer, Integer, Integer>(BuiltIn.INT_MAX){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return Math.max(a0, a1);
        }
    };
    private static final List INT_MAX_INT = Codes.optionSome(Integer.MAX_VALUE);
    private static final Applicable INT_MIN = new Applicable2<Integer, Integer, Integer>(BuiltIn.INT_MIN){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return Math.min(a0, a1);
        }
    };
    private static final List INT_MIN_INT = Codes.optionSome(Integer.MAX_VALUE);
    private static final Applicable INT_DIV = new IntDiv(BuiltIn.INT_DIV);
    private static final Applicable INT_MOD = new IntMod(BuiltIn.INT_MOD);
    private static final List INT_PRECISION = Codes.optionSome(32);
    private static final Applicable INT_QUOT = new Applicable2<Integer, Integer, Integer>(BuiltIn.INT_QUOT){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 / a1;
        }
    };
    private static final Applicable INT_REM = new Applicable2<Integer, Integer, Integer>(BuiltIn.INT_REM){

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return a0 % a1;
        }
    };
    private static final Applicable INT_SAME_SIGN = new Applicable2<Boolean, Integer, Integer>(BuiltIn.INT_SAME_SIGN){

        @Override
        public Boolean apply(Integer a0, Integer a1) {
            return a0 < 0 && a1 < 0 || a0 == 0 && a1 == 0 || a0 > 0 && a1 > 0;
        }
    };
    private static final Applicable INT_SIGN = new ApplicableImpl(BuiltIn.INT_SIGN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Integer.compare((Integer)arg, 0);
        }
    };
    private static final Applicable INT_TO_INT = Codes.identity(BuiltIn.INT_TO_INT);
    private static final Applicable INT_TO_LARGE = Codes.identity(BuiltIn.INT_TO_LARGE);
    private static final Applicable INT_TO_STRING = new ApplicableImpl(BuiltIn.INT_TO_STRING){

        @Override
        public String apply(EvalEnv env, Object arg) {
            Integer f = (Integer)arg;
            String s = Integer.toString(f);
            return s.replace('-', '~');
        }
    };
    private static final Applicable INTERACT_USE = new InteractUse(Pos.ZERO, false);
    private static final Applicable INTERACT_USE_SILENTLY = new InteractUse(Pos.ZERO, true);
    private static final Applicable OP_CARET = new Applicable2<String, String, String>(BuiltIn.OP_CARET){

        @Override
        public String apply(String a0, String a1) {
            return a0 + a1;
        }
    };
    private static final Applicable OP_CONS = new Applicable2<List, Object, Iterable>(BuiltIn.OP_CONS){

        @Override
        public List apply(Object e, Iterable iterable) {
            return ImmutableList.builder().add(e).addAll(iterable).build();
        }
    };
    private static final Applicable NOT = new ApplicableImpl(BuiltIn.NOT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return (Boolean)arg == false;
        }
    };
    private static final Applicable ABS = new ApplicableImpl(BuiltIn.ABS){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Integer integer = (Integer)arg;
            return integer >= 0 ? integer : -integer.intValue();
        }
    };
    private static final Applicable IGNORE = new ApplicableImpl(BuiltIn.IGNORE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Unit.INSTANCE;
        }
    };
    private static final Macro OP_MINUS = (typeSystem, env, argType) -> {
        Type resultType = ((TupleType)argType).argTypes.get(0);
        switch ((PrimitiveType)resultType) {
            case INT: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_MINUS_INT);
            }
            case REAL: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_MINUS_REAL);
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Applicable OP_MOD = new IntMod(BuiltIn.OP_MOD);
    private static final Macro OP_PLUS = (typeSystem, env, argType) -> {
        Type resultType = ((TupleType)argType).argTypes.get(0);
        switch ((PrimitiveType)resultType) {
            case INT: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_PLUS_INT);
            }
            case REAL: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_PLUS_REAL);
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Macro OP_TIMES = (typeSystem, env, argType) -> {
        Type resultType = ((TupleType)argType).argTypes.get(0);
        switch ((PrimitiveType)resultType) {
            case INT: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_TIMES_INT);
            }
            case REAL: {
                return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_TIMES_REAL);
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Integer STRING_MAX_SIZE = Integer.MAX_VALUE;
    private static final Applicable STRING_OP_CARET = new Applicable2<String, String, String>(BuiltIn.STRING_OP_CARET){

        @Override
        public String apply(String a0, String a1) {
            return a0 + a1;
        }
    };
    private static final Applicable STRING_OP_GE = new Applicable2<Boolean, String, String>(BuiltIn.STRING_OP_GE){

        @Override
        public Boolean apply(String a0, String a1) {
            return a0.compareTo(a1) >= 0;
        }
    };
    private static final Applicable STRING_OP_GT = new Applicable2<Boolean, String, String>(BuiltIn.STRING_OP_GT){

        @Override
        public Boolean apply(String a0, String a1) {
            return a0.compareTo(a1) > 0;
        }
    };
    private static final Applicable STRING_OP_LE = new Applicable2<Boolean, String, String>(BuiltIn.STRING_OP_LE){

        @Override
        public Boolean apply(String a0, String a1) {
            return a0.compareTo(a1) <= 0;
        }
    };
    private static final Applicable STRING_OP_LT = new Applicable2<Boolean, String, String>(BuiltIn.STRING_OP_LT){

        @Override
        public Boolean apply(String a0, String a1) {
            return a0.compareTo(a1) < 0;
        }
    };
    private static final Applicable STRING_SIZE = new ApplicableImpl(BuiltIn.STRING_SIZE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return ((String)arg).length();
        }
    };
    private static final Applicable STRING_SUB = new StringSub(Pos.ZERO);
    private static final Applicable STRING_COLLATE = new ApplicableImpl(BuiltIn.STRING_COLLATE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.stringCollate((Applicable)arg);
        }
    };
    private static final Applicable STRING_COMPARE = new Applicable2<List, String, String>(BuiltIn.STRING_COMPARE){

        @Override
        public List apply(String a0, String a1) {
            return Codes.order(a0.compareTo(a1));
        }
    };
    private static final Applicable STRING_EXTRACT = new StringExtract(Pos.ZERO);
    private static final Applicable STRING_FIELDS = Codes.fieldsTokens(BuiltIn.STRING_FIELDS);
    private static final Applicable STRING_TOKENS = Codes.fieldsTokens(BuiltIn.STRING_TOKENS);
    private static final Applicable STRING_SUBSTRING = new StringSubstring(Pos.ZERO);
    private static final Applicable STRING_CONCAT = new StringConcat(Pos.ZERO);
    private static final Applicable STRING_CONCAT_WITH = new StringConcatWith(Pos.ZERO);
    private static final Applicable STRING_STR = new ApplicableImpl(BuiltIn.STRING_STR){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Character character = (Character)arg;
            return character + "";
        }
    };
    private static final Applicable STRING_IMPLODE = new ApplicableImpl(BuiltIn.STRING_IMPLODE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return String.valueOf(Chars.toArray((Collection)((List)arg)));
        }
    };
    private static final Applicable STRING_EXPLODE = new ApplicableImpl(BuiltIn.STRING_EXPLODE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            return MapList.of(s.length(), s::charAt);
        }
    };
    private static final Applicable STRING_MAP = new ApplicableImpl(BuiltIn.STRING_MAP){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.stringMap((Applicable)arg);
        }
    };
    private static final Applicable STRING_TRANSLATE = new ApplicableImpl(BuiltIn.STRING_TRANSLATE){

        @Override
        public Applicable apply(EvalEnv env, Object arg) {
            Applicable f = (Applicable)arg;
            return Codes.translate(f);
        }
    };
    private static final Applicable STRING_IS_PREFIX = new ApplicableImpl(BuiltIn.STRING_IS_PREFIX){

        @Override
        public Applicable apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            return Codes.isPrefix(s);
        }
    };
    private static final Applicable STRING_IS_SUBSTRING = new ApplicableImpl(BuiltIn.STRING_IS_SUBSTRING){

        @Override
        public Applicable apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            return Codes.isSubstring(s);
        }
    };
    private static final Applicable STRING_IS_SUFFIX = new ApplicableImpl(BuiltIn.STRING_IS_SUFFIX){

        @Override
        public Applicable apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            return Codes.isSuffix(s);
        }
    };
    private static final Applicable LIST_NULL = Codes.empty(BuiltIn.LIST_NULL);
    private static final Applicable LIST_LENGTH = Codes.length(BuiltIn.LIST_LENGTH);
    private static final Applicable LIST_AT = Codes.union(BuiltIn.LIST_AT);
    private static final Applicable LIST_HD = new ListHd(BuiltIn.LIST_HD, Pos.ZERO);
    private static final Applicable LIST_TL = new ListTl(BuiltIn.LIST_TL, Pos.ZERO);
    private static final Applicable LIST_LAST = new ListLast(BuiltIn.LIST_LAST, Pos.ZERO);
    private static final Applicable LIST_GET_ITEM = Codes.listGetItem(BuiltIn.LIST_GET_ITEM);
    private static final Applicable LIST_NTH = new ListNth(BuiltIn.LIST_NTH, Pos.ZERO);
    private static final Applicable LIST_TAKE = new ListTake(BuiltIn.LIST_TAKE, Pos.ZERO);
    private static final Applicable LIST_DROP = Codes.listDrop(BuiltIn.LIST_DROP);
    private static final Applicable LIST_REV = new ApplicableImpl(BuiltIn.LIST_REV){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            return Lists.reverse((List)list);
        }
    };
    private static final Applicable LIST_CONCAT = Codes.listConcat(BuiltIn.LIST_CONCAT);
    private static final Applicable LIST_EXCEPT = new ApplicableImpl(BuiltIn.LIST_EXCEPT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            if (list.isEmpty()) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            List collection = new ArrayList((Collection)list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                collection.removeAll((Collection)list.get(i));
            }
            if (collection.size() == ((List)list.get(0)).size()) {
                collection = (List)list.get(0);
            }
            return ImmutableList.copyOf(collection);
        }
    };
    private static final Applicable LIST_INTERSECT = new ApplicableImpl(BuiltIn.LIST_EXCEPT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            if (list.isEmpty()) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            List collection = new ArrayList((Collection)list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                HashSet set = new HashSet((Collection)list.get(i));
                collection.retainAll(set);
            }
            if (collection.size() == ((List)list.get(0)).size()) {
                collection = (List)list.get(0);
            }
            return ImmutableList.copyOf(collection);
        }
    };
    private static final Applicable LIST_REV_APPEND = new Applicable2<List, List, List>(BuiltIn.LIST_REV_APPEND){

        @Override
        public List apply(List list0, List list1) {
            return ImmutableList.builder().addAll((Iterable)Lists.reverse((List)list0)).addAll((Iterable)list1).build();
        }
    };
    private static final Applicable LIST_APP = Codes.listApp0(BuiltIn.LIST_APP);
    private static final Applicable LIST_MAPI = new ApplicableImpl(BuiltIn.LIST_MAPI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.listMapi((Applicable)arg);
        }
    };
    private static final Applicable LIST_MAP = Codes.listMap0(BuiltIn.LIST_MAP);
    private static final Applicable LIST_MAP_PARTIAL = Codes.listMapPartial0(BuiltIn.LIST_MAP_PARTIAL);
    private static final Applicable LIST_FIND = Codes.find(BuiltIn.LIST_FIND);
    private static final Applicable LIST_FILTER = Codes.listFilter0(BuiltIn.LIST_FILTER);
    private static final Applicable LIST_PARTITION = Codes.listPartition0(BuiltIn.LIST_PARTITION);
    private static final Applicable LIST_FOLDL = Codes.listFold0(BuiltIn.LIST_FOLDL, true);
    private static final Applicable LIST_FOLDR = Codes.listFold0(BuiltIn.LIST_FOLDR, false);
    private static final Applicable LIST_EXISTS = Codes.exists(BuiltIn.LIST_EXISTS);
    private static final Applicable LIST_ALL = Codes.all(BuiltIn.LIST_ALL);
    private static final Applicable LIST_TABULATE = new ListTabulate(BuiltIn.LIST_TABULATE, Pos.ZERO);
    private static final Applicable LIST_COLLATE = Codes.collate(BuiltIn.LIST_COLLATE);
    private static final Applicable MATH_ACOS = new ApplicableImpl(BuiltIn.MATH_ACOS){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.acos(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_ASIN = new ApplicableImpl(BuiltIn.MATH_ASIN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.asin(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_ATAN = new ApplicableImpl(BuiltIn.MATH_ATAN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.atan(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_ATAN2 = new Applicable2<Float, Float, Float>(BuiltIn.MATH_ATAN2){

        @Override
        public Float apply(Float arg0, Float arg1) {
            return Float.valueOf((float)Math.atan2(arg0.floatValue(), arg1.floatValue()));
        }
    };
    private static final Applicable MATH_COS = new ApplicableImpl(BuiltIn.MATH_COS){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.cos(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_COSH = new ApplicableImpl(BuiltIn.MATH_COSH){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.cosh(((Float)arg).floatValue()));
        }
    };
    private static final float MATH_E = (float)Math.E;
    private static final Applicable MATH_EXP = new ApplicableImpl(BuiltIn.MATH_EXP){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.exp(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_LN = new ApplicableImpl(BuiltIn.MATH_LN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.log(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_LOG10 = new ApplicableImpl(BuiltIn.MATH_LOG10){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.log10(((Float)arg).floatValue()));
        }
    };
    private static final float MATH_PI = (float)Math.PI;
    private static final Applicable MATH_POW = new Applicable2<Float, Float, Float>(BuiltIn.MATH_POW){

        @Override
        public Float apply(Float arg0, Float arg1) {
            return Float.valueOf((float)Math.pow(arg0.floatValue(), arg1.floatValue()));
        }
    };
    private static final Applicable MATH_SIN = new ApplicableImpl(BuiltIn.MATH_SIN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.sin(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_SINH = new ApplicableImpl(BuiltIn.MATH_SINH){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.sinh(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_SQRT = new ApplicableImpl(BuiltIn.MATH_SQRT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.sqrt(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_TAN = new ApplicableImpl(BuiltIn.MATH_TAN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.tan(((Float)arg).floatValue()));
        }
    };
    private static final Applicable MATH_TANH = new ApplicableImpl(BuiltIn.MATH_TANH){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.tanh(((Float)arg).floatValue()));
        }
    };
    private static final Applicable OPTION_APP = new ApplicableImpl(BuiltIn.OPTION_APP){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Applicable f = (Applicable)arg;
            return Codes.optionApp(f);
        }
    };
    private static final Applicable OPTION_GET_OPT = new ApplicableImpl(BuiltIn.OPTION_GET_OPT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List tuple = (List)arg;
            List opt = (List)tuple.get(0);
            if (opt.size() == 2) {
                assert (opt.get(0).equals("SOME"));
                return opt.get(1);
            }
            return tuple.get(1);
        }
    };
    private static final Applicable OPTION_IS_SOME = new ApplicableImpl(BuiltIn.OPTION_IS_SOME){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List opt = (List)arg;
            return opt.size() == 2;
        }
    };
    private static final Applicable OPTION_VAL_OF = new OptionValOf(Pos.ZERO);
    private static final Applicable OPTION_FILTER = new ApplicableImpl(BuiltIn.OPTION_FILTER){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Applicable f = (Applicable)arg;
            return Codes.optionFilter(f);
        }
    };
    private static final Applicable OPTION_JOIN = new ApplicableImpl(BuiltIn.OPTION_JOIN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List opt = (List)arg;
            return opt.size() == 2 ? opt.get(1) : opt;
        }
    };
    private static final Applicable OPTION_MAP = new ApplicableImpl(BuiltIn.OPTION_MAP){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.optionMap((Applicable)arg);
        }
    };
    private static final Applicable OPTION_MAP_PARTIAL = new ApplicableImpl(BuiltIn.OPTION_MAP_PARTIAL){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.optionMapPartial((Applicable)arg);
        }
    };
    private static final Applicable OPTION_COMPOSE = new ApplicableImpl(BuiltIn.OPTION_COMPOSE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List tuple = (List)arg;
            Applicable f = (Applicable)tuple.get(0);
            Applicable g = (Applicable)tuple.get(1);
            return Codes.optionCompose(f, g);
        }
    };
    private static final Applicable OPTION_COMPOSE_PARTIAL = new ApplicableImpl(BuiltIn.OPTION_COMPOSE_PARTIAL){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List tuple = (List)arg;
            Applicable f = (Applicable)tuple.get(0);
            Applicable g = (Applicable)tuple.get(1);
            return Codes.optionComposePartial(f, g);
        }
    };
    private static final Applicable REAL_ABS = new ApplicableImpl(BuiltIn.REAL_ABS){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Float.valueOf(Math.abs(((Float)arg).floatValue()));
        }
    };
    private static final Applicable REAL_CEIL = new ApplicableImpl(BuiltIn.REAL_CEIL){

        @Override
        public Integer apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            if (f >= 0.0f) {
                return Math.round(f);
            }
            return -Math.round(-f);
        }
    };
    private static final Applicable REAL_CHECK_FLOAT = new RealCheckFloat(Pos.ZERO);
    private static final Applicable REAL_COMPARE = new RealCompare(Pos.ZERO);
    private static final Applicable REAL_COPY_SIGN = new Applicable2<Float, Float, Float>(BuiltIn.REAL_COPY_SIGN){

        @Override
        public Float apply(Float f0, Float f1) {
            if (Float.isNaN(f1.floatValue())) {
                f1 = Float.valueOf(Codes.isNegative(f1.floatValue()) ? -1.0f : 1.0f);
            }
            return Float.valueOf(Math.copySign(f0.floatValue(), f1.floatValue()));
        }
    };
    private static final Applicable REAL_FLOOR = new ApplicableImpl(BuiltIn.REAL_FLOOR){

        @Override
        public Integer apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            if (f >= 0.0f) {
                return -Math.round(-f);
            }
            return Math.round(f);
        }
    };
    private static final Applicable REAL_FROM_INT = new ApplicableImpl(BuiltIn.REAL_FROM_INT){

        @Override
        public Float apply(EvalEnv env, Object arg) {
            return Float.valueOf(((Integer)arg).intValue());
        }
    };
    private static final Applicable REAL_FROM_MAN_EXP = new Applicable2<Float, Integer, Float>(BuiltIn.REAL_FROM_MAN_EXP){

        @Override
        public Float apply(Integer exp, Float mantissa) {
            if (!Float.isFinite(mantissa.floatValue())) {
                return mantissa;
            }
            if (exp >= 127) {
                int exp2 = exp - -126 & 0xFF;
                int bits = Float.floatToRawIntBits(mantissa.floatValue());
                int bits2 = bits & 0x807FFFFF | exp2 << 23;
                return Float.valueOf(Float.intBitsToFloat(bits2));
            }
            int exp2 = exp - -126 + 1 & 0xFF;
            float exp3 = Float.intBitsToFloat(exp2 << 23);
            return Float.valueOf(mantissa.floatValue() * exp3);
        }
    };
    static final Pattern FLOAT_PATTERN = Pattern.compile("^ *-?([0-9]*\\.)?[0-9]+([Ee]-?[0-9]+)?");
    private static final Applicable REAL_FROM_STRING = new ApplicableImpl(BuiltIn.REAL_FROM_STRING){

        @Override
        public List apply(EvalEnv env, Object arg) {
            String s = (String)arg;
            String s2 = s.replace('~', '-');
            Matcher matcher = FLOAT_PATTERN.matcher(s2);
            if (!matcher.find(0)) {
                return OPTION_NONE;
            }
            String s3 = s2.substring(0, matcher.end());
            try {
                float f = Float.parseFloat(s3);
                return Codes.optionSome(Float.valueOf(f));
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)e);
            }
        }
    };
    private static final Applicable REAL_IS_FINITE = new ApplicableImpl(BuiltIn.REAL_IS_FINITE){

        @Override
        public Boolean apply(EvalEnv env, Object arg) {
            return Float.isFinite(((Float)arg).floatValue());
        }
    };
    private static final Applicable REAL_IS_NAN = new ApplicableImpl(BuiltIn.REAL_IS_NAN){

        @Override
        public Boolean apply(EvalEnv env, Object arg) {
            return Float.isNaN(((Float)arg).floatValue());
        }
    };
    private static final Applicable REAL_IS_NORMAL = new ApplicableImpl(BuiltIn.REAL_IS_NORMAL){

        @Override
        public Boolean apply(EvalEnv env, Object arg) {
            Float f = (Float)arg;
            return Float.isFinite(f.floatValue()) && (f.floatValue() >= Float.MIN_NORMAL || f.floatValue() <= -1.1754944E-38f);
        }
    };
    private static final float REAL_NEG_INF = Float.NEGATIVE_INFINITY;
    private static final float REAL_POS_INF = Float.POSITIVE_INFINITY;
    private static final int REAL_RADIX = 2;
    private static final int REAL_PRECISION = 24;
    private static final Applicable REAL_MIN = new Applicable2<Float, Float, Float>(BuiltIn.REAL_MIN){

        @Override
        public Float apply(Float f0, Float f1) {
            return Float.valueOf(Float.isNaN(f0.floatValue()) ? f1.floatValue() : (Float.isNaN(f1.floatValue()) ? f0.floatValue() : Math.min(f0.floatValue(), f1.floatValue())));
        }
    };
    private static final Applicable REAL_MAX = new Applicable2<Float, Float, Float>(BuiltIn.REAL_MAX){

        @Override
        public Float apply(Float f0, Float f1) {
            return Float.valueOf(Float.isNaN(f0.floatValue()) ? f1.floatValue() : (Float.isNaN(f1.floatValue()) ? f0.floatValue() : Math.max(f0.floatValue(), f1.floatValue())));
        }
    };
    private static final float REAL_MAX_FINITE = Float.MAX_VALUE;
    private static final float REAL_MIN_POS = Float.MIN_VALUE;
    private static final float REAL_MIN_NORMAL_POS = Float.MIN_NORMAL;
    private static final Applicable REAL_REAL_MOD = new ApplicableImpl(BuiltIn.REAL_REAL_MOD){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            if (Float.isInfinite(f)) {
                return Float.valueOf(f > 0.0f ? 0.0f : -0.0f);
            }
            return Float.valueOf(f % 1.0f);
        }
    };
    private static final Applicable REAL_REAL_CEIL = new ApplicableImpl(BuiltIn.REAL_REAL_CEIL){

        @Override
        public Float apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.ceil(((Float)arg).floatValue()));
        }
    };
    private static final Applicable REAL_REAL_FLOOR = new ApplicableImpl(BuiltIn.REAL_REAL_FLOOR){

        @Override
        public Float apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.floor(((Float)arg).floatValue()));
        }
    };
    private static final Applicable REAL_REAL_ROUND = new ApplicableImpl(BuiltIn.REAL_REAL_ROUND){

        @Override
        public Float apply(EvalEnv env, Object arg) {
            return Float.valueOf((float)Math.rint(((Float)arg).floatValue()));
        }
    };
    private static final Applicable REAL_REAL_TRUNC = new ApplicableImpl(BuiltIn.REAL_REAL_TRUNC){

        @Override
        public Float apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            float frac = f % 1.0f;
            return Float.valueOf(f - frac);
        }
    };
    private static final Applicable REAL_REM = new Applicable2<Float, Float, Float>(BuiltIn.REAL_REM){

        @Override
        public Float apply(Float x, Float y) {
            return Float.valueOf(x.floatValue() % y.floatValue());
        }
    };
    private static final Applicable REAL_ROUND = new ApplicableImpl(BuiltIn.REAL_ROUND){

        @Override
        public Integer apply(EvalEnv env, Object arg) {
            return Math.round(((Float)arg).floatValue());
        }
    };
    private static final Applicable REAL_SAME_SIGN = new Applicable2<Boolean, Float, Float>(BuiltIn.REAL_SAME_SIGN){

        @Override
        public Boolean apply(Float x, Float y) {
            return Codes.isNegative(x.floatValue()) == Codes.isNegative(y.floatValue());
        }
    };
    private static final Applicable REAL_SIGN = new RealSign(Pos.ZERO);
    private static final Applicable REAL_SIGN_BIT = new ApplicableImpl(BuiltIn.REAL_SIGN_BIT){

        @Override
        public Boolean apply(EvalEnv env, Object arg) {
            return Codes.isNegative(((Float)arg).floatValue());
        }
    };
    private static final Applicable REAL_SPLIT = new ApplicableImpl(BuiltIn.REAL_SPLIT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            float whole;
            float frac;
            float f = ((Float)arg).floatValue();
            if (Float.isInfinite(f)) {
                frac = f > 0.0f ? 0.0f : -0.0f;
                whole = f;
            } else {
                frac = f % 1.0f;
                whole = f - frac;
            }
            return ImmutableList.of((Object)Float.valueOf(frac), (Object)Float.valueOf(whole));
        }
    };
    private static final Applicable REAL_TO_MAN_EXP = new ApplicableImpl(BuiltIn.REAL_TO_MAN_EXP){

        @Override
        public List apply(EvalEnv env, Object arg) {
            float mantissa;
            float f = ((Float)arg).floatValue();
            int bits = Float.floatToRawIntBits(f);
            int exp = bits >> 23 & 0xFF;
            if (exp == 0) {
                mantissa = f / Float.MIN_NORMAL;
            } else if (Float.isFinite(f)) {
                int bits2 = bits & 0x807FFFFF | 0x3F000000;
                mantissa = Float.intBitsToFloat(bits2);
            } else {
                mantissa = f;
            }
            return ImmutableList.of((Object)(exp + -126), (Object)Float.valueOf(mantissa));
        }
    };
    private static final Applicable REAL_TO_STRING = new ApplicableImpl(BuiltIn.REAL_TO_STRING){

        @Override
        public String apply(EvalEnv env, Object arg) {
            Float f = (Float)arg;
            return Codes.floatToString(f.floatValue());
        }
    };
    private static final Applicable REAL_TRUNC = new ApplicableImpl(BuiltIn.REAL_TRUNC){

        @Override
        public Integer apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            return (int)f;
        }
    };
    private static final Applicable REAL_UNORDERED = new Applicable2<Boolean, Float, Float>(BuiltIn.REAL_UNORDERED){

        @Override
        public Boolean apply(Float f0, Float f1) {
            return Float.isNaN(f0.floatValue()) || Float.isNaN(f1.floatValue());
        }
    };
    private static final Applicable RELATIONAL_COMPARE = Comparer.INITIAL;
    private static final Applicable RELATIONAL_COUNT = Codes.length(BuiltIn.RELATIONAL_COUNT);
    private static final Applicable RELATIONAL_NON_EMPTY = Codes.nonEmpty(BuiltIn.RELATIONAL_NON_EMPTY);
    private static final Applicable RELATIONAL_EMPTY = Codes.empty(BuiltIn.RELATIONAL_EMPTY);
    private static final Applicable RELATIONAL_ITERATE = new ApplicableImpl(BuiltIn.RELATIONAL_ITERATE){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            final List initialList = (List)arg;
            return new ApplicableImpl("Relational.iterate$list"){

                @Override
                public Object apply(EvalEnv env, Object argValue) {
                    List list;
                    Applicable update = (Applicable)argValue;
                    List newList = list = initialList;
                    List nextList;
                    while (!(nextList = (List)update.apply(env, FlatLists.of((Object)list, (Object)newList))).isEmpty()) {
                        list = ImmutableList.builder().addAll((Iterable)list).addAll((Iterable)nextList).build();
                        newList = nextList;
                    }
                    return list;
                }
            };
        }
    };
    private static final Applicable RELATIONAL_ONLY = new RelationalOnly(Pos.ZERO);
    private static final Applicable Z_SUM_INT = new ApplicableImpl("Relational.sum$int"){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            int sum = 0;
            for (Number o : list) {
                sum += o.intValue();
            }
            return sum;
        }
    };
    private static final Applicable Z_SUM_REAL = new ApplicableImpl("Relational.sum$real"){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            float sum = 0.0f;
            for (Number o : list) {
                sum += o.floatValue();
            }
            return Float.valueOf(sum);
        }
    };
    private static final Macro RELATIONAL_SUM = (typeSystem, env, argType) -> {
        if (argType.isCollection()) {
            Type resultType = argType.arg(0);
            switch ((PrimitiveType)resultType) {
                case INT: {
                    return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_SUM_INT);
                }
                case REAL: {
                    return CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_SUM_REAL);
                }
            }
        }
        throw new AssertionError((Object)("bad type " + argType));
    };
    private static final Applicable RELATIONAL_MIN = new ApplicableImpl(BuiltIn.RELATIONAL_MIN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Ordering.natural().min((Iterable)((List)arg));
        }
    };
    private static final Applicable RELATIONAL_MAX = new ApplicableImpl(BuiltIn.RELATIONAL_MAX){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Ordering.natural().max((Iterable)((List)arg));
        }
    };
    private static final Applicable SYS_CLEAR_ENV = new ApplicableImpl(BuiltIn.MATH_LOG10){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            session.clearEnv();
            return Unit.INSTANCE;
        }
    };
    private static final Applicable SYS_PLAN = new ApplicableImpl(BuiltIn.SYS_PLAN){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            return Codes.describe(session.code);
        }
    };
    private static final Applicable SYS_SET = new ApplicableImpl(BuiltIn.SYS_SET){

        @Override
        public Unit apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            List list = (List)arg;
            String propName = (String)list.get(0);
            Object value = list.get(1);
            Prop.lookup(propName).setLenient(session.map, value);
            return Unit.INSTANCE;
        }
    };
    private static final Applicable SYS_SHOW = new ApplicableImpl(BuiltIn.SYS_SHOW){

        @Override
        public List apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            String propName = (String)arg;
            Object value = Prop.lookup(propName).get(session.map);
            return value == null ? OPTION_NONE : Codes.optionSome(value.toString());
        }
    };
    private static final Applicable SYS_SHOW_ALL = new ApplicableImpl(BuiltIn.SYS_SHOW_ALL){

        @Override
        public List apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            ImmutableList.Builder list = ImmutableList.builder();
            for (Prop prop : Prop.BY_CAMEL_NAME) {
                Object value = prop.get(session.map);
                List option = value == null ? OPTION_NONE : Codes.optionSome(value.toString());
                list.add((Object)ImmutableList.of((Object)prop.camelName, (Object)option));
            }
            return list.build();
        }
    };
    private static final Applicable SYS_UNSET = new ApplicableImpl(BuiltIn.SYS_UNSET){

        @Override
        public Unit apply(EvalEnv env, Object arg) {
            Session session = (Session)env.getOpt("$session");
            String propName = (String)arg;
            Prop prop = Prop.lookup(propName);
            Object value = prop.remove(session.map);
            return Unit.INSTANCE;
        }
    };
    private static final List ORDER_LESS = ImmutableList.of((Object)BuiltIn.Constructor.ORDER_LESS.constructor);
    private static final List ORDER_EQUAL = ImmutableList.of((Object)BuiltIn.Constructor.ORDER_EQUAL.constructor);
    private static final List ORDER_GREATER = ImmutableList.of((Object)BuiltIn.Constructor.ORDER_GREATER.constructor);
    private static final int VECTOR_MAX_LEN = 0xFFFFFF;
    private static final Applicable VECTOR_FROM_LIST = Codes.identity(BuiltIn.VECTOR_FROM_LIST);
    private static final Applicable VECTOR_TABULATE = new ListTabulate(BuiltIn.VECTOR_TABULATE, Pos.ZERO);
    private static final Applicable VECTOR_LENGTH = Codes.length(BuiltIn.VECTOR_LENGTH);
    private static final Applicable VECTOR_SUB = new ListNth(BuiltIn.VECTOR_SUB, Pos.ZERO);
    private static final Applicable VECTOR_UPDATE = new VectorUpdate(Pos.ZERO);
    private static final Applicable VECTOR_CONCAT = new ApplicableImpl(BuiltIn.VECTOR_CONCAT){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List lists = (List)arg;
            ImmutableList.Builder b = ImmutableList.builder();
            for (List list : lists) {
                b.addAll((Iterable)list);
            }
            return b.build();
        }
    };
    private static final Applicable VECTOR_APPI = new ApplicableImpl(BuiltIn.VECTOR_APPI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.vectorAppi((Applicable)arg);
        }
    };
    private static final Applicable VECTOR_APP = new ApplicableImpl(BuiltIn.VECTOR_APP){

        @Override
        public Applicable apply(EvalEnv env, Object arg) {
            return Codes.vectorApp((Applicable)arg);
        }
    };
    private static final Applicable VECTOR_MAPI = new ApplicableImpl(BuiltIn.VECTOR_MAPI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.listMapi((Applicable)arg);
        }
    };
    private static final Applicable VECTOR_MAP = new ApplicableImpl(BuiltIn.VECTOR_MAP){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.vectorMap((Applicable)arg);
        }
    };
    private static final Applicable VECTOR_FOLDLI = new ApplicableImpl(BuiltIn.VECTOR_FOLDLI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            final Applicable f = (Applicable)arg;
            return new ApplicableImpl("Vector.foldli$f"){

                @Override
                public Object apply(EvalEnv env2, final Object init) {
                    return new ApplicableImpl("Vector.foldli$f$init"){

                        @Override
                        public Object apply(EvalEnv env3, Object arg3) {
                            List vec = (List)arg3;
                            Object acc = init;
                            int n = vec.size();
                            for (int i = 0; i < n; ++i) {
                                acc = f.apply(env3, FlatLists.of((Object)i, vec.get(i), (Object)acc));
                            }
                            return acc;
                        }
                    };
                }
            };
        }
    };
    private static final Applicable VECTOR_FOLDRI = new ApplicableImpl(BuiltIn.VECTOR_FOLDRI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            final Applicable f = (Applicable)arg;
            return new ApplicableImpl("Vector.foldri$f"){

                @Override
                public Object apply(EvalEnv env2, final Object init) {
                    return new ApplicableImpl("Vector.foldri$f$init"){

                        @Override
                        public Object apply(EvalEnv env3, Object arg3) {
                            List vec = (List)arg3;
                            Object acc = init;
                            for (int i = vec.size() - 1; i >= 0; --i) {
                                acc = f.apply(env3, FlatLists.of((Object)i, vec.get(i), (Object)acc));
                            }
                            return acc;
                        }
                    };
                }
            };
        }
    };
    private static final Applicable VECTOR_FOLDL = new ApplicableImpl(BuiltIn.VECTOR_FOLDL){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            final Applicable f = (Applicable)arg;
            return new ApplicableImpl("Vector.foldl$f"){

                @Override
                public Object apply(EvalEnv env2, final Object init) {
                    return new ApplicableImpl("Vector.foldl$f$init"){

                        @Override
                        public Object apply(EvalEnv env3, Object arg3) {
                            List vec = (List)arg3;
                            Object acc = init;
                            for (Object o : vec) {
                                acc = f.apply(env3, FlatLists.of(o, (Object)acc));
                            }
                            return acc;
                        }
                    };
                }
            };
        }
    };
    private static final Applicable VECTOR_FOLDR = new ApplicableImpl(BuiltIn.VECTOR_FOLDR){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            final Applicable f = (Applicable)arg;
            return new ApplicableImpl("Vector.foldlr$f"){

                @Override
                public Object apply(EvalEnv env2, final Object init) {
                    return new ApplicableImpl("Vector.foldr$f$init"){

                        @Override
                        public Object apply(EvalEnv env3, Object arg3) {
                            List vec = (List)arg3;
                            Object acc = init;
                            for (int i = vec.size() - 1; i >= 0; --i) {
                                acc = f.apply(env3, FlatLists.of(vec.get(i), (Object)acc));
                            }
                            return acc;
                        }
                    };
                }
            };
        }
    };
    private static final Applicable VECTOR_FINDI = new ApplicableImpl(BuiltIn.VECTOR_FINDI){

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.vectorFindi((Applicable)arg);
        }
    };
    private static final Applicable VECTOR_FIND = Codes.find(BuiltIn.VECTOR_FIND);
    private static final Applicable VECTOR_EXISTS = Codes.exists(BuiltIn.VECTOR_EXISTS);
    private static final Applicable VECTOR_ALL = Codes.all(BuiltIn.VECTOR_ALL);
    private static final Applicable VECTOR_COLLATE = Codes.collate(BuiltIn.VECTOR_COLLATE);
    private static final Applicable BAG_NULL = Codes.empty(BuiltIn.BAG_NULL);
    private static final Applicable BAG_LENGTH = Codes.length(BuiltIn.BAG_LENGTH);
    private static final Applicable BAG_AT = Codes.union(BuiltIn.BAG_AT);
    private static final Applicable BAG_HD = new ListHd(BuiltIn.LIST_HD, Pos.ZERO);
    private static final Applicable BAG_TL = new ListTl(BuiltIn.LIST_TL, Pos.ZERO);
    private static final Applicable BAG_GET_ITEM = Codes.listGetItem(BuiltIn.BAG_GET_ITEM);
    private static final Applicable BAG_NTH = new ListNth(BuiltIn.BAG_NTH, Pos.ZERO);
    private static final Applicable BAG_TAKE = new ListTake(BuiltIn.BAG_TAKE, Pos.ZERO);
    private static final Applicable BAG_DROP = Codes.listDrop(BuiltIn.BAG_DROP);
    private static final Applicable BAG_CONCAT = Codes.listConcat(BuiltIn.BAG_CONCAT);
    private static final Applicable BAG_APP = Codes.listApp0(BuiltIn.BAG_APP);
    private static final Applicable BAG_MAP = Codes.listMap0(BuiltIn.BAG_MAP);
    private static final Applicable BAG_MAP_PARTIAL = Codes.listMapPartial0(BuiltIn.BAG_MAP_PARTIAL);
    private static final Applicable BAG_FIND = Codes.find(BuiltIn.BAG_FIND);
    private static final Applicable BAG_FILTER = Codes.listFilter0(BuiltIn.BAG_FILTER);
    private static final Applicable BAG_PARTITION = Codes.listPartition0(BuiltIn.BAG_PARTITION);
    private static final Applicable BAG_FOLD = Codes.listFold0(BuiltIn.BAG_FOLD, true);
    private static final Applicable BAG_EXISTS = Codes.exists(BuiltIn.BAG_EXISTS);
    private static final Applicable BAG_ALL = Codes.all(BuiltIn.BAG_ALL);
    private static final Applicable BAG_FROM_LIST = Codes.identity(BuiltIn.BAG_FROM_LIST);
    private static final Applicable BAG_TO_LIST = Codes.identity(BuiltIn.BAG_TO_LIST);
    private static final Applicable BAG_TABULATE = new ListTabulate(BuiltIn.BAG_TABULATE, Pos.ZERO);
    private static final Applicable Z_EXTENT = new ApplicableImpl(BuiltIn.Z_EXTENT){

        @Override
        public List apply(EvalEnv env, Object arg) {
            RangeExtent rangeExtent = (RangeExtent)arg;
            if (rangeExtent.iterable == null) {
                throw new AssertionError((Object)("infinite: " + rangeExtent));
            }
            return ImmutableList.copyOf((Iterable)rangeExtent.iterable);
        }
    };
    private static final Applicable Z_LIST = Codes.identity(BuiltIn.Z_LIST);
    public static final ImmutableMap<BuiltIn, Object> BUILT_IN_VALUES = ImmutableMap.builder().put((Object)BuiltIn.TRUE, (Object)true).put((Object)BuiltIn.FALSE, (Object)false).put((Object)BuiltIn.NOT, (Object)NOT).put((Object)BuiltIn.ABS, (Object)ABS).put((Object)BuiltIn.IGNORE, (Object)IGNORE).put((Object)BuiltIn.GENERAL_OP_O, (Object)GENERAL_OP_O).put((Object)BuiltIn.BAG_NIL, (Object)ImmutableList.of()).put((Object)BuiltIn.BAG_NULL, (Object)BAG_NULL).put((Object)BuiltIn.BAG_LENGTH, (Object)BAG_LENGTH).put((Object)BuiltIn.BAG_AT, (Object)BAG_AT).put((Object)BuiltIn.BAG_OP_AT, (Object)BAG_AT).put((Object)BuiltIn.BAG_HD, (Object)BAG_HD).put((Object)BuiltIn.BAG_TL, (Object)BAG_TL).put((Object)BuiltIn.BAG_GET_ITEM, (Object)BAG_GET_ITEM).put((Object)BuiltIn.BAG_NTH, (Object)BAG_NTH).put((Object)BuiltIn.BAG_TAKE, (Object)BAG_TAKE).put((Object)BuiltIn.BAG_DROP, (Object)BAG_DROP).put((Object)BuiltIn.BAG_CONCAT, (Object)BAG_CONCAT).put((Object)BuiltIn.BAG_APP, (Object)BAG_APP).put((Object)BuiltIn.BAG_MAP, (Object)BAG_MAP).put((Object)BuiltIn.BAG_MAP_PARTIAL, (Object)BAG_MAP_PARTIAL).put((Object)BuiltIn.BAG_FIND, (Object)BAG_FIND).put((Object)BuiltIn.BAG_FILTER, (Object)BAG_FILTER).put((Object)BuiltIn.BAG_PARTITION, (Object)BAG_PARTITION).put((Object)BuiltIn.BAG_FOLD, (Object)BAG_FOLD).put((Object)BuiltIn.BAG_EXISTS, (Object)BAG_EXISTS).put((Object)BuiltIn.BAG_ALL, (Object)BAG_ALL).put((Object)BuiltIn.BAG_FROM_LIST, (Object)BAG_FROM_LIST).put((Object)BuiltIn.BAG_TO_LIST, (Object)BAG_TO_LIST).put((Object)BuiltIn.BAG_TABULATE, (Object)BAG_TABULATE).put((Object)BuiltIn.CHAR_CHR, (Object)CHAR_CHR).put((Object)BuiltIn.CHAR_ORD, (Object)CHAR_ORD).put((Object)BuiltIn.CHAR_MIN_CHAR, (Object)CHAR_MIN_CHAR).put((Object)BuiltIn.CHAR_MAX_CHAR, (Object)CHAR_MAX_CHAR).put((Object)BuiltIn.CHAR_MAX_ORD, (Object)CHAR_MAX_ORD).put((Object)BuiltIn.CHAR_SUCC, (Object)CHAR_SUCC).put((Object)BuiltIn.CHAR_PRED, (Object)CHAR_PRED).put((Object)BuiltIn.CHAR_IS_LOWER, (Object)CHAR_IS_LOWER).put((Object)BuiltIn.CHAR_IS_UPPER, (Object)CHAR_IS_UPPER).put((Object)BuiltIn.CHAR_IS_DIGIT, (Object)CHAR_IS_DIGIT).put((Object)BuiltIn.CHAR_IS_ALPHA, (Object)CHAR_IS_ALPHA).put((Object)BuiltIn.CHAR_IS_HEX_DIGIT, (Object)CHAR_IS_HEX_DIGIT).put((Object)BuiltIn.CHAR_IS_ALPHA_NUM, (Object)CHAR_IS_ALPHA_NUM).put((Object)BuiltIn.CHAR_IS_PRINT, (Object)CHAR_IS_PRINT).put((Object)BuiltIn.CHAR_IS_SPACE, (Object)CHAR_IS_SPACE).put((Object)BuiltIn.CHAR_IS_PUNCT, (Object)CHAR_IS_PUNCT).put((Object)BuiltIn.CHAR_IS_GRAPH, (Object)CHAR_IS_GRAPH).put((Object)BuiltIn.CHAR_IS_ASCII, (Object)CHAR_IS_ASCII).put((Object)BuiltIn.CHAR_IS_CNTRL, (Object)CHAR_IS_CNTRL).put((Object)BuiltIn.CHAR_TO_LOWER, (Object)CHAR_TO_LOWER).put((Object)BuiltIn.CHAR_TO_UPPER, (Object)CHAR_TO_UPPER).put((Object)BuiltIn.CHAR_FROM_STRING, (Object)CHAR_FROM_STRING).put((Object)BuiltIn.CHAR_FROM_CSTRING, (Object)CHAR_FROM_CSTRING).put((Object)BuiltIn.CHAR_TO_CSTRING, (Object)CHAR_TO_CSTRING).put((Object)BuiltIn.CHAR_TO_STRING, (Object)CHAR_TO_STRING).put((Object)BuiltIn.CHAR_CONTAINS, (Object)CHAR_CONTAINS).put((Object)BuiltIn.CHAR_NOT_CONTAINS, (Object)CHAR_NOT_CONTAINS).put((Object)BuiltIn.CHAR_OP_GE, (Object)CHAR_OP_GE).put((Object)BuiltIn.CHAR_OP_GT, (Object)CHAR_OP_GT).put((Object)BuiltIn.CHAR_OP_LE, (Object)CHAR_OP_LE).put((Object)BuiltIn.CHAR_OP_LT, (Object)CHAR_OP_LT).put((Object)BuiltIn.CHAR_COMPARE, (Object)CHAR_COMPARE).put((Object)BuiltIn.INT_ABS, (Object)INT_ABS).put((Object)BuiltIn.INT_COMPARE, (Object)INT_COMPARE).put((Object)BuiltIn.INT_DIV, (Object)INT_DIV).put((Object)BuiltIn.INT_FROM_INT, (Object)INT_FROM_INT).put((Object)BuiltIn.INT_FROM_LARGE, (Object)INT_FROM_LARGE).put((Object)BuiltIn.INT_FROM_STRING, (Object)INT_FROM_STRING).put((Object)BuiltIn.INT_MAX, (Object)INT_MAX).put((Object)BuiltIn.INT_MAX_INT, (Object)INT_MAX_INT).put((Object)BuiltIn.INT_MIN, (Object)INT_MIN).put((Object)BuiltIn.INT_MIN_INT, (Object)INT_MIN_INT).put((Object)BuiltIn.INT_MOD, (Object)INT_MOD).put((Object)BuiltIn.INT_PRECISION, (Object)INT_PRECISION).put((Object)BuiltIn.INT_QUOT, (Object)INT_QUOT).put((Object)BuiltIn.INT_REM, (Object)INT_REM).put((Object)BuiltIn.INT_SAME_SIGN, (Object)INT_SAME_SIGN).put((Object)BuiltIn.INT_SIGN, (Object)INT_SIGN).put((Object)BuiltIn.INT_TO_INT, (Object)INT_TO_INT).put((Object)BuiltIn.INT_TO_LARGE, (Object)INT_TO_LARGE).put((Object)BuiltIn.INT_TO_STRING, (Object)INT_TO_STRING).put((Object)BuiltIn.INTERACT_USE, (Object)INTERACT_USE).put((Object)BuiltIn.INTERACT_USE_SILENTLY, (Object)INTERACT_USE_SILENTLY).put((Object)BuiltIn.OP_CARET, (Object)OP_CARET).put((Object)BuiltIn.OP_CONS, (Object)OP_CONS).put((Object)BuiltIn.OP_DIV, (Object)OP_DIV).put((Object)BuiltIn.OP_DIVIDE, (Object)OP_DIVIDE).put((Object)BuiltIn.OP_ELEM, (Object)OP_ELEM).put((Object)BuiltIn.OP_EQ, (Object)OP_EQ).put((Object)BuiltIn.OP_GE, (Object)OP_GE).put((Object)BuiltIn.OP_GT, (Object)OP_GT).put((Object)BuiltIn.OP_LE, (Object)OP_LE).put((Object)BuiltIn.OP_LT, (Object)OP_LT).put((Object)BuiltIn.OP_NE, (Object)OP_NE).put((Object)BuiltIn.OP_MINUS, (Object)OP_MINUS).put((Object)BuiltIn.OP_MOD, (Object)OP_MOD).put((Object)BuiltIn.OP_NEGATE, (Object)OP_NEGATE).put((Object)BuiltIn.OP_NOT_ELEM, (Object)OP_NOT_ELEM).put((Object)BuiltIn.OP_PLUS, (Object)OP_PLUS).put((Object)BuiltIn.OP_TIMES, (Object)OP_TIMES).put((Object)BuiltIn.STRING_COLLATE, (Object)STRING_COLLATE).put((Object)BuiltIn.STRING_COMPARE, (Object)STRING_COMPARE).put((Object)BuiltIn.STRING_MAX_SIZE, (Object)STRING_MAX_SIZE).put((Object)BuiltIn.STRING_SIZE, (Object)STRING_SIZE).put((Object)BuiltIn.STRING_SUB, (Object)STRING_SUB).put((Object)BuiltIn.STRING_EXTRACT, (Object)STRING_EXTRACT).put((Object)BuiltIn.STRING_FIELDS, (Object)STRING_FIELDS).put((Object)BuiltIn.STRING_TOKENS, (Object)STRING_TOKENS).put((Object)BuiltIn.STRING_SUBSTRING, (Object)STRING_SUBSTRING).put((Object)BuiltIn.STRING_CONCAT, (Object)STRING_CONCAT).put((Object)BuiltIn.STRING_CONCAT_WITH, (Object)STRING_CONCAT_WITH).put((Object)BuiltIn.STRING_STR, (Object)STRING_STR).put((Object)BuiltIn.STRING_IMPLODE, (Object)STRING_IMPLODE).put((Object)BuiltIn.STRING_EXPLODE, (Object)STRING_EXPLODE).put((Object)BuiltIn.STRING_MAP, (Object)STRING_MAP).put((Object)BuiltIn.STRING_OP_CARET, (Object)STRING_OP_CARET).put((Object)BuiltIn.STRING_OP_GE, (Object)STRING_OP_GE).put((Object)BuiltIn.STRING_OP_GT, (Object)STRING_OP_GT).put((Object)BuiltIn.STRING_OP_LE, (Object)STRING_OP_LE).put((Object)BuiltIn.STRING_OP_LT, (Object)STRING_OP_LT).put((Object)BuiltIn.STRING_TRANSLATE, (Object)STRING_TRANSLATE).put((Object)BuiltIn.STRING_IS_PREFIX, (Object)STRING_IS_PREFIX).put((Object)BuiltIn.STRING_IS_SUBSTRING, (Object)STRING_IS_SUBSTRING).put((Object)BuiltIn.STRING_IS_SUFFIX, (Object)STRING_IS_SUFFIX).put((Object)BuiltIn.LIST_NIL, (Object)ImmutableList.of()).put((Object)BuiltIn.LIST_NULL, (Object)LIST_NULL).put((Object)BuiltIn.LIST_LENGTH, (Object)LIST_LENGTH).put((Object)BuiltIn.LIST_AT, (Object)LIST_AT).put((Object)BuiltIn.LIST_OP_AT, (Object)LIST_AT).put((Object)BuiltIn.LIST_HD, (Object)LIST_HD).put((Object)BuiltIn.LIST_TL, (Object)LIST_TL).put((Object)BuiltIn.LIST_LAST, (Object)LIST_LAST).put((Object)BuiltIn.LIST_GET_ITEM, (Object)LIST_GET_ITEM).put((Object)BuiltIn.LIST_NTH, (Object)LIST_NTH).put((Object)BuiltIn.LIST_TAKE, (Object)LIST_TAKE).put((Object)BuiltIn.LIST_DROP, (Object)LIST_DROP).put((Object)BuiltIn.LIST_REV, (Object)LIST_REV).put((Object)BuiltIn.LIST_CONCAT, (Object)LIST_CONCAT).put((Object)BuiltIn.LIST_EXCEPT, (Object)LIST_EXCEPT).put((Object)BuiltIn.LIST_INTERSECT, (Object)LIST_INTERSECT).put((Object)BuiltIn.LIST_REV_APPEND, (Object)LIST_REV_APPEND).put((Object)BuiltIn.LIST_APP, (Object)LIST_APP).put((Object)BuiltIn.LIST_MAPI, (Object)LIST_MAPI).put((Object)BuiltIn.LIST_MAP, (Object)LIST_MAP).put((Object)BuiltIn.LIST_MAP_PARTIAL, (Object)LIST_MAP_PARTIAL).put((Object)BuiltIn.LIST_FIND, (Object)LIST_FIND).put((Object)BuiltIn.LIST_FILTER, (Object)LIST_FILTER).put((Object)BuiltIn.LIST_PARTITION, (Object)LIST_PARTITION).put((Object)BuiltIn.LIST_FOLDL, (Object)LIST_FOLDL).put((Object)BuiltIn.LIST_FOLDR, (Object)LIST_FOLDR).put((Object)BuiltIn.LIST_EXISTS, (Object)LIST_EXISTS).put((Object)BuiltIn.LIST_ALL, (Object)LIST_ALL).put((Object)BuiltIn.LIST_TABULATE, (Object)LIST_TABULATE).put((Object)BuiltIn.LIST_COLLATE, (Object)LIST_COLLATE).put((Object)BuiltIn.MATH_ACOS, (Object)MATH_ACOS).put((Object)BuiltIn.MATH_ASIN, (Object)MATH_ASIN).put((Object)BuiltIn.MATH_ATAN, (Object)MATH_ATAN).put((Object)BuiltIn.MATH_ATAN2, (Object)MATH_ATAN2).put((Object)BuiltIn.MATH_COS, (Object)MATH_COS).put((Object)BuiltIn.MATH_COSH, (Object)MATH_COSH).put((Object)BuiltIn.MATH_E, (Object)Float.valueOf((float)Math.E)).put((Object)BuiltIn.MATH_EXP, (Object)MATH_EXP).put((Object)BuiltIn.MATH_LN, (Object)MATH_LN).put((Object)BuiltIn.MATH_LOG10, (Object)MATH_LOG10).put((Object)BuiltIn.MATH_PI, (Object)Float.valueOf((float)Math.PI)).put((Object)BuiltIn.MATH_POW, (Object)MATH_POW).put((Object)BuiltIn.MATH_SIN, (Object)MATH_SIN).put((Object)BuiltIn.MATH_SINH, (Object)MATH_SINH).put((Object)BuiltIn.MATH_SQRT, (Object)MATH_SQRT).put((Object)BuiltIn.MATH_TAN, (Object)MATH_TAN).put((Object)BuiltIn.MATH_TANH, (Object)MATH_TANH).put((Object)BuiltIn.OPTION_APP, (Object)OPTION_APP).put((Object)BuiltIn.OPTION_COMPOSE, (Object)OPTION_COMPOSE).put((Object)BuiltIn.OPTION_COMPOSE_PARTIAL, (Object)OPTION_COMPOSE_PARTIAL).put((Object)BuiltIn.OPTION_FILTER, (Object)OPTION_FILTER).put((Object)BuiltIn.OPTION_GET_OPT, (Object)OPTION_GET_OPT).put((Object)BuiltIn.OPTION_IS_SOME, (Object)OPTION_IS_SOME).put((Object)BuiltIn.OPTION_JOIN, (Object)OPTION_JOIN).put((Object)BuiltIn.OPTION_MAP, (Object)OPTION_MAP).put((Object)BuiltIn.OPTION_MAP_PARTIAL, (Object)OPTION_MAP_PARTIAL).put((Object)BuiltIn.OPTION_VAL_OF, (Object)OPTION_VAL_OF).put((Object)BuiltIn.REAL_ABS, (Object)REAL_ABS).put((Object)BuiltIn.REAL_CEIL, (Object)REAL_CEIL).put((Object)BuiltIn.REAL_CHECK_FLOAT, (Object)REAL_CHECK_FLOAT).put((Object)BuiltIn.REAL_COMPARE, (Object)REAL_COMPARE).put((Object)BuiltIn.REAL_COPY_SIGN, (Object)REAL_COPY_SIGN).put((Object)BuiltIn.REAL_FLOOR, (Object)REAL_FLOOR).put((Object)BuiltIn.REAL_FROM_INT, (Object)REAL_FROM_INT).put((Object)BuiltIn.REAL_FROM_MAN_EXP, (Object)REAL_FROM_MAN_EXP).put((Object)BuiltIn.REAL_FROM_STRING, (Object)REAL_FROM_STRING).put((Object)BuiltIn.REAL_IS_FINITE, (Object)REAL_IS_FINITE).put((Object)BuiltIn.REAL_IS_NAN, (Object)REAL_IS_NAN).put((Object)BuiltIn.REAL_IS_NORMAL, (Object)REAL_IS_NORMAL).put((Object)BuiltIn.REAL_MAX, (Object)REAL_MAX).put((Object)BuiltIn.REAL_MAX_FINITE, (Object)Float.valueOf(Float.MAX_VALUE)).put((Object)BuiltIn.REAL_MIN, (Object)REAL_MIN).put((Object)BuiltIn.REAL_MIN_POS, (Object)Float.valueOf(Float.MIN_VALUE)).put((Object)BuiltIn.REAL_MIN_NORMAL_POS, (Object)Float.valueOf(Float.MIN_NORMAL)).put((Object)BuiltIn.REAL_NEG_INF, (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).put((Object)BuiltIn.REAL_POS_INF, (Object)Float.valueOf(Float.POSITIVE_INFINITY)).put((Object)BuiltIn.REAL_PRECISION, (Object)24).put((Object)BuiltIn.REAL_RADIX, (Object)2).put((Object)BuiltIn.REAL_REAL_MOD, (Object)REAL_REAL_MOD).put((Object)BuiltIn.REAL_REAL_CEIL, (Object)REAL_REAL_CEIL).put((Object)BuiltIn.REAL_REAL_FLOOR, (Object)REAL_REAL_FLOOR).put((Object)BuiltIn.REAL_REAL_ROUND, (Object)REAL_REAL_ROUND).put((Object)BuiltIn.REAL_REAL_TRUNC, (Object)REAL_REAL_TRUNC).put((Object)BuiltIn.REAL_REM, (Object)REAL_REM).put((Object)BuiltIn.REAL_ROUND, (Object)REAL_ROUND).put((Object)BuiltIn.REAL_SAME_SIGN, (Object)REAL_SAME_SIGN).put((Object)BuiltIn.REAL_SIGN, (Object)REAL_SIGN).put((Object)BuiltIn.REAL_SIGN_BIT, (Object)REAL_SIGN_BIT).put((Object)BuiltIn.REAL_SPLIT, (Object)REAL_SPLIT).put((Object)BuiltIn.REAL_TO_MAN_EXP, (Object)REAL_TO_MAN_EXP).put((Object)BuiltIn.REAL_TO_STRING, (Object)REAL_TO_STRING).put((Object)BuiltIn.REAL_TRUNC, (Object)REAL_TRUNC).put((Object)BuiltIn.REAL_UNORDERED, (Object)REAL_UNORDERED).put((Object)BuiltIn.RELATIONAL_COMPARE, (Object)RELATIONAL_COMPARE).put((Object)BuiltIn.RELATIONAL_COUNT, (Object)RELATIONAL_COUNT).put((Object)BuiltIn.RELATIONAL_EMPTY, (Object)RELATIONAL_EMPTY).put((Object)BuiltIn.RELATIONAL_ITERATE, (Object)RELATIONAL_ITERATE).put((Object)BuiltIn.RELATIONAL_MAX, (Object)RELATIONAL_MAX).put((Object)BuiltIn.RELATIONAL_MIN, (Object)RELATIONAL_MIN).put((Object)BuiltIn.RELATIONAL_NON_EMPTY, (Object)RELATIONAL_NON_EMPTY).put((Object)BuiltIn.RELATIONAL_ONLY, (Object)RELATIONAL_ONLY).put((Object)BuiltIn.RELATIONAL_SUM, (Object)RELATIONAL_SUM).put((Object)BuiltIn.SYS_CLEAR_ENV, (Object)SYS_CLEAR_ENV).put((Object)BuiltIn.SYS_ENV, Codes::sysEnv).put((Object)BuiltIn.SYS_FILE, (Object)ImmutableList.of()).put((Object)BuiltIn.SYS_PLAN, (Object)SYS_PLAN).put((Object)BuiltIn.SYS_SET, (Object)SYS_SET).put((Object)BuiltIn.SYS_SHOW, (Object)SYS_SHOW).put((Object)BuiltIn.SYS_SHOW_ALL, (Object)SYS_SHOW_ALL).put((Object)BuiltIn.SYS_UNSET, (Object)SYS_UNSET).put((Object)BuiltIn.VECTOR_MAX_LEN, (Object)0xFFFFFF).put((Object)BuiltIn.VECTOR_FROM_LIST, (Object)VECTOR_FROM_LIST).put((Object)BuiltIn.VECTOR_TABULATE, (Object)VECTOR_TABULATE).put((Object)BuiltIn.VECTOR_LENGTH, (Object)VECTOR_LENGTH).put((Object)BuiltIn.VECTOR_SUB, (Object)VECTOR_SUB).put((Object)BuiltIn.VECTOR_UPDATE, (Object)VECTOR_UPDATE).put((Object)BuiltIn.VECTOR_CONCAT, (Object)VECTOR_CONCAT).put((Object)BuiltIn.VECTOR_APPI, (Object)VECTOR_APPI).put((Object)BuiltIn.VECTOR_APP, (Object)VECTOR_APP).put((Object)BuiltIn.VECTOR_MAPI, (Object)VECTOR_MAPI).put((Object)BuiltIn.VECTOR_MAP, (Object)VECTOR_MAP).put((Object)BuiltIn.VECTOR_FOLDLI, (Object)VECTOR_FOLDLI).put((Object)BuiltIn.VECTOR_FOLDRI, (Object)VECTOR_FOLDRI).put((Object)BuiltIn.VECTOR_FOLDL, (Object)VECTOR_FOLDL).put((Object)BuiltIn.VECTOR_FOLDR, (Object)VECTOR_FOLDR).put((Object)BuiltIn.VECTOR_FINDI, (Object)VECTOR_FINDI).put((Object)BuiltIn.VECTOR_FIND, (Object)VECTOR_FIND).put((Object)BuiltIn.VECTOR_EXISTS, (Object)VECTOR_EXISTS).put((Object)BuiltIn.VECTOR_ALL, (Object)VECTOR_ALL).put((Object)BuiltIn.VECTOR_COLLATE, (Object)VECTOR_COLLATE).put((Object)BuiltIn.Z_ANDALSO, (Object)Unit.INSTANCE).put((Object)BuiltIn.Z_ORELSE, (Object)Unit.INSTANCE).put((Object)BuiltIn.Z_CURRENT, (Object)Unit.INSTANCE).put((Object)BuiltIn.Z_ORDINAL, (Object)0).put((Object)BuiltIn.Z_NEGATE_INT, (Object)Z_NEGATE_INT).put((Object)BuiltIn.Z_NEGATE_REAL, (Object)Z_NEGATE_REAL).put((Object)BuiltIn.Z_DIVIDE_INT, (Object)Z_DIVIDE_INT).put((Object)BuiltIn.Z_DIVIDE_REAL, (Object)Z_DIVIDE_REAL).put((Object)BuiltIn.Z_PLUS_INT, (Object)Z_PLUS_INT).put((Object)BuiltIn.Z_PLUS_REAL, (Object)Z_PLUS_REAL).put((Object)BuiltIn.Z_MINUS_INT, (Object)Z_MINUS_INT).put((Object)BuiltIn.Z_MINUS_REAL, (Object)Z_MINUS_REAL).put((Object)BuiltIn.Z_TIMES_INT, (Object)Z_TIMES_INT).put((Object)BuiltIn.Z_TIMES_REAL, (Object)Z_TIMES_REAL).put((Object)BuiltIn.Z_SUM_INT, (Object)Z_SUM_INT).put((Object)BuiltIn.Z_SUM_REAL, (Object)Z_SUM_REAL).put((Object)BuiltIn.Z_EXTENT, (Object)Z_EXTENT).put((Object)BuiltIn.Z_LIST, (Object)Z_LIST).build();
    public static final Map<Applicable, BuiltIn> BUILT_IN_MAP = ((Supplier<Map>)Codes::get).get();
    private static final EvalEnv EMPTY_ENV = ((Supplier<EvalEnv>)Codes::makeEmptyEnv).get();

    private Codes() {
    }

    public static String describe(Code code) {
        Code code2 = Codes.strip(code);
        return code2.describe(new DescriberImpl()).toString();
    }

    public static Code constant(Object value) {
        return new ConstantCode(value);
    }

    private static ApplicableImpl identity(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return arg;
            }
        };
    }

    public static Code andAlso(Code code0, Code code1) {
        return new AndAlsoCode(code0, code1);
    }

    public static Code orElse(Code code0, Code code1) {
        return new OrElseCode(code0, code1);
    }

    private static ApplicableImpl charContains(final String s, final boolean negate) {
        return new ApplicableImpl("contains"){

            @Override
            public Object apply(EvalEnv env, Object argValue) {
                Character c = (Character)argValue;
                return s.indexOf(c.charValue()) >= 0 ^ negate;
            }
        };
    }

    public static Code ordinalGet(int[] ordinalSlots) {
        return new OrdinalGetCode(ordinalSlots);
    }

    public static Code ordinalInc(int[] ordinalSlots, Code nextCode) {
        return new OrdinalIncCode(ordinalSlots, nextCode);
    }

    public static Code strip(Code code) {
        while (code instanceof WrapRelList) {
            code = ((WrapRelList)code).code;
        }
        return code;
    }

    public static Code get(String name) {
        return new GetCode(name);
    }

    public static Code getTuple(Iterable<String> names) {
        if (Iterables.isEmpty(names)) {
            return new ConstantCode(Unit.INSTANCE);
        }
        return new GetTupleCode((ImmutableList<String>)ImmutableList.copyOf(names));
    }

    public static Code let(List<Code> matchCodes, Code resultCode) {
        switch (matchCodes.size()) {
            case 0: {
                return resultCode;
            }
            case 1: {
                return new Let1Code(matchCodes.get(0), resultCode);
            }
        }
        return new LetCode((ImmutableList<Code>)ImmutableList.copyOf(matchCodes), resultCode);
    }

    public static Code apply(Code fnCode, Code argCode) {
        assert (!fnCode.isConstant());
        return new ApplyCodeCode(fnCode, argCode);
    }

    public static Code apply(Applicable fnValue, Code argCode) {
        return new ApplyCode(fnValue, argCode);
    }

    public static Code apply2(Applicable2 fnValue, Code argCode0, Code argCode1) {
        return new ApplyCode2(fnValue, argCode0, argCode1);
    }

    public static Code apply3(Applicable3 fnValue, Code argCode0, Code argCode1, Code argCode2) {
        return new ApplyCode3(fnValue, argCode0, argCode1, argCode2);
    }

    public static Code list(Iterable<? extends Code> codes) {
        return Codes.tuple(codes);
    }

    public static Code tuple(Iterable<? extends Code> codes) {
        return new TupleCode(ImmutableList.copyOf(codes));
    }

    public static Code wrapRelList(Code code) {
        return new WrapRelList(code);
    }

    public static Applicable tyCon(Type dataType, final String name) {
        Objects.requireNonNull(dataType);
        Objects.requireNonNull(name);
        return new ApplicableImpl("tyCon"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return ImmutableList.of((Object)name, (Object)arg);
            }
        };
    }

    public static Code from(Supplier<RowSink> rowSinkFactory) {
        return new FromCode(rowSinkFactory);
    }

    public static RowSink scanRowSink(Op op, Core.Pat pat, Code code, Code conditionCode, RowSink rowSink) {
        return new ScanRowSink(op, pat, code, conditionCode, rowSink);
    }

    public static RowSink whereRowSink(Code filterCode, RowSink rowSink) {
        return new WhereRowSink(filterCode, rowSink);
    }

    public static RowSink skipRowSink(Code skipCode, RowSink rowSink) {
        return new SkipRowSink(skipCode, rowSink);
    }

    public static RowSink takeRowSink(Code takeCode, RowSink rowSink) {
        return new TakeRowSink(takeCode, rowSink);
    }

    public static RowSink exceptRowSink(boolean distinct, ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
        return distinct ? new ExceptDistinctRowSink(codes, names, rowSink) : new ExceptAllRowSink(codes, names, rowSink);
    }

    public static RowSink intersectRowSink(boolean distinct, ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
        return distinct ? new IntersectDistinctRowSink(codes, names, rowSink) : new IntersectAllRowSink(codes, names, rowSink);
    }

    public static RowSink unionRowSink(boolean distinct, ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
        return new UnionRowSink(distinct, codes, names, rowSink);
    }

    public static RowSink orderRowSink(Code code, Comparator comparator, Core.StepEnv env, RowSink rowSink) {
        ImmutableList<String> names = Static.transformEager(env.bindings, b -> b.id.name);
        return new OrderRowSink(code, comparator, names, rowSink);
    }

    public static RowSink groupRowSink(Code keyCode, ImmutableList<Applicable> aggregateCodes, ImmutableList<String> inNames, ImmutableList<String> keyNames, ImmutableList<String> outNames, RowSink rowSink) {
        return new GroupRowSink(keyCode, aggregateCodes, inNames, keyNames, outNames, rowSink);
    }

    public static RowSink yieldRowSink(Map<String, Code> yieldCodes, RowSink rowSink) {
        return new YieldRowSink((ImmutableList<String>)ImmutableList.copyOf(yieldCodes.keySet()), (ImmutableList<Code>)ImmutableList.copyOf(yieldCodes.values()), rowSink);
    }

    public static RowSink collectRowSink(Code code) {
        return new CollectRowSink(code);
    }

    public static RowSink firstRowSink(RowSink rowSink) {
        final ArrayList<Runnable> startActions = new ArrayList<Runnable>();
        rowSink.describe(new CodeVisitor(){

            @Override
            public void addStartAction(Runnable runnable) {
                startActions.add(runnable);
            }
        });
        if (startActions.isEmpty()) {
            return rowSink;
        }
        return new FirstRowSink(rowSink, startActions);
    }

    public static Applicable nth(final int slot) {
        assert (slot >= 0) : slot;
        return new ApplicableImpl("nth:" + slot){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return ((List)arg).get(slot);
            }
        };
    }

    private static Applicable stringCollate(final Applicable comparator) {
        return new ApplicableImpl("String.collate$comparator"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List tuple = (List)arg;
                String string0 = (String)tuple.get(0);
                String string1 = (String)tuple.get(1);
                int n0 = string0.length();
                int n1 = string1.length();
                int n = Math.min(n0, n1);
                for (int i = 0; i < n; ++i) {
                    char char0 = string0.charAt(i);
                    char char1 = string1.charAt(i);
                    List compare = (List)comparator.apply(env, ImmutableList.of((Object)Character.valueOf(char0), (Object)Character.valueOf(char1)));
                    if (compare.get(0).equals("EQUAL")) continue;
                    return compare;
                }
                return Codes.order(Integer.compare(n0, n1));
            }
        };
    }

    private static Applicable fieldsTokens(final BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object argValue) {
                return Codes.fieldsTokens2(builtIn, (Applicable)argValue);
            }
        };
    }

    private static Applicable fieldsTokens2(final BuiltIn builtIn, final Applicable applicable) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object argValue) {
                String s = (String)argValue;
                ArrayList<String> result = new ArrayList<String>();
                int h = 0;
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    Boolean b = (Boolean)applicable.apply(env, Character.valueOf(c));
                    if (!b.booleanValue()) continue;
                    if (builtIn == BuiltIn.STRING_FIELDS || i > h) {
                        result.add(s.substring(h, i));
                    }
                    h = i + 1;
                }
                if (builtIn == BuiltIn.STRING_FIELDS || s.length() > h) {
                    result.add(s.substring(h));
                }
                return result;
            }
        };
    }

    private static String stringConcat(Pos pos, String separator, List<String> list) {
        long n = 0L;
        for (String s : list) {
            n += (long)s.length();
            n += (long)separator.length();
        }
        if (n > (long)STRING_MAX_SIZE.intValue()) {
            throw new MorelRuntimeException(BuiltInExn.SIZE, pos);
        }
        return String.join((CharSequence)separator, list);
    }

    private static Applicable stringMap(final Applicable f) {
        return new ApplicableImpl("String.map$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                String s = (String)arg;
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    char c2 = ((Character)f.apply(env, Character.valueOf(c))).charValue();
                    buf.append(c2);
                }
                return buf.toString();
            }
        };
    }

    private static Applicable translate(final Applicable f) {
        return new ApplicableImpl("String.translate$f"){

            @Override
            public String apply(EvalEnv env, Object arg) {
                String s = (String)arg;
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    String c2 = (String)f.apply(env, Character.valueOf(c));
                    buf.append(c2);
                }
                return buf.toString();
            }
        };
    }

    private static Applicable isPrefix(final String s) {
        return new ApplicableImpl("String.isPrefix$s"){

            @Override
            public Boolean apply(EvalEnv env, Object arg) {
                String s2 = (String)arg;
                return s2.startsWith(s);
            }
        };
    }

    private static Applicable isSubstring(final String s) {
        return new ApplicableImpl("String.isSubstring$s"){

            @Override
            public Boolean apply(EvalEnv env, Object arg) {
                String s2 = (String)arg;
                return s2.contains(s);
            }
        };
    }

    private static Applicable isSuffix(final String s) {
        return new ApplicableImpl("String.isSuffix$s"){

            @Override
            public Boolean apply(EvalEnv env, Object arg) {
                String s2 = (String)arg;
                return s2.endsWith(s);
            }
        };
    }

    private static ApplicableImpl length(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return ((List)arg).size();
            }
        };
    }

    private static ApplicableImpl union(BuiltIn builtIn) {
        return new Applicable2<List, List, List>(builtIn){

            @Override
            public List apply(List list0, List list1) {
                return ImmutableList.builder().addAll((Iterable)list0).addAll((Iterable)list1).build();
            }
        };
    }

    private static ApplicableImpl listGetItem(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                if (list.isEmpty()) {
                    return OPTION_NONE;
                }
                return Codes.optionSome(ImmutableList.of(list.get(0), list.subList(1, list.size())));
            }
        };
    }

    private static Applicable2<List, List, Integer> listDrop(BuiltIn builtIn) {
        return new Applicable2<List, List, Integer>(builtIn){

            @Override
            public List apply(List list, Integer i) {
                return list.subList(i, list.size());
            }
        };
    }

    private static ApplicableImpl listConcat(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : list) {
                    builder.addAll((Iterable)((List)o));
                }
                return builder.build();
            }
        };
    }

    private static ApplicableImpl listApp0(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Applicable apply(EvalEnv env, Object arg) {
                return Codes.listApp((Applicable)arg);
            }
        };
    }

    private static Applicable listApp(final Applicable consumer) {
        return new ApplicableImpl("List.app$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                list.forEach(o -> consumer.apply(env, o));
                return Unit.INSTANCE;
            }
        };
    }

    private static Applicable listMap0(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Applicable apply(EvalEnv env, Object arg) {
                return Codes.listMap((Applicable)arg);
            }
        };
    }

    private static Applicable listMap(final Applicable fn) {
        return new ApplicableImpl("List.map$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : list) {
                    builder.add(fn.apply(env, o));
                }
                return builder.build();
            }
        };
    }

    private static Applicable listMapPartial0(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Applicable apply(EvalEnv env, Object arg) {
                return Codes.listMapPartial((Applicable)arg);
            }
        };
    }

    private static Applicable listMapPartial(final Applicable f) {
        return new ApplicableImpl("List.mapPartial$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : list) {
                    List opt = (List)f.apply(env, o);
                    if (opt.size() != 2) continue;
                    builder.add(opt.get(1));
                }
                return builder.build();
            }
        };
    }

    private static ApplicableImpl find(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Applicable apply(EvalEnv env, Object arg) {
                Applicable fn = (Applicable)arg;
                return Codes.find(fn);
            }
        };
    }

    private static Applicable find(final Applicable f) {
        return new ApplicableImpl("List.find$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                for (Object o : list) {
                    if (!((Boolean)f.apply(env, o)).booleanValue()) continue;
                    return Codes.optionSome(o);
                }
                return OPTION_NONE;
            }
        };
    }

    private static Applicable listFilter0(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                Applicable fn = (Applicable)arg;
                return Codes.listFilter(fn);
            }
        };
    }

    private static Applicable listFilter(final Applicable f) {
        return new ApplicableImpl("List.filter$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : list) {
                    if (!((Boolean)f.apply(env, o)).booleanValue()) continue;
                    builder.add(o);
                }
                return builder.build();
            }
        };
    }

    private static ApplicableImpl listPartition0(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                Applicable fn = (Applicable)arg;
                return Codes.listPartition(fn);
            }
        };
    }

    private static Applicable listPartition(final Applicable f) {
        return new ApplicableImpl("List.partition$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                ImmutableList.Builder trueBuilder = ImmutableList.builder();
                ImmutableList.Builder falseBuilder = ImmutableList.builder();
                for (Object o : list) {
                    ((Boolean)f.apply(env, o) != false ? trueBuilder : falseBuilder).add(o);
                }
                return ImmutableList.of((Object)trueBuilder.build(), (Object)falseBuilder.build());
            }
        };
    }

    private static ApplicableImpl listFold0(BuiltIn builtIn, final boolean left) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return Codes.listFold(left, (Applicable)arg);
            }
        };
    }

    private static Applicable listFold(final boolean left, final Applicable f) {
        return new ApplicableImpl("List.fold$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return Codes.listFold2(left, f, arg);
            }
        };
    }

    private static Applicable listFold2(final boolean left, final Applicable f, final Object init) {
        return new ApplicableImpl("List.fold$f$init"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                Object b = init;
                for (Object a : left ? list : Lists.reverse((List)list)) {
                    b = f.apply(env, ImmutableList.of(a, (Object)b));
                }
                return b;
            }
        };
    }

    private static ApplicableImpl exists(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return Codes.listExists((Applicable)arg);
            }
        };
    }

    private static Applicable listExists(final Applicable f) {
        return new ApplicableImpl("List.exists$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                for (Object o : list) {
                    if (!((Boolean)f.apply(env, o)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static ApplicableImpl all(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return Codes.listAll((Applicable)arg);
            }
        };
    }

    private static Applicable listAll(final Applicable f) {
        return new ApplicableImpl("List.all$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List list = (List)arg;
                for (Object o : list) {
                    if (((Boolean)f.apply(env, o)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static ApplicableImpl collate(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return Codes.collate((Applicable)arg);
            }
        };
    }

    private static Applicable collate(final Applicable comparator) {
        return new ApplicableImpl("List.collate$comparator"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List tuple = (List)arg;
                List list0 = (List)tuple.get(0);
                List list1 = (List)tuple.get(1);
                int n0 = list0.size();
                int n1 = list1.size();
                int n = Math.min(n0, n1);
                for (int i = 0; i < n; ++i) {
                    Object element1;
                    Object element0 = list0.get(i);
                    List compare = (List)comparator.apply(env, ImmutableList.of(element0, element1 = list1.get(i)));
                    if (compare.get(0).equals("EQUAL")) continue;
                    return compare;
                }
                return Codes.order(Integer.compare(n0, n1));
            }
        };
    }

    private static Applicable optionApp(final Applicable f) {
        return new ApplicableImpl("Option.app$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List a = (List)arg;
                if (a.size() == 2) {
                    f.apply(env, a.get(1));
                }
                return Unit.INSTANCE;
            }
        };
    }

    private static Applicable optionFilter(final Applicable f) {
        return new ApplicableImpl("Option.filter$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                if (((Boolean)f.apply(env, arg)).booleanValue()) {
                    return Codes.optionSome(arg);
                }
                return OPTION_NONE;
            }
        };
    }

    private static Applicable optionMap(final Applicable f) {
        return new ApplicableImpl(BuiltIn.OPTION_MAP){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List a = (List)arg;
                if (a.size() == 2) {
                    return Codes.optionSome(f.apply(env, a.get(1)));
                }
                return a;
            }
        };
    }

    private static List optionSome(Object o) {
        return ImmutableList.of((Object)BuiltIn.Constructor.OPTION_SOME.constructor, (Object)o);
    }

    private static Applicable optionMapPartial(final Applicable f) {
        return new ApplicableImpl("Option.mapPartial$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List a = (List)arg;
                if (a.size() == 2) {
                    return f.apply(env, a.get(1));
                }
                return a;
            }
        };
    }

    private static Applicable optionCompose(final Applicable f, final Applicable g) {
        return new ApplicableImpl("Option.compose$f$g"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List ga = (List)g.apply(env, arg);
                if (ga.size() == 2) {
                    return Codes.optionSome(f.apply(env, ga.get(1)));
                }
                return ga;
            }
        };
    }

    private static Applicable optionComposePartial(final Applicable f, final Applicable g) {
        return new ApplicableImpl("Option.composePartial$f$g"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List ga = (List)g.apply(env, arg);
                if (ga.size() == 2) {
                    return f.apply(env, ga.get(1));
                }
                return ga;
            }
        };
    }

    @VisibleForTesting
    public static boolean isNegative(float f) {
        boolean negative;
        boolean bl = negative = (Float.floatToRawIntBits(f) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (Float.isNaN(f)) {
            return !negative;
        }
        return negative;
    }

    private static ApplicableImpl nonEmpty(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                return !((List)arg).isEmpty();
            }
        };
    }

    private static ApplicableImpl empty(BuiltIn builtIn) {
        return new ApplicableImpl(builtIn){

            @Override
            public Boolean apply(EvalEnv env, Object arg) {
                return ((List)arg).isEmpty();
            }
        };
    }

    private static Core.Exp sysEnv(TypeSystem typeSystem, Environment env, Type argType) {
        TupleType stringPairType = typeSystem.tupleType(PrimitiveType.STRING, PrimitiveType.STRING);
        List args = env.getValueMap(true).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> CoreBuilder.core.tuple((RecordLikeType)stringPairType, CoreBuilder.core.stringLiteral((String)entry.getKey()), CoreBuilder.core.stringLiteral(((Binding)entry.getValue()).id.type.moniker()))).collect(Collectors.toList());
        return CoreBuilder.core.apply(Pos.ZERO, typeSystem.listType(argType), CoreBuilder.core.functionLiteral(typeSystem, BuiltIn.Z_LIST), CoreBuilder.core.tuple(typeSystem, null, args));
    }

    static List order(int c) {
        if (c < 0) {
            return ORDER_LESS;
        }
        if (c > 0) {
            return ORDER_GREATER;
        }
        return ORDER_EQUAL;
    }

    private static Applicable vectorAppi(final Applicable f) {
        return new ApplicableImpl("Vector.appi$f"){

            @Override
            public Unit apply(EvalEnv env, Object arg) {
                List vec = (List)arg;
                Ord.forEachIndexed(vec, (e, i) -> f.apply(env, FlatLists.of((Object)i, (Object)e)));
                return Unit.INSTANCE;
            }
        };
    }

    private static Applicable vectorApp(final Applicable f) {
        return new ApplicableImpl("Vector.app$f"){

            @Override
            public Unit apply(EvalEnv env, Object arg) {
                List vec = (List)arg;
                vec.forEach(e -> f.apply(env, e));
                return Unit.INSTANCE;
            }
        };
    }

    private static Applicable listMapi(final Applicable f) {
        return new ApplicableImpl("Vector.map$f"){

            @Override
            public List apply(EvalEnv env, Object arg) {
                List vec = (List)arg;
                ImmutableList.Builder b = ImmutableList.builder();
                Ord.forEachIndexed(vec, (e, i) -> b.add(f.apply(env, FlatLists.of((Object)i, (Object)e))));
                return b.build();
            }
        };
    }

    private static Applicable vectorMap(final Applicable f) {
        return new ApplicableImpl("Vector.map$f"){

            @Override
            public List apply(EvalEnv env, Object arg) {
                List vec = (List)arg;
                ImmutableList.Builder b = ImmutableList.builder();
                vec.forEach(e -> b.add(f.apply(env, e)));
                return b.build();
            }
        };
    }

    private static Applicable vectorFindi(final Applicable f) {
        return new ApplicableImpl("Vector.findi$f"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List vec = (List)arg;
                int n = vec.size();
                for (int i = 0; i < n; ++i) {
                    List tuple = FlatLists.of((Object)i, vec.get(i));
                    if (!((Boolean)f.apply(env, tuple)).booleanValue()) continue;
                    return Codes.optionSome(tuple);
                }
                return OPTION_NONE;
            }
        };
    }

    private static void populateBuiltIns(Map<String, Object> valueMap) {
        if (Static.SKIP) {
            return;
        }
        TypeSystem typeSystem = new TypeSystem();
        BuiltIn.dataTypes(typeSystem, new ArrayList<Binding>());
        BuiltIn.forEach(typeSystem, (key, type) -> {
            Object value = BUILT_IN_VALUES.get((Object)key);
            if (value == null) {
                throw new AssertionError((Object)("no implementation for " + (Object)key));
            }
            if (key.structure == null) {
                valueMap.put(key.mlName, value);
            }
            if (key.alias != null) {
                valueMap.put(key.alias, value);
            }
        });
        BuiltIn.forEachStructure(typeSystem, (structure, type) -> valueMap.put(structure.name, Static.transformEager(structure.memberMap.values(), arg_0 -> BUILT_IN_VALUES.get(arg_0))));
    }

    public static EvalEnv emptyEnv() {
        return EMPTY_ENV;
    }

    public static EvalEnv emptyEnvWith(Session session, Environment env) {
        Map<String, Object> map = EMPTY_ENV.valueMap();
        env.forEachValue(map::put);
        map.put("$session", session);
        return EvalEnvs.copyOf(map);
    }

    public static Environment env(TypeSystem typeSystem, Environment environment) {
        Environment[] hEnv = new Environment[]{environment};
        BUILT_IN_VALUES.forEach((key, value) -> {
            Core.IdPat idPat;
            Type type = key.typeFunction.apply(typeSystem);
            if (key.structure == null) {
                idPat = CoreBuilder.core.idPat(type, key.mlName, typeSystem.nameGenerator::inc);
                hEnv[0] = hEnv[0].bind(idPat, value);
            }
            if (key.alias != null) {
                idPat = CoreBuilder.core.idPat(type, key.alias, typeSystem.nameGenerator::inc);
                hEnv[0] = hEnv[0].bind(idPat, value);
            }
        });
        ArrayList valueList = new ArrayList();
        BuiltIn.forEachStructure(typeSystem, (structure, type) -> {
            valueList.clear();
            structure.memberMap.values().forEach(builtIn -> valueList.add(BUILT_IN_VALUES.get((Object)builtIn)));
            Core.IdPat idPat = CoreBuilder.core.idPat((Type)type, structure.name, typeSystem.nameGenerator::inc);
            hEnv[0] = hEnv[0].bind(idPat, ImmutableList.copyOf((Collection)valueList));
        });
        return hEnv[0];
    }

    public static Applicable aggregate(Environment env0, final Code aggregateCode, final List<String> names, final @Nullable Code argumentCode) {
        return new ApplicableImpl("aggregate"){

            @Override
            public Object apply(EvalEnv env, Object arg) {
                List<Object> argRows;
                List<Object> rows = (List<Object>)arg;
                if (argumentCode != null) {
                    MutableEvalEnv env2 = env.bindMutableArray(names);
                    argRows = new ArrayList<Object>(rows.size());
                    for (Object row2 : rows) {
                        env2.set(row2);
                        argRows.add(argumentCode.eval(env2));
                    }
                } else {
                    argRows = names.size() != 1 ? Static.transform(rows, row -> Arrays.asList((Object[])row)) : rows;
                }
                Applicable aggregate = (Applicable)aggregateCode.eval(env);
                return aggregate.apply(env, argRows);
            }
        };
    }

    private static Map<Applicable, BuiltIn> get() {
        IdentityHashMap b = new IdentityHashMap();
        BUILT_IN_VALUES.forEach((builtIn, o) -> {
            if (o instanceof Applicable) {
                b.put((Applicable)o, builtIn);
            }
        });
        return ImmutableMap.copyOf(b);
    }

    private static EvalEnv makeEmptyEnv() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Codes.populateBuiltIns(map);
        return EvalEnvs.copyOf(map);
    }

    public static StringBuilder appendFloat(StringBuilder buf, float f) {
        return buf.append(Codes.floatToString(f));
    }

    @VisibleForTesting
    public static String floatToString(float f) {
        if (Float.isFinite(f)) {
            String s = FLOAT_TO_STRING.apply(Float.valueOf(f));
            return s.replace('-', '~');
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "inf";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "~inf";
        }
        if (Float.isNaN(f)) {
            return "nan";
        }
        throw new AssertionError((Object)("unknown float " + f));
    }

    private static String floatToString0(float f) {
        String s = Float.toString(f);
        int lastDigit = s.indexOf("E");
        if (lastDigit < 0) {
            lastDigit = s.length();
        }
        if (s.equals("1.17549435E-38")) {
            return "1.1754944E-38";
        }
        if (s.equals("1.23456795E12")) {
            return "1.234568E12";
        }
        if (s.equals("1.23456791E11")) {
            return "1.2345679E11";
        }
        if (s.equals("1.23456788E10")) {
            return "1.2345679E10";
        }
        if (s.equals("1.23456792E8")) {
            return "1.2345679E8";
        }
        return s;
    }

    private static class ConstantCode
    implements Code {
        private final Object value;

        ConstantCode(Object value) {
            this.value = value;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("constant", d -> d.arg("", this.value));
        }

        @Override
        public Object eval(EvalEnv env) {
            return this.value;
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    private static class AndAlsoCode
    implements Code {
        private final Code code0;
        private final Code code1;

        AndAlsoCode(Code code0, Code code1) {
            this.code0 = code0;
            this.code1 = code1;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("andalso", d -> d.arg("", this.code0).arg("", this.code1));
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            return (Boolean)this.code0.eval(evalEnv) != false && (Boolean)this.code1.eval(evalEnv) != false;
        }
    }

    private static class OrElseCode
    implements Code {
        private final Code code0;
        private final Code code1;

        OrElseCode(Code code0, Code code1) {
            this.code0 = code0;
            this.code1 = code1;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("orelse", d -> d.arg("", this.code0).arg("", this.code1));
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            return (Boolean)this.code0.eval(evalEnv) != false || (Boolean)this.code1.eval(evalEnv) != false;
        }
    }

    private static class OrdinalGetCode
    implements Code {
        private final int[] ordinalSlots;

        OrdinalGetCode(int[] ordinalSlots) {
            this.ordinalSlots = Objects.requireNonNull(ordinalSlots);
            Preconditions.checkArgument((ordinalSlots.length == 1 ? 1 : 0) != 0);
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            return this.ordinalSlots[0];
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("ordinal", d -> {});
        }
    }

    private static class OrdinalIncCode
    implements Code {
        private final int[] ordinalSlots;
        private final Code nextCode;

        OrdinalIncCode(int[] ordinalSlots, Code nextCode) {
            this.ordinalSlots = Objects.requireNonNull(ordinalSlots);
            this.nextCode = Objects.requireNonNull(nextCode);
            Preconditions.checkArgument((ordinalSlots.length == 1 ? 1 : 0) != 0);
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            this.ordinalSlots[0] = this.ordinalSlots[0] + 1;
            return this.nextCode.eval(evalEnv);
        }

        @Override
        public Describer describe(Describer describer) {
            describer.addStartAction(this::resetOrdinal);
            return describer.start("ordinal", d -> {});
        }

        private void resetOrdinal() {
            this.ordinalSlots[0] = -1;
        }
    }

    static class WrapRelList
    implements Code {
        public final Code code;

        WrapRelList(Code code) {
            this.code = code;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("wrapRelList", d -> d.arg("code", this.code));
        }

        @Override
        public Object eval(EvalEnv env) {
            Object arg = this.code.eval(env);
            if (arg instanceof RelList) {
                final RelList list = (RelList)arg;
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return list.get(index);
                    }

                    @Override
                    public int size() {
                        return list.size();
                    }
                };
            }
            return arg;
        }
    }

    private static class GetCode
    implements Code {
        private final String name;

        GetCode(String name) {
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("get", d -> d.arg("name", this.name));
        }

        public String toString() {
            return "get(" + this.name + ")";
        }

        @Override
        public Object eval(EvalEnv env) {
            return env.getOpt(this.name);
        }
    }

    private static class GetTupleCode
    implements Code {
        private final ImmutableList<String> names;
        private final Object[] values;

        GetTupleCode(ImmutableList<String> names) {
            this.names = Objects.requireNonNull(names);
            this.values = new Object[names.size()];
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("getTuple", d -> d.args("names", (Iterable<?>)this.names));
        }

        public String toString() {
            return "getTuple(" + this.names + ")";
        }

        @Override
        public Object eval(EvalEnv env) {
            for (int i = 0; i < this.names.size(); ++i) {
                this.values[i] = env.getOpt((String)this.names.get(i));
            }
            return Arrays.asList((Object[])this.values.clone());
        }
    }

    private static class Let1Code
    implements Code {
        private final Code matchCode;
        private final Code resultCode;

        Let1Code(Code matchCode, Code resultCode) {
            this.matchCode = matchCode;
            this.resultCode = resultCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("let1", d -> d.arg("matchCode", this.matchCode).arg("resultCode", this.resultCode));
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            Closure fnValue = (Closure)this.matchCode.eval(evalEnv);
            EvalEnv env2 = fnValue.evalBind(evalEnv);
            return this.resultCode.eval(env2);
        }
    }

    private static class LetCode
    implements Code {
        private final ImmutableList<Code> matchCodes;
        private final Code resultCode;

        LetCode(ImmutableList<Code> matchCodes, Code resultCode) {
            this.matchCodes = matchCodes;
            this.resultCode = resultCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("let", d -> {
                Ord.forEachIndexed(this.matchCodes, (matchCode, i) -> d.arg("matchCode" + i, (Describable)matchCode));
                d.arg("resultCode", this.resultCode);
            });
        }

        @Override
        public Object eval(EvalEnv evalEnv) {
            EvalEnv evalEnv2 = evalEnv;
            for (Code matchCode : this.matchCodes) {
                Closure fnValue = (Closure)matchCode.eval(evalEnv);
                evalEnv2 = fnValue.evalBind(evalEnv2);
            }
            return this.resultCode.eval(evalEnv2);
        }
    }

    static class ApplyCodeCode
    implements Code {
        public final Code fnCode;
        public final Code argCode;

        ApplyCodeCode(Code fnCode, Code argCode) {
            this.fnCode = fnCode;
            this.argCode = argCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("apply", d -> d.arg("fnCode", this.fnCode).arg("argCode", this.argCode));
        }

        @Override
        public Object eval(EvalEnv env) {
            Applicable fnValue = (Applicable)this.fnCode.eval(env);
            Object arg = this.argCode.eval(env);
            return fnValue.apply(env, arg);
        }
    }

    private static class ApplyCode
    implements Code {
        private final Applicable fnValue;
        private final Code argCode;

        ApplyCode(Applicable fnValue, Code argCode) {
            this.fnValue = fnValue;
            this.argCode = argCode;
        }

        @Override
        public Object eval(EvalEnv env) {
            Object arg = this.argCode.eval(env);
            return this.fnValue.apply(env, arg);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("apply", d -> d.arg("fnValue", this.fnValue).arg("argCode", this.argCode));
        }
    }

    private static class ApplyCode2
    implements Code {
        private final Applicable2 fnValue;
        private final Code argCode0;
        private final Code argCode1;

        ApplyCode2(Applicable2 fnValue, Code argCode0, Code argCode1) {
            this.fnValue = fnValue;
            this.argCode0 = argCode0;
            this.argCode1 = argCode1;
        }

        @Override
        public Object eval(EvalEnv env) {
            Object arg0 = this.argCode0.eval(env);
            Object arg1 = this.argCode1.eval(env);
            return this.fnValue.apply(arg0, arg1);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("apply2", d -> d.arg("fnValue", this.fnValue).arg("", this.argCode0).arg("", this.argCode1));
        }
    }

    private static class ApplyCode3
    implements Code {
        private final Applicable3 fnValue;
        private final Code argCode0;
        private final Code argCode1;
        private final Code argCode2;

        ApplyCode3(Applicable3 fnValue, Code argCode0, Code argCode1, Code argCode2) {
            this.fnValue = fnValue;
            this.argCode0 = argCode0;
            this.argCode1 = argCode1;
            this.argCode2 = argCode2;
        }

        @Override
        public Object eval(EvalEnv env) {
            Object arg0 = this.argCode0.eval(env);
            Object arg1 = this.argCode1.eval(env);
            Object arg2 = this.argCode2.eval(env);
            return this.fnValue.apply(arg0, arg1, arg2);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("apply3", d -> d.arg("fnValue", this.fnValue).arg("", this.argCode0).arg("", this.argCode1).arg("", this.argCode2));
        }
    }

    public static class TupleCode
    implements Code {
        public final List<Code> codes;

        private TupleCode(ImmutableList<Code> codes) {
            this.codes = codes;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("tuple", d -> this.codes.forEach(code -> d.arg("", (Describable)code)));
        }

        @Override
        public Object eval(EvalEnv env) {
            Object[] values = new Object[this.codes.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.codes.get(i).eval(env);
            }
            return Arrays.asList(values);
        }
    }

    static class FromCode
    implements Code {
        private final Supplier<RowSink> rowSinkFactory;

        FromCode(Supplier<RowSink> rowSinkFactory) {
            this.rowSinkFactory = Objects.requireNonNull(rowSinkFactory);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("from", d -> d.arg("sink", this.rowSinkFactory.get()));
        }

        @Override
        public Object eval(EvalEnv env) {
            RowSink rowSink = this.rowSinkFactory.get();
            rowSink.start(env);
            rowSink.accept(env);
            return rowSink.result(env);
        }
    }

    static class ScanRowSink
    extends BaseRowSink {
        final Op op;
        private final Core.Pat pat;
        private final Code code;
        final Code conditionCode;

        ScanRowSink(Op op, Core.Pat pat, Code code, Code conditionCode, RowSink rowSink) {
            super(rowSink);
            Preconditions.checkArgument((op == Op.SCAN ? 1 : 0) != 0);
            this.op = op;
            this.pat = pat;
            this.code = code;
            this.conditionCode = conditionCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("join", d -> d.arg("pat", this.pat).arg("exp", this.code).argIf("condition", this.conditionCode, !ScanRowSink.isConstantTrue(this.conditionCode)).arg("sink", this.rowSink));
        }

        private static boolean isConstantTrue(Code code) {
            return code.isConstant() && Objects.equals(code.eval(null), true);
        }

        @Override
        public void accept(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutablePat(this.pat);
            Iterable elements = (Iterable)this.code.eval(env);
            for (Object element : elements) {
                Boolean b;
                if (!mutableEvalEnv.setOpt(element) || (b = (Boolean)this.conditionCode.eval(mutableEvalEnv)) == null || !b.booleanValue()) continue;
                this.rowSink.accept(mutableEvalEnv);
            }
        }
    }

    public static interface RowSink
    extends Describable {
        public void start(EvalEnv var1);

        public void accept(EvalEnv var1);

        public List<Object> result(EvalEnv var1);
    }

    static class WhereRowSink
    extends BaseRowSink {
        final Code filterCode;

        WhereRowSink(Code filterCode, RowSink rowSink) {
            super(rowSink);
            this.filterCode = filterCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("where", d -> d.arg("condition", this.filterCode).arg("sink", this.rowSink));
        }

        @Override
        public void accept(EvalEnv env) {
            if (((Boolean)this.filterCode.eval(env)).booleanValue()) {
                this.rowSink.accept(env);
            }
        }
    }

    static class SkipRowSink
    extends BaseRowSink {
        final Code skipCode;
        int skip;

        SkipRowSink(Code skipCode, RowSink rowSink) {
            super(rowSink);
            this.skipCode = skipCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("skip", d -> d.arg("count", this.skipCode).arg("sink", this.rowSink));
        }

        @Override
        public void start(EvalEnv env) {
            this.skip = (Integer)this.skipCode.eval(env);
            super.start(env);
        }

        @Override
        public void accept(EvalEnv env) {
            if (this.skip > 0) {
                --this.skip;
            } else {
                this.rowSink.accept(env);
            }
        }
    }

    static class TakeRowSink
    extends BaseRowSink {
        final Code takeCode;
        int take;

        TakeRowSink(Code takeCode, RowSink rowSink) {
            super(rowSink);
            this.takeCode = takeCode;
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("take", d -> d.arg("count", this.takeCode).arg("sink", this.rowSink));
        }

        @Override
        public void start(EvalEnv env) {
            this.take = (Integer)this.takeCode.eval(env);
            super.start(env);
        }

        @Override
        public void accept(EvalEnv env) {
            if (this.take > 0) {
                --this.take;
                this.rowSink.accept(env);
            }
        }
    }

    static class ExceptDistinctRowSink
    extends SetRowSink {
        ExceptDistinctRowSink(ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(Op.EXCEPT, true, codes, names, rowSink);
        }

        @Override
        public void accept(EvalEnv env) {
            this.add(env);
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutableArray((List<String>)this.names);
            for (Code code : this.codes) {
                Iterable elements = (Iterable)code.eval(env);
                for (Object element2 : elements) {
                    mutableEvalEnv.set(element2);
                    this.remove(mutableEvalEnv);
                }
            }
            if (!this.map.isEmpty()) {
                MutableEvalEnv mutableEvalEnv2 = env.bindMutableList((List<String>)this.names);
                this.map.keySet().forEach(element -> {
                    mutableEvalEnv2.set(element);
                    this.rowSink.accept(mutableEvalEnv2);
                });
            }
            return this.rowSink.result(env);
        }
    }

    static class ExceptAllRowSink
    extends SetRowSink {
        ExceptAllRowSink(ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(Op.EXCEPT, false, codes, names, rowSink);
        }

        @Override
        public void accept(EvalEnv env) {
            this.inc(env);
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutableArray((List<String>)this.names);
            for (Code code : this.codes) {
                Iterable elements = (Iterable)code.eval(env);
                for (Object element : elements) {
                    mutableEvalEnv.set(element);
                    this.dec(mutableEvalEnv);
                }
            }
            if (!this.map.isEmpty()) {
                MutableEvalEnv mutableEvalEnv2 = env.bindMutableList((List<String>)this.names);
                this.map.forEach((k, v) -> {
                    int v2 = v[0];
                    if (v2 > 0) {
                        mutableEvalEnv2.set(k);
                        for (int i = 0; i < v2; ++i) {
                            this.rowSink.accept(mutableEvalEnv2);
                        }
                    }
                });
            }
            return this.rowSink.result(env);
        }
    }

    static class IntersectDistinctRowSink
    extends SetRowSink {
        IntersectDistinctRowSink(ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(Op.INTERSECT, true, codes, names, rowSink);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void accept(EvalEnv env) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutableArray((List<String>)this.names);
            int pass = 0;
            for (Code code : this.codes) {
                Iterable elements = (Iterable)code.eval(env);
                if (pass++ > 0) {
                    this.map.entrySet().removeIf(e -> ((int[])e.getValue())[0] == 0);
                    this.map.forEach((k, v) -> {
                        v[0] = 0;
                    });
                }
                for (Object element : elements) {
                    mutableEvalEnv.set(element);
                    this.computeIfPresent(mutableEvalEnv, (k, v) -> {
                        v[0] = v[0] + 1;
                        return v;
                    });
                }
            }
            if (!this.map.isEmpty()) {
                MutableEvalEnv mutableEvalEnv2 = env.bindMutableList((List<String>)this.names);
                this.map.forEach((k, v) -> {
                    if (v[0] > 0) {
                        mutableEvalEnv2.set(k);
                        this.rowSink.accept(mutableEvalEnv2);
                    }
                });
            }
            return this.rowSink.result(env);
        }
    }

    static class IntersectAllRowSink
    extends SetRowSink {
        IntersectAllRowSink(ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(Op.INTERSECT, false, codes, names, rowSink);
        }

        @Override
        public void accept(EvalEnv env) {
            this.compute(env, (k, v) -> {
                if (v == null) {
                    return new int[]{1, 0};
                }
                v[0] = v[0] + 1;
                return v;
            });
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutableArray((List<String>)this.names);
            int pass = 0;
            for (Code code : this.codes) {
                Iterable elements = (Iterable)code.eval(env);
                if (pass++ > 0) {
                    this.map.entrySet().removeIf(e -> ((int[])e.getValue())[1] == 0);
                    this.map.values().forEach(v -> {
                        v[0] = Math.min(v[0], v[1]);
                        v[1] = 0;
                    });
                }
                for (Object element : elements) {
                    mutableEvalEnv.set(element);
                    this.computeIfPresent(mutableEvalEnv, (k, v) -> {
                        v[1] = v[1] + 1;
                        return v;
                    });
                }
            }
            if (!this.map.isEmpty()) {
                MutableEvalEnv mutableEvalEnv2 = env.bindMutableList((List<String>)this.names);
                this.map.forEach((k, v) -> {
                    int v2 = Math.min(v[0], v[1]);
                    if (v2 > 0) {
                        mutableEvalEnv2.set(k);
                        for (int i = 0; i < v2; ++i) {
                            this.rowSink.accept(mutableEvalEnv2);
                        }
                    }
                });
            }
            return this.rowSink.result(env);
        }
    }

    static class UnionRowSink
    extends SetRowSink {
        UnionRowSink(boolean distinct, ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(Op.UNION, distinct, codes, names, rowSink);
        }

        @Override
        public void accept(EvalEnv env) {
            if (!this.distinct || this.add(env)) {
                this.rowSink.accept(env);
            }
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv mutableEvalEnv = env.bindMutableArray((List<String>)this.names);
            for (Code code : this.codes) {
                Iterable elements = (Iterable)code.eval(env);
                for (Object element : elements) {
                    mutableEvalEnv.set(element);
                    if (this.distinct && !this.add(mutableEvalEnv)) continue;
                    this.rowSink.accept(mutableEvalEnv);
                }
            }
            return this.rowSink.result(env);
        }
    }

    static class OrderRowSink
    extends BaseRowSink {
        final Code code;
        final Comparator comparator;
        final ImmutableList<String> names;
        final List<Object> rows = new ArrayList<Object>();
        final Object[] values;

        OrderRowSink(Code code, Comparator comparator, ImmutableList<String> names, RowSink rowSink) {
            super(rowSink);
            this.code = code;
            this.comparator = comparator;
            this.names = names;
            this.values = names.size() == 1 ? null : new Object[names.size()];
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("order", d -> d.arg("code", this.code).arg("sink", this.rowSink));
        }

        @Override
        public void accept(EvalEnv env) {
            if (this.values == null) {
                this.rows.add(env.getOpt((String)this.names.get(0)));
            } else {
                for (int i = 0; i < this.names.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.names.get(i));
                }
                this.rows.add(this.values.clone());
            }
        }

        @Override
        public List<Object> result(EvalEnv env) {
            MutableEvalEnv leftEnv = env.bindMutableArray((List<String>)this.names);
            MutableEvalEnv rightEnv = env.bindMutableArray((List<String>)this.names);
            this.rows.sort((left, right) -> {
                leftEnv.set(left);
                rightEnv.set(right);
                Object leftVal = this.code.eval(leftEnv);
                Object rightVal = this.code.eval(rightEnv);
                return this.comparator.compare(leftVal, rightVal);
            });
            for (Object row : this.rows) {
                leftEnv.set(row);
                this.rowSink.accept(leftEnv);
            }
            return this.rowSink.result(env);
        }
    }

    private static class GroupRowSink
    extends BaseRowSink {
        final Code keyCode;
        final ImmutableList<String> inNames;
        final ImmutableList<String> keyNames;
        final ImmutableList<String> outNames;
        final ImmutableList<Applicable> aggregateCodes;
        final ListMultimap<Object, Object> map = ArrayListMultimap.create();
        final Object[] values;

        GroupRowSink(Code keyCode, ImmutableList<Applicable> aggregateCodes, ImmutableList<String> inNames, ImmutableList<String> keyNames, ImmutableList<String> outNames, RowSink rowSink) {
            super(rowSink);
            this.keyCode = Objects.requireNonNull(keyCode);
            this.aggregateCodes = Objects.requireNonNull(aggregateCodes);
            this.inNames = Objects.requireNonNull(inNames);
            this.keyNames = Objects.requireNonNull(keyNames);
            this.outNames = Objects.requireNonNull(outNames);
            this.values = inNames.size() == 1 ? null : new Object[inNames.size()];
            Preconditions.checkArgument((boolean)GroupRowSink.isPrefix(keyNames, outNames));
        }

        private static <E> boolean isPrefix(List<E> list0, List<E> list1) {
            return list0.size() <= list1.size() && list0.equals(list1.subList(0, list0.size()));
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("group", d -> {
                d.arg("key", this.keyCode);
                this.aggregateCodes.forEach(a -> d.arg("agg", (Describable)a));
                d.arg("sink", this.rowSink);
            });
        }

        @Override
        public void accept(EvalEnv env) {
            if (this.inNames.size() == 1) {
                this.map.put(this.keyCode.eval(env), env.getOpt((String)this.inNames.get(0)));
            } else {
                for (int i = 0; i < this.inNames.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.inNames.get(i));
                }
                this.map.put(this.keyCode.eval(env), this.values.clone());
            }
        }

        @Override
        public List<Object> result(EvalEnv env) {
            EvalEnv env2 = env;
            MutableEvalEnv[] groupEnvs = new MutableEvalEnv[this.outNames.size()];
            int i = 0;
            for (String name : this.outNames) {
                int n = i++;
                MutableEvalEnv mutableEvalEnv = env2.bindMutable(name);
                groupEnvs[n] = mutableEvalEnv;
                env2 = mutableEvalEnv;
            }
            EvalEnv env3 = this.keyNames.isEmpty() ? env : groupEnvs[this.keyNames.size() - 1];
            Map map2 = this.map.isEmpty() && this.keyCode instanceof TupleCode && ((TupleCode)this.keyCode).codes.isEmpty() ? ImmutableMap.of((Object)ImmutableList.of(), (Object)ImmutableList.of()) : Multimaps.asMap(this.map);
            for (Map.Entry entry : map2.entrySet()) {
                List list = (List)entry.getKey();
                for (i = 0; i < list.size(); ++i) {
                    groupEnvs[i].set(list.get(i));
                }
                List rows = (List)entry.getValue();
                for (Applicable aggregateCode : this.aggregateCodes) {
                    groupEnvs[i++].set(aggregateCode.apply(env3, rows));
                }
                this.rowSink.accept(env2);
            }
            return this.rowSink.result(env);
        }
    }

    private static class YieldRowSink
    extends BaseRowSink {
        private final ImmutableList<String> names;
        private final ImmutableList<Code> codes;
        private final Object[] values;

        YieldRowSink(ImmutableList<String> names, ImmutableList<Code> codes, RowSink rowSink) {
            super(rowSink);
            this.names = names;
            this.codes = codes;
            this.values = names.size() == 1 ? null : new Object[names.size()];
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("yield", d -> d.args("codes", (Iterable<?>)this.codes).arg("sink", this.rowSink));
        }

        @Override
        public void accept(EvalEnv env) {
            MutableEvalEnv env2 = env.bindMutableArray((List<String>)this.names);
            if (this.values == null) {
                Object value = ((Code)this.codes.get(0)).eval(env);
                env2.set(value);
            } else {
                for (int i = 0; i < this.codes.size(); ++i) {
                    this.values[i] = ((Code)this.codes.get(i)).eval(env);
                }
                env2.set(this.values);
            }
            this.rowSink.accept(env2);
        }
    }

    private static class CollectRowSink
    implements RowSink {
        final List<Object> list = new ArrayList<Object>();
        final Code code;

        CollectRowSink(Code code) {
            this.code = Objects.requireNonNull(code);
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start("collect", d -> d.arg("", this.code));
        }

        @Override
        public void start(EvalEnv env) {
            this.list.clear();
        }

        @Override
        public void accept(EvalEnv env) {
            this.list.add(this.code.eval(env));
        }

        @Override
        public List<Object> result(EvalEnv env) {
            return this.list;
        }
    }

    private static class FirstRowSink
    extends BaseRowSink {
        final ImmutableList<Runnable> startActions;

        FirstRowSink(RowSink rowSink, List<Runnable> startActions) {
            super(rowSink);
            this.startActions = ImmutableList.copyOf(startActions);
        }

        @Override
        public Describer describe(Describer describer) {
            return this.rowSink.describe(describer);
        }

        @Override
        public void start(EvalEnv env) {
            this.startActions.forEach(Runnable::run);
            this.rowSink.start(env);
        }
    }

    public static class MorelRuntimeException
    extends RuntimeException
    implements MorelException {
        private final BuiltInExn e;
        private final Pos pos;

        public MorelRuntimeException(BuiltInExn e, Pos pos) {
            this.e = Objects.requireNonNull(e);
            this.pos = Objects.requireNonNull(pos);
        }

        @Override
        public String toString() {
            return this.e.mlName + " at " + this.pos;
        }

        @Override
        public StringBuilder describeTo(StringBuilder buf) {
            return buf.append("uncaught exception ").append(this.e.mlName);
        }

        @Override
        public Pos pos() {
            return this.pos;
        }
    }

    public static enum BuiltInExn {
        EMPTY("List", "Empty"),
        BIND("General", "Bind"),
        CHR("General", "Chr"),
        DIV("General", "Div"),
        DOMAIN("General", "Domain"),
        OPTION("Option", "Option"),
        OVERFLOW("General", "Overflow"),
        ERROR("Interact", "Error"),
        SIZE("General", "Size"),
        SUBSCRIPT("General", "Subscript [subscript out of bounds]"),
        UNORDERED("IEEEReal", "Unordered");

        public final String structure;
        public final String mlName;

        private BuiltInExn(String structure, String mlName) {
            this.structure = structure;
            this.mlName = mlName;
        }
    }

    private static class IntDiv
    extends Applicable2<Integer, Integer, Integer> {
        IntDiv(BuiltIn builtIn) {
            super(builtIn);
        }

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return Math.floorDiv(a0, (int)a1);
        }
    }

    private static class CharPredicate
    extends ApplicableImpl {
        private final Predicate<Character> predicate;

        CharPredicate(BuiltIn builtIn, Predicate<Character> predicate) {
            super(builtIn);
            this.predicate = predicate;
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return this.predicate.test((Character)arg);
        }

        static boolean isGraph(char c) {
            return c >= '!' && c <= '~';
        }

        static boolean isPrint(char c) {
            return CharPredicate.isGraph(c) || c == ' ';
        }

        static boolean isCntrl(char c) {
            return CharPredicate.isAscii(c) && !CharPredicate.isPrint(c);
        }

        static boolean isSpace(char c) {
            return c >= '\t' && c <= '\r' || c == ' ';
        }

        static boolean isAscii(char c) {
            return c <= '\u007f';
        }

        static boolean isUpper(char c) {
            return 'A' <= c && c <= 'Z';
        }

        static boolean isLower(char c) {
            return 'a' <= c && c <= 'z';
        }

        static boolean isDigit(char c) {
            return '0' <= c && c <= '9';
        }

        static boolean isAlpha(char c) {
            return CharPredicate.isUpper(c) || CharPredicate.isLower(c);
        }

        static boolean isAlphaNum(char c) {
            return CharPredicate.isAlpha(c) || CharPredicate.isDigit(c);
        }

        static boolean isHexDigit(char c) {
            return CharPredicate.isDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
        }

        static boolean isPunct(char c) {
            return CharPredicate.isGraph(c) && !CharPredicate.isAlphaNum(c);
        }
    }

    private static class IntMod
    extends Applicable2<Integer, Integer, Integer> {
        IntMod(BuiltIn builtIn) {
            super(builtIn);
        }

        @Override
        public Integer apply(Integer a0, Integer a1) {
            return Math.floorMod(a0, (int)a1);
        }
    }

    private static class InteractUse
    extends PositionedApplicableImpl {
        private final boolean silent;

        InteractUse(Pos pos, boolean silent) {
            super(BuiltIn.INTERACT_USE, pos);
            this.silent = silent;
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new InteractUse(pos, this.silent);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            String f = (String)arg;
            Session session = (Session)env.getOpt("$session");
            session.use(f, this.silent, this.pos);
            return Unit.INSTANCE;
        }
    }

    private static class StringSub
    extends Applicable2<Character, String, Integer>
    implements Positioned {
        StringSub(Pos pos) {
            super(BuiltIn.STRING_SUB, pos);
        }

        @Override
        public Character apply(String s, Integer i) {
            if (i < 0 || i >= s.length()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            return Character.valueOf(s.charAt(i));
        }

        @Override
        public StringSub withPos(Pos pos) {
            return new StringSub(pos);
        }
    }

    private static class StringExtract
    extends Applicable3<String, String, Integer, List>
    implements Positioned {
        StringExtract(Pos pos) {
            super(BuiltIn.STRING_EXTRACT, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new StringExtract(pos);
        }

        @Override
        public String apply(String s, Integer i, List jOpt) {
            if (i < 0) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            if (jOpt.size() == 2) {
                int j = (Integer)jOpt.get(1);
                if (j < 0 || i + j > s.length()) {
                    throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
                }
                return s.substring(i, i + j);
            }
            if (i > s.length()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            return s.substring(i);
        }
    }

    private static class StringSubstring
    extends Applicable3<String, String, Integer, Integer>
    implements Positioned {
        StringSubstring(Pos pos) {
            super(BuiltIn.STRING_SUBSTRING, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new StringSubstring(pos);
        }

        @Override
        public String apply(String s, Integer i, Integer j) {
            if (i < 0 || j < 0 || i + j > s.length()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            return s.substring(i, i + j);
        }
    }

    private static class StringConcat
    extends PositionedApplicableImpl {
        StringConcat(Pos pos) {
            super(BuiltIn.STRING_CONCAT, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new StringConcat(pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            return Codes.stringConcat(this.pos, "", (List)arg);
        }
    }

    private static class StringConcatWith
    extends PositionedApplicableImpl {
        StringConcatWith(Pos pos) {
            super(BuiltIn.STRING_CONCAT_WITH, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new StringConcatWith(pos);
        }

        @Override
        public Object apply(EvalEnv env, Object argValue) {
            final String separator = (String)argValue;
            return new ApplicableImpl("String.concatWith$separator"){

                @Override
                public Object apply(EvalEnv env, Object arg) {
                    return Codes.stringConcat(this.pos, separator, (List)arg);
                }
            };
        }
    }

    private static class ListHd
    extends PositionedApplicableImpl {
        ListHd(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListHd(this.builtIn, pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            if (list.isEmpty()) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            return list.get(0);
        }
    }

    private static class ListTl
    extends PositionedApplicableImpl {
        ListTl(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListTl(this.builtIn, pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            int size = list.size();
            if (size == 0) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            return list.subList(1, size);
        }
    }

    private static class ListLast
    extends PositionedApplicableImpl {
        ListLast(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListLast(this.builtIn, pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            int size = list.size();
            if (size == 0) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            return list.get(size - 1);
        }
    }

    private static class ListNth
    extends Applicable2<Object, List, Integer>
    implements Positioned {
        private final BuiltIn builtIn;

        ListNth(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
            this.builtIn = builtIn;
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListNth(this.builtIn, pos);
        }

        @Override
        public Object apply(List list, Integer i) {
            if (i < 0 || i >= list.size()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            return list.get(i);
        }
    }

    private static class ListTake
    extends Applicable2<List, List, Integer>
    implements Positioned {
        private final BuiltIn builtIn;

        ListTake(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
            this.builtIn = builtIn;
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListTake(this.builtIn, pos);
        }

        @Override
        public List apply(List list, Integer i) {
            if (i < 0 || i > list.size()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            return list.subList(0, i);
        }
    }

    private static class ListTabulate
    extends PositionedApplicableImpl {
        ListTabulate(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new ListTabulate(this.builtIn, pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List tuple = (List)arg;
            int count = (Integer)tuple.get(0);
            if (count < 0) {
                throw new MorelRuntimeException(BuiltInExn.SIZE, this.pos);
            }
            Applicable fn = (Applicable)tuple.get(1);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < count; ++i) {
                builder.add(fn.apply(env, i));
            }
            return builder.build();
        }
    }

    private static class OptionValOf
    extends PositionedApplicableImpl {
        OptionValOf(Pos pos) {
            super(BuiltIn.OPTION_VAL_OF, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new OptionValOf(pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List opt = (List)arg;
            if (opt.size() == 2) {
                return opt.get(1);
            }
            throw new MorelRuntimeException(BuiltInExn.OPTION, this.pos);
        }
    }

    private static class RealCheckFloat
    extends PositionedApplicableImpl {
        RealCheckFloat(Pos pos) {
            super(BuiltIn.REAL_CHECK_FLOAT, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new RealCheckFloat(pos);
        }

        @Override
        public Float apply(EvalEnv env, Object arg) {
            Float f = (Float)arg;
            if (Float.isFinite(f.floatValue())) {
                return f;
            }
            if (Float.isNaN(f.floatValue())) {
                throw new MorelRuntimeException(BuiltInExn.DIV, this.pos);
            }
            throw new MorelRuntimeException(BuiltInExn.OVERFLOW, this.pos);
        }
    }

    private static class RealCompare
    extends Applicable2<List, Float, Float>
    implements Positioned {
        RealCompare(Pos pos) {
            super(BuiltIn.REAL_COMPARE, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new RealCompare(pos);
        }

        @Override
        public List apply(Float f0, Float f1) {
            if (Float.isNaN(f0.floatValue()) || Float.isNaN(f1.floatValue())) {
                throw new MorelRuntimeException(BuiltInExn.UNORDERED, this.pos);
            }
            if (f0.floatValue() < f1.floatValue()) {
                return ORDER_LESS;
            }
            if (f0.floatValue() > f1.floatValue()) {
                return ORDER_GREATER;
            }
            return ORDER_EQUAL;
        }
    }

    private static class RealSign
    extends PositionedApplicableImpl {
        RealSign(Pos pos) {
            super(BuiltIn.REAL_SIGN, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new RealSign(pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            float f = ((Float)arg).floatValue();
            if (Float.isNaN(f)) {
                throw new MorelRuntimeException(BuiltInExn.DOMAIN, this.pos);
            }
            return f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        }
    }

    static class Comparer
    extends Applicable2<List, Object, Object>
    implements Typed {
        static final Applicable INITIAL = new Comparer(Comparators::compare);
        private final Comparator comparator;

        Comparer(Comparator comparator) {
            super(BuiltIn.RELATIONAL_COMPARE);
            this.comparator = Objects.requireNonNull(comparator);
        }

        @Override
        public Applicable withType(TypeSystem typeSystem, Type type) {
            Preconditions.checkArgument((boolean)(type instanceof FnType));
            Type argType = ((FnType)type).paramType;
            Preconditions.checkArgument((boolean)(argType instanceof TupleType));
            List<Type> argTypes = ((TupleType)argType).argTypes;
            Preconditions.checkArgument((argTypes.size() == 2 ? 1 : 0) != 0);
            Type argType0 = argTypes.get(0);
            Type argType1 = argTypes.get(1);
            Preconditions.checkArgument((boolean)argType0.equals(argType1));
            return new Comparer(Comparators.comparatorFor(typeSystem, argType0));
        }

        @Override
        public List apply(Object o1, Object o2) {
            return Codes.order(this.comparator.compare(o1, o2));
        }
    }

    private static class RelationalOnly
    extends PositionedApplicableImpl {
        RelationalOnly(Pos pos) {
            super(BuiltIn.RELATIONAL_ONLY, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new RelationalOnly(pos);
        }

        @Override
        public Object apply(EvalEnv env, Object arg) {
            List list = (List)arg;
            if (list.isEmpty()) {
                throw new MorelRuntimeException(BuiltInExn.EMPTY, this.pos);
            }
            if (list.size() > 1) {
                throw new MorelRuntimeException(BuiltInExn.SIZE, this.pos);
            }
            return list.get(0);
        }
    }

    private static class VectorUpdate
    extends Applicable3<List, List, Integer, Object>
    implements Positioned {
        VectorUpdate(Pos pos) {
            super(BuiltIn.VECTOR_UPDATE, pos);
        }

        @Override
        public Applicable withPos(Pos pos) {
            return new VectorUpdate(pos);
        }

        @Override
        public List apply(List vec, Integer i, Object x) {
            if (i < 0 || i >= vec.size()) {
                throw new MorelRuntimeException(BuiltInExn.SUBSCRIPT, this.pos);
            }
            Object[] elements = vec.toArray();
            elements[i.intValue()] = x;
            return ImmutableList.copyOf((Object[])elements);
        }
    }

    private static abstract class PositionedApplicableImpl
    extends ApplicableImpl
    implements Positioned {
        final BuiltIn builtIn;

        protected PositionedApplicableImpl(BuiltIn builtIn, Pos pos) {
            super(builtIn, pos);
            this.builtIn = builtIn;
        }
    }

    public static interface Typed
    extends Applicable {
        public Applicable withType(TypeSystem var1, Type var2);
    }

    public static interface Positioned
    extends Applicable {
        public Applicable withPos(Pos var1);
    }

    static abstract class SetRowSink
    extends BaseRowSink {
        private static final int[] ZERO = new int[0];
        final Op op;
        final boolean distinct;
        final ImmutableList<Code> codes;
        final ImmutableList<String> names;
        final Map<Object, int[]> map = new HashMap<Object, int[]>();
        final Object[] values;

        SetRowSink(Op op, boolean distinct, ImmutableList<Code> codes, ImmutableList<String> names, RowSink rowSink) {
            super(rowSink);
            Preconditions.checkArgument((op == Op.EXCEPT || op == Op.INTERSECT || op == Op.UNION ? 1 : 0) != 0, (String)"invalid op %s", (Object)((Object)op));
            this.op = op;
            this.distinct = distinct;
            this.codes = Objects.requireNonNull(codes);
            this.names = Objects.requireNonNull(names);
            this.values = new Object[names.size()];
        }

        @Override
        public Describer describe(Describer describer) {
            return describer.start(this.op.opName, d -> {
                d.arg("distinct", this.distinct);
                Ord.forEachIndexed(this.codes, (code, i) -> d.arg("arg" + i, (Describable)code));
                d.arg("sink", this.rowSink);
            });
        }

        boolean add(EvalEnv env) {
            if (this.names.size() == 1) {
                Object value = env.getOpt((String)this.names.get(0));
                return this.map.put(value, ZERO) == null;
            }
            for (int i = 0; i < this.names.size(); ++i) {
                this.values[i] = env.getOpt((String)this.names.get(i));
            }
            return this.map.put(ImmutableList.copyOf((Object[])this.values), ZERO) == null;
        }

        void remove(EvalEnv env) {
            if (this.names.size() == 1) {
                Object value = env.getOpt((String)this.names.get(0));
                this.map.remove(value);
            } else {
                for (int i = 0; i < this.names.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.names.get(i));
                }
                this.map.remove(ImmutableList.copyOf((Object[])this.values));
            }
        }

        void inc(EvalEnv env) {
            this.compute(env, (k, v) -> {
                if (v == null) {
                    return new int[]{1};
                }
                v[0] = v[0] + 1;
                return v;
            });
        }

        void dec(EvalEnv env) {
            this.computeIfPresent(env, (k, v) -> {
                v[0] = v[0] - 1;
                return v;
            });
        }

        void compute(EvalEnv env, BiFunction<Object, int[], int[]> fn) {
            Object value;
            if (this.names.size() == 1) {
                value = env.getOpt((String)this.names.get(0));
            } else {
                for (int i = 0; i < this.names.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.names.get(i));
                }
                value = ImmutableList.copyOf((Object[])this.values);
            }
            this.map.compute(value, fn);
        }

        void computeIfPresent(EvalEnv env, BiFunction<Object, int[], int[]> fn) {
            Object value;
            if (this.names.size() == 1) {
                value = env.getOpt((String)this.names.get(0));
            } else {
                for (int i = 0; i < this.names.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.names.get(i));
                }
                value = ImmutableList.copyOf((Object[])this.values);
            }
            this.map.computeIfPresent(value, fn);
        }

        void computeIfAbsent(EvalEnv env, Function<Object, int[]> fn) {
            Object value;
            if (this.names.size() == 1) {
                value = env.getOpt((String)this.names.get(0));
            } else {
                for (int i = 0; i < this.names.size(); ++i) {
                    this.values[i] = env.getOpt((String)this.names.get(i));
                }
                value = ImmutableList.copyOf((Object[])this.values);
            }
            this.map.computeIfAbsent(value, fn);
        }
    }

    static abstract class BaseRowSink
    implements RowSink {
        final RowSink rowSink;

        BaseRowSink(RowSink rowSink) {
            this.rowSink = Objects.requireNonNull(rowSink);
        }

        @Override
        public void start(EvalEnv env) {
            this.rowSink.start(env);
        }

        @Override
        public void accept(EvalEnv env) {
            this.rowSink.accept(env);
        }

        @Override
        public List<Object> result(EvalEnv env) {
            return this.rowSink.result(env);
        }
    }
}

