/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.DummyType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;

public class Comparators {
    private Comparators() {
    }

    public static Comparator comparatorFor(TypeSystem typeSystem, Type type) {
        return new ComparatorBuilder(typeSystem).comparatorFor(type);
    }

    public static int compare(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    static class ComparatorBuilder {
        private final TypeSystem typeSystem;
        private final Map<Type.Key, Comparator> cache = new HashMap<Type.Key, Comparator>();

        ComparatorBuilder(TypeSystem typeSystem) {
            this.typeSystem = Objects.requireNonNull(typeSystem);
        }

        Comparator comparatorFor(Type t2) {
            if (t2 == DummyType.INSTANCE) {
                return (list1, list2) -> 0;
            }
            Type.Key key = t2.key();
            Comparator comparator = this.cache.get(key);
            if (comparator == Dummy.INSTANCE) {
                return new DeferredComparator(key);
            }
            if (comparator != null) {
                return comparator;
            }
            return this.comparatorFor1(t2);
        }

        private Comparator comparatorFor1(Type type) {
            Type.Key key = type.key();
            this.cache.put(key, Dummy.INSTANCE);
            Comparator comparator2 = this.comparatorFor2(type);
            this.cache.put(key, comparator2);
            return comparator2;
        }

        private Comparator comparatorFor2(Type type) {
            switch (type.op()) {
                case ID: 
                case TY_VAR: {
                    return Comparators::compare;
                }
                case TUPLE_TYPE: 
                case RECORD_TYPE: {
                    ImmutableList<Comparator> fieldComparators = Static.transformEager(((RecordLikeType)type).argTypes(), this::comparatorFor);
                    return (list1, list2) -> {
                        for (int i = 0; i < fieldComparators.size(); ++i) {
                            Comparator comparator = (Comparator)fieldComparators.get(i);
                            int c = comparator.compare(list1.get(i), list2.get(i));
                            if (c == 0) continue;
                            return c;
                        }
                        return 0;
                    };
                }
                case LIST: {
                    return this.listComparator(type.arg(0));
                }
                case DATA_TYPE: {
                    DataType dataType = (DataType)type;
                    switch (dataType.name) {
                        case "bag": {
                            return this.listComparator(dataType.arg(0));
                        }
                        case "descending": {
                            Comparator objectComparator = this.comparatorFor(dataType.arg(0));
                            return (list1, list2) -> objectComparator.compare(list2.get(1), list1.get(1));
                        }
                    }
                    PairList b = PairList.of();
                    dataType.typeConstructors(this.typeSystem).forEach((name, t) -> b.add(name, Ord.of(b.size(), this.comparatorFor((Type)t))));
                    ImmutableMap constructorComparators = b.toImmutableMap();
                    return (list1, list2) -> {
                        String s2;
                        String s1 = (String)list1.get(0);
                        if (s1.equals(s2 = (String)list2.get(0))) {
                            if (list1.size() == 1) {
                                return 0;
                            }
                            Ord comparator = Objects.requireNonNull((Ord)constructorComparators.get((Object)s1));
                            return ((Comparator)comparator.e).compare(list1.get(1), list2.get(1));
                        }
                        Ord comparator1 = Objects.requireNonNull((Ord)constructorComparators.get((Object)s1));
                        Ord comparator2 = Objects.requireNonNull((Ord)constructorComparators.get((Object)s2));
                        return Integer.compare(comparator1.i, comparator2.i);
                    };
                }
            }
            throw new AssertionError((Object)("unknown type: " + type));
        }

        private Comparator<List> listComparator(Type elementType) {
            Comparator elementComparator = this.comparatorFor(elementType);
            return (list1, list2) -> {
                int n1 = list1.size();
                int n2 = list2.size();
                int n = Math.min(n1, n2);
                for (int i = 0; i < n; ++i) {
                    Object element1;
                    Object element0 = list1.get(i);
                    int c = elementComparator.compare(element0, element1 = list2.get(i));
                    if (c == 0) continue;
                    return c;
                }
                return Integer.compare(n1, n2);
            };
        }

        private class DeferredComparator
        implements Comparator {
            final Supplier<Comparator> supplier = Suppliers.memoize(() -> Objects.requireNonNull((Comparator)ComparatorBuilder.this.cache.get(key)));

            DeferredComparator(Type.Key key) {
            }

            public int compare(Object o1, Object o2) {
                return Objects.requireNonNull((Comparator)this.supplier.get()).compare(o1, o2);
            }
        }
    }

    private static enum Dummy implements Comparator
    {
        INSTANCE;


        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

