/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.hydromatic.morel.eval.Describable;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.util.Ord;

class DescriberImpl
implements Describer {
    final StringBuilder buf = new StringBuilder();
    final Map<String, List<Integer>> nameIds = new HashMap<String, List<Integer>>();

    DescriberImpl() {
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public Describer start(String name, Consumer<Describer.Detail> consumer) {
        this.buf.append(name);
        DetailImpl detail = new DetailImpl();
        consumer.accept(detail);
        detail.end();
        return this;
    }

    @Override
    public int register(String name, int i) {
        List list = this.nameIds.computeIfAbsent(name, id_ -> new ArrayList());
        int j = list.indexOf(i);
        if (j < 0) {
            j = list.size();
            list.add(i);
        }
        return j;
    }

    private class DetailImpl
    implements Describer.Detail {
        final int start;

        private DetailImpl() {
            this.start = DescriberImpl.this.buf.length();
        }

        @Override
        public Describer.Detail arg(String name, Object value) {
            if (value instanceof Iterable) {
                return this.args(name, (Iterable)value);
            }
            DescriberImpl.this.buf.append(DescriberImpl.this.buf.length() == this.start ? "(" : ", ").append(name).append(name.isEmpty() ? "" : " ").append(value);
            return this;
        }

        @Override
        public Describer.Detail args(String name, Iterable<?> values) {
            DescriberImpl.this.buf.append(DescriberImpl.this.buf.length() == this.start ? "(" : ", ").append(name).append(name.isEmpty() ? "[" : " [");
            this.appendAll(values);
            DescriberImpl.this.buf.append(']');
            return this;
        }

        private void appendAll(Iterable<?> values) {
            Ord.forEachIndexed(values, (value, i) -> {
                if (i > 0) {
                    DescriberImpl.this.buf.append(", ");
                }
                this.append(value);
            });
        }

        private void append(Object value) {
            if (value instanceof Describable) {
                ((Describable)value).describe(DescriberImpl.this);
            } else {
                DescriberImpl.this.buf.append(value);
            }
        }

        @Override
        public Describer.Detail arg(String name, Describable describable) {
            DescriberImpl.this.buf.append(DescriberImpl.this.buf.length() == this.start ? "(" : ", ").append(name).append(name.isEmpty() ? "" : " ");
            describable.describe(DescriberImpl.this);
            return this;
        }

        void end() {
            if (DescriberImpl.this.buf.length() > this.start) {
                DescriberImpl.this.buf.append(')');
            }
        }
    }
}

