/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.MutableEvalEnv;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EvalEnvs {
    public static EvalEnv copyOf(Map<String, Object> valueMap) {
        return new MapEvalEnv(valueMap);
    }

    private EvalEnvs() {
    }

    static class MapEvalEnv
    implements EvalEnv {
        final Map<String, Object> valueMap;

        MapEvalEnv(Map<String, Object> valueMap) {
            this.valueMap = ImmutableMap.copyOf(valueMap);
        }

        @Override
        public Object getOpt(String name) {
            return this.valueMap.get(name);
        }

        @Override
        public void visit(BiConsumer<String, Object> consumer) {
            this.valueMap.forEach(consumer);
        }
    }

    static class MutableListSubEvalEnv
    extends ListSubEvalEnv
    implements MutableEvalEnv {
        MutableListSubEvalEnv(EvalEnv parentEnv, List<String> names) {
            super(parentEnv, (ImmutableList<String>)ImmutableList.copyOf(names), null);
        }

        @Override
        public void set(Object value) {
            this.values = (List)value;
            assert (this.values.size() == this.names.size());
        }

        @Override
        public ListSubEvalEnv fix() {
            throw new UnsupportedOperationException("fix");
        }
    }

    static class ListSubEvalEnv
    implements EvalEnv {
        protected final EvalEnv parentEnv;
        protected final ImmutableList<String> names;
        protected List<?> values;

        ListSubEvalEnv(EvalEnv parentEnv, ImmutableList<String> names, @Nullable List<?> values) {
            this.parentEnv = Objects.requireNonNull(parentEnv);
            this.names = Objects.requireNonNull(names);
            this.values = values;
        }

        @Override
        public void visit(BiConsumer<String, Object> consumer) {
            for (int i = 0; i < this.names.size(); ++i) {
                consumer.accept((String)this.names.get(i), this.values.get(i));
            }
            this.parentEnv.visit(consumer);
        }

        @Override
        public Object getOpt(String name) {
            int i = this.names.indexOf((Object)name);
            if (i >= 0) {
                return this.values.get(i);
            }
            return this.parentEnv.getOpt(name);
        }
    }

    static class MutablePatSubEvalEnv
    extends PatSubEvalEnv
    implements MutableEvalEnv {
        private int slot;

        MutablePatSubEvalEnv(EvalEnv parentEnv, Core.Pat pat, List<String> names) {
            super(parentEnv, pat, (ImmutableList<String>)ImmutableList.copyOf(names), new Object[names.size()]);
        }

        @Override
        public EvalEnv fix() {
            return new PatSubEvalEnv(this.parentEnv, this.pat, (ImmutableList<String>)this.names, (Object[])this.values.clone());
        }

        @Override
        public void set(Object value) {
            if (!this.setOpt(value)) {
                throw new AssertionError((Object)"bind failed");
            }
        }

        @Override
        public boolean setOpt(Object value) {
            this.slot = 0;
            return this.bindRecurse(this.pat, value);
        }

        boolean bindRecurse(Core.Pat pat, Object argValue) {
            switch (pat.op) {
                case ID_PAT: {
                    this.values[this.slot++] = argValue;
                    return true;
                }
                case AS_PAT: {
                    Core.AsPat asPat = (Core.AsPat)pat;
                    int oldSlot = this.slot++;
                    if (this.bindRecurse(asPat.pat, argValue)) {
                        this.values[oldSlot] = argValue;
                        return true;
                    }
                    return false;
                }
                case WILDCARD_PAT: {
                    return true;
                }
                case BOOL_LITERAL_PAT: 
                case CHAR_LITERAL_PAT: 
                case STRING_LITERAL_PAT: {
                    Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                    return literalPat.value.equals(argValue);
                }
                case INT_LITERAL_PAT: {
                    Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                    return ((BigDecimal)literalPat.value).intValue() == ((Integer)argValue).intValue();
                }
                case REAL_LITERAL_PAT: {
                    Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                    return ((BigDecimal)literalPat.value).doubleValue() == ((Double)argValue).doubleValue();
                }
                case TUPLE_PAT: {
                    Core.TuplePat tuplePat = (Core.TuplePat)pat;
                    List listValue = (List)argValue;
                    return Pair.allMatch(tuplePat.args, listValue, this::bindRecurse);
                }
                case RECORD_PAT: {
                    Core.RecordPat recordPat = (Core.RecordPat)pat;
                    List listValue = (List)argValue;
                    for (Pair pair : Pair.zip(recordPat.args, listValue)) {
                        if (this.bindRecurse((Core.Pat)pair.left, pair.right)) continue;
                        return false;
                    }
                    return true;
                }
                case LIST_PAT: {
                    Core.ListPat listPat = (Core.ListPat)pat;
                    List listValue = (List)argValue;
                    if (listValue.size() != listPat.args.size()) {
                        return false;
                    }
                    for (Pair pair : Pair.zip(listPat.args, listValue)) {
                        if (this.bindRecurse((Core.Pat)pair.left, pair.right)) continue;
                        return false;
                    }
                    return true;
                }
                case CONS_PAT: {
                    Core.ConPat infixPat = (Core.ConPat)pat;
                    List consValue = (List)argValue;
                    if (consValue.isEmpty()) {
                        return false;
                    }
                    Object head = consValue.get(0);
                    List tail = Static.skip(consValue);
                    List<Core.Pat> patArgs = ((Core.TuplePat)infixPat.pat).args;
                    return this.bindRecurse(patArgs.get(0), head) && this.bindRecurse(patArgs.get(1), tail);
                }
                case CON0_PAT: {
                    Core.Con0Pat con0Pat = (Core.Con0Pat)pat;
                    List con0Value = (List)argValue;
                    return con0Value.get(0).equals(con0Pat.tyCon);
                }
                case CON_PAT: {
                    Core.ConPat conPat = (Core.ConPat)pat;
                    List conValue = (List)argValue;
                    return conValue.get(0).equals(conPat.tyCon) && this.bindRecurse(conPat.pat, conValue.get(1));
                }
            }
            throw new AssertionError((Object)("cannot compile " + (Object)((Object)pat.op) + ": " + pat));
        }
    }

    static class PatSubEvalEnv
    extends ArraySubEvalEnv {
        protected final Core.Pat pat;

        PatSubEvalEnv(EvalEnv parentEnv, Core.Pat pat, ImmutableList<String> names, Object[] values) {
            super(parentEnv, (ImmutableList<String>)ImmutableList.copyOf(names), values);
            this.pat = Objects.requireNonNull(pat);
            assert (!(pat instanceof Core.IdPat));
        }
    }

    static class MutableArraySubEvalEnv
    extends ArraySubEvalEnv
    implements MutableEvalEnv {
        MutableArraySubEvalEnv(EvalEnv parentEnv, List<String> names) {
            super(parentEnv, (ImmutableList<String>)ImmutableList.copyOf(names), null);
        }

        @Override
        public void set(Object value) {
            this.values = (Object[])value;
            assert (this.values.length == this.names.size());
        }

        @Override
        public ArraySubEvalEnv fix() {
            return new ArraySubEvalEnv(this.parentEnv, (ImmutableList<String>)this.names, (Object[])this.values.clone());
        }
    }

    static class ArraySubEvalEnv
    implements EvalEnv {
        protected final EvalEnv parentEnv;
        protected final ImmutableList<String> names;
        protected Object[] values;

        ArraySubEvalEnv(EvalEnv parentEnv, ImmutableList<String> names, @Nullable Object[] values) {
            this.parentEnv = Objects.requireNonNull(parentEnv);
            this.names = Objects.requireNonNull(names);
            this.values = values;
        }

        @Override
        public void visit(BiConsumer<String, Object> consumer) {
            for (int i = 0; i < this.names.size(); ++i) {
                consumer.accept((String)this.names.get(i), this.values[i]);
            }
            this.parentEnv.visit(consumer);
        }

        @Override
        public Object getOpt(String name) {
            int i = this.names.indexOf((Object)name);
            if (i >= 0) {
                return this.values[i];
            }
            return this.parentEnv.getOpt(name);
        }
    }

    static class MutableSubEvalEnv
    extends SubEvalEnv
    implements MutableEvalEnv {
        MutableSubEvalEnv(EvalEnv parentEnv, String name) {
            super(parentEnv, name, null);
        }

        @Override
        public void set(Object value) {
            this.value = value;
        }

        @Override
        public EvalEnv fix() {
            return new SubEvalEnv(this.parentEnv, this.name, this.value);
        }
    }

    static class SubEvalEnv
    implements EvalEnv {
        protected final EvalEnv parentEnv;
        protected final String name;
        protected Object value;

        SubEvalEnv(EvalEnv parentEnv, String name, Object value) {
            this.parentEnv = parentEnv;
            this.name = name;
            this.value = value;
        }

        @Override
        public void visit(BiConsumer<String, Object> consumer) {
            consumer.accept(this.name, this.value);
            this.parentEnv.visit(consumer);
        }

        @Override
        public Object getOpt(String name) {
            SubEvalEnv e = this;
            while (true) {
                if (name.equals(e.name)) {
                    return e.value;
                }
                if (!(e.parentEnv instanceof SubEvalEnv)) break;
                e = (SubEvalEnv)e.parentEnv;
            }
            return e.parentEnv.getOpt(name);
        }
    }
}

