/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.eval;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.NameGenerator;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.File;
import net.hydromatic.morel.eval.Files;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.util.MorelException;

public class Session {
    public Code code;
    public List<String> out;
    public final Map<Prop, Object> map;
    public final Supplier<File> file;
    public final NameGenerator nameGenerator = new NameGenerator();
    private Shell shell = Shells.INSTANCE;

    public Session(Map<Prop, Object> map) {
        this.map = map;
        this.file = Suppliers.memoize(() -> Files.create(Prop.DIRECTORY.fileValue(this.map)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withShell(Shell shell, Consumer<String> outLines, Consumer<Session> consumer) {
        Shell prevShell = this.shell;
        try {
            this.shell = Objects.requireNonNull(shell, "shell");
            consumer.accept(this);
        }
        catch (RuntimeException e) {
            StringBuilder buf = new StringBuilder();
            prevShell.handle(e, buf);
            outLines.accept(buf.toString());
        }
        finally {
            this.shell = prevShell;
        }
    }

    public void withoutHandlingExceptions(Consumer<Session> consumer) {
        Shell prevShell = this.shell;
        try {
            this.shell = Shells.BARF;
            consumer.accept(this);
        }
        finally {
            this.shell = prevShell;
        }
    }

    public void use(String fileName, boolean silent, Pos pos) {
        this.shell.use(fileName, silent, pos);
    }

    public void handle(MorelException e, StringBuilder buf) {
        this.shell.handle((RuntimeException)((Object)e), buf);
    }

    public void clearEnv() {
        this.shell.clearEnv();
    }

    private static enum Shells implements Shell
    {
        INSTANCE{

            @Override
            public void handle(RuntimeException e, StringBuilder buf) {
                if (e instanceof Codes.MorelRuntimeException) {
                    ((Codes.MorelRuntimeException)e).describeTo(buf);
                } else if (e instanceof CompileException) {
                    buf.append(e.getMessage());
                } else {
                    buf.append(e);
                }
            }
        }
        ,
        BARF{

            @Override
            public void handle(RuntimeException e, StringBuilder buf) {
                throw e;
            }
        };


        @Override
        public void use(String fileName, boolean silent, Pos pos) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Shell {
        public void use(String var1, boolean var2, Pos var3);

        public void handle(RuntimeException var1, StringBuilder var2);

        default public void clearEnv() {
        }
    }
}

