/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.foreign;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.foreign.Converter;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableNullableList;

public class Converters {
    private Converters() {
    }

    public static Converter<Object[]> ofRow(RelDataType rowType) {
        List fields = rowType.getFieldList();
        ImmutableList.Builder converters = ImmutableList.builder();
        Ord.forEachIndexed(fields, (field, i) -> converters.add(Converters.ofField(field.getType(), i)));
        return new RecordConverter((ImmutableList<Converter<Object[]>>)converters.build());
    }

    public static Converter<Object[]> ofRow2(RelDataType rowType, RecordLikeType type) {
        return Converters.ofRow3(rowType.getFieldList().iterator(), new AtomicInteger(), (Enumerator<Type>)Linq4j.enumerator(type.argTypes()));
    }

    static Converter<Object[]> ofRow3(Iterator<RelDataTypeField> fields, AtomicInteger ordinal, Enumerator<Type> types) {
        ImmutableList.Builder converters = ImmutableList.builder();
        while (types.moveNext()) {
            converters.add(Converters.ofField2(fields, ordinal, (Type)types.current()));
        }
        return new RecordConverter((ImmutableList<Converter<Object[]>>)converters.build());
    }

    public static Converter<Object[]> ofField(RelDataType type, int ordinal) {
        FieldConverter fieldConverter = FieldConverter.toType(type);
        return values -> fieldConverter.convertFrom(values[ordinal]);
    }

    static Converter<Object[]> ofField2(Iterator<RelDataTypeField> fields, AtomicInteger ordinal, Type type) {
        RelDataTypeField field = fields.next();
        if (type instanceof RecordType) {
            if (field.getType().isStruct()) {
                return Converters.offset(ordinal.getAndIncrement(), Converters.ofRow3(field.getType().getFieldList().iterator(), new AtomicInteger(), (Enumerator<Type>)Linq4j.enumerator(((RecordType)type).argNameTypes.values())));
            }
            return Converters.ofRow3(fields, ordinal, (Enumerator<Type>)Linq4j.enumerator(((RecordType)type).argNameTypes.values()));
        }
        return Converters.ofField3(field, ordinal, type);
    }

    static Converter<Object[]> offset(int i, Converter<Object[]> converter) {
        return values -> converter.apply((Object[])values[i]);
    }

    static Converter<Object[]> ofField3(RelDataTypeField field, AtomicInteger ordinal, Type type) {
        if (field.getType().isStruct()) {
            return Converters.ofRow3(field.getType().getFieldList().iterator(), ordinal, (Enumerator<Type>)Linq4j.singletonEnumerator((Object)type));
        }
        FieldConverter fieldConverter = FieldConverter.toType(field.getType());
        int i = ordinal.getAndIncrement();
        return values -> fieldConverter.convertFrom(values[i]);
    }

    public static Function<Enumerable<Object[]>, List<Object>> fromEnumerable(RelNode rel, Type type) {
        Preconditions.checkArgument((boolean)type.isCollection(), (String)"not a collection type: %s", (Object)type);
        Type elementType = type.arg(0);
        RelDataType rowType = rel.getRowType();
        Function elementConverter = Converters.forType(rowType, elementType);
        return enumerable -> enumerable.select(elementConverter::apply).toList();
    }

    public static <E> Function<E, Object> forType(RelDataType fromType, Type type) {
        if (type == PrimitiveType.UNIT) {
            return o -> Unit.INSTANCE;
        }
        if (type instanceof PrimitiveType) {
            RelDataTypeField field = (RelDataTypeField)Iterables.getOnlyElement((Iterable)fromType.getFieldList());
            return Converters.ofField(field.getType(), 0);
        }
        if (type instanceof RecordLikeType) {
            return Converters.ofRow2(fromType, (RecordLikeType)type);
        }
        if (fromType.isNullable()) {
            return o -> o == null ? BigDecimal.ZERO : o;
        }
        return o -> o;
    }

    public static Type fieldType(RelDataTypeField field) {
        return FieldConverter.toType((RelDataType)field.getType()).mlType;
    }

    public static RelDataType toCalciteType(Type type, RelDataTypeFactory typeFactory) {
        return C2m.forMorel((Type)type, (RelDataTypeFactory)typeFactory, (boolean)false, (boolean)true).calciteType;
    }

    public static Function<Object, Enumerable<Object[]>> toCalciteEnumerable(Type type, RelDataTypeFactory typeFactory) {
        C2m converter = C2m.forMorel(type, typeFactory, false, false);
        return converter::toCalciteEnumerable;
    }

    public static Function<Object, Object> toCalcite(Type type, RelDataTypeFactory typeFactory) {
        C2m converter = C2m.forMorel(type, typeFactory, false, true);
        return converter::toCalciteObject;
    }

    public static Function<Object, Object> toMorel(Type type, RelDataTypeFactory typeFactory) {
        C2m converter = C2m.forMorel(type, typeFactory, false, true);
        return converter.toMorelObjectFunction();
    }

    private static class RecordConverter
    implements Converter<Object[]> {
        final Object[] tempValues;
        final ImmutableList<Converter<Object[]>> converterList;

        RecordConverter(ImmutableList<Converter<Object[]>> converterList) {
            this.tempValues = new Object[converterList.size()];
            this.converterList = converterList;
        }

        @Override
        public List<Object> apply(Object[] a) {
            for (int i = 0; i < this.tempValues.length; ++i) {
                this.tempValues[i] = ((Converter)this.converterList.get(i)).apply(a);
            }
            return ImmutableNullableList.copyOf((Object[])this.tempValues);
        }
    }

    static enum FieldConverter {
        FROM_BOOLEAN(PrimitiveType.BOOL){

            @Override
            public Boolean convertFrom(Object o) {
                return (Boolean)o;
            }
        }
        ,
        FROM_INTEGER(PrimitiveType.INT){

            @Override
            public Integer convertFrom(Object o) {
                return o == null ? 0 : ((Number)o).intValue();
            }
        }
        ,
        FROM_FLOAT(PrimitiveType.REAL){

            @Override
            public Float convertFrom(Object o) {
                return Float.valueOf(o == null ? 0.0f : ((Number)o).floatValue());
            }
        }
        ,
        FROM_DATE(PrimitiveType.STRING){

            @Override
            public String convertFrom(Object o) {
                return o == null ? "" : DateTimeUtils.unixDateToString((int)((Integer)o));
            }
        }
        ,
        FROM_TIME(PrimitiveType.STRING){

            @Override
            public String convertFrom(Object o) {
                return o == null ? "" : DateTimeUtils.unixTimeToString((int)((Integer)o));
            }
        }
        ,
        FROM_TIMESTAMP(PrimitiveType.STRING){

            @Override
            public String convertFrom(Object o) {
                return o == null ? "" : DateTimeUtils.unixTimestampToString((long)((Long)o));
            }
        }
        ,
        FROM_STRING(PrimitiveType.STRING){

            @Override
            public String convertFrom(Object o) {
                return o == null ? "" : (String)o;
            }
        };

        final Type mlType;

        private FieldConverter(Type mlType) {
            this.mlType = mlType;
        }

        public abstract Object convertFrom(Object var1);

        static FieldConverter toType(RelDataType type) {
            switch (type.getSqlTypeName()) {
                case BOOLEAN: {
                    return FROM_BOOLEAN;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    return FROM_INTEGER;
                }
                case FLOAT: 
                case REAL: 
                case DOUBLE: 
                case DECIMAL: {
                    return FROM_FLOAT;
                }
                case DATE: {
                    return FROM_DATE;
                }
                case TIME: {
                    return FROM_TIME;
                }
                case TIMESTAMP: {
                    return FROM_TIMESTAMP;
                }
            }
            return FROM_STRING;
        }
    }

    private static class C2m {
        final RelDataType calciteType;
        final Type morelType;

        C2m(RelDataType calciteType, Type morelType) {
            this.calciteType = calciteType;
            this.morelType = morelType;
        }

        static C2m forMorel(Type type, RelDataTypeFactory typeFactory, boolean nullable, boolean recordList) {
            switch (type.op()) {
                case DATA_TYPE: {
                    DataType dataType = (DataType)type;
                    if (dataType.isCollection()) {
                        return C2m.forMorelCollection(type, typeFactory, nullable, recordList);
                    }
                    if (dataType.name.equals("option")) {
                        return C2m.forMorel((Type)dataType.parameterTypes.get(0), typeFactory, true, false);
                    }
                    throw new AssertionError((Object)("unknown type " + type));
                }
                case FUNCTION_TYPE: {
                    return new C2m(typeFactory.createSqlType(SqlTypeName.ANY), type);
                }
                case LIST: {
                    return C2m.forMorelCollection(type, typeFactory, nullable, recordList);
                }
                case RECORD_TYPE: 
                case TUPLE_TYPE: {
                    RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
                    RecordLikeType recordType = (RecordLikeType)type;
                    recordType.argNameTypes().forEach((arg_0, arg_1) -> C2m.lambda$forMorel$0((RelDataTypeFactory.Builder)typeBuilder, typeFactory, nullable, recordList, arg_0, arg_1));
                    return new C2m(typeBuilder.build(), type);
                }
                case TY_VAR: {
                    type = PrimitiveType.BOOL;
                }
                case ID: {
                    PrimitiveType primitiveType = (PrimitiveType)type;
                    switch (primitiveType) {
                        case BOOL: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), nullable), type);
                        }
                        case INT: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), nullable), type);
                        }
                        case REAL: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.REAL), nullable), type);
                        }
                        case CHAR: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.SMALLINT), nullable), type);
                        }
                        case UNIT: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.TINYINT), nullable), type);
                        }
                        case STRING: {
                            return new C2m(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR, -1), nullable), type);
                        }
                    }
                    throw new AssertionError((Object)("unknown type " + type));
                }
            }
            throw new UnsupportedOperationException("cannot convert type " + type);
        }

        private static C2m forMorelCollection(Type type, RelDataTypeFactory typeFactory, boolean nullable, boolean recordList) {
            Preconditions.checkArgument((boolean)type.isCollection(), (String)"not a collection type: %s", (Object)type);
            RelDataType elementType = C2m.forMorel((Type)type.arg((int)0), (RelDataTypeFactory)typeFactory, (boolean)nullable, (boolean)false).calciteType;
            if (recordList && !elementType.isStruct()) {
                elementType = typeFactory.builder().add("1", elementType).build();
            }
            return new C2m(typeFactory.createMultisetType(elementType, -1L), type);
        }

        public Object toCalciteObject(Object v) {
            return v;
        }

        public Enumerable<Object[]> toCalciteEnumerable(Object v) {
            Enumerable enumerable = Linq4j.asEnumerable((List)((List)v));
            if (this.morelType.isCollection()) {
                Type elementType = this.morelType.arg(0);
                C2m c = new C2m(this.calciteType.getComponentType(), elementType);
                if (c.morelType instanceof PrimitiveType) {
                    if (c.calciteType.isStruct()) {
                        return EnumerableDefaults.select((Enumerable)enumerable, c::scalarToArray);
                    }
                    return enumerable;
                }
                return EnumerableDefaults.select((Enumerable)enumerable, c::listToArray);
            }
            throw new AssertionError((Object)("cannot convert " + this.morelType));
        }

        private Object[] listToArray(Object o) {
            List list = (List)o;
            return list.toArray();
        }

        private Object[] scalarToArray(Object o) {
            return new Object[]{o};
        }

        public Function<Object, Object> toMorelObjectFunction() {
            switch (this.morelType.op()) {
                case TUPLE_TYPE: {
                    ImmutableList.Builder b = ImmutableList.builder();
                    Pair.forEach(this.calciteType.getFieldList(), ((TupleType)this.morelType).argTypes, (field, argType) -> b.add(new C2m(field.getType(), (Type)argType).toMorelObjectFunction()));
                    final ImmutableList converters = b.build();
                    return v -> {
                        final Object[] values = (Object[])v;
                        return new AbstractList<Object>(){

                            @Override
                            public int size() {
                                return values.length;
                            }

                            @Override
                            public Object get(int index) {
                                return ((Function)converters.get(index)).apply(values[index]);
                            }
                        };
                    };
                }
                case ID: {
                    switch ((PrimitiveType)this.morelType) {
                        case INT: {
                            return v -> ((Number)v).intValue();
                        }
                    }
                    return v -> v;
                }
            }
            throw new AssertionError((Object)("unknown type " + this.morelType));
        }

        private static /* synthetic */ void lambda$forMorel$0(RelDataTypeFactory.Builder typeBuilder, RelDataTypeFactory typeFactory, boolean nullable, boolean recordList, String name, Type argType) {
            typeBuilder.add(name, C2m.forMorel((Type)argType, (RelDataTypeFactory)typeFactory, (boolean)nullable, (boolean)recordList).calciteType);
        }
    }
}

