/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.parse;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Parsers {
    private Parsers() {
    }

    public static String unquoteIdentifier(String s) {
        Preconditions.checkArgument((s.length() >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(0) == '`' ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(s.length() - 1) == '`' ? 1 : 0) != 0);
        s = s.substring(1, s.length() - 1);
        return s.replace("``", "`");
    }

    public static String unquoteString(String s) {
        Preconditions.checkArgument((s.length() >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(0) == '\"' ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(s.length() - 1) == '\"' ? 1 : 0) != 0);
        s = s.substring(1, s.length() - 1);
        if (!s.contains("\\")) {
            return s;
        }
        StringParser p = new StringParser(s);
        StringBuilder b = new StringBuilder();
        while (p.i < p.s.length()) {
            b.append(p.parseChar());
        }
        return b.toString();
    }

    public static char unquoteCharLiteral(String s) {
        Preconditions.checkArgument((s.length() >= 3 ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(0) == '#' ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(1) == '\"' ? 1 : 0) != 0);
        Preconditions.checkArgument((s.charAt(s.length() - 1) == '\"' ? 1 : 0) != 0);
        s = s.substring(2, s.length() - 1);
        StringParser p = new StringParser(s);
        char c = p.parseChar();
        if (p.i != s.length()) {
            throw new RuntimeException("Error: character literal not length 1");
        }
        return c;
    }

    public static @Nullable Character fromString(String s) {
        if (s.isEmpty()) {
            return null;
        }
        StringParser p = new StringParser(s);
        return Character.valueOf(p.parseChar());
    }

    public static String charToString(char c) {
        switch (c) {
            case '\u0007': {
                return "\\a";
            }
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\u000b': {
                return "\\v";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ') {
            return "\\^" + (char)(c + 64);
        }
        if (c >= '\u007f' && c < '\u0100') {
            return "\\" + c;
        }
        return String.valueOf(c);
    }

    public static void stringToString(String s, StringBuilder b) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            b.append(Parsers.charToString(c));
        }
    }

    public static String stringToString(String s) {
        if (!Parsers.requiresEscape(s)) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        Parsers.stringToString(s, b);
        return b.toString();
    }

    private static boolean requiresEscape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c != '\"' && c != '\\' && c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static StringBuilder appendId(StringBuilder buf, String id) {
        if (id.contains("`")) {
            return buf.append("`").append(id.replaceAll("`", "``")).append("`");
        }
        if (id.contains(" ")) {
            return buf.append("`").append(id).append("`");
        }
        return buf.append(id);
    }

    static class StringParser {
        final String s;
        int i = 0;

        StringParser(String s) {
            this.s = s;
        }

        char parseChar() {
            char c;
            if ((c = this.s.charAt(this.i++)) != '\\') {
                return c;
            }
            if (this.i >= this.s.length()) {
                throw new RuntimeException("illegal escape; no character after \\");
            }
            char c2 = this.s.charAt(this.i++);
            switch (c2) {
                case '\"': 
                case '\\': {
                    return c2;
                }
                case 'a': {
                    return '\u0007';
                }
                case 'b': {
                    return '\b';
                }
                case 't': {
                    return '\t';
                }
                case 'n': {
                    return '\n';
                }
                case 'v': {
                    return '\u000b';
                }
                case 'f': {
                    return '\f';
                }
                case 'r': {
                    return '\r';
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (this.i + 2 <= this.s.length()) {
                        char c3 = this.s.charAt(this.i++);
                        char c4 = this.s.charAt(this.i++);
                        if (c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9') {
                            int d2 = c2 - 48;
                            int d3 = c3 - 48;
                            int d4 = c4 - 48;
                            return (char)(d2 * 100 + d3 * 10 + d4);
                        }
                    }
                    throw new RuntimeException("illegal control escape; too few digits after ^");
                }
                case '^': {
                    char c3;
                    if (this.i >= this.s.length()) {
                        throw new RuntimeException("illegal control escape; no character after ^");
                    }
                    if ((c3 = this.s.charAt(this.i++)) >= '@' && c3 <= '_') {
                        return (char)(c3 - 64);
                    }
                    throw new RuntimeException("illegal control escape; must be one of @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
                }
            }
            throw new RuntimeException("illegal escape; invalid character after \\");
        }
    }
}

