/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.parse.MorelParser;

public final class Span {
    private final List<Pos> posList = new ArrayList<Pos>();

    private Span() {
    }

    public static Span of() {
        return new Span();
    }

    public static Span of(Pos p) {
        return new Span().add(p);
    }

    public static Span of(AstNode n) {
        return new Span().add(n);
    }

    public static Span of(AstNode n0, AstNode n1) {
        return new Span().add(n0).add(n1);
    }

    public static Span of(Collection<? extends AstNode> nodes) {
        return new Span().addAll(nodes);
    }

    public Span add(AstNode n) {
        return this.add(n.pos);
    }

    public Span addIf(AstNode n) {
        return n == null ? this : this.add(n);
    }

    public Span add(Pos pos) {
        this.posList.add(pos);
        return this;
    }

    public Span addAll(Iterable<? extends AstNode> nodes) {
        for (AstNode astNode : nodes) {
            this.add(astNode);
        }
        return this;
    }

    public Span add(MorelParser parser) {
        try {
            Pos pos = parser.pos();
            return this.add(pos);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public Pos pos() {
        switch (this.posList.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return this.posList.get(0);
            }
        }
        return Pos.sum(this.posList);
    }

    public Pos end(MorelParser parser) {
        return this.add(parser).pos();
    }

    public Pos end(AstNode n) {
        return this.add(n).pos();
    }

    public Span clear() {
        this.posList.clear();
        return this;
    }
}

