/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.eval.Unit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Binding {
    public final Core.NamedPat id;
    public final Core.Exp exp;
    public final Object value;
    public final boolean parameter;
    public final Kind kind;
    public final  @Nullable Core.IdPat overloadId;

    private Binding(Core.NamedPat id,  @Nullable Core.IdPat overloadId, Core.Exp exp, Object value, boolean parameter, Kind kind) {
        this.id = Objects.requireNonNull(id);
        this.overloadId = overloadId;
        this.exp = exp;
        this.value = Objects.requireNonNull(value);
        this.parameter = parameter;
        this.kind = Objects.requireNonNull(kind);
        Preconditions.checkArgument((!(value instanceof Core.IdPat) ? 1 : 0) != 0);
        Preconditions.checkArgument((kind == Kind.INST == (overloadId != null) ? 1 : 0) != 0);
    }

    public static Binding of(Core.NamedPat id) {
        return new Binding(id, null, null, Unit.INSTANCE, false, Kind.VAL);
    }

    public static Binding over(Core.NamedPat id, Object value) {
        return new Binding(id, null, null, value, false, Kind.OVER);
    }

    public static Binding over(Core.NamedPat id) {
        return Binding.over(id, Unit.INSTANCE);
    }

    public static Binding of(Core.NamedPat id, Core.Exp exp) {
        return new Binding(id, null, exp, Unit.INSTANCE, false, Kind.VAL);
    }

    public static Binding inst(Core.NamedPat id, Core.IdPat overloadId, Core.Exp exp) {
        return new Binding(id, overloadId, exp, Unit.INSTANCE, false, Kind.INST);
    }

    public static Binding of(Core.NamedPat id, Object value) {
        return new Binding(id, null, null, value, false, Kind.VAL);
    }

    public static Binding inst(Core.NamedPat id, Core.IdPat overloadId, Object value) {
        return new Binding(id, overloadId, null, value, false, Kind.INST);
    }

    public Binding withFlattenedName() {
        if (this.id.i == 0) {
            return this;
        }
        Core.NamedPat id1 = this.id.withName(this.id.name + '_' + this.id.i);
        return new Binding(id1, this.overloadId, this.exp, this.value, this.parameter, this.kind);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.exp, this.value);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Binding && this.id.equals(((Binding)o).id) && Objects.equals(this.exp, ((Binding)o).exp) && this.value.equals(((Binding)o).value);
    }

    public Binding withParameter(boolean parameter) {
        return parameter == this.parameter ? this : new Binding(this.id, this.overloadId, this.exp, this.value, parameter, this.kind);
    }

    public Binding withKind(Kind kind) {
        return kind == this.kind ? this : new Binding(this.id, this.overloadId, this.exp, this.value, this.parameter, kind);
    }

    public boolean isInst() {
        return this.kind == Kind.INST;
    }

    public String toString() {
        if (this.exp != null) {
            return this.id + " = " + this.exp;
        }
        if (this.value == Unit.INSTANCE) {
            return this.id + " : " + this.id.type.moniker();
        }
        return this.id + " = " + this.value + " : " + this.id.type.moniker();
    }

    public static enum Kind {
        VAL,
        OVER,
        INST;

    }
}

