/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.ParameterizedType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;

public class DataType
extends ParameterizedType {
    public final List<Type> arguments;
    public final Map<String, Type.Key> typeConstructors;

    protected DataType(String name, String moniker, ImmutableList<Type> arguments, ImmutableMap<String, Type.Key> typeConstructors) {
        super(Op.DATA_TYPE, name, moniker, arguments.size());
        this.arguments = (List)Objects.requireNonNull(arguments);
        this.typeConstructors = (Map)Objects.requireNonNull(typeConstructors);
    }

    @Override
    public Keys.DataTypeKey key() {
        return Keys.datatype(this.name, Keys.toKeys(this.arguments), (Map<String, Type.Key>)ImmutableMap.copyOf(this.typeConstructors));
    }

    @Override
    public Type arg(int i) {
        return this.arguments.get(i);
    }

    @Override
    public boolean isCollection() {
        return this.name.equals(BuiltIn.Eqtype.BAG.mlName());
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    public Map<String, Type> typeConstructors(TypeSystem typeSystem) {
        return Static.transformValuesEager(this.typeConstructors, k -> k.copy(t -> t.substitute(this.arguments)).toType(typeSystem));
    }

    @Override
    public DataType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        ImmutableList arguments = Static.transformEager(this.arguments, transform);
        if (arguments.equals(this.arguments)) {
            return this;
        }
        return (DataType)this.key().substitute((List<? extends Type>)arguments).toType(typeSystem);
    }

    public StringBuilder describe(StringBuilder buf) {
        buf.append("datatype ").append(this.moniker).append(" = ");
        int initialSize = buf.length();
        this.typeConstructors.forEach((name, typeKey) -> {
            if (buf.length() > initialSize) {
                buf.append(" | ");
            }
            buf.append((String)name);
            if (typeKey.op != Op.DUMMY_TYPE) {
                buf.append(" of ");
                typeKey.describe(buf, 0, 0);
            }
        });
        return buf;
    }

    @Override
    public boolean specializes(Type type) {
        if (type instanceof DataType) {
            DataType dataType = (DataType)type;
            return this.name.equals(dataType.name) && Pair.allMatch(this.arguments, dataType.arguments, Type::specializes);
        }
        return type instanceof TypeVar;
    }
}

